<?php
class AppController extends Controller {

	public $components = array(
		'Acl',
		'Auth' => array(
			// to do some additional work in determining proper credentials - By using actions, Auth will make use of ACL and check with AclComponent::check(). An isAuthorized function is not needed.
			'authorize' => 'actions',
			'loginRedirect' => array(
				'controller' => 'evaluations',
				'action' => 'index'
					),
			'logoutRedirect' => array(
				'controller' => 'pages',
				'action' => 'home'
					),				
			'loginError' => 'Identificador incorrecto, corrija su información.',
			'authError' => 'Su sesión ha terminado. Por favor inicie una nueva sesión'
				),
		'Language',
		'Session',		
		'Cookie'
//		'Security'
	);
	
	public function beforeFilter() {	
		$this->Auth->autoRedirect = false;
		# Is just to get the key of $user array
		if ($this->Auth->getModel()->hasField('active')) {
			# userScope var: Use this to provide additional requirements for authentication to succeed
			$this->Auth->userScope = array('User.active' => 1);		
		}
		
		//$this->_setupSecurity();
	}
	
	public function isAuthorized() {
		return true;
	}

	// function _setupSecurity() {
	// 	$this->Security->blackHoleCallback = '_badRequest';
	// 	if(Configure::read('forceSSL')) {
	// 		$this->Security->requireSecure('*');
	// 	}
	// }	
	
	/********************************************************
	* Private function to get the current day
	********************************************************/
	function _todaydate() {
		$today = date('D, F j, Y');	
		return $today;
	}				

	/********************************************************
	* Sets up successful session flash message for view
	********************************************************/	
	function flashSuccess($msg, $url = null) {
		$this->Session->setFlash($msg, 'flash_success');
		if (!empty($url)) {
		  $this->redirect($url, null, true);
		}
	}	
	
	/********************************************************
	* Sets up warning session flash message for view
	********************************************************/		
	function flashWarning($msg, $url = null) {
		$this->Session->setFlash($msg, 'warning');
		if (!empty($url)) {
		  $this->redirect($url, null, true);
		}
	}		

	/********************************************************
	* Checks for id, if no id  redirects to given $url
	********************************************************/	
	function idEmptyRedirect($id, $url = null) {
		if (empty($id)) {
			//$this->flashWarning('Invalid Id', $url);
			if (!empty($url)) {
			  $this->redirect($url, null, true);
			}			
		}
		return true;
	}

	/********************************************************
	* Returns true if on one of the given $actions
	********************************************************/
	function only($actions = array()) {
		foreach ($actions as $action) {
			if ($action == $this->params['action']) {
			  return true;
			}
		}
		return false;
  	}			
		
	/********************************************************
	* Redirects get params to named params
	********************************************************/
	// function redirectToNamed() {		
	// 	$urlArray = $this->params['url'];
	// 	unset($urlArray['url']);		
	// 	if (!empty($urlArray)) {
	// 	  $this->redirect($urlArray, null, true);
	// 	}
	// }
	    		
	/********************************************************
	* Redirects get params to named params
	********************************************************/
	function redirectToNamed() {
		$urlArray = array_map('trim', $this->params['url']);
        // var_dump($urlArray);
		unset($urlArray['url']);	
		if (!empty($urlArray)) {
		  $this->redirect($urlArray, null, true);	
		}
	}
	
	/**
	* The main SecurityComponent callback.
	* Handles both missing SSL problems and general bad requests.
	*/
	// function _badRequest() {
	// 	if(Configure::read('forceSSL') && !$this->RequestHandler->isSSL()) {
	// 		$this->_forceSSL();
	// 	} else {
	// 		$this->cakeError('error400');
	// 	}
	// 	exit;
	// }

	/**
	* Redirect to the same page, but with the https protocol and exit.
	*/
	function _forceSSL() {
		// $this->redirect('https://' . env('SERVER_NAME') . $this->here);
		// exit;
	}	
	
}
?>