<?php
/**
 * Application level View Helper
 *
 * This file is application-wide helper file. You can put all
 * application-wide helper-related methods here.
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2010, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake
 * @since         CakePHP(tm) v 0.2.9e
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
App::import('Helper', 'Helper', false);

/**
 * This is a placeholder class.
 * Create the same file in app/app_helper.php
 *
 * Add your application-wide methods in the class below, your helpers
 * will inherit them.
 *
 * @package       cake
 * @subpackage    cake.cake
 */
class AppHelper extends Helper {

	function output($string) {
		return parent::output($string . "\n");
	}

	function url($url = null, $full = false) {
        if(!isset($url['language']) && isset($this->params['language'])) {
          $url['language'] = $this->params['language'];
        }
        return parent::url($url, $full);
	}	
	
	/********************************************************
	* returns formatted date 30th Apr 2011
	* @param string $time
	* @return string
	*******************************************************/
	function formattedFieldDate($time) {
	  return	$this->format('jS M Y', $time);
	}

	/********************************************************
	* returns formatted date 30th Apr 2011
	* @param string $time
	* @return string
	********************************************************/
	function formattedFieldDate2($time) {
		return	$this->format('Y-m-d', $time);
	}

	function formattedFieldDate3($time) {
		return	$this->format('F j, Y', $time);
	}	
	
	function formattedEngDate($time) {
		return	$this->format('m/d/Y', $time);
	}
	
	function formattedFraDate($time) {
		return	$this->format('d/m/Y', $time);
	}		
	
	/********************************************************
	* returns formatted date 30th Apr 2011
	* @param string $time
	* @return string
	********************************************************/
	function formattedFieldDateHour($time) {
		return	$this->nice($time);
	}	

	/********************************************************
	* checks if we are on the controller and
	* one of the actions
	* @param string $controller
	* @param array $array
	* @return bool
	********************************************************/
	function isActive($controller, $actions = array()) {
		foreach ($actions as $action) {
			if ($controller == $this->params['controller'] && $action == $this->params['action']) {
				return true;
			}
		}
  	  return false;
  	}
	
	/********************************************************
	* Lowercases name and removes spaces
	********************************************************/
	function formatCssName($name) {
		return strtolower(str_replace(' ', '', $name));
	}	
	
	/********************************************************
	* Get the day in long format, by language
	* Fre: Montr�al, le 19 f�vrier, 2012  | Eng: Montreal, February 19, 2012 
	********************************************************/	
	function frMonthDate() {
		//$today = date('Y-m-d', time());	
		//$today = date("F j, Y, g:i a"); 	// March 10, 2001, 5:16 pm
		if (date("m") == 01){
			return 'enero';
		} elseif (date("m") == "02") {
			return 'febrero';
		} elseif (date("m") == "03") {
			return 'marzo';
		} elseif (date("m") == "04") {
			return 'abril';
		} elseif (date("m") == "05") {
			return 'mayo';
		} elseif (date("m") == "06") {
			return 'junio';
		} elseif (date("m") == "07") {
			return 'julio';
		} elseif (date("m") == "08") {
			return 'agosto';
		} elseif (date("m") == "09") {
			return 'septiembre';
		} elseif (date("m") == "10") {
			return 'octubre';
		} elseif (date("m") == "11") {
			return 'noviembre';
		} elseif (date("m") == "12") {
			return 'diciembre';
		}
	}

	/********************************************************
	* Put french characteres in UPPER case
	********************************************************/	
	function fullUpper($string) {
	  return strtr(mb_strtoupper($string, "utf-8"), array(
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		"�" => "�",
		));
	}
}
?>