<?php
class CitiesController extends AppController {

	var $name = 'Cities';
	var $helpers = array('Html', 'Form', 'Time');
	
	function beforeFilter() {
	  if ($this->only(array('add', 'edit'))) { $this->__lists(); }
	  parent::beforeFilter();
	}	
	
	
	function index() {
		$this->City->recursive = 0;
		$this->set('cities', $this->paginate());
	}
	
	function cancel() {
		$this->redirect('/cities'); 
	}	
	
	function add() {
		if (!empty($this->data)) {
			$this->City->create();
			if ($this->City->save($this->data)) {
				$this->flashSuccess(__('La ciudad ha sido creada', true), 'index');
			} else {
				$this->flashWarning(__('La ciudad no ha sido creada. Corrija los errores e intente de nuevo', true));
			}
		}
	}		


	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');		
		if (!empty($this->data)) {
			if ($this->City->save($this->data)) {
				$this->flashSuccess(__('La ciudad ha sido actualizada', true), 'index');
			} else {
				$this->flashWarning(__('La ciudad no ha sido actualizada. Corrija los errores e intente de nuevo', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->City->read(null, $id);
		}
	}

	
	function delete($id = null) {
    $this->idEmptyRedirect($id, 'index');
		if ($this->City->delete($id)) {
       $this->flashSuccess(__('La ciudad ha sido borrada', true), 'index');
		}
	}	
	
	
	#private methods	
	function __lists() {
		$provinces = $this->City->Province->find('list');
		$this->set(compact('provinces'));
	}
	
	
}
?>