<?php
class CustomersController extends AppController {

	var $name = 'Customers';
	var $helpers = array('Html', 'Form', 'Time', 'Text', 'Js' => array('Jquery'), 'FormatMask.Format');
	var $components = array('FormatMask.Format','RequestHandler');
	
	function beforeFilter() {
	  parent::beforeFilter();
	}	
		
	
	function index() {
		$this->Customer->recursive = 0;
		$this->set('customers', $this->paginate());
	}

	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('customer', $this->Customer->read(null, $id));
	}	

	function cancel() {
		$this->redirect('/customers'); 
	}	

	function add() {
		if (!empty($this->data)) {
			$this->Customer->create();
			if ($this->Customer->save($this->data)) {
				$this->flashSuccess(__('El cliente ha sido creado', true), 'index');
			} else {
				$this->flashWarning(__('El cliente no ha sido creado. Corrija los errores e intente de nuevo', true));
			}
		}
		$provinces = $this->Customer->Province->find('list');
		$this->set(compact('provinces'));	
	}		
	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Customer->save($this->data)) {
				$this->flashSuccess(__('El cliente ha sido actualizado', true), 'index');
			} else {
				$this->flashWarning(__('El cliente no ha sido actualizado. Corrija los errores e intente de nuevo', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Customer->read(null, $id);
			$provinces = $this->Customer->Province->find('list');
			$cities = $this->Customer->City->find('list', array('conditions' => array('City.province_id' => $this->data['Customer']['province_id'])));
			$this->set(compact('provinces','cities'));
		}
	}		

	# Private methods	
	public function get_cities_ajax() {
	  Configure::write('debug', 0);
	  if($this->RequestHandler->isAjax()) {
		$this->set('cities', $this->Customer->Province->City->find('list',
							array('conditions' => array('City.province_id' => $this->params['url']['idprov']), 'recursive' => -1)));
						}
	}		
}
?>