<?php
class DoctorInterpsController extends AppController {

	var $name = 'DoctorInterps';
	var $helpers = array('Html', 'Form', 'Time');

	
	function beforeFilter() {
	  parent::beforeFilter();
	}
	

	function index() {
		$this->DoctorInterp->recursive = 0;
		$this->set('doctorInterps', $this->paginate());
	}	
	
	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('doctorInterp', $this->DoctorInterp->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/doctor_interps'); 
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->DoctorInterp->create();
			if ($this->DoctorInterp->save($this->data)) {
				$this->flashSuccess(__('El código ha sido creado', true), 'index');
			} else {
				$this->flashWarning(__('El código no ha sido creado. Corrija el error e intente de nuevo', true));
			}
		}
	}	
	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		if (!empty($this->data)) {
			if ($this->DoctorInterp->save($this->data)) {
				$this->flashSuccess(__('El código ha sido actualizado', true), 'index');
			} else {
				$this->flashWarning(__('El código no ha sido actualizado. Corrija el error e intente de nuevo', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->DoctorInterp->read(null, $id);
		}
	}	
}
?>