<?php
class DoctorsController extends AppController {

	var $name = 'Doctors';
	var $helpers = array('Html', 'Form', 'Js' => array('Jquery'), 'FormatMask.Format');
	var $components = array('FormatMask.Format');
	
	function beforeFilter()
	{
	  parent::beforeFilter();
	}		

	function cancel() {
		if ($this->params['named']['parag'] == 'r3') {
		//View evaluation
			//http://localhost/testmetrix/evaluations/view/311
			$this->redirect('/evaluations/view/'.$this->params['named']['eval_id']);
		}		
	}
	
	function index() {
		$this->Doctor->recursive = 0;
		$this->set('doctors', $this->paginate());
	}

	function view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Médico no valido', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('doctor', $this->Doctor->read(null, $id));
	}
	
	function add() {
		if (!empty($this->data)) {
			$this->Doctor->create();			
			if ($this->Doctor->save($this->data)) {
				$response = �saved�;
//				$this->flashSuccess('The Doctor has been saved', '/orders/add/');
				$this->flashSuccess(__('El médico ha sido creado', true));				
			} else {
				$response = $this->Doctor->invalidFields();
//				$this->flashWarning(__('The Doctor could not be created. Please, try again', true));
			}
			$cities = array();
			$provinces = $this->Doctor->Province->find('list');			
		}
		$this->set(compact('cities', 'provinces', 'response'));
	}
		

	function edit() {	
		if (isset($this->params['named']['doc_id'])){
			$id = $this->params['named']['doc_id'];
			if (isset($this->params['named']['eval'])) { $this->data['Doctor']['evaluation_id'] = $this->params['named']['eval']; }	 		
		}
		
		if (!empty($this->data)) {
			if ($this->Doctor->save($this->data)) {
				$this->flashSuccess(__('El médico ha sido actualizado', true), '/evaluations/view/'.$this->data['Doctor']['evaluation_id']);
			} else {
				$this->flashWarning(__('El médico no ha sido actualizado. Intente de nuevo', true));
			}
		}else {
			$cities = $this->Doctor->City->find('list');
			$provinces = $this->Doctor->Province->find('list');
			$this->set(compact('cities', 'provinces', $this->Doctor->read(null, $id)));				
		}
	}
	

	function delete($id = null) {
		$this->idEmptyRedirect($id, 'index');
	
		if ($this->Doctor->delete($id)) { $this->flashSuccess(__('El médico fue borrado', true), 'index'); }
	}

	function view_letter() {
		if (isset($this->params['named']['id'])) {
			$doc_id = $this->params['named']['id'];
			$serv = $this->params['named']['serv'];
			$eval_id = $this->params['named']['eval_id'];
		}	

		$doctor = $this->Doctor->infoDoctorEval($doc_id, $eval_id);
		$lang_id = $doctor['Doctor']['langue'];
		$quest = 0;
		$this->loadModel('DocLabel');		
		if ($serv == 1 || $serv == 3 || $serv == 5 || $serv == 7 || $serv == 17 || $serv == 30 || $serv == 19 || $serv == 32 || $serv == 21 || $serv == 33 || $serv == 22 || $serv == 34 || $serv == 23 || $serv == 35) {
			//DSP 45
			$quest = 45;
			$labelsDoctorReport = $this->DocLabel->labelsQSTXReport(3, $lang_id, 1, 1);
		}elseif ($serv == 2 || $serv == 4 || $serv == 6 || $serv == 8 || $serv == 9 || $serv == 10 || $serv == 11 || $serv == 12 || $serv == 13 || $serv == 26 || $serv == 14 || $serv == 27 || $serv == 15 || $serv == 28 || $serv == 16 || $serv == 29 || $serv == 20 || $serv == 25 || $serv == 24 || $serv == 36) {
			//DSP 77/HSQ
			$quest = 77;
			$labelsDoctorReport = $this->DocLabel->labelsQSTXReport(3, $lang_id, 2, 1);
		}

		$this->layout = 'pdf'; //this will use the pdf.ctp layout
			
		$this->set(compact('lang_id', 'doctor', 'labelsDoctorReport', 'quest'));
		$this->render();
	}	
	
	function getCities() {
		$this->set('options',
			$this->Doctor->City->find('list',
				array(
					'conditions' => array(
						'City.province_id' => $this->data['Doctor']['province_id']
					),
					'group' => array('City.name')
				)
			)
		);
		$this->render('ajax_dropdown');
	}	
	
}
?>