<?php
class DrugsController extends AppController {

	var $name = 'Drugs';
	var $helpers = array('Html', 'Form', 'Time');	
	
	
	public function beforeFilter() {
		parent::beforeFilter();
	}	
	
	
	function index() {
		$this->Drug->recursive = 0;
		$this->set('drugs', $this->paginate());
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->Drug->create();
			if ($this->Drug->save($this->data)) {
				$this->flashSuccess(__('El medicamento ha sido creado.', true), 'index');
			} else {
				$this->flashWarning(__('El medicamento no ha sido creado. Corrija el error.', true));
			}
		} else {
			$drugs = $this->Drug->find('list', array('fields' => array('category', 'name'),
							'conditions' => array('Drug.sub_category' => 0),
							'order' => 'category ASC'));		
			$this->set(compact('drugs'));		
		}
	}

	
	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Drug->save($this->data)) {
				$this->flashSuccess(__('El medicamento fué actualizado.', true), 'index');
			} else {
				$this->flashWarning(__('El medicamento no fué actualizado. Corrija el error', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Drug->read(null, $id);
		}
	}	
	
	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('drug', $this->Drug->read(null, $id));
	}
	
	
	function cancel() {
		$this->redirect('/drugs'); 
	}		
	
	
}
?>