<?php
class DspDeterminantsController extends AppController {

	var $name = 'DspDeterminants';
	var $helpers = array('Html', 'Form', 'Time');

	
	function beforeFilter() {
	  parent::beforeFilter();
	}
	

	function index() {
		$this->DspDeterminant->recursive = 0;
		$this->set('dspDeterminants', $this->paginate());
	}	
	
	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('dspDeterminant', $this->DspDeterminant->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/DspDeterminants'); 
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->DspDeterminant->create();
			if ($this->DspDeterminant->save($this->data)) {
				$this->flashSuccess(__('El determinante de DSP fué creado. ', true), 'index');
			} else {
				$this->flashWarning(__('El determinante de DSP no fué creado. Corrija el error.', true));
			}
		}
	}	
	

	function edit($id = null) {
    $this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->DspDeterminant->save($this->data)) {
				$this->flashSuccess(__('El determinante de DSP no fué actualizado.', true), 'index');
			} else {
				$this->flashWarning(__('El determinante de DSP no fué actualizado. Corrija el error.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->DspDeterminant->read(null, $id);
		}
	}	
}
?>