<?php
class DspInterpsController extends AppController {

	var $name = 'DspInterps';
	var $helpers = array('Html', 'Form', 'Time');

	
	function beforeFilter() {
	  parent::beforeFilter();
	}
	

	function index() {
		$this->DspInterp->recursive = 0;
		$this->set('dspInterps', $this->paginate());
	}	
	
	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('dspInterp', $this->DspInterp->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/dsp_interps'); 
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->DspInterp->create();
			if ($this->DspInterp->save($this->data)) {
				$this->flashSuccess(__('La interpretación de DSP fué creada.', true), 'index');
			} else {
				$this->flashWarning(__('La interpretación de DSP no fué creada. Corrija el error.', true));
			}
		}
	}	
	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->DspInterp->save($this->data)) {
				$this->flashSuccess(__('La interpretación de DSP fué actualizada.', true), 'index');
			} else {
				$this->flashWarning(__('La interpretación de DSP no fué actualizada. Corrija el error.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->DspInterp->read(null, $id);
		}
	}	
}
?>