<?php
class DspScoresController extends AppController {

	var $name = 'DspScores';
	var $helpers = array('Html', 'Form', 'Time', 'Js' => array('Jquery'));
	
	
	function beforeFilter() {
		$this->Auth->allow('view_combo_dsp_trq_score');
		parent::beforeFilter();
	}		

	function cancel() {
	# Called from DSP view/add
	# VIEW = http://localhost/testmetrix/questionnaires_services/view_answers/serv:1/eval:582
	# ADD  = http://localhost/testmetrix/questionnaires_services/add_score/serv:11/eval:492
	# dsp_history = http://localhost/testmetrix/evaluations/view/770
		if (isset($this->params['named']['ctrl_return'])) { 		
			if($this->params['named']['ctrl_return'] == 'dsp_history'){
				$this->redirect(array ('controller' => 'evaluations', 
				'action' => 'view', $this->params['named']['eval']));			
			} else {
				$this->redirect(array ('controller' => 'questionnaires_services', 
				'action' => $this->params['named']['ctrl_return'], 'serv' => $this->params['named']['serv'], 'eval' => $this->params['named']['eval']));			
			}
		}		
	}	
	
	function index() {
		$this->DspScore->recursive = 0;
		$this->set('dspScores', $this->paginate());
	}
	

	function view() {
		# First time the page is loaded
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
		}	

		# Get the DspScore Questionnaire information
		# Order info - header
		$this->data['DspScore']['langue'] = $lang_id;
		$infoEval = $this->DspScore->Evaluation->infoEval($eval_id);
		$infoCurrentDsp = $this->DspScore->infoCurrentDsp($eval_id);
					
		##### set the data to save DSP
		# set up default values for form
		# DSP 45
		if( $infoCurrentDsp['DspScore']['questionnaire_id'] == 1 ) { 					
			$questionsCount = 45;			
		} elseif ( $infoCurrentDsp['DspScore']['questionnaire_id'] == 2 ) {
		# DSP 77
			$questionsCount = 77;
		}
			
		$this->data['DspScore']['evaluation_id'] = $eval_id;
		$this->data['DspScore']['questionnaire_id'] = $infoCurrentDsp['DspScore']['questionnaire_id'];
		$this->data['DspScore']['ctrlform'] = 1;  //to control the select input question - VIEW
			
		# Get all the questions from a specific Questionnaire
		$questions = $this->DspScore->Questionnaire->infoquestion($infoCurrentDsp['DspScore']['questionnaire_id']);

		#Answers Info
		$dspanswers = array();
		for ($i=0; $i < $questionsCount; $i++) {
			$rest = substr($infoCurrentDsp['DspScore']['answers'], $i, 1);
			$dspanswers = $dspanswers + array($i => $rest);
		}			

		$allchoices = array(); 
											
		foreach($questions as $question):
				$choices = $this->DspScore->Questionnaire->Question->Choice->questionchoices($question['Question']['id'],$lang_id);
				$allchoices = array_merge($allchoices, $choices);						
		endforeach;
		
		$this->set(compact('questions', 'infoEval', 'infoCurrentDsp', 'dspanswers', 'allchoices'));
	}
		

	function add() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {	
			$quest_id = $this->params['named']['quest'];
			$eval_id = $this->params['named']['eval'];
			$lang_id = $this->params['named']['elang'];
			$test_serie = $this->params['named']['test_serie'];
		}

		if (!empty($this->data)) {
			$this->DspScore->create();
		    //print_r($this->data);
			if ($this->DspScore->save($this->data)) {
				$newStatusEval = $this->DspScore->Evaluation->findById($this->data['DspScore']['evaluation_id']);
				if ($newStatusEval['Evaluation']['status_id'] == 13 ){
					$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
				} else {
					$this->flashSuccess(__('El puntaje del DSP fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['DspScore']['evaluation_id']);	
				}							
			} else {			
				$this->flashWarning(__('El puntaje del DSP no fué creado. El cuestionario puede estar siendo contestado por otro usuario.', true), '/evaluations/order_code:'.$this->data['Order']['order_code']);
			}
		} else {
		//echo '2. '.Configure::read('Config.language');
			$this->data['DspScore']['langue'] = $lang_id;
			$infoEval = $this->DspScore->Evaluation->infoEval($eval_id);		
			$infoDSPquestionnaire = $this->DspScore->Evaluation->infoServorderDSP($eval_id);
			
			##### set the data to save DSP
			# set up default values for form
			if( $infoDSPquestionnaire[0]['Questionnaire']['id'] == 1 ) { 
				# DSP 45
				$this->data['DspScore']['type_q'] = 'DSP - 45';				
			} else {
				# DSP 77
				$this->data['DspScore']['type_q'] = 'DSP - 77';
			}
			
			$this->data['DspScore']['evaluation_id'] = $eval_id;
			$this->data['DspScore']['questionnaire_id'] = $infoDSPquestionnaire[0]['Questionnaire']['id'];			
			$this->data['DspScore']['ctrlform'] = 0;  //to control the select input question - ADD
			$this->data['DspScore']['test_serie'] = $test_serie;
			$this->data['Service']['id'] = $infoEval['Service']['id'];
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];

			$this->data['DspScore']['createdby'] = $this->Session->read('Auth.User.username');			
			
			# Get all the questions from a specific Questionnaire
			$questions = $this->DspScore->Questionnaire->infoquestion($infoDSPquestionnaire[0]['Questionnaire']['id']);

			$allchoices = array(); 
											
			foreach($questions as $question):
						$choices = $this->DspScore->Questionnaire->Question->Choice->questionchoices($question['Question']['id'],$lang_id);
						$allchoices = array_merge($allchoices, $choices);						
			endforeach;
		}
		$this->set(compact('infoEval','questions', 'allchoices'));
		//echo '3. '.Configure::read('Config.language');
	}		



	function add_dsp()
	{
		# First time the page is loaded - right after an Employee has been selected
		if (!empty($this->params['named']['eval'])) {
			$quest_id = $this->params['named']['quest'];
			$eval_id = $this->params['named']['eval'];
			$lang_id = $this->params['named']['elang'];
			$test_serie = $this->params['named']['test_serie'];
		}

		if (!empty($this->data)) {
			$this->DspScore->create();
			if ($this->DspScore->save($this->data)) {
				$serv_id = $this->data['Service']['id'];
				$test_serie = $this->data['DspScore']['test_serie'];
				$eval_id = $this->data['DspScore']['evaluation_id'];
				$lang_id = $this->data['DspScore']['langue'];
				###DSP as a single option in the service or as a final questionnaire after DSP (no treatment questionnaire in the service).###
				###Logs out the client after completion###
				if (($test_serie >= 1) && ($serv_id == 19 || $serv_id == 20 || $serv_id == 21 || $serv_id == 25 || $serv_id == 32 || $serv_id == 33 || $serv_id == 37 || $serv_id == 38))
					$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
				// HSQ
				if ($serv_id == 9 || $serv_id == 10 || $serv_id == 11 || $serv_id == 12 || $serv_id == 13 || $serv_id == 14 || $serv_id == 15 || $serv_id == 16 || $serv_id == 17 || $serv_id == 22 || $serv_id == 23 || $serv_id == 24 || $serv_id == 26 || $serv_id == 27 ||  $serv_id == 28 || $serv_id == 29 || $serv_id == 30 || $serv_id == 34 || $serv_id == 35 || $serv_id == 36) {
					$this->flashSuccess(__('El puntaje del DSP fué creado. Continúe con el siguiente cuestionario.', true), '/hsq_scores/add_hsq/quest:3/eval:' . $eval_id . '/elang:' . $lang_id . '/test_serie:' . $test_serie);
				} else {
					// TRQ - INITIAL
					if (($test_serie == 1) && ($serv_id == 1 || $serv_id == 2 || $serv_id == 5 || $serv_id == 6 || $serv_id == 40 || $serv_id == 42 || $serv_id == 44)) {
						$quest_next = 4;
					}
					// TRQ - FOLLOW UP
					if (($test_serie > 1) && ($serv_id == 3 || $serv_id == 4 || $serv_id == 7 || $serv_id == 8 || $serv_id == 41 || $serv_id == 43 || $serv_id == 45)) {
						$quest_next = 5;
					}
					$this->flashSuccess(__('El puntaje del DSP fué creado. Continúe con el siguiente cuestionario.', true), '/questionnaire_treatments/add_treatqst/quest:' . $quest_next . '/eval:' . $eval_id . '/elang:' . $lang_id . '/test_serie:' . $test_serie);
				}
			} else {
				$this->flashWarning(__('El puntaje del DSP no fué creado. Intente de nuevo.', true));
			}
		} else {
			$this->data['DspScore']['langue'] = $lang_id;
			$infoEval = $this->DspScore->Evaluation->infoEval($eval_id);
			$infoDSPquestionnaire = $this->DspScore->Evaluation->infoServorderDSP($eval_id);

			##### set the data to save DSP
			# set up default values for form

			if ($infoDSPquestionnaire[0]['Questionnaire']['id'] == 1) {
				# DSP 45
				$this->data['DspScore']['type_q'] = 'DSP - 45';
			} else {
				# DSP 77
				$this->data['DspScore']['type_q'] = 'DSP - 77';
			}

			$this->data['DspScore']['evaluation_id'] = $eval_id;
			$this->data['DspScore']['questionnaire_id'] = $infoDSPquestionnaire[0]['Questionnaire']['id'];
			$this->data['DspScore']['test_serie'] = $test_serie;
			$this->data['Service']['id'] = $infoEval['Service']['id'];
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];

			$this->data['DspScore']['createdby'] = $this->Session->read('Auth.User.username');


			# Get all the questions from a specific Questionnaire
			$questions = $this->DspScore->Questionnaire->infoquestion($infoDSPquestionnaire[0]['Questionnaire']['id']);

			$allchoices = array();

			foreach ($questions as $question) :
				$choices = $this->DspScore->Questionnaire->Question->Choice->questionchoices($question['Question']['id'], $lang_id);

				$allchoices = array_merge($allchoices, $choices);

			endforeach;
		}
		$this->set(compact('infoEval', 'questions', 'allchoices'));
	}
	
	function edit() {
		if (!empty($this->data)) {
			if ($this->DspScore->save($this->data['DspScore'])) {
				$this->flashSuccess(__('El puntaje del DSP fue actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['DspScore']['evaluation_id']);
			} else {
				$this->flashWarning(__('El puntaje del DSP fue actualizado. Intente de nuevo.', true));
			}
		}elseif (empty($this->data)) {
			# First time the page is loaded
			if (isset($this->params['named']['eval'])) {
				$eval_id = $this->params['named']['eval'];
				$lang_id = $this->params['named']['elang'];
			}
			# Get the DspScore Questionnaire information
			# Order info - header
			$this->data['DspScore']['langue'] = $lang_id;
			$infoEval = $this->DspScore->Evaluation->infoEval($eval_id);
			$infoCurrentDsp = $this->DspScore->infoCurrentDsp($eval_id);	

			##### set the data to save DSP
			# set up default values for form
			# DSP 45
			if( $infoCurrentDsp['DspScore']['questionnaire_id'] == 1 ) { 					
				$questionsCount = 45;			
			} elseif ( $infoCurrentDsp['DspScore']['questionnaire_id'] == 2 ) {
			// DSP 77
				$questionsCount = 77;
			}
			
			$this->data['DspScore']['id'] = $infoCurrentDsp['DspScore']['id'];
			$this->data['DspScore']['type_q'] = $infoCurrentDsp['DspScore']['type_q'];
			$this->data['DspScore']['evaluation_id'] = $eval_id;
			$this->data['DspScore']['questionnaire_id'] = $infoCurrentDsp['DspScore']['questionnaire_id'];
			$this->data['DspScore']['ctrlform'] = 2;  //to control the select input question - VIEW
			$this->data['Service']['id'] = $infoEval['Service']['id'];
				
			# Get all the questions from a specific Questionnaire
			$questions = $this->DspScore->Questionnaire->infoquestion($infoCurrentDsp['DspScore']['questionnaire_id']);

			#Answers Info
			$dspanswers = array();
			for ($i=0; $i < $questionsCount; $i++) {
				$rest = substr($infoCurrentDsp['DspScore']['answers'], $i, 1);
				$dspanswers = $dspanswers + array($i => $rest);
			}			

			$allchoices = array(); 
												
			foreach($questions as $question):
					$choices = $this->DspScore->Questionnaire->Question->Choice->questionchoices($question['Question']['id'],$lang_id);
					$allchoices = array_merge($allchoices, $choices);						
			endforeach;
			
			$this->set(compact('questions', 'infoEval', 'infoCurrentDsp', 'dspanswers', 'allchoices'));			
		}
	}

	function view_dsp_score() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$ord_id = $this->params['named']['ord'];
			$quest_id = $this->params['named']['quest'];
			$test_serie = $this->params['named']['test_serie'];
		}
		
		$this->loadModel('DocLabel');
		$labelsDSPReport = $this->DocLabel->labelsQSTXReport(5, $lang_id, 1, 1);

		# Get a complete information about the current DSP Score: Customer/Employee/Evaluation/DSP		
		$infoDsp = $this->DspScore->infoDsp($eval_id);

		# Get an array Interpretation of the current DSP Score		
		$interpDspScore = $this->DspScore->interpDspScore($eval_id, $lang_id);
		
		# Get an array of the Critical answers of the current DSP Score		
		$criticalDspList = $this->DspScore->criticalDspList($eval_id, $quest_id, $lang_id);	

		# Get the History DSP values scales from an specific Employee, before create the Graph
		$infoHistScaleDsp = $this->DspScore->Evaluation->Order->infoHistScaleDsp($ord_id, $test_serie);
		
		$infodataset = $this->DspScore->infodataset($infoHistScaleDsp);
	
		# Create the .png Image
		$strdate = date("ymd");
		$filenameimg = 'DSP'.$eval_id.$strdate;

		$this->__barLibchart($filenameimg,$infodataset);
		
		$this->layout = 'pdf'; //this will use the pdf.ctp layout
			
		$this->set(compact('infoDsp', 'lang_id', 'labelsDSPReport', 'interpDspScore', 'criticalDspList','filenameimg'));
		$this->render();
	}		
	
	function view_combo_dsp_trq_score() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$ord_id = $this->params['named']['ord'];
			$quest_id = $this->params['named']['quest'];
			$test_serie = $this->params['named']['test_serie'];
		}
		
		$this->loadModel('QuestionnaireTreatment');
		$infoCustomerEvalorder = $this->QuestionnaireTreatment->Evaluation->infoCustomerEvalOrder($eval_id);
		$interpDoctorLetter = $this->QuestionnaireTreatment->interpDoctorLetter($eval_id, $infoCustomerEvalorder['Evaluation']['test_serie'],$lang_id);	


		$this->loadModel('DocLabel');
		$labelsDSPReport = $this->DocLabel->labelsQSTXReport(5, $lang_id, 1, 1);

		# Get a complete information about the current DSP Score: Customer/Employee/Evaluation/DSP		
		$infoDsp = $this->DspScore->infoDsp($eval_id);

		# Get an array Interpretation of the current DSP Score		
		$interpDspScore = $this->DspScore->interpDspScore($eval_id, $lang_id);
		
		# Get an array of the Critical answers of the current DSP Score		
		$criticalDspList = $this->DspScore->criticalDspList($eval_id, $quest_id, $lang_id);	

		# Get the History DSP values scales from an specific Employee, before create the Graph
		$infoHistScaleDsp = $this->DspScore->Evaluation->Order->infoHistScaleDsp($ord_id, $test_serie);
		
		$infodataset = $this->DspScore->infodataset($infoHistScaleDsp);

	
		# Create the .png Image
		$strdate = date("ymd");
		$filenameimg = 'DSP'.$eval_id.$strdate;
	
		$this->__barLibchart($filenameimg, $infodataset);
		
		$this->layout = 'pdf'; //this will use the pdf.ctp layout
			
		$this->set(compact('infoDsp', 'lang_id', 'labelsDSPReport', 'interpDspScore', 'criticalDspList','filenameimg','infoCustomerEvalorder','interpDoctorLetter'));
		$this->render();
	}	
	
	function dsp_history() {
		$eval_id = 0; $test_serie = 0; $order_id = 0;
		# First time the page is loaded
		if (isset($this->params['named']['eval']) && isset($this->params['named']['test_serie']) && 
			isset($this->params['named']['order'])){
			$eval_id = $this->params['named']['eval'];
			$test_serie = $this->params['named']['test_serie'];
			$order_id = $this->params['named']['order'];
		}
		
		# Get the DspScore Questionnaire information
		# Order info - header
		$infoEval = $this->DspScore->Evaluation->infoEval($eval_id);
		$infoHistoryDsp = $this->DspScore->infoHistoryDsp($eval_id,$order_id,$test_serie);	
		//echo pr($infoHistoryDsp);
		$this->set(compact('infoHistoryDsp', 'infoEval'));
	}
	
	function __barLibchart($filenameimg,$infodatasets) {
		App::import('Vendor', 'libchart/classes/libchart');	
		$chart = new VerticalBarChart(830, 400);

		$items = count($infodatasets);  //ex. 1 - number of tests
		$dspquest = count($infodatasets[0]);  //ex.10 - number of scales
	
		if ($items > 4) { $chart->getConfig()->setShowPointCaption(false); }
		
		if ($items == 1) {
			$serie1 = new XYDataSet();

			$serie1->addPoint(new Point("SOM-".$infodatasets[0][0], $infodatasets[0][0]));
			// print_r($serie1);	die();	
			$serie1->addPoint(new Point("DEP-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("ALC-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("ANX-".$infodatasets[0][3], $infodatasets[0][3]));
			
			if ($dspquest == 5) {
				$serie1->addPoint(new Point("RB-".$infodatasets[0][4], $infodatasets[0][4]));
			} elseif ($dspquest == 10) {
				$serie1->addPoint(new Point("OBS-".$infodatasets[0][4], $infodatasets[0][4]));
				$serie1->addPoint(new Point("PAN-".$infodatasets[0][5], $infodatasets[0][5]));
				$serie1->addPoint(new Point("AGO-".$infodatasets[0][6], $infodatasets[0][6]));
				$serie1->addPoint(new Point("TRA-".$infodatasets[0][7], $infodatasets[0][7]));
				$serie1->addPoint(new Point("MIN-".$infodatasets[0][8], $infodatasets[0][8]));
				$serie1->addPoint(new Point("RB-".$infodatasets[0][9], $infodatasets[0][9]));			
			}	
			// var_dump($serie1);	die();				
			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test #1", $serie1);			
		} elseif ($items == 2) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("SOM-".$infodatasets[1][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("DEP-".$infodatasets[1][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("ALC-".$infodatasets[1][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("ANX-".$infodatasets[1][3], $infodatasets[0][3]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("SOM", $infodatasets[1][0]));
			$serie2->addPoint(new Point("DEP", $infodatasets[1][1]));
			$serie2->addPoint(new Point("ALC", $infodatasets[1][2]));
			$serie2->addPoint(new Point("ANX", $infodatasets[1][3]));			
			
			if ($dspquest == 5) {
				$serie1->addPoint(new Point("RB-".$infodatasets[1][4], $infodatasets[0][4]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][4]));
			} elseif ($dspquest == 10) {
				$serie1->addPoint(new Point("OBS-".$infodatasets[1][4], $infodatasets[0][4]));
				$serie1->addPoint(new Point("PAN-".$infodatasets[1][5], $infodatasets[0][5]));
				$serie1->addPoint(new Point("AGO-".$infodatasets[1][6], $infodatasets[0][6]));
				$serie1->addPoint(new Point("TRA-".$infodatasets[1][7], $infodatasets[0][7]));
				$serie1->addPoint(new Point("MIN-".$infodatasets[1][8], $infodatasets[0][8]));
				$serie1->addPoint(new Point("RB-".$infodatasets[1][9], $infodatasets[0][9]));	

				$serie2->addPoint(new Point("OBS", $infodatasets[1][4]));
				$serie2->addPoint(new Point("PAN", $infodatasets[1][5]));
				$serie2->addPoint(new Point("AGO", $infodatasets[1][6]));
				$serie2->addPoint(new Point("TRA", $infodatasets[1][7]));
				$serie2->addPoint(new Point("MIN", $infodatasets[1][8]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][9]));	
			}			

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test #1", $serie1);
			$dataSet->addSerie("Test #2", $serie2);			
		} elseif ($items == 3) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("SOM-".$infodatasets[2][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("DEP-".$infodatasets[2][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("ALC-".$infodatasets[2][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("ANX-".$infodatasets[2][3], $infodatasets[0][3]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("SOM", $infodatasets[1][0]));
			$serie2->addPoint(new Point("DEP", $infodatasets[1][1]));
			$serie2->addPoint(new Point("ALC", $infodatasets[1][2]));
			$serie2->addPoint(new Point("ANX", $infodatasets[1][3]));			

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("SOM", $infodatasets[2][0]));
			$serie3->addPoint(new Point("DEP", $infodatasets[2][1]));
			$serie3->addPoint(new Point("ALC", $infodatasets[2][2]));
			$serie3->addPoint(new Point("ANX", $infodatasets[2][3]));
			
			if ($dspquest == 5) {
				$serie1->addPoint(new Point("RB-".$infodatasets[2][4], $infodatasets[0][4]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][4]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][4]));
			} elseif ($dspquest == 10) {
				$serie1->addPoint(new Point("OBS-".$infodatasets[2][4], $infodatasets[0][4]));
				$serie1->addPoint(new Point("PAN-".$infodatasets[2][5], $infodatasets[0][5]));
				$serie1->addPoint(new Point("AGO-".$infodatasets[2][6], $infodatasets[0][6]));
				$serie1->addPoint(new Point("TRA-".$infodatasets[2][7], $infodatasets[0][7]));
				$serie1->addPoint(new Point("MIN-".$infodatasets[2][8], $infodatasets[0][8]));
				$serie1->addPoint(new Point("RB-".$infodatasets[2][9], $infodatasets[0][9]));	

				$serie2->addPoint(new Point("OBS", $infodatasets[1][4]));
				$serie2->addPoint(new Point("PAN", $infodatasets[1][5]));
				$serie2->addPoint(new Point("AGO", $infodatasets[1][6]));
				$serie2->addPoint(new Point("TRA", $infodatasets[1][7]));
				$serie2->addPoint(new Point("MIN", $infodatasets[1][8]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][9]));

				$serie3->addPoint(new Point("OBS", $infodatasets[2][4]));
				$serie3->addPoint(new Point("PAN", $infodatasets[2][5]));
				$serie3->addPoint(new Point("AGO", $infodatasets[2][6]));
				$serie3->addPoint(new Point("TRA", $infodatasets[2][7]));
				$serie3->addPoint(new Point("MIN", $infodatasets[2][8]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][9]));			
			}				

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test #1", $serie1);
			$dataSet->addSerie("Test #2", $serie2);
			$dataSet->addSerie("Test #3", $serie3);			
		} elseif ($items == 4) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("SOM-".$infodatasets[3][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("DEP-".$infodatasets[3][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("ALC-".$infodatasets[3][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("ANX-".$infodatasets[3][3], $infodatasets[0][3]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("SOM", $infodatasets[1][0]));
			$serie2->addPoint(new Point("DEP", $infodatasets[1][1]));
			$serie2->addPoint(new Point("ALC", $infodatasets[1][2]));
			$serie2->addPoint(new Point("ANX", $infodatasets[1][3]));		

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("SOM", $infodatasets[2][0]));
			$serie3->addPoint(new Point("DEP", $infodatasets[2][1]));
			$serie3->addPoint(new Point("ALC", $infodatasets[2][2]));
			$serie3->addPoint(new Point("ANX", $infodatasets[2][3]));
			
			$serie4 = new XYDataSet();
			$serie4->addPoint(new Point("SOM", $infodatasets[3][0]));
			$serie4->addPoint(new Point("DEP", $infodatasets[3][1]));
			$serie4->addPoint(new Point("ALC", $infodatasets[3][2]));
			$serie4->addPoint(new Point("ANX", $infodatasets[3][3]));
			
			if ($dspquest == 5) {
				$serie1->addPoint(new Point("RB-".$infodatasets[3][4], $infodatasets[0][4]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][4]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][4]));
				$serie4->addPoint(new Point("RB", $infodatasets[3][4]));
			} elseif ($dspquest == 10) {
				$serie1->addPoint(new Point("OBS-".$infodatasets[3][4], $infodatasets[0][4]));
				$serie1->addPoint(new Point("PAN-".$infodatasets[3][5], $infodatasets[0][5]));
				$serie1->addPoint(new Point("AGO-".$infodatasets[3][6], $infodatasets[0][6]));
				$serie1->addPoint(new Point("TRA-".$infodatasets[3][7], $infodatasets[0][7]));
				$serie1->addPoint(new Point("MIN-".$infodatasets[3][8], $infodatasets[0][8]));
				$serie1->addPoint(new Point("RB-".$infodatasets[3][9], $infodatasets[0][9]));	

				$serie2->addPoint(new Point("OBS", $infodatasets[1][4]));
				$serie2->addPoint(new Point("PAN", $infodatasets[1][5]));
				$serie2->addPoint(new Point("AGO", $infodatasets[1][6]));
				$serie2->addPoint(new Point("TRA", $infodatasets[1][7]));
				$serie2->addPoint(new Point("MIN", $infodatasets[1][8]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][9]));

				$serie3->addPoint(new Point("OBS", $infodatasets[2][4]));
				$serie3->addPoint(new Point("PAN", $infodatasets[2][5]));
				$serie3->addPoint(new Point("AGO", $infodatasets[2][6]));
				$serie3->addPoint(new Point("TRA", $infodatasets[2][7]));
				$serie3->addPoint(new Point("MIN", $infodatasets[2][8]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][9]));	

				$serie4->addPoint(new Point("OBS", $infodatasets[3][4]));
				$serie4->addPoint(new Point("PAN", $infodatasets[3][5]));
				$serie4->addPoint(new Point("AGO", $infodatasets[3][6]));
				$serie4->addPoint(new Point("TRA", $infodatasets[3][7]));
				$serie4->addPoint(new Point("MIN", $infodatasets[3][8]));
				$serie4->addPoint(new Point("RB", $infodatasets[3][9]));			
			}			

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test #1", $serie1);
			$dataSet->addSerie("Test #2", $serie2);
			$dataSet->addSerie("Test #3", $serie3);
			$dataSet->addSerie("Test #4", $serie4);			
		} elseif ($items == 5) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("SOM-".$infodatasets[4][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("DEP-".$infodatasets[4][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("ALC-".$infodatasets[4][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("ANX-".$infodatasets[4][3], $infodatasets[0][3]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("SOM", $infodatasets[1][0]));
			$serie2->addPoint(new Point("DEP", $infodatasets[1][1]));
			$serie2->addPoint(new Point("ALC", $infodatasets[1][2]));
			$serie2->addPoint(new Point("ANX", $infodatasets[1][3]));			

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("SOM", $infodatasets[2][0]));
			$serie3->addPoint(new Point("DEP", $infodatasets[2][1]));
			$serie3->addPoint(new Point("ALC", $infodatasets[2][2]));
			$serie3->addPoint(new Point("ANX", $infodatasets[2][3]));
			
			$serie4 = new XYDataSet();
			$serie4->addPoint(new Point("SOM", $infodatasets[3][0]));
			$serie4->addPoint(new Point("DEP", $infodatasets[3][1]));
			$serie4->addPoint(new Point("ALC", $infodatasets[3][2]));
			$serie4->addPoint(new Point("ANX", $infodatasets[3][3]));
			
			$serie5 = new XYDataSet();
			$serie5->addPoint(new Point("SOM", $infodatasets[4][0]));
			$serie5->addPoint(new Point("DEP", $infodatasets[4][1]));
			$serie5->addPoint(new Point("ALC", $infodatasets[4][2]));
			$serie5->addPoint(new Point("ANX", $infodatasets[4][3]));

			if ($dspquest == 5) {
				$serie1->addPoint(new Point("RB-".$infodatasets[4][4], $infodatasets[0][4]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][4]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][4]));
				$serie4->addPoint(new Point("RB", $infodatasets[3][4]));
				$serie5->addPoint(new Point("RB", $infodatasets[4][4]));
			} elseif ($dspquest == 10) {
				$serie1->addPoint(new Point("OBS-".$infodatasets[4][4], $infodatasets[0][4]));
				$serie1->addPoint(new Point("PAN-".$infodatasets[4][5], $infodatasets[0][5]));
				$serie1->addPoint(new Point("AGO-".$infodatasets[4][6], $infodatasets[0][6]));
				$serie1->addPoint(new Point("TRA-".$infodatasets[4][7], $infodatasets[0][7]));
				$serie1->addPoint(new Point("MIN-".$infodatasets[4][8], $infodatasets[0][8]));
				$serie1->addPoint(new Point("RB-".$infodatasets[4][9], $infodatasets[0][9]));	

				$serie2->addPoint(new Point("OBS", $infodatasets[1][4]));
				$serie2->addPoint(new Point("PAN", $infodatasets[1][5]));
				$serie2->addPoint(new Point("AGO", $infodatasets[1][6]));
				$serie2->addPoint(new Point("TRA", $infodatasets[1][7]));
				$serie2->addPoint(new Point("MIN", $infodatasets[1][8]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][9]));

				$serie3->addPoint(new Point("OBS", $infodatasets[2][4]));
				$serie3->addPoint(new Point("PAN", $infodatasets[2][5]));
				$serie3->addPoint(new Point("AGO", $infodatasets[2][6]));
				$serie3->addPoint(new Point("TRA", $infodatasets[2][7]));
				$serie3->addPoint(new Point("MIN", $infodatasets[2][8]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][9]));	

				$serie4->addPoint(new Point("OBS", $infodatasets[3][4]));
				$serie4->addPoint(new Point("PAN", $infodatasets[3][5]));
				$serie4->addPoint(new Point("AGO", $infodatasets[3][6]));
				$serie4->addPoint(new Point("TRA", $infodatasets[3][7]));
				$serie4->addPoint(new Point("MIN", $infodatasets[3][8]));
				$serie4->addPoint(new Point("RB", $infodatasets[3][9]));

				$serie5->addPoint(new Point("OBS", $infodatasets[4][4]));
				$serie5->addPoint(new Point("PAN", $infodatasets[4][5]));
				$serie5->addPoint(new Point("AGO", $infodatasets[4][6]));
				$serie5->addPoint(new Point("TRA", $infodatasets[4][7]));
				$serie5->addPoint(new Point("MIN", $infodatasets[4][8]));
				$serie5->addPoint(new Point("RB", $infodatasets[4][9]));			
			}			
			
			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test #1", $serie1);
			$dataSet->addSerie("Test #2", $serie2);
			$dataSet->addSerie("Test #3", $serie3);
			$dataSet->addSerie("Test #4", $serie4);
			$dataSet->addSerie("Test #5", $serie5);			
		} elseif ($items == 6) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("SOM-".$infodatasets[5][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("DEP-".$infodatasets[5][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("ALC-".$infodatasets[5][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("ANX-".$infodatasets[5][3], $infodatasets[0][3]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("SOM", $infodatasets[1][0]));
			$serie2->addPoint(new Point("DEP", $infodatasets[1][1]));
			$serie2->addPoint(new Point("ALC", $infodatasets[1][2]));
			$serie2->addPoint(new Point("ANX", $infodatasets[1][3]));		

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("SOM", $infodatasets[2][0]));
			$serie3->addPoint(new Point("DEP", $infodatasets[2][1]));
			$serie3->addPoint(new Point("ALC", $infodatasets[2][2]));
			$serie3->addPoint(new Point("ANX", $infodatasets[2][3]));
			
			$serie4 = new XYDataSet();
			$serie4->addPoint(new Point("SOM", $infodatasets[3][0]));
			$serie4->addPoint(new Point("DEP", $infodatasets[3][1]));
			$serie4->addPoint(new Point("ALC", $infodatasets[3][2]));
			$serie4->addPoint(new Point("ANX", $infodatasets[3][3]));
			
			$serie5 = new XYDataSet();
			$serie5->addPoint(new Point("SOM", $infodatasets[4][0]));
			$serie5->addPoint(new Point("DEP", $infodatasets[4][1]));
			$serie5->addPoint(new Point("ALC", $infodatasets[4][2]));
			$serie5->addPoint(new Point("ANX", $infodatasets[4][3]));
			
			$serie6 = new XYDataSet();
			$serie6->addPoint(new Point("SOM", $infodatasets[5][0]));
			$serie6->addPoint(new Point("DEP", $infodatasets[5][1]));
			$serie6->addPoint(new Point("ALC", $infodatasets[5][2]));
			$serie6->addPoint(new Point("ANX", $infodatasets[5][3]));			
			
			if ($dspquest == 5) {
				$serie1->addPoint(new Point("RB-".$infodatasets[5][4], $infodatasets[0][4]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][4]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][4]));
				$serie4->addPoint(new Point("RB", $infodatasets[3][4]));
				$serie5->addPoint(new Point("RB", $infodatasets[4][4]));
				$serie6->addPoint(new Point("RB", $infodatasets[5][4]));
			} elseif ($dspquest == 10) {
				$serie1->addPoint(new Point("OBS-".$infodatasets[5][4], $infodatasets[0][4]));
				$serie1->addPoint(new Point("PAN-".$infodatasets[5][5], $infodatasets[0][5]));
				$serie1->addPoint(new Point("AGO-".$infodatasets[5][6], $infodatasets[0][6]));
				$serie1->addPoint(new Point("TRA-".$infodatasets[5][7], $infodatasets[0][7]));
				$serie1->addPoint(new Point("MIN-".$infodatasets[5][8], $infodatasets[0][8]));
				$serie1->addPoint(new Point("RB-".$infodatasets[5][9], $infodatasets[0][9]));	

				$serie2->addPoint(new Point("OBS", $infodatasets[1][4]));
				$serie2->addPoint(new Point("PAN", $infodatasets[1][5]));
				$serie2->addPoint(new Point("AGO", $infodatasets[1][6]));
				$serie2->addPoint(new Point("TRA", $infodatasets[1][7]));
				$serie2->addPoint(new Point("MIN", $infodatasets[1][8]));
				$serie2->addPoint(new Point("RB", $infodatasets[1][9]));

				$serie3->addPoint(new Point("OBS", $infodatasets[2][4]));
				$serie3->addPoint(new Point("PAN", $infodatasets[2][5]));
				$serie3->addPoint(new Point("AGO", $infodatasets[2][6]));
				$serie3->addPoint(new Point("TRA", $infodatasets[2][7]));
				$serie3->addPoint(new Point("MIN", $infodatasets[2][8]));
				$serie3->addPoint(new Point("RB", $infodatasets[2][9]));	

				$serie4->addPoint(new Point("OBS", $infodatasets[3][4]));
				$serie4->addPoint(new Point("PAN", $infodatasets[3][5]));
				$serie4->addPoint(new Point("AGO", $infodatasets[3][6]));
				$serie4->addPoint(new Point("TRA", $infodatasets[3][7]));
				$serie4->addPoint(new Point("MIN", $infodatasets[3][8]));
				$serie4->addPoint(new Point("RB", $infodatasets[3][9]));

				$serie5->addPoint(new Point("OBS", $infodatasets[4][4]));
				$serie5->addPoint(new Point("PAN", $infodatasets[4][5]));
				$serie5->addPoint(new Point("AGO", $infodatasets[4][6]));
				$serie5->addPoint(new Point("TRA", $infodatasets[4][7]));
				$serie5->addPoint(new Point("MIN", $infodatasets[4][8]));
				$serie5->addPoint(new Point("RB", $infodatasets[4][9]));

				$serie6->addPoint(new Point("OBS", $infodatasets[5][4]));
				$serie6->addPoint(new Point("PAN", $infodatasets[5][5]));
				$serie6->addPoint(new Point("AGO", $infodatasets[5][6]));
				$serie6->addPoint(new Point("TRA", $infodatasets[5][7]));
				$serie6->addPoint(new Point("MIN", $infodatasets[5][8]));
				$serie6->addPoint(new Point("RB", $infodatasets[5][9]));			
			}				

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test #1", $serie1);
			$dataSet->addSerie("Test #2", $serie2);
			$dataSet->addSerie("Test #3", $serie3);
			$dataSet->addSerie("Test #4", $serie4);
			$dataSet->addSerie("Test #5", $serie5);
			$dataSet->addSerie("Test #6", $serie6);			
		}
		
		$chart->setDataSet($dataSet);
		// var_dump($dataSet);	die();	
		$chart->getPlot()->setGraphCaptionRatio(0.69);
		// $chart->getPlot()->setGraphCaptionRatio(0.69);
		
		$path_file = 'img/dsp/'.$filenameimg.'.png';

		// echo($path_file); die();	
	
		# Validate if the file already exists		
        while(is_file($path_file) == TRUE) {
            chmod($path_file, 0666);
            unlink($path_file);
        }
		$chart->setTitle("");
		$chart->render($path_file);			
	}	
	
	function __lists() {

	}		
}
?>