<?php
class EmailParametersController extends AppController {

	var $name = 'EmailParameters';
	var $helpers = array('Html', 'Form', 'Time');
	
	
	function beforeFilter() {
	  if ($this->only(array('add', 'edit'))) { $this->__lists(); }
	  parent::beforeFilter();
	}
	
	
	function index() {
		$this->EmailParameter->recursive = 0;
		$this->set('emailParameters', $this->paginate());	
	}

	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('emailParameter', $this->EmailParameter->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/emailParameters'); 
	}
	
	function add() {
		if (!empty($this->data)) {
			$this->EmailParameter->create();
			if ($this->EmailParameter->save($this->data)) {
				$this->flashSuccess(__('The Email parameter has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Email parameter could not be created. Please correct the error(s) and try again', true));
			}
		}
	}	
	

	function edit($id = null) {
    $this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->EmailParameter->save($this->data)) {
				$this->flashSuccess(__('The Email Parameter has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Email Parameter could not be updated. Please correct the error(s) and try again', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->EmailParameter->read(null, $id);
		}
	}	


	function delete($id = null) {
    $this->idEmptyRedirect($id, 'index');
		
		if ($this->EmailParameter->delete($id)) {
			$this->flashSuccess('Email parameter deleted', 'index');
		}
	}	
	
	#private methods
	
	function __lists() {
		$currentLang = Configure::read('Config.language');	
		$statuses = $this->EmailParameter->Status->find('list', array('conditions' => array('active' => 1), 
								'fields' => array('id', 'name_'.$currentLang),
								'order' => array('name_'.$currentLang))
								);	
		$this->set(compact('statuses'));
	}		
}
?>