<?php
class EmployeesController extends AppController {

	var $name = 'Employees';
	var $helpers = array('Html', 'Form', 'Time', 'Js' => array('Jquery'), 'FormatMask.Format');
	var $components = array('RequestHandler', 'FormatMask.Format');
	
	var $paginate = array('limit' => 10);

	function beforeFilter() {
		$this->customer_id = $this->Auth->user('customer_id');
		$this->group_id = $this->Auth->user('group_id');	
		parent::beforeFilter();	
	}

	
	function index() {
		$this->layout = 'main_index';
		$this->redirectToNamed();		
		$conditions = array();	
		
		$params = $this->params['named'];
		
		if (!empty($params['employee_first_name'])) {
		  $conditions['Employee.first_name LIKE'] = '%'.$params['employee_first_name'].'%';
		}	

		if (!empty($params['customer_internalcode'])) {
		  $conditions['Employee.customer_internalcode LIKE'] =  '%'.$params['customer_internalcode'];
		}
		
		if (!empty($params['employee_last_name'])) {
		  $conditions['Employee.last_name LIKE'] = $params['employee_last_name'].'%';
		}	
		
		if (!empty($params['day_f']) && !empty($params['month_f']) && !empty($params['year_f'])) {
		  $conditions['Employee.date_birth'] = $params['year_f'].'-'.$params['month_f'].'-'.$params['day_f'];
		}		
		
		$urlArgs = array('url' => $params);
		
		if (empty($conditions)) {
		  $conditions['Employee.customer_internalcode ='] = 0;
		}		
	
		if (($this->group_id == 2) || ($this->group_id == 3)) {
		//Superv - Case manager
			$conditions['Employee.customer_id ='] = $this->customer_id;
		}	

		$this->paginate = array(
						'fields' => array('id','last_name','first_name','date_birth','ind','customer_id','Customer.name'),			
						'conditions' => $conditions,
						'order' => array('Customer.id ASC', 'Employee.id ASC')
					);
	
		$employees = $this->paginate('Employee');
		$this->set(compact('employees', 'urlArgs'));
		
		$params['year_f'] = '';
		$params['month_f'] = '';
		$params['day_f'] = '';
		
	}

	
	function view() {
		if (isset($this->params['named']['id'])){
			$eval_id = '';
			$id = $this->params['named']['id'];
			$parag = $this->params['named']['parag'];
			if (isset($this->params['named']['eval_id'])) { $eval_id = $this->params['named']['eval_id']; }			
			
			//$this->idEmptyRedirect($id, 'index');
			$employee = $this->Employee->read(null, $id);
			
			$this->set(compact('employee', 'parag', 'eval_id'));
		}		
	}
	
	function cancel() {
		if ($this->params['named']['parag'] == 'r1' || $this->params['named']['parag'] == 'r2') {
		//View evaluation
			//http://localhost/testmetrix/evaluations/view/311
			$this->redirect('/evaluations/view/'.$this->params['named']['eval_id']);
		} elseif ($this->params['named']['parag'] == 'r0') {
			$last_name = '';
			if (isset($this->params['named']['last_name'])) {
				$last_name = $this->params['named']['last_name'];
			}	
			$this->redirect('/employees/index/employee_last_name:'.$last_name);
		} else {
			$this->redirect('/employees/index/');
			//http://localhost/testmetrix/employees/index/employee_last_name:Li
		}
	}

	function add() {
		if (!empty($this->data)) {
			// Get the first of last names to create correct URL after editing an employee
			$ulr_name = str_replace(' ', '+', $this->data['Employee']['last_name']); 
			$this->Employee->create();
			$this->data['Employee']['code_postal'] = strtoupper($this->data['Employee']['code_postal']);
			$this->data['Employee']['email'] = trim($this->data['Employee']['email']);
			if ($this->Employee->save($this->data)) {
				// $this->flashSuccess(__('El empleado fué creado.', true), 'index/employee_first_name:'.str_replace(' ', '', $this->data['Employee']['first_name'].'/employee_last_name:'.$this->data['Employee']['last_name']));
				$this->flashSuccess(__('El empleado fué creado.', true), 'index/employee_last_name:'.$ulr_name);
			} else {
				$this->flashWarning(__('El empleado no fué creado. Corrija el error e intente de nuevo.', true));
			}
		} else {
			$this->data['Employee']['createdby'] = $this->Session->read('Auth.User.username');
		}
		# Admin
		if ($this->group_id == 1) {		
			$customers = $this->Employee->Customer->find('list', array('conditions' => array('Customer.active' => 1), 'fields' => array('id', 'name'),'order' => 'name ASC'));	
		} elseif ($this->group_id == 2 || $this->group_id == 3) {	
		# Superv
			$customers = $this->Employee->Customer->find('list', array('conditions' => array('Customer.active' => 1, 'Customer.id' => $this->customer_id), 
					'fields' => array('id', 'name'),'order' => 'name ASC'));	
		}			
		$provinces = $this->Employee->Province->find('list', array('fields' => array('id', 'name'),'order' => 'name ASC'));		
		
		$this->set(compact('provinces','customers'));
	}
	
	
	function edit() {	
		if (isset($this->params['named']['id'])){
			$eval_id = '';   //$id = null
			$id = $this->params['named']['id'];
			$parag = $this->params['named']['parag'];   //$this->params['named']['parag'] == 'r1'
			if (isset($this->params['named']['eval_id'])) { $eval_id = $this->params['named']['eval_id']; }		
		}	
		
		if (!empty($this->data)) {
			// Get the first of last names to create correct URL after editing an employee
			$ulr_name = str_replace(' ', '+', $this->data['Employee']['last_name']);
			$this->data['Employee']['code_postal'] = strtoupper($this->data['Employee']['code_postal']);	
			$this->data['Employee']['email'] = trim($this->data['Employee']['email']);	
			if ($this->Employee->save($this->data)) {
				if($this->data['Employee']['parag'] == 'r1') {
					// $this->flashSuccess(__('El empleado fué actualizado', true), '/evaluations/index/employee_last_name:'.$this->data['Employee']['last_name']);	
					$this->flashSuccess(__('El empleado fué actualizado', true), '/evaluations/index/employee_last_name:'.$ulr_name);	
				//http://localhost/testmetrix/evaluations/index/order_code:20144
				} elseif($this->data['Employee']['parag'] == 'r0') {
					// $this->flashSuccess(__('El empleado fué actualizado', true), 'index/employee_last_name:'.$this->data['Employee']['last_name']);
					$this->flashSuccess(__('El empleado fué actualizado', true), 'index/employee_last_name:'.$ulr_name);
				//http://localhost/testmetrix/employees/index/employee_last_name:Ramirez
				}				
			} else {
				$this->flashWarning(__('El empleado no fué actualizado. Corrija el error e intente de nuevo.', true));
			}
		} else {		
			$this->data = $this->Employee->read(null, $id);
			$this->data['Employee']['modifiedby'] = $this->Session->read('Auth.User.username');					
			$this->data['Evaluation']['id'] = $eval_id;
			$this->data['Employee']['parag'] = $parag;
		}
			$cities = $this->Employee->City->find('list', array('fields' => array('id', 'name'),'order' => 'name ASC'));
			$provinces = $this->Employee->Province->find('list', array('fields' => array('id', 'name'),'order' => 'name ASC'));
			$customers = $this->Employee->Customer->find('list', array('conditions' => array('Customer.active' => 1), 'fields' => array('id', 'name'),'order' => 'name ASC'));		
		$this->set(compact('cities', 'provinces','customers'));
	}


	###After email link is clicked, the information about the patient is verified####	
	function verify_empinfo()
	{
		if (!empty($this->params['named']['wtf']) && !empty($this->params['named']['f08n'])) {
			$eval_check = $this->params['named']['wtf'];
			$emp_id = $this->params['named']['f08n'];
		}
		if (!empty($this->data)) {
			if (!empty($this->params['named']['t5yeh0']) && !empty($this->params['named']['xcv890p'])) {
				$this->Employee->id = $this->data['Employee']['id'];
				if ($this->Employee->save($this->data)) {
					$evail = $this->params['named']['t5yeh0'];
					$serv = $this->params['named']['xcv890p'];
					$test_serie = $this->params['named']['asx2is'];
					####After the patients information is confirmed the first questionnaire is opened according to the service Id. ####
					###Opens DSP-45 as a first questionnaire###
					if ($serv == 42 || $serv == 43 || $serv == 1 || $serv == 3 || $serv == 5 || $serv == 7 || $serv == 17 || $serv == 19 || $serv == 21 || $serv == 22 || $serv == 23 || $serv == 30 ||  $serv == 32 ||  $serv == 33 ||  $serv == 34 ||  $serv == 35 || $serv == 40 ||  $serv == 41) {
						$quest = 1;
						$this->flashSuccess(
							__('Su información fué guardada, continúe con el siguiente cuestionario.', true),
							'/dsp_scores/add_dsp/quest:' . $quest . '/eval:' . $evail . '/elang:' . $this->data['Employee']['langue'] . '/test_serie:' . $test_serie . '/vrse:' . $serv
						);
					}
					###Opens DSP-77 as a first questionnaire###
					if ($serv == 44 || $serv == 45 || $serv == 2 || $serv == 4 || $serv == 6 || $serv == 8 || $serv == 9 || $serv == 10 || $serv == 11 || $serv == 12 || $serv == 13 || $serv == 14 || $serv == 15 || $serv == 16 || $serv == 20 || $serv == 24 || $serv == 25 || $serv == 26 ||  $serv == 27 ||  $serv == 28 ||  $serv == 29 ||  $serv == 36 ||  $serv == 37 ||  $serv == 38) {
						$quest = 2;
						$this->flashSuccess(
							__('Su información fué guardada, continúe con el siguiente cuestionario.', true),
							'/dsp_scores/add_dsp/quest:' . $quest . '/eval:' . $evail . '/elang:' . $this->data['Employee']['langue'] . '/test_serie:' . $test_serie . '/vrse:' . $serv
						);
					}
					###Opens HSQ as a first questionnaire###
					if ($serv == 18 || $serv == 31) {
						$this->flashSuccess(
							__('Su información fué guardada, continúe con el siguiente cuestionario.', true),
							'/hsq_scores/add_hsq/quest:3/eval:' . $evail . '/elang:' . $this->data['Employee']['langue'] . '/test_serie:' . $test_serie . '/vrse:' . $serv
						);
					} //for opening an HSQ questionnaire as first and only option.



				} else {
					$this->flashWarning(__('Su información no fué guardada, intente de nuevo.', true));
				}
			}
		} else {
			$evalToken = $this->Employee->Order->Evaluation->findAllByTokenhash($eval_check);
			/////Edited here. Added statuses 10, 11 and 12 to allow test access when 1st, 2nd and 3rd reminders are sent.//
			if (($evalToken[0]['Evaluation']['status_id'] == 9) || ($evalToken[0]['Evaluation']['status_id'] == 10) || ($evalToken[0]['Evaluation']['status_id'] == 11) || ($evalToken[0]['Evaluation']['status_id'] == 12)) {
				$tokenPage = 1;
				$this->data = $this->Employee->read(null, $emp_id);
				$eval_id = $evalToken[0]['Evaluation']['id'];
				$serv_id = $evalToken[0]['Service']['id'];
				$test_serie = $evalToken[0]['Evaluation']['test_serie'];
			} else {
				$tokenPage = 0;
			}
		}
		$this->set(compact('tokenPage', 'eval_id', 'serv_id', 'test_serie'));
	}
	
	public function get_json_city() {
		$this->view = 'Json';
		
		$query = $this->params['url']['term'];
		$prov = $this->params['url']['prov'];
		
		$cities = $this->Employee->City->searchListCityName($query, $prov);
		$i=0;
		foreach($cities as $citie)
		{
			$json[$i]['value'] = $citie['City']['name'];
			$json[$i]['id'] = $citie['City']['id'];
			$i++;  
		}
		$this->set(compact('json'));
	}	
}
?>