<?php
class FeesController extends AppController {

	var $name = 'Fees';
	var $helpers = array('Html', 'Form', 'Time', 'Js' => array('Jquery'));
	var $components = array('RequestHandler');
	
	
	function beforeFilter() {
	  parent::beforeFilter();
	}	
	
	
	function index() {
		$this->Fee->recursive = 0;
		$this->set('fees', $this->paginate());
	}
	

	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('fee', $this->Fee->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/fees'); 
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->Fee->create();
			if ($this->Fee->save($this->data)) {
				$this->flashSuccess(__('The Fee has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Fee could not be created. Please correct the error(s) and try again', true));				
			}
		}
		# Get the current language for status
		$currentLang = Configure::read('Config.language');		
		$communications = $this->Fee->Communication->find('list', array('fields' => array('id', 'name_'.$currentLang),'order' => 'id ASC'));
		$services = $this->Fee->Service->find('list', array('conditions' => array('active' => 1, 'type_s' => $this->data['Fee']['type_test'])));
		$statuses = $this->Fee->Status->find('list', array('conditions' => array('invoiced'=> 1, 'type_s' => 2, 'active' => 1), 
							'fields' => array('id', 'name_'.$currentLang),
							'order' => array('name_'.$currentLang))
							);		
		$this->set(compact('communications','services','statuses'));		
	}		


	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		//$this->data = $this->Fee->read(null, $id);
		if (!empty($this->data)) {
			if ($this->Fee->save($this->data)) {
				$this->flashSuccess(__('The Fee has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Fee could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$currentLang = Configure::read('Config.language');	
			$communications = $this->Fee->Communication->find('list', array('fields' => array('id', 'name_'.$currentLang),'order' => 'id ASC'));
			$services = $this->Fee->Service->find('list', array('conditions' => array('active' => 1)));
			$statuses = $this->Fee->Status->find('list', array('conditions' => array('invoiced'=> 1, 'active' => 1), 
								'fields' => array('id', 'name_'.$currentLang),
								'order' => array('name_'.$currentLang))
								);
			$this->data = $this->Fee->read(null, $id);					
			$this->set(compact('communications','services','statuses'));			
		}
	}

	
	function delete($id = null) {
    $this->idEmptyRedirect($id, 'index');		
		if ($this->Fee->delete($id)) {
			$this->flashSuccess('Fee deleted', 'index');
		}
	}	
	
	
	#private methods
	function __lists() {

	}

	public function get_services_ajax() {
	  Configure::write('debug', 0);
	  if($this->RequestHandler->isAjax()) {
		$this->set('services', $this->Fee->Service->find('list',
							   array('conditions' =>
										   array('Service.type_s' => $this->params['url']['idtest'], 'active' => 1),
									 'recursive' => -1)));
	  }
	}	
	
}
?>