<?php
class GroupsController extends AppController {

	var $name = 'Groups';
	var $helpers = array('Html', 'Form', 'Time');

	
	public function beforeFilter() {
		parent::beforeFilter();
	}	
	
	function index() {
		$this->Group->recursive = 0;
		$this->set('groups', $this->paginate());
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->Group->create();
			if ($this->Group->save($this->data)) {
				$this->flashSuccess(__('The Group has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Group could not be created. Please correct the error(s) and try again', true));
			}
		}
	}

	
	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Group->save($this->data)) {
				$this->flashSuccess(__('The Group has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Group could not be updated. Please correct the error(s) and try again', true));
			}
		}else {
			$this->data = $this->Group->read(null, $id);
		}
	}	
	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('group', $this->Group->read(null, $id));
	}
	
	function cancel() {
		$this->redirect('/groups'); 
	}		
	
}
?>