<?php
class HsqInterpsController extends AppController {

	var $name = 'HsqInterps';
	var $helpers = array('Html', 'Form', 'Time');


	function beforeFilter() {
	  parent::beforeFilter();
	}
	

	function index() {
		$this->HsqInterp->recursive = 0;
		$this->set('hsqInterps', $this->paginate());
	}	
	
	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('hsqInterp', $this->HsqInterp->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/hsq_interps'); 
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->HsqInterp->create();
			if ($this->HsqInterp->save($this->data)) {
				$this->flashSuccess(__('The Hsq Interp. code has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Hsq Interp. code could not be created. Please correct the error(s) and try again', true));
			}
		}
	}	
	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');		
		if (!empty($this->data)) {
			if ($this->HsqInterp->save($this->data)) {
				$this->flashSuccess(__('The Hsq Interp. has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Hsq Interp. could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$this->data = $this->HsqInterp->read(null, $id);
		}
	}	
}
?>