<?php
class HsqScoresController extends AppController {

	var $name = 'HsqScores';
	var $helpers = array('Html', 'Form', 'Time', 'Js' => array('Jquery'));
		

	function cancel() {
        $this->redirect(array ('controller' => 'evaluations', 'action' => 'index'));
	}		
	
	
	function index() {
		$this->HsqScore->recursive = 0;
		$this->set('hsqScores', $this->paginate());
	}

	
	function view() {
		# First time the page is loaded
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
		}

		$infoEval = $this->HsqScore->Evaluation->infoEval($eval_id);
		$infoScaleHsq = $this->HsqScore->infoScaleHsq($eval_id);
		
		# set up default values for form - HSQ
		$this->data['HsqScore']['evaluation_id'] = $eval_id;
		$this->data['HsqScore']['questionnaire_id'] = 3;
		$this->data['HsqScore']['langue'] = $lang_id;
		$this->data['Service']['id'] = $infoEval['Service']['id'];
		
		$this->data['Employee']['id'] = $infoEval['Employee']['id'];
		$this->data['Employee']['gender'] = $infoEval['Employee']['gender'];
		$this->data['Employee']['age'] = $this->__birthday_age($infoEval['Employee']['date_birth']);
		
		$this->data['HsqScore']['ctrlform'] = 1;  //to control the select input question

		#Answers Info
		$hsqanswers = array();
		for ($i=0; $i < 39; $i++) {
			$rest = substr($infoScaleHsq[0]['HsqScore']['answers'], $i, 1);
			$hsqanswers = $hsqanswers + array($i => $rest);
		}		
		
		# Get all the questions - choices from a specific Questionnaire
		$allquestions = $this->HsqScore->Questionnaire->Question->infoquestionallchoices($this->data['HsqScore']['questionnaire_id']);		

		$this->set(compact('infoEval', 'allquestions', 'hsqanswers'));	
	}
		

	function add() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$test_serie = $this->params['named']['test_serie'];	
		}	
		if (!empty($this->data)) {
			$this->HsqScore->create();
			if ($this->HsqScore->save($this->data)) {
				$newStatusEval = $this->HsqScore->Evaluation->findById($this->data['HsqScore']['evaluation_id']);
				if ($newStatusEval['Evaluation']['status_id'] == 13 ){
					$this->flashSuccess(__('All the Questionnaires have been completed', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
				} else {
					$this->flashSuccess(__('The Hsq score has been created', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['HsqScore']['evaluation_id']);
				}											
			} else {				
				$this->flashWarning(__('The Hsq score could not be created. The Test may be in use by another user', true), '/evaluations/order_code:'.$this->data['Order']['order_code']);			
			}
		} else {
			$infoEval = $this->HsqScore->Evaluation->infoEval($eval_id);
			
			# set up default values for form - HSQ
			$this->data['HsqScore']['type_q'] = 'HSQ';
					
			$this->data['HsqScore']['evaluation_id'] = $eval_id;
			$this->data['HsqScore']['questionnaire_id'] = 3;
			$this->data['HsqScore']['langue'] = $lang_id;
			$this->data['HsqScore']['test_serie'] = $test_serie;
			$this->data['Service']['id'] = $infoEval['Service']['id'];
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];
			
			$this->data['Employee']['id'] = $infoEval['Employee']['id'];
			$this->data['Employee']['gender'] = $infoEval['Employee']['gender'];
			$this->data['Employee']['age'] = $this->__birthday_age($infoEval['Employee']['date_birth']);
			$this->data['HsqScore']['createdby'] = $this->Session->read('Auth.User.username');
			
			$this->data['HsqScore']['ctrlform'] = 0;  //to control the select input question
			
			# Get all the questions - choices from a specific Questionnaire
			$allquestions = $this->HsqScore->Questionnaire->Question->infoquestionallchoices($this->data['HsqScore']['questionnaire_id']);
			
			$this->set(compact('infoEval', 'allquestions'));			
		}		
	}		
	
	
	function add_hsq() {
		# First time the page is loaded - right after an Employee has been selected
		if (!empty($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$test_serie = $this->params['named']['test_serie'];	
		}	
		if (!empty($this->data)) {
			$this->HsqScore->create();
			if ($this->HsqScore->save($this->data)) {
				$serv_id = $this->data['Service']['id'];
				$test_serie = $this->data['HsqScore']['test_serie'];
				$eval_id = $this->data['HsqScore']['evaluation_id'];
				$lang_id = $this->data['HsqScore']['langue'];
				###DSP as a single option in the service or as a final questionnaire after DSP (no treatment questionnaire in the service).###
				###Logs out the client after completion###
				if (($test_serie >= 1) && ($serv_id == 18 || $serv_id == 31 || $serv_id == 11 || $serv_id == 12 || $serv_id == 13 || $serv_id == 22 || $serv_id == 23 || $serv_id == 24 || $serv_id == 26 || $serv_id == 34 || $serv_id == 35 || $serv_id == 36))
				$this->flashSuccess(__('All the Questionnaires have been saved', true), '/pages/logout_usr');
				###Redirects to Treatment questionnaire initial###
				if ($test_serie == 1) { $quest_next = 4;}
				###Redirects to Treatment questionnaire Follow-up###
				if ($test_serie > 1) { $quest_next = 5;}				
				$this->flashSuccess(__('The Hsq Score has been saved. Now continue with the next questionnaire', true), '/questionnaire_treatments/add_treatqst/quest:'.$quest_next.'/eval:'.$eval_id.'/elang:'.$lang_id.'/test_serie:'.$test_serie);
				} else {				
				$this->flashWarning(__('The Hsq Score could not be saved. Please, try again', true));				
			}
		} else {
			$infoEval = $this->HsqScore->Evaluation->infoEval($eval_id);
			
			# set up default values for form - HSQ
			$this->data['HsqScore']['type_q'] = 'HSQ';
					
			$this->data['HsqScore']['evaluation_id'] = $eval_id;
			$this->data['HsqScore']['questionnaire_id'] = 3;
			$this->data['HsqScore']['langue'] = $lang_id;
			$this->data['HsqScore']['test_serie'] = $test_serie;
			$this->data['Service']['id'] = $infoEval['Service']['id'];
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];
			
			$this->data['Employee']['id'] = $infoEval['Employee']['id'];
			$this->data['Employee']['gender'] = $infoEval['Employee']['gender'];
			$this->data['Employee']['age'] = $this->__birthday_age($infoEval['Employee']['date_birth']);
			$this->data['HsqScore']['createdby'] = $this->Session->read('Auth.User.username');
			
			$this->data['HsqScore']['ctrlform'] = 0;  //to control the select input question
			
			# Get all the questions - choices from a specific Questionnaire
			$allquestions = $this->HsqScore->Questionnaire->Question->infoquestionallchoices($this->data['HsqScore']['questionnaire_id']);	
			
			$this->set(compact('infoEval', 'allquestions'));
		}
	}		

	
	function edit() {
	//echo pr($this->data['HsqScore']);
		//echo $this->data['Employee']['age'];
		//die();
		if (!empty($this->data['HsqScore'])) {
			//die();
			if(empty($this->data['Employee']['age']) || $this->data['Employee']['age'] == null || 
				$this->data['Employee']['age'] == '' || $this->data['Employee']['age'] == 0){
				$this->flashWarning(__('The Hsq Score can not be Scored: Missing the Date of Birth of employee', true));				
			}
			else {				
				if ($this->HsqScore->save($this->data['HsqScore'])) {
					$this->flashSuccess(__('The Hsq Score has been updated', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['HsqScore']['evaluation_id']);			
				} else {
					$this->flashWarning(__('The Hsq Score could not be updated. Please, try again', true));
				}				
			}			
		}elseif (empty($this->data)) {
			# First time the page is loaded
			if (isset($this->params['named']['eval'])) {
				$lang_id = $this->params['named']['elang'];
				$eval_id = $this->params['named']['eval'];
			} else {				
				$lang_id = $this->data['HsqScore']['langue'];
				$eval_id = $this->data['HsqScore']['evaluation_id'];
			}
			# Get the HsqScore Questionnaire information
			# Order info - header
			$this->data['HsqScore']['langue'] = $lang_id;
			$infoEval = $this->HsqScore->Evaluation->infoEval($eval_id);		
			$infoScaleHsq = $this->HsqScore->infoScaleHsq($eval_id);
			//echo pr($infoScaleHsq);
			# set up default values for form - HSQ
			$this->data['HsqScore']['evaluation_id'] = $eval_id;
			$this->data['HsqScore']['questionnaire_id'] = $infoScaleHsq[0]['HsqScore']['questionnaire_id'];
			$this->data['HsqScore']['langue'] = $lang_id;
			
			$this->data['Service']['id'] = $infoEval['Service']['id'];
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];
						
			$this->data['Employee']['id'] = $infoEval['Employee']['id'];
			$this->data['Employee']['gender'] = $infoEval['Employee']['gender'];
			$this->data['Employee']['age'] = $this->__birthday_age($infoEval['Employee']['date_birth']);
			
			$this->data['HsqScore']['id'] = $infoScaleHsq[0]['HsqScore']['id'];
			$this->data['HsqScore']['ctrlform'] = 2;  //to control the select input question - VIEW

			$this->data['HsqScore']['createdby'] = $infoScaleHsq[0]['HsqScore']['createdby'];
			$this->data['HsqScore']['modifiedby'] = $this->Session->read('Auth.User.username');
			
			#Answers Info
			$hsqanswers = array();
			for ($i=0; $i < 39; $i++) {
				$rest = substr($infoScaleHsq[0]['HsqScore']['answers'], $i, 1);
				$hsqanswers = $hsqanswers + array($i => $rest);
			}		
			$allchoices = array(); 			
			# Get all the questions - choices from a specific Questionnaire
			$allquestions = $this->HsqScore->Questionnaire->Question->infoquestionallchoices($this->data['HsqScore']['questionnaire_id']);		
			
			$this->set(compact('infoEval', 'infoScaleHsq', 'allquestions', 'hsqanswers'));	
		}
	}	
	
	
	
	function view_hsq_score() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$ord_id = $this->params['named']['ord'];
			$test_serie = $this->params['named']['test_serie'];			
		}
		
		$this->loadModel('DocLabel');
		$labelsHSQReport = $this->DocLabel->labelsQSTXReport(6, $lang_id, 1, 1);

		# Get a complete information about the current DSP Score: Customer/Employee/Evaluation/DSP		
		$infoHsq = $this->HsqScore->infoHsq($eval_id);

		# Get an array Interpretation of the current HSQ Score		
		$interpHsqScore = $this->HsqScore->interpHsqScore($eval_id, $lang_id);
	
		# Get an array of the Depression Screener answers of the current HSQ Score		
		$depressionHsqScreenerList = $this->HsqScore->depressionHsqScreener($eval_id, 3, $lang_id);	
		
		# Get the History HSQ values scales from an specific Employee, before create the Graph
		$infoHistScaleHsq = $this->HsqScore->Evaluation->Order->infoHistScaleHsq($ord_id, $test_serie);
		
		$infodataset = $this->HsqScore->infodataset($infoHistScaleHsq);

		# Create the .png Image
		$strdate = date("ymd");
		$filenameimg = 'HSQ'.$eval_id.$strdate;
		$this->__barLibchart($filenameimg,$infodataset);
			
		$this->layout = 'pdf'; //this will use the pdf.ctp layout
			
		$this->set(compact('infoHsq', 'lang_id', 'labelsHSQReport', 'interpHsqScore', 'depressionHsqScreenerList','filenameimg'));
		$this->render();
	}		

	function hsq_history()  {
		# First time the page is loaded
		if (isset($this->params['named']['eval'])) {
			$eval_id = $this->params['named']['eval'];
			$test_serie = $this->params['named']['test_serie'];
			$order_id = $this->params['named']['order'];
		}
		
		$infoEval = $this->HsqScore->Evaluation->infoEval($eval_id);
		$infoHistoryHsq = $this->HsqScore->infoHistoryHsq($eval_id, $order_id, $test_serie);			
		
		$this->set(compact('infoHistoryHsq', 'infoEval'));	
	}
	
	function __barLibchart($filenameimg,$infodatasets) {
		App::import('Vendor', 'libchart/classes/libchart');	
		$chart = new VerticalBarChart(810, 450);

		$items = count($infodatasets);  //ex. 1 - number of tests	
	
		if ($items > 4) { $chart->getConfig()->setShowPointCaption(false); }
		
		if ($items == 1) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("HP-".$infodatasets[0][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("PF-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("RP-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("RE-".$infodatasets[0][3], $infodatasets[0][3]));
			$serie1->addPoint(new Point("SF-".$infodatasets[0][4], $infodatasets[0][4]));
			$serie1->addPoint(new Point("MH-".$infodatasets[0][5], $infodatasets[0][5]));
			$serie1->addPoint(new Point("BP-".$infodatasets[0][6], $infodatasets[0][6]));
			$serie1->addPoint(new Point("EF-".$infodatasets[0][7], $infodatasets[0][7]));		
			
			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test # 1", $serie1);			
		} elseif ($items == 2)  {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("HP-".$infodatasets[0][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("PF-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("RP-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("RE-".$infodatasets[0][3], $infodatasets[0][3]));
			$serie1->addPoint(new Point("SF-".$infodatasets[0][4], $infodatasets[0][4]));
			$serie1->addPoint(new Point("MH-".$infodatasets[0][5], $infodatasets[0][5]));
			$serie1->addPoint(new Point("BP-".$infodatasets[0][6], $infodatasets[0][6]));
			$serie1->addPoint(new Point("EF-".$infodatasets[0][7], $infodatasets[0][7]));	
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("HP", $infodatasets[1][0]));
			$serie2->addPoint(new Point("PF", $infodatasets[1][1]));
			$serie2->addPoint(new Point("RP", $infodatasets[1][2]));
			$serie2->addPoint(new Point("RE", $infodatasets[1][3]));
			$serie2->addPoint(new Point("SF", $infodatasets[1][4]));
			$serie2->addPoint(new Point("MH", $infodatasets[1][5]));
			$serie2->addPoint(new Point("BP", $infodatasets[1][6]));
			$serie2->addPoint(new Point("EF", $infodatasets[1][7]));			

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test # 1", $serie1);
			$dataSet->addSerie("Test # 2", $serie2);			
		} elseif ($items == 3) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("HP-".$infodatasets[0][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("PF-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("RP-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("RE-".$infodatasets[0][3], $infodatasets[0][3]));
			$serie1->addPoint(new Point("SF-".$infodatasets[0][4], $infodatasets[0][4]));
			$serie1->addPoint(new Point("MH-".$infodatasets[0][5], $infodatasets[0][5]));
			$serie1->addPoint(new Point("BP-".$infodatasets[0][6], $infodatasets[0][6]));
			$serie1->addPoint(new Point("EF-".$infodatasets[0][7], $infodatasets[0][7]));	
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("HP", $infodatasets[1][0]));
			$serie2->addPoint(new Point("PF", $infodatasets[1][1]));
			$serie2->addPoint(new Point("RP", $infodatasets[1][2]));
			$serie2->addPoint(new Point("RE", $infodatasets[1][3]));
			$serie2->addPoint(new Point("SF", $infodatasets[1][4]));
			$serie2->addPoint(new Point("MH", $infodatasets[1][5]));
			$serie2->addPoint(new Point("BP", $infodatasets[1][6]));
			$serie2->addPoint(new Point("EF", $infodatasets[1][7]));			

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("HP", $infodatasets[2][0]));
			$serie3->addPoint(new Point("PF", $infodatasets[2][1]));
			$serie3->addPoint(new Point("RP", $infodatasets[2][2]));
			$serie3->addPoint(new Point("RE", $infodatasets[2][3]));
			$serie3->addPoint(new Point("SF", $infodatasets[2][4]));
			$serie3->addPoint(new Point("MH", $infodatasets[2][5]));
			$serie3->addPoint(new Point("BP", $infodatasets[2][6]));
			$serie3->addPoint(new Point("EF", $infodatasets[2][7]));

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test # 1", $serie1);
			$dataSet->addSerie("Test # 2", $serie2);
			$dataSet->addSerie("Test # 3", $serie3);			
		} elseif ($items == 4) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("HP-".$infodatasets[0][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("PF-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("RP-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("RE-".$infodatasets[0][3], $infodatasets[0][3]));
			$serie1->addPoint(new Point("SF-".$infodatasets[0][4], $infodatasets[0][4]));
			$serie1->addPoint(new Point("MH-".$infodatasets[0][5], $infodatasets[0][5]));
			$serie1->addPoint(new Point("BP-".$infodatasets[0][6], $infodatasets[0][6]));
			$serie1->addPoint(new Point("EF-".$infodatasets[0][7], $infodatasets[0][7]));	
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("HP", $infodatasets[1][0]));
			$serie2->addPoint(new Point("PF", $infodatasets[1][1]));
			$serie2->addPoint(new Point("RP", $infodatasets[1][2]));
			$serie2->addPoint(new Point("RE", $infodatasets[1][3]));
			$serie2->addPoint(new Point("SF", $infodatasets[1][4]));
			$serie2->addPoint(new Point("MH", $infodatasets[1][5]));
			$serie2->addPoint(new Point("BP", $infodatasets[1][6]));
			$serie2->addPoint(new Point("EF", $infodatasets[1][7]));			

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("HP", $infodatasets[2][0]));
			$serie3->addPoint(new Point("PF", $infodatasets[2][1]));
			$serie3->addPoint(new Point("RP", $infodatasets[2][2]));
			$serie3->addPoint(new Point("RE", $infodatasets[2][3]));
			$serie3->addPoint(new Point("SF", $infodatasets[2][4]));
			$serie3->addPoint(new Point("MH", $infodatasets[2][5]));
			$serie3->addPoint(new Point("BP", $infodatasets[2][6]));
			$serie3->addPoint(new Point("EF", $infodatasets[2][7]));
			
			$serie4 = new XYDataSet();
			$serie4->addPoint(new Point("HP", $infodatasets[3][0]));
			$serie4->addPoint(new Point("PF", $infodatasets[3][1]));
			$serie4->addPoint(new Point("RP", $infodatasets[3][2]));
			$serie4->addPoint(new Point("RE", $infodatasets[3][3]));
			$serie4->addPoint(new Point("SF", $infodatasets[3][4]));
			$serie4->addPoint(new Point("MH", $infodatasets[3][5]));
			$serie4->addPoint(new Point("BP", $infodatasets[3][6]));
			$serie4->addPoint(new Point("EF", $infodatasets[3][7]));		

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test # 1", $serie1);
			$dataSet->addSerie("Test # 2", $serie2);
			$dataSet->addSerie("Test # 3", $serie3);
			$dataSet->addSerie("Test # 4", $serie4);			
		} elseif ($items == 5) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("HP-".$infodatasets[0][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("PF-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("RP-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("RE-".$infodatasets[0][3], $infodatasets[0][3]));
			$serie1->addPoint(new Point("SF-".$infodatasets[0][4], $infodatasets[0][4]));
			$serie1->addPoint(new Point("MH-".$infodatasets[0][5], $infodatasets[0][5]));
			$serie1->addPoint(new Point("BP-".$infodatasets[0][6], $infodatasets[0][6]));
			$serie1->addPoint(new Point("EF-".$infodatasets[0][7], $infodatasets[0][7]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("HP", $infodatasets[1][0]));
			$serie2->addPoint(new Point("PF", $infodatasets[1][1]));
			$serie2->addPoint(new Point("RP", $infodatasets[1][2]));
			$serie2->addPoint(new Point("RE", $infodatasets[1][3]));
			$serie2->addPoint(new Point("SF", $infodatasets[1][4]));
			$serie2->addPoint(new Point("MH", $infodatasets[1][5]));
			$serie2->addPoint(new Point("BP", $infodatasets[1][6]));
			$serie2->addPoint(new Point("EF", $infodatasets[1][7]));			

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("HP", $infodatasets[2][0]));
			$serie3->addPoint(new Point("PF", $infodatasets[2][1]));
			$serie3->addPoint(new Point("RP", $infodatasets[2][2]));
			$serie3->addPoint(new Point("RE", $infodatasets[2][3]));
			$serie3->addPoint(new Point("SF", $infodatasets[2][4]));
			$serie3->addPoint(new Point("MH", $infodatasets[2][5]));
			$serie3->addPoint(new Point("BP", $infodatasets[2][6]));
			$serie3->addPoint(new Point("EF", $infodatasets[2][7]));
			
			$serie4 = new XYDataSet();
			$serie4->addPoint(new Point("HP", $infodatasets[3][0]));
			$serie4->addPoint(new Point("PF", $infodatasets[3][1]));
			$serie4->addPoint(new Point("RP", $infodatasets[3][2]));
			$serie4->addPoint(new Point("RE", $infodatasets[3][3]));
			$serie4->addPoint(new Point("SF", $infodatasets[3][4]));
			$serie4->addPoint(new Point("MH", $infodatasets[3][5]));
			$serie4->addPoint(new Point("BP", $infodatasets[3][6]));
			$serie4->addPoint(new Point("EF", $infodatasets[3][7]));	
			
			$serie5 = new XYDataSet();
			$serie5->addPoint(new Point("HP", $infodatasets[4][0]));
			$serie5->addPoint(new Point("PF", $infodatasets[4][1]));
			$serie5->addPoint(new Point("RP", $infodatasets[4][2]));
			$serie5->addPoint(new Point("RE", $infodatasets[4][3]));
			$serie5->addPoint(new Point("SF", $infodatasets[4][4]));
			$serie5->addPoint(new Point("MH", $infodatasets[4][5]));
			$serie5->addPoint(new Point("BP", $infodatasets[4][6]));
			$serie5->addPoint(new Point("EF", $infodatasets[4][7]));
			
			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test # 1", $serie1);
			$dataSet->addSerie("Test # 2", $serie2);
			$dataSet->addSerie("Test # 3", $serie3);
			$dataSet->addSerie("Test # 4", $serie4);
			$dataSet->addSerie("Test # 5", $serie5);			
		} elseif ($items == 6) {
			$serie1 = new XYDataSet();
			$serie1->addPoint(new Point("HP-".$infodatasets[0][0], $infodatasets[0][0]));
			$serie1->addPoint(new Point("PF-".$infodatasets[0][1], $infodatasets[0][1]));
			$serie1->addPoint(new Point("RP-".$infodatasets[0][2], $infodatasets[0][2]));
			$serie1->addPoint(new Point("RE-".$infodatasets[0][3], $infodatasets[0][3]));
			$serie1->addPoint(new Point("SF-".$infodatasets[0][4], $infodatasets[0][4]));
			$serie1->addPoint(new Point("MH-".$infodatasets[0][5], $infodatasets[0][5]));
			$serie1->addPoint(new Point("BP-".$infodatasets[0][6], $infodatasets[0][6]));
			$serie1->addPoint(new Point("EF-".$infodatasets[0][7], $infodatasets[0][7]));
				
			$serie2 = new XYDataSet();
			$serie2->addPoint(new Point("HP", $infodatasets[1][0]));
			$serie2->addPoint(new Point("PF", $infodatasets[1][1]));
			$serie2->addPoint(new Point("RP", $infodatasets[1][2]));
			$serie2->addPoint(new Point("RE", $infodatasets[1][3]));
			$serie2->addPoint(new Point("SF", $infodatasets[1][4]));
			$serie2->addPoint(new Point("MH", $infodatasets[1][5]));
			$serie2->addPoint(new Point("BP", $infodatasets[1][6]));
			$serie2->addPoint(new Point("EF", $infodatasets[1][7]));			

			$serie3 = new XYDataSet();
			$serie3->addPoint(new Point("HP", $infodatasets[2][0]));
			$serie3->addPoint(new Point("PF", $infodatasets[2][1]));
			$serie3->addPoint(new Point("RP", $infodatasets[2][2]));
			$serie3->addPoint(new Point("RE", $infodatasets[2][3]));
			$serie3->addPoint(new Point("SF", $infodatasets[2][4]));
			$serie3->addPoint(new Point("MH", $infodatasets[2][5]));
			$serie3->addPoint(new Point("BP", $infodatasets[2][6]));
			$serie3->addPoint(new Point("EF", $infodatasets[2][7]));
			
			$serie4 = new XYDataSet();
			$serie4->addPoint(new Point("HP", $infodatasets[3][0]));
			$serie4->addPoint(new Point("PF", $infodatasets[3][1]));
			$serie4->addPoint(new Point("RP", $infodatasets[3][2]));
			$serie4->addPoint(new Point("RE", $infodatasets[3][3]));
			$serie4->addPoint(new Point("SF", $infodatasets[3][4]));
			$serie4->addPoint(new Point("MH", $infodatasets[3][5]));
			$serie4->addPoint(new Point("BP", $infodatasets[3][6]));
			$serie4->addPoint(new Point("EF", $infodatasets[3][7]));	
			
			$serie5 = new XYDataSet();
			$serie5->addPoint(new Point("HP", $infodatasets[4][0]));
			$serie5->addPoint(new Point("PF", $infodatasets[4][1]));
			$serie5->addPoint(new Point("RP", $infodatasets[4][2]));
			$serie5->addPoint(new Point("RE", $infodatasets[4][3]));
			$serie5->addPoint(new Point("SF", $infodatasets[4][4]));
			$serie5->addPoint(new Point("MH", $infodatasets[4][5]));
			$serie5->addPoint(new Point("BP", $infodatasets[4][6]));
			$serie5->addPoint(new Point("EF", $infodatasets[4][7]));
			
			$serie6 = new XYDataSet();
			$serie6->addPoint(new Point("HP", $infodatasets[5][0]));
			$serie6->addPoint(new Point("PF", $infodatasets[5][1]));
			$serie6->addPoint(new Point("RP", $infodatasets[5][2]));
			$serie6->addPoint(new Point("RE", $infodatasets[5][3]));
			$serie6->addPoint(new Point("SF", $infodatasets[5][4]));
			$serie6->addPoint(new Point("MH", $infodatasets[5][5]));
			$serie6->addPoint(new Point("BP", $infodatasets[5][6]));
			$serie6->addPoint(new Point("EF", $infodatasets[5][7]));					

			$dataSet = new XYSeriesDataSet();
			$dataSet->addSerie("Test # 1", $serie1);
			$dataSet->addSerie("Test # 2", $serie2);
			$dataSet->addSerie("Test # 3", $serie3);
			$dataSet->addSerie("Test # 4", $serie4);
			$dataSet->addSerie("Test # 5", $serie5);
			$dataSet->addSerie("Test # 6", $serie6);			
		}

		$chart->setDataSet($dataSet);
		$chart->getPlot()->setGraphCaptionRatio(0.7);
		
		$path_file = 'img/hsq/'.$filenameimg.'.png';
	
		# Validate if the file already exists		
        while(is_file($path_file) == TRUE) {
            chmod($path_file, 0666);
            unlink($path_file);
        }
		$chart->setTitle("");
		$chart->render($path_file);	
	}
	
	function __birthday_age($dob) {
	  list($Y, $m, $d) = explode("-", $dob);
	  return ((date('m') - $m) >0 || (date('m') - $m) == 0 && (date('d') - $d) >= 0) ? (date('Y') - $Y) : ((date('Y') - $Y) - 1);  
	}					
}
?>