<?php
class ProvincesController extends AppController {

	var $name = 'Provinces';
	var $helpers = array('Html', 'Form', 'Time');

	
	function beforeFilter() {	  
		parent::beforeFilter();
	}	
	

	function index() {
		$this->Province->recursive = 0;
		$this->set('provinces', $this->paginate());
	}


	function add() {
		if (!empty($this->data)) {
			$this->Province->create();
			if ($this->Province->save($this->data)) {
				$this->flashSuccess(__('El estado fué creado.', true), 'index');
			} else {
				$this->flashWarning(__('El estado no fué creado. Corrija el error.', true));
			}
		}
	}
	
			
	function cancel() {
		$this->redirect('/provinces'); 
	}	
	
	
	function edit($id = null) {
    $this->idEmptyRedirect($id, 'index');
	
		if (!empty($this->data)) {
			if ($this->Province->save($this->data)) 
			{
				$this->flashSuccess(__('El estado fué actualizado.', true), 'index');
			} else {
				$this->flashWarning(__('El estado no fué actualizado. Corrija el error.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->Province->read(null, $id);
		}
	}
	

	function delete($id = null) {
    $this->idEmptyRedirect($id, 'index');
	
		if ($this->Province->delete($id)) {
			$this->flashSuccess(__('El estado fué actualizado', true), 'index');		
		}
	}
	
}
?>