<?php
#[AllowDynamicProperties]
class QuestionnaireTreatmentsController extends AppController {

	var $name = 'QuestionnaireTreatments';
	var $helpers = array('Html', 'Form', 'Time', 'Text', 'Number', 'Js' => array('Jquery'));
	var $components = array('RequestHandler');

	
	function cancel() {
	# Called from Ques.Treat. view/add
		if (isset($this->params['named']['ctrl_return'])) { 		
			$this->redirect(array ('controller' => 'questionnaires_services', 
			'action' => $this->params['named']['ctrl_return'], 'serv' => $this->params['named']['serv'], 'eval' => $this->params['named']['eval']));
		}		
	}			

	function add() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$quest_id = $this->params['named']['quest'];
			$eval_id = $this->params['named']['eval'];
			$lang_id = $this->params['named']['elang'];
			$test_serie = $this->params['named']['test_serie'];
		} else {
			$quest_id = $this->data['QuestionnaireTreatment']['questionnaire_id'];
			$eval_id = $this->data['QuestionnaireTreatment']['evaluation_id'];
		}
		
		if (!empty($this->data)) {
			$this->QuestionnaireTreatment->create();
			$this->QuestionnaireTreatment->begin();  // Start of transaction
			if ($this->QuestionnaireTreatment->save($this->data)) {				
				# save QuestionnaireTreatment
				if (!empty($this->data['Medstemp'])) {
					$this->__settingdataMeds($this->QuestionnaireTreatment->id); 
					if (!empty($this->data['MedicationTreatment'])) {
						if ($this->QuestionnaireTreatment->MedicationTreatment->saveAll($this->data['MedicationTreatment'])) {
							if (!empty($this->data['Therapytemp'])) {
								$this->__settingdataThep($this->QuestionnaireTreatment->id); 
								if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
									$this->QuestionnaireTreatment->commit(); // Persist the data 
									$newStatusEval = $this->QuestionnaireTreatment->Evaluation->findById($this->data['QuestionnaireTreatment']['evaluation_id']);
									if ($newStatusEval['Evaluation']['status_id'] == 13 ){
										$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
										exit;	
									} else {
										$this->flashSuccess(__('El Treatment Questionnaire fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
										exit;	
									}									
								} else {
									$this->QuestionnaireTreatment->rollback();
									$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));							
								}
							} else {
								$this->QuestionnaireTreatment->commit(); // Persist the data 
								$newStatusEval = $this->QuestionnaireTreatment->Evaluation->findById($this->data['QuestionnaireTreatment']['evaluation_id']);
								if ($newStatusEval['Evaluation']['status_id'] == 13 ){
									$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
									exit;	
								} else {
									$this->flashSuccess(__('El Treatment Questionnaire fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
									exit;	
								}								
							}
						} else {
							$this->QuestionnaireTreatment->rollback();
							$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));
						}
					} else {
						if (!empty($this->data['Therapytemp'])) {
							$this->__settingdataThep($this->QuestionnaireTreatment->id); 
							if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
								$this->QuestionnaireTreatment->commit(); // Persist the data 
								$newStatusEval = $this->QuestionnaireTreatment->Evaluation->findById($this->data['QuestionnaireTreatment']['evaluation_id']);
								if ($newStatusEval['Evaluation']['status_id'] == 13 ){
									$this->flashSuccess(__('All the Questionnaires have been completed', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
									exit;	
								} else {
									$this->flashSuccess(__('El Treatment Questionnaire fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
									exit;	
								}								
							} else {
								$this->QuestionnaireTreatment->rollback();
								$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));						
							}
						} else {
							$this->QuestionnaireTreatment->commit(); // Persist the data 
							$newStatusEval = $this->QuestionnaireTreatment->Evaluation->findById($this->data['QuestionnaireTreatment']['evaluation_id']);
							if ($newStatusEval['Evaluation']['status_id'] == 13 ){
								$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
								exit;	
							} else {
								$this->flashSuccess(__('El Treatment Questionnaire fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
								exit;	
							}							
						}
					}				
				} else { 
					if (!empty($this->data['Therapytemp'])) {
						$this->__settingdataThep($this->QuestionnaireTreatment->id); 
						if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
							$this->QuestionnaireTreatment->commit(); // Persist the data 
							$newStatusEval = $this->QuestionnaireTreatment->Evaluation->findById($this->data['QuestionnaireTreatment']['evaluation_id']);
							if ($newStatusEval['Evaluation']['status_id'] == 13 ){
								$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
								exit;	
							} else {
								$this->flashSuccess(__('El Treatment Questionnaire fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
								exit;	
							}
						} else {
							$this->QuestionnaireTreatment->rollback();
							$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));						
						}
					} else {
						$this->QuestionnaireTreatment->commit(); // Persist the data 
						$newStatusEval = $this->QuestionnaireTreatment->Evaluation->findById($this->data['QuestionnaireTreatment']['evaluation_id']);
						if ($newStatusEval['Evaluation']['status_id'] == 13 ){
							$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/evaluations/index/order_id:'.$newStatusEval['Evaluation']['order_id']);
							exit;	
						} else {
							$this->flashSuccess(__('El Treatment Questionnaire fué creado.', true), '/questionnaires_services/add_score/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
							exit;	
						}
					}
				}
			} else {
				$this->QuestionnaireTreatment->rollback();
				$this->flashWarning(__('El Treatment Questionnaire no fué creado. El test podría estar en uso por otro usuario.', true), '/evaluations/order_code:'.$this->data['Order']['order_code']);
			}		
		} else {
			### set up default ###			
			$infoEval = $this->QuestionnaireTreatment->Evaluation->infoEval($eval_id);
							
			##### set the data to save Treatment Q
			# set up default values for form
			$this->data['Service']['id'] = $infoEval['Service']['id'];
		
			# Treatment Questionnaire: Initial
			if( $quest_id == 4 ) { $this->data['QuestionnaireTreatment']['type_q'] = 0; }
			
			# Treatment Questionnaire: Follow up
			if( $quest_id == 5 ) { $this->data['QuestionnaireTreatment']['type_q'] = 1; }
		
			$this->data['QuestionnaireTreatment']['evaluation_id'] = $eval_id;
			$this->data['QuestionnaireTreatment']['questionnaire_id'] = $quest_id;
			$this->data['QuestionnaireTreatment']['langue'] = $lang_id;
			$this->data['QuestionnaireTreatment']['test_serie'] = $test_serie; //Validate the max number of tests by order - then close the Order
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];
			$this->data['QuestionnaireTreatment']['createdby'] = $this->Session->read('Auth.User.username');
			
			$this->data['QuestionnaireTreatment']['ctrlform'] = 0;  //to control the select input question - ADD
		}
		$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->find('list', array('order' => 'Drug.name'));
		//$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->find('list', array('fields' => array('Drug.id', 'Drug.name', 'Drug.category')));
		$allquestions = $this->QuestionnaireTreatment->Questionnaire->Question->infoquestionallchoices($this->data['QuestionnaireTreatment']['questionnaire_id']);	
		$this->set(compact('infoEval', 'allquestions', 'drugs', 'quest_id'));
	}		
		
		
	function add_treatqst() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])){
			$quest_id = $this->params['named']['quest'];
			$eval_id = $this->params['named']['eval'];
			$lang_id = $this->params['named']['elang'];
			$test_serie = $this->params['named']['test_serie'];
		} else {
			$quest_id = $this->data['QuestionnaireTreatment']['questionnaire_id'];
			$eval_id = $this->data['QuestionnaireTreatment']['evaluation_id'];
		}
		
		if (!empty($this->data)) {
			$this->QuestionnaireTreatment->create();
			$this->QuestionnaireTreatment->begin();  // Start of transaction
			if ($this->QuestionnaireTreatment->save($this->data)) {				
				# save QuestionnaireTreatment
				if (!empty($this->data['Medstemp']))  {
					$this->__settingdataMeds($this->QuestionnaireTreatment->id); 
					if (!empty($this->data['MedicationTreatment'])) {
						if ($this->QuestionnaireTreatment->MedicationTreatment->saveAll($this->data['MedicationTreatment'])) {
							if (isset($this->data['Therapytemp'])) {
								$this->__settingdataThep($this->QuestionnaireTreatment->id); 
								if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
									$this->QuestionnaireTreatment->commit(); // Persist the data 
									$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
									exit;
								} else {
									$this->QuestionnaireTreatment->rollback();
									$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));							
								}
							} else {
								$this->QuestionnaireTreatment->commit(); // Persist the data 
								$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
								exit;							
							}
						} else {
							$this->QuestionnaireTreatment->rollback();
							$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));
						}
					} else {
						if (isset($this->data['Therapytemp'])) {
							$this->__settingdataThep($this->QuestionnaireTreatment->id); 
							if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
								$this->QuestionnaireTreatment->commit(); // Persist the data 
								$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
								exit;
							} else {
								$this->QuestionnaireTreatment->rollback();
								$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));						
							}
						} else {
							$this->QuestionnaireTreatment->commit(); // Persist the data 
							$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
							exit;					
						}
					}				
				} else { 
					if (isset($this->data['Therapytemp'])) {
						$this->__settingdataThep($this->QuestionnaireTreatment->id); 
						if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
							$this->QuestionnaireTreatment->commit(); // Persist the data 
							$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
							exit;
						} else {
							$this->QuestionnaireTreatment->rollback();
							$this->flashWarning(__('El Treatment Questionnaire no fué creado. Corrija el error.', true));						
						}
					} else {
						$this->QuestionnaireTreatment->commit(); // Persist the data 
						$this->flashSuccess(__('Los cuestionarios fueron completados.', true), '/pages/logout_usr');
						exit;					
					}
				}
			} else {
				$this->QuestionnaireTreatment->rollback();
				$this->flashWarning('El Treatment Questionnaire no fué creado. Corrija el error.');
			}		
		} else {
			### set up default ###			
			$infoEval = $this->QuestionnaireTreatment->Evaluation->infoEval($eval_id);
							
			##### set the data to save Treatment Q
			# set up default values for form
			$this->data['Service']['id'] = $infoEval['Service']['id'];
		
			# Treatment Questionnaire: Initial
			if( $quest_id == 4 ) { $this->data['QuestionnaireTreatment']['type_q'] = 0; }
			
			# Treatment Questionnaire: Follow up
			if( $quest_id == 5 ) { $this->data['QuestionnaireTreatment']['type_q'] = 1; }
		
			$this->data['QuestionnaireTreatment']['evaluation_id'] = $eval_id;
			$this->data['QuestionnaireTreatment']['questionnaire_id'] = $quest_id;
			$this->data['QuestionnaireTreatment']['langue'] = $lang_id;
			$this->data['QuestionnaireTreatment']['test_serie'] = $test_serie; //Validate the max number of tests by order - then close the Order
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];
			$this->data['QuestionnaireTreatment']['createdby'] = $this->Session->read('Auth.User.username');
			
			$this->data['QuestionnaireTreatment']['ctrlform'] = 0;  //to control the select input question - ADD
		}
		$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->find('list', array('order' => 'Drug.name'));
		$allquestions = $this->QuestionnaireTreatment->Questionnaire->Question->infoquestionallchoices($this->data['QuestionnaireTreatment']['questionnaire_id']);	
		
		$this->set(compact('infoEval', 'allquestions', 'drugs', 'quest_id'));
	}

	function edit() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$typeQ = $this->params['named']['typeQ'];
			$eval_id = $this->params['named']['eval'];
			$lang_id = $this->params['named']['elang'];
		}
		
		if (!empty($this->data)) {
			$this->QuestionnaireTreatment->begin();  // Start of transaction
			if ($this->QuestionnaireTreatment->save($this->data['QuestionnaireTreatment'])) {				
				# save QuestionnaireTreatment
				if (!empty($this->data['Medstemp'])) {
					# delete all Items for MedicationTreatment
					$this->QuestionnaireTreatment->MedicationTreatment->deleteAll(array('questionnaire_treatment_id =' => $this->QuestionnaireTreatment->id));				
					$this->__settingdataMeds($this->data['QuestionnaireTreatment']['id']); 
					if (!empty($this->data['MedicationTreatment'])) {
						if ($this->QuestionnaireTreatment->MedicationTreatment->saveAll($this->data['MedicationTreatment'])) {
							if (isset($this->data['Therapytemp'])) {
								# delete all Items for TherapyTreatment
								$this->QuestionnaireTreatment->TherapyTreatment->deleteAll(array('questionnaire_treatment_id =' => $this->QuestionnaireTreatment->id));											
								$this->__settingdataThep($this->data['QuestionnaireTreatment']['id']); 
								if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
									$this->QuestionnaireTreatment->commit(); // Persist the data 
									$this->flashSuccess(__('El Treatment Questionnaire fué actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
									exit;
								} else {
									$this->QuestionnaireTreatment->rollback();
									$this->flashWarning(__('El Treatment Questionnaire no fué actualizado. Corrija el error.', true));							
								}
							} else {
								$this->QuestionnaireTreatment->commit(); // Persist the data 
								$this->flashSuccess(__('El Treatment Questionnaire fué actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
								exit;							
							}
						} else {
							$this->QuestionnaireTreatment->rollback();
							$this->flashWarning(__('El Treatment Questionnaire no fué actualizado. Corrija el error.', true));
						}
					} else {
						if (isset($this->data['Therapytemp'])) {
							# delete all Items for TherapyTreatment
							$this->QuestionnaireTreatment->TherapyTreatment->deleteAll(array('questionnaire_treatment_id =' => $this->QuestionnaireTreatment->id));							
							$this->__settingdataThep($this->data['QuestionnaireTreatment']['id']); 
							if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
								$this->QuestionnaireTreatment->commit(); // Persist the data 
								$this->flashSuccess(__('El Treatment Questionnaire fué actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
								exit;
							} else {
								$this->QuestionnaireTreatment->rollback();
								$this->flashWarning(__('El Treatment Questionnaire no fué actualizado. Corrija el error.', true));						
							}
						} else {
							$this->QuestionnaireTreatment->commit(); // Persist the data 
							$this->flashSuccess(__('El Treatment Questionnaire fué actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
							exit;					
						}
					}				
				} else { 
					if (isset($this->data['Therapytemp'])) {
						# delete all Items for TherapyTreatment
						$this->QuestionnaireTreatment->TherapyTreatment->deleteAll(array('questionnaire_treatment_id =' => $this->QuestionnaireTreatment->id));						
						$this->__settingdataThep($this->data['QuestionnaireTreatment']['id']); 
						if ($this->QuestionnaireTreatment->TherapyTreatment->saveAll($this->data['TherapyTreatment'])) {					
							$this->QuestionnaireTreatment->commit(); // Persist the data 
							$this->flashSuccess(__('El Treatment Questionnaire fué actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
							exit;
						} else {
							$this->QuestionnaireTreatment->rollback();
							$this->flashWarning(__('El Treatment Questionnaire no fué actualizado. Corrija el error.', true));						
						}
					} else {
						$this->QuestionnaireTreatment->commit(); // Persist the data 
						$this->flashSuccess(__('El Treatment Questionnaire fué actualizado.', true), '/questionnaires_services/view_answers/serv:'.$this->data['Service']['id'].'/eval:'.$this->data['QuestionnaireTreatment']['evaluation_id']);
						exit;					
					}
				}
			} else {
				$this->QuestionnaireTreatment->rollback();
				$this->flashWarning(__('El Treatment Questionnaire no fué actualizado. Corrija el error.', true));
			}		
		} else {
			### set up default ###			
			$infoEval = $this->QuestionnaireTreatment->Evaluation->infoEval($eval_id);
			$infoTreatQuest = $this->QuestionnaireTreatment->infoTreatQuest0($eval_id);

			##### set the data to save Treatment Q
			# set up default values for form
			$this->data['Service']['id'] = $infoEval['Service']['id'];
			$this->data['QuestionnaireTreatment']['id'] = $infoTreatQuest['QuestionnaireTreatment']['id'];
			$this->data['MedicationTreatment']['questionnaire_treatment_id'] = $infoTreatQuest['QuestionnaireTreatment']['id'];
			
			# Treatment Questionnaire: Initial
			$this->data['QuestionnaireTreatment']['type_q'] = $typeQ;

			# Treatment Questionnaire: Initial
			if( $typeQ == 0 ) { $this->data['QuestionnaireTreatment']['questionnaire_id'] = $quest_id = 4; }
			
			# Treatment Questionnaire: Follow up
			if( $typeQ == 1 ) { $this->data['QuestionnaireTreatment']['questionnaire_id'] = $quest_id = 5; }
		
			$this->data['QuestionnaireTreatment']['evaluation_id'] = $eval_id;
			$this->data['QuestionnaireTreatment']['langue'] = $lang_id;
			$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];
			//$this->data['QuestionnaireTreatment']['createdby'] = $this->Session->read('Auth.User.username');
			//echo $infoTreatQuest['QuestionnaireTreatment']['id'];
			$this->data['QuestionnaireTreatment']['ctrlform'] = 2;  //to control the select input question - ADD
		}
		$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->find('list', array('order' => 'Drug.name'));
		//$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->find('list', array('fields' => array('Drug.id', 'Drug.name', 'Drug.category')));
		$allquestions = $this->QuestionnaireTreatment->Questionnaire->Question->infoquestionallchoices($this->data['QuestionnaireTreatment']['questionnaire_id']);				

		#Answers Info
		$selectedstop = array();
		
		# Initial Treatment Questionnaire / Q1: Yes, receiving some treatment
		if ($infoTreatQuest['QuestionnaireTreatment']['type_q'] == 0 && $infoTreatQuest['QuestionnaireTreatment']['treatment'] == 1)  {	
			# Go look for the list of meds
			$a = count($infoTreatQuest['MedicationTreatment']);
			$e=0;
			
			for ($b=0; $b < $a; $b++) {
				if ($infoTreatQuest['MedicationTreatment'][$b]['type_temps'] == 1) {	//1: Current medications	
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['drug_id'])) { 
						$this->data['Medstemp'][$e]['drug_id'] = $infoTreatQuest['MedicationTreatment'][$b]['drug_id']; 
					} else {
						$this->data['Medstemp'][$e]['customemeds'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_drug']; 
					}
					
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['date_of_start'])) {
						//$this->data['Medstemp'][$e]['date_of_start'] = $infoTreatQuest['MedicationTreatment'][$b]['date_of_start'];
							$this->data['Medstemp'][$e]['year_t'] =  date('Y', strtotime($infoTreatQuest['MedicationTreatment'][$b]['date_of_start']));
							$this->data['Medstemp'][$e]['month_t'] =  date('m', strtotime($infoTreatQuest['MedicationTreatment'][$b]['date_of_start']));
							$this->data['Medstemp'][$e]['day_t'] =  date('d', strtotime($infoTreatQuest['MedicationTreatment'][$b]['date_of_start']));
					} else {
						$this->data['Medstemp'][$e]['date_of_start'] = ' -  - ';
					}
					$this->data['Medstemp'][$e]['more_5years'] = $infoTreatQuest['MedicationTreatment'][$b]['more_5years'];
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['custome_dose'])) { 
						$this->data['Medstemp'][$e]['custome_dose'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_dose'];
					}					
				}
				
				if ($infoTreatQuest['MedicationTreatment'][$b]['type_temps'] == 0) {	//0: Stopped medications	
					if ($e < 5) { $e = 5; }
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['reason_stopped_list'])) {
						$listestop = substr($infoTreatQuest['MedicationTreatment'][$b]['reason_stopped_list'], 1);
					} else {
						$listestop = '';
					}					
					$selectedstop1 = explode(":", $listestop);
					$selectedstop = array_merge($selectedstop, array($e => $selectedstop1));
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['drug_id'])) { 
						$this->data['Medstemp'][$e]['drug_id'] = $infoTreatQuest['MedicationTreatment'][$b]['drug_id']; 
					} else {
						$this->data['Medstemp'][$e]['customemeds'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_drug']; 
					}
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['custome_dose'])) { 
						$this->data['Medstemp'][$e]['custome_dose'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_dose'];
					}						
				}				
				$e++;
			}			
		}		

		# Follow up Treatment Questionnaire / 
		if ($infoTreatQuest['QuestionnaireTreatment']['type_q'] == 1)  {	
			if (isset($infoTreatQuest['MedicationTreatment'])) {
				# Go look for the list of meds
				$a = count($infoTreatQuest['MedicationTreatment']);
				$e=0;				
				for ($b=0; $b < $a; $b++) {
					if ($infoTreatQuest['MedicationTreatment'][$b]['type_temps'] == 1) {	//1: Current medications	
						if (!empty($infoTreatQuest['MedicationTreatment'][$b]['drug_id'])) { 
							$this->data['Medstemp'][$e]['drug_id'] = $infoTreatQuest['MedicationTreatment'][$b]['drug_id']; 
						} else {
							$this->data['Medstemp'][$e]['customemeds'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_drug']; 
						}
						
						if (!empty($infoTreatQuest['MedicationTreatment'][$b]['date_of_start'])){
							//$this->data['Medstemp'][$e]['date_of_start'] = $infoTreatQuest['MedicationTreatment'][$b]['date_of_start'];
							$this->data['Medstemp'][$e]['year_t'] =  date('Y', strtotime($infoTreatQuest['MedicationTreatment'][$b]['date_of_start']));
							$this->data['Medstemp'][$e]['month_t'] =  date('m', strtotime($infoTreatQuest['MedicationTreatment'][$b]['date_of_start']));
							$this->data['Medstemp'][$e]['day_t'] =  date('d', strtotime($infoTreatQuest['MedicationTreatment'][$b]['date_of_start']));
						} else {
							$this->data['Medstemp'][$e]['date_of_start'] = ' -  - ';
						}
						if (!empty($infoTreatQuest['MedicationTreatment'][$b]['custome_dose'])) { 
							$this->data['Medstemp'][$e]['custome_dose'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_dose'];
						}												
					}				
					$e++;
				}			
			}			
		}
		$this->data['QuestionnaireTreatment']['nonprescrip_compounds_name'] = $infoTreatQuest['QuestionnaireTreatment']['nonprescrip_compounds_name'];
		
		if ($infoTreatQuest['QuestionnaireTreatment']['side_effects'] == 1) {	//Yes side_effects
			$listesef = substr($infoTreatQuest['QuestionnaireTreatment']['side_effects_list'], 1);
			$selectedsef = explode(":", $listesef);
			$this->data['QuestionnaireTreatment']['custome_side_effect'] = $infoTreatQuest['QuestionnaireTreatment']['custome_side_effect'];
		}  else { $selectedsef = null; }

		if (!empty($infoTreatQuest['QuestionnaireTreatment']['taking_meds_list'])) {	//Yes side_effects
			$listemedl = substr($infoTreatQuest['QuestionnaireTreatment']['taking_meds_list'], 1);
			$selectedmedl = explode(":", $listemedl);	
		}  else { $selectedmedl = null; }
		
		$this->data['QuestionnaireTreatment']['choice_secondary_id'] = $infoTreatQuest['QuestionnaireTreatment']['choice_secondary_id'];
				
		$this->set(compact('infoEval', 'allquestions', 'drugs', 'infoTreatQuest', 'selectedsef','selectedmedl','selectedstop'));
	}
	
	
	function view($id = null) {
		# First time the page is loaded
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$quest_id = $this->params['named']['quest'];
		}			
			
		### set up default ###			
		$infoEval = $this->QuestionnaireTreatment->Evaluation->infoEval($eval_id);
		$infoTreatQuest = $this->QuestionnaireTreatment->infoTreatQuest0($eval_id);
							
		##### set the data to save Treatment Q
		# set up default values for form
		$this->data['Service']['id'] = $infoEval['Service']['id'];
		
		# Treatment Questionnaire: Initial
		if( $quest_id == 4 ) { $this->data['QuestionnaireTreatment']['type_q'] = 0; }
			
		# Treatment Questionnaire: Follow up
		if( $quest_id == 5 ) { $this->data['QuestionnaireTreatment']['type_q'] = 1; }
		
		$this->data['QuestionnaireTreatment']['evaluation_id'] = $eval_id;
		$this->data['QuestionnaireTreatment']['questionnaire_id'] = $quest_id;
		$this->data['QuestionnaireTreatment']['langue'] = $lang_id;
		$this->data['QuestionnaireTreatment']['test_serie'] = $infoEval['Evaluation']['test_serie'];
		$this->data['Evaluation']['order_id'] = $infoEval['Evaluation']['order_id'];		
		
		$this->data['QuestionnaireTreatment']['ctrlform'] = 1;  //to control the select input question - VIEW
		
		$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->find('list', array('order' => 'Drug.name'));
		$allquestions = $this->QuestionnaireTreatment->Questionnaire->Question->infoquestionallchoices($this->data['QuestionnaireTreatment']['questionnaire_id']);	
		
		#Answers Info
		$selectedstop = array();
		
		# Initial Treatment Questionnaire / Q1: Yes, receiving some treatment
		if ($infoTreatQuest['QuestionnaireTreatment']['type_q'] == 0 && $infoTreatQuest['QuestionnaireTreatment']['treatment'] == 1)  {	
			# Go look for the list of meds
			$a = count($infoTreatQuest['MedicationTreatment']);
			$e=0;
			
			for ($b=0; $b < $a; $b++) {
				if ($infoTreatQuest['MedicationTreatment'][$b]['type_temps'] == 1) {	//1: Current medications	
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['drug_id'])) { 
						$this->data['MedicationTreatment'][$e]['drug_id'] = $infoTreatQuest['MedicationTreatment'][$b]['drug_id']; 
					} else {
						$this->data['MedicationTreatment'][$e]['customemeds'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_drug']; 
					}
					
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['date_of_start'])) {
						$this->data['MedicationTreatment'][$e]['date_of_start'] = $infoTreatQuest['MedicationTreatment'][$b]['date_of_start'];								
					} else {
						$this->data['MedicationTreatment'][$e]['date_of_start'] = ' -  - ';
					}
					$this->data['MedicationTreatment'][$e]['more_5years'] = $infoTreatQuest['MedicationTreatment'][$b]['more_5years'];
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['custome_dose'])) { 
						$this->data['MedicationTreatment'][$e]['custome_dose'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_dose'];
					}										
				}
				
				if ($infoTreatQuest['MedicationTreatment'][$b]['type_temps'] == 0) {	//0: Stopped medications	
					if ($e < 5) { $e = 5; }
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['reason_stopped_list'])) {
						$listestop = substr($infoTreatQuest['MedicationTreatment'][$b]['reason_stopped_list'], 1);
					} else {
						$listestop = '';
					}					
					$selectedstop1 = explode(":", $listestop);
					$selectedstop = array_merge($selectedstop, array($e => $selectedstop1));
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['drug_id'])) { 
						$this->data['MedicationTreatment'][$e]['drug_id'] = $infoTreatQuest['MedicationTreatment'][$b]['drug_id']; 
					} else {
						$this->data['MedicationTreatment'][$e]['customemeds'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_drug']; 
					}
					if (!empty($infoTreatQuest['MedicationTreatment'][$b]['custome_dose'])) { 
						$this->data['MedicationTreatment'][$e]['custome_dose'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_dose'];
					}							
				}				
				$e++;
			}			
		}
		
		# Follow up Treatment Questionnaire / 
		if ($infoTreatQuest['QuestionnaireTreatment']['type_q'] == 1)  {	
			if (isset($infoTreatQuest['MedicationTreatment'])) {
				# Go look for the list of meds
				$a = count($infoTreatQuest['MedicationTreatment']);
				$e=0;				
				for ($b=0; $b < $a; $b++) {
					if ($infoTreatQuest['MedicationTreatment'][$b]['type_temps'] == 1) {	//1: Current medications	
						if (!empty($infoTreatQuest['MedicationTreatment'][$b]['drug_id'])) { 
							$this->data['MedicationTreatment'][$e]['drug_id'] = $infoTreatQuest['MedicationTreatment'][$b]['drug_id']; 
						} else {
							$this->data['MedicationTreatment'][$e]['customemeds'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_drug']; 
						}
						
						if (!empty($infoTreatQuest['MedicationTreatment'][$b]['date_of_start'])){
							$this->data['MedicationTreatment'][$e]['date_of_start'] = $infoTreatQuest['MedicationTreatment'][$b]['date_of_start'];								
						} else {
							$this->data['MedicationTreatment'][$e]['date_of_start'] = ' -  - ';
						}
						if (!empty($infoTreatQuest['MedicationTreatment'][$b]['custome_dose'])) { 
							$this->data['MedicationTreatment'][$e]['custome_dose'] = $infoTreatQuest['MedicationTreatment'][$b]['custome_dose'];
						}							
					}				
					$e++;
				}			
			}			
		}

		
		$this->data['QuestionnaireTreatment']['nonprescrip_compounds_name'] = $infoTreatQuest['QuestionnaireTreatment']['nonprescrip_compounds_name'];
		
		if ($infoTreatQuest['QuestionnaireTreatment']['side_effects'] == 1) {	//Yes side_effects
			$listesef = substr($infoTreatQuest['QuestionnaireTreatment']['side_effects_list'], 1);
			$selectedsef = explode(":", $listesef);
			$this->data['QuestionnaireTreatment']['custome_side_effect'] = $infoTreatQuest['QuestionnaireTreatment']['custome_side_effect'];
		} else { $selectedsef = null; }

		if (!empty($infoTreatQuest['QuestionnaireTreatment']['taking_meds_list'])) {	//Yes side_effects
			$listemedl = substr($infoTreatQuest['QuestionnaireTreatment']['taking_meds_list'], 1);
			$selectedmedl = explode(":", $listemedl);
		} else { $selectedmedl = null; }

		$this->data['QuestionnaireTreatment']['choice_secondary_id'] = $infoTreatQuest['QuestionnaireTreatment']['choice_secondary_id'];

		$this->set(compact('infoEval', 'allquestions', 'drugs', 'quest_id', 'infoTreatQuest', 'selectedsef', 'selectedmedl', 'selectedstop'));
	}

	
	function view_treat_quest() {
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['eval'])) {
			$lang_id = $this->params['named']['elang'];
			$eval_id = $this->params['named']['eval'];
			$ord_id = $this->params['named']['ord'];
		}	
		

		# Get the customer address / patient name / order code => to the letter	
		$infoCustomerEvalorder = $this->QuestionnaireTreatment->Evaluation->infoCustomerEvalOrder($eval_id);

		# Call to the function that will do the Doctor Letter - Scoring 
		$interpDoctorLetter = $this->QuestionnaireTreatment->interpDoctorLetter($eval_id, $infoCustomerEvalorder['Evaluation']['test_serie'],$lang_id);		
		//echo pr($interpDoctorLetter);
		$this->layout = 'pdf'; //this will use the pdf.ctp layout
		$this->set(compact('lang_id','infoCustomerEvalorder','interpDoctorLetter'));
		$this->render();
	}
		
	function __settingdataMeds($id) {	
		# Current Medications for Initial and Follow up
		$j = 0;
		for ($x=0; $x < 5; $x++) {
			if (!empty($this->data['Medstemp'][$x]['drug_id']) || !empty($this->data['Medstemp'][$x]['customemeds'])) {
			//1: Current medications
				$this->data['MedicationTreatment'][$j]['type_temps'] = 1;
				if (!empty($this->data['Medstemp'][$x]['year_t']['year']) && !empty($this->data['Medstemp'][$x]['month_t']['month']) && !empty($this->data['Medstemp'][$x]['day_t']['day'])) {
					$this->data['MedicationTreatment'][$j]['date_of_start'] = $this->data['Medstemp'][$x]['year_t']['year'].'-'.$this->data['Medstemp'][$x]['month_t']['month'].'-'.$this->data['Medstemp'][$x]['day_t']['day'];
				}
				
				# Settting the drugs
				if (!empty($this->data['Medstemp'][$x]['drug_id'])) { 
					$this->data['MedicationTreatment'][$j]['drug_id'] = $this->data['Medstemp'][$x]['drug_id'];	
					$this->data['MedicationTreatment'][$j]['custome_drug'] = '';
				}
				if (!empty($this->data['Medstemp'][$x]['customemeds'])) { 
					$this->data['MedicationTreatment'][$j]['custome_drug'] = $this->data['Medstemp'][$x]['customemeds'];
				}
				$this->data['MedicationTreatment'][$j]['more_5years'] = $this->data['Medstemp'][$x]['more_5years'];
				if (!empty($this->data['Medstemp'][$x]['custome_dose'])) { 
					$this->data['MedicationTreatment'][$j]['custome_dose'] = $this->data['Medstemp'][$x]['custome_dose'];
				}									
				$this->data['MedicationTreatment'][$j]['custome_dose_unit'] = $this->data['Medstemp'][$x]['custome_dose_unit'];
				$this->data['MedicationTreatment'][$j]['reason_stopped_list'] = '';	
				if ($this->data['Medstemp'][$x]['higherdose'] != NULL) { 
					$this->data['MedicationTreatment'][$j]['higherdose'] = $this->data['Medstemp'][$x]['higherdose'];
				}									
				# attach the recent QuestionnaireTreatment ID 
				$this->data['MedicationTreatment'][$j]['questionnaire_treatment_id'] = $id;
				$j++;
			}				
		}

		# Stopped medications for Initial Questionnaire
		if ($this->data['QuestionnaireTreatment']['type_q'] == 0) {
		# Meds NO longer taking
			for ($x=5; $x < 10; $x++) {
				if (!empty($this->data['Medstemp'][$x]['drug_id']) || !empty($this->data['Medstemp'][$x]['customemeds'])) {
					//0: Stopped medications
					$this->data['MedicationTreatment'][$j]['type_temps'] = 0;
					$this->data['MedicationTreatment'][$j]['date_of_start'] = '';
					$this->data['MedicationTreatment'][$j]['custome_drug'] = '';										
					if (!empty($this->data['Medstemp'][$x]['custome_dose'])) { 
						$this->data['MedicationTreatment'][$j]['custome_dose'] = $this->data['Medstemp'][$x]['custome_dose'];
					}					
					$this->data['MedicationTreatment'][$j]['custome_dose_unit'] = $this->data['Medstemp'][$x]['custome_dose_unit'];
					if ($this->data['Medstemp'][$x]['reason_stopped_list'] != '' || !empty($this->data['Medstemp'][$x]['reason_stopped_list'])) {
						$reasonstoppedschaine = '';
						$reasonstoppeds = $this->data['Medstemp'][$x]['reason_stopped_list'];
						foreach($reasonstoppeds as $reasonstopped)
						{
							$reasonstoppedschaine = $reasonstoppedschaine.':'.$reasonstopped;			
						}					
						$this->data['MedicationTreatment'][$j]['reason_stopped_list'] = $reasonstoppedschaine;
					}						
					
					# Settting the drugs
					if (!empty($this->data['Medstemp'][$x]['drug_id'])) { 
						$this->data['MedicationTreatment'][$j]['drug_id'] = $this->data['Medstemp'][$x]['drug_id'];
						$this->data['MedicationTreatment'][$j]['custome_drug'] = '';
					}
					if (!empty($this->data['Medstemp'][$x]['customemeds'])) { 
						$this->data['MedicationTreatment'][$j]['custome_drug'] = $this->data['Medstemp'][$x]['customemeds'];
					}					
					
					$this->data['MedicationTreatment'][$j]['questionnaire_treatment_id'] = $id;						
					$j++;
				}				
			}
		}
	}
	
	function __settingdataThep($id) {	
		### Treatment with Therapy ###
		$w = 0;
		for ($g=0; $g < 5; $g++) {	
			if (!empty($this->data['Therapytemp'][$g]['choice_secondary_id'])) {									
				$this->data['TherapyTreatment'][$w]['duration_of_session'] = $this->data['Therapytemp'][$g]['duration_of_session'];
				$this->data['TherapyTreatment'][$w]['custometherapy'] = $this->data['Therapytemp'][$g]['custometherapy'];					
				$this->data['TherapyTreatment'][$w]['choice_secondary_id'] = $this->data['Therapytemp'][$g]['choice_secondary_id'];
				$this->data['TherapyTreatment'][$w]['frequency_list_id'] = $this->data['Therapytemp'][$g]['frequency_list_id'];
				$this->data['TherapyTreatment'][$w]['customeFtherapy'] = $this->data['Therapytemp'][$g]['customeFtherapy'];
				$this->data['TherapyTreatment'][$w]['questionnaire_treatment_id'] = $id;
				$w++;
			}				
		}
	}	
	
	
	public function get_json_drug() {
		$this->view = 'Json';
		
		$query = $_GET['term'];
		
		$drugs = $this->QuestionnaireTreatment->MedicationTreatment->Drug->searchListDrugName($query);
		$i=0;
		foreach($drugs as $drug) {
			$json[$i]['value'] = $drug['Drug']['name'];
			$json[$i]['id'] = $drug['Drug']['id'];
			$i++;  
		}
		$this->set(compact('json'));
	}	
}
?>