<?php
class QuestionnairesServicesController extends AppController {

	var $name = 'QuestionnairesServices';
	var $helpers = array('Html', 'Form', 'Time');

	
	function beforeFilter() {
	  parent::beforeFilter();
	}		

	
	function index() {
		$this->QuestionnairesService->recursive = 0;
		
		$this->paginate = array(
						'fields' => array('id'),
						'link' => array(
							'Questionnaire' => array(
								'fields' => array('Questionnaire.id', 'Questionnaire.name')),
							'Service' => array(
								'fields' => array('Service.id', 'Service.name'))
								),
						'group' => 'QuestionnairesService.service_id',		
						'order' => 'Service.id DESC'
					);		
					
		$questionnaireServices = $this->paginate('QuestionnairesService');
		
		$this->set(compact('questionnaireServices'));
	}

	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('questionnaireService', $this->QuestionnairesService->read(null, $id));
	}
	
	function cancel() {
		# Called from form_select_questionnaire view
		if (isset($this->params['named']['eval'])){		
			$this->redirect(array ('controller' => 'evaluations', 'action' => $this->params['named']['returnctl'].'/'.$this->params['named']['eval']));			
		}		
	}

	function add($id = null) {
		if (!empty($this->data)) {
			$this->QuestionnairesService->create();
		}
			$questionnaires = $this->QuestionnairesService->Questionnaire->find('list', array('conditions' => array('Questionnaire.active' => 1)));
			$serviceQ = $this->QuestionnairesService->Service->read(null, $id);
		
		$this->set(compact('serviceQ', 'questionnaires'));
	}
		

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
	
		if (!empty($this->data)) {
			if ($this->QuestionnairesService->save($this->data)) {
				$this->flashSuccess(__('El cuestionario/servicio ha sido actualizado.', true), 'index');
			} else {
				$this->flashWarning(__('El cuestionario/servicio no ha sido actualizado. Corrija el error.', true));
			}
		} else {
			$this->data = $this->QuestionnairesService->read(null, $id);
		}
	}

	
	function add_score() {
		# Validating a change of language in order to redirect to the next "index"
		if (isset($this->params['named']['elang'])) {
			  $this->redirect(array('controller' => 'evaluations', 'action' => 'index'));			
		}		
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['serv'])){
			$serv_id = $this->params['named']['serv'];
			$eval_id = $this->params['named']['eval'];
		}
		if (!empty($this->data)) {
			if(( $this->data['QuestionnaireService']['questionnaire_id'] == 1 ) || ( $this->data['QuestionnaireService']['questionnaire_id'] == 2 )) {
			## DSP-45 OR DSP-77 ##
			Controller::loadModel('DspScore');
			$countDsps = $this->DspScore->countDsp($this->data['QuestionnaireService']['evaluation_id']);
				if( $countDsps == 0 ) {
					$this->redirect(array('controller' => 'dsp_scores', 'action' => 'add', 'quest' => $this->data['QuestionnaireService']['questionnaire_id'], 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 
												'elang' => $this->data['QuestionnairesServices']['langue'], 'test_serie' => $this->data['Evaluation']['test_serie']));									
				} else {
					$this->flashWarning(__('El cuestionario no pudo ser procesado. Ha sido completado ya.', true));
				}
				//echo '00. '.Configure::read('Config.language');
			} elseif( $this->data['QuestionnaireService']['questionnaire_id'] == 3 )  {
			## HSQ ##			
				Controller::loadModel('HsqScore');
				$countHsqs = $this->HsqScore->countHsq($this->data['QuestionnaireService']['evaluation_id']);
					if( $countHsqs == 0 ) {
						$this->redirect(array('controller' => 'hsq_scores', 'action' => 'add', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue'],
												'test_serie' => $this->data['Evaluation']['test_serie']));
					} else {
						$this->flashWarning(__('El cuestionario no pudo ser procesado. Ha sido completado ya.', true));
					}										
			} else {
			## TR.Quest Initial / TR.Quest Follow Up ##
				if(( $this->data['QuestionnaireService']['questionnaire_id'] == 4 ) || ( $this->data['QuestionnaireService']['questionnaire_id'] == 5 ) ){
					Controller::loadModel('QuestionnaireTreatment');
					$countTreatQ = $this->QuestionnaireTreatment->countTreatQ($this->data['QuestionnaireService']['evaluation_id']);
					if( $countTreatQ == 0 ) {
						$this->redirect(array('controller' => 'questionnaire_treatments', 'action' => 'add', 'quest' => $this->data['QuestionnaireService']['questionnaire_id'], 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 
													'elang' => $this->data['QuestionnairesServices']['langue'], 'test_serie' => $this->data['Evaluation']['test_serie']));
					} else {
						$this->flashWarning(__('El cuestionario no pudo ser procesado. Ha sido completado ya.', true));
					}	
				}					
			}						
		} else {
			$this->data['QuestionnaireService']['evaluation_id'] = $eval_id;
			$this->data['Service']['id'] = $serv_id;
			$this->data['QuestionnaireService']['formname'] = 0;  //to control the jquery submit
					
			$infoEvalorder = $this->QuestionnairesService->Service->Evaluation->infoEvalorder($eval_id);			
			$this->data['Service']['name'] = $infoEvalorder['Service']['name'];
			$this->data['Employee']['name'] = $infoEvalorder['Employee']['name'];
			$this->data['Employee']['id'] = $infoEvalorder['Employee']['id'];
			$this->data['Order']['order_code'] = $infoEvalorder['Order']['order_code'];
			$this->data['Order']['id'] = $infoEvalorder['Order']['id'];
			$this->data['Evaluation']['test_serie'] = $infoEvalorder['Evaluation']['test_serie'];			
		}
			$questionnaires = $this->QuestionnairesService->Questionnaire->infoquestservice($this->data['Service']['id']);			
		
			$this->set(compact('questionnaires'));
			//echo '1. '.Configure::read('Config.language');
	}

	function view_score()
	{
		$serv_id = 0;
		$eval_id = 0;
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['serv']) && isset($this->params['named']['eval'])) {
			$serv_id = $this->params['named']['serv'];
			$eval_id = $this->params['named']['eval'];
			$emp_language = $this->params['named']['lang_emp'];
		}

		if (!empty($this->data)) {
			## INDIVIDUAL REPORTS ##
			## DSP-45 OR DSP-77 ##
			if (($this->data['QuestionnaireService']['questionnaire_id'] == 1)  || ($this->data['QuestionnaireService']['questionnaire_id'] == 2)) {
				Controller::loadModel('DspScore');
				$countDsps = $this->DspScore->countDsp($this->data['QuestionnaireService']['evaluation_id']);
				if ($countDsps == 0) {
					$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));
				} else {
					$this->redirect(array(
						'controller' => 'dsp_scores', 'action' => 'view_dsp_score', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue'],
						'ord' => $this->data['Order']['id'], 'quest' => $this->data['QuestionnaireService']['questionnaire_id'], 'test_serie' => $this->data['Evaluation']['test_serie']
					));
				}
			} elseif ($this->data['QuestionnaireService']['questionnaire_id'] == 3) {
				## INDIVIDUAL REPORTS ##
				## HSQ ##
				Controller::loadModel('HsqScore');
				$countHsqs = $this->HsqScore->countHsq($this->data['QuestionnaireService']['evaluation_id']);
				if ($countHsqs == 0) {
					$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));
				} else {
					$this->redirect(array(
						'controller' => 'hsq_scores', 'action' => 'view_hsq_score', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue'],
						'ord' => $this->data['Order']['id'], 'test_serie' => $this->data['Evaluation']['test_serie']
					));
				}
			}
			if (($this->data['QuestionnaireService']['questionnaire_id'] == 4) || ($this->data['QuestionnaireService']['questionnaire_id'] == 5)) {
				## INDIVIDUAL REPORTS ##
				## TR.Quest Initial / TR.Quest Follow Up ##
				Controller::loadModel('QuestionnaireTreatment');
				$countTreatQ = $this->QuestionnaireTreatment->countTreatQ($this->data['QuestionnaireService']['evaluation_id']);

				Controller::loadModel('DspScore');
				$countDsps = $this->DspScore->countDsp($this->data['QuestionnaireService']['evaluation_id']);

				if ($countTreatQ == 0 && $countDsps == 0) {
					$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));
				} else {
					$this->redirect(array(
						'controller' => 'questionnaire_treatments', 'action' => 'view_treat_quest', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue'],
						'ord' => $this->data['Order']['id'], 'quest' => $this->data['QuestionnaireService']['questionnaire_id'], 'test_serie' => $this->data['Evaluation']['test_serie']
					));
				}
			} else {
				## COMBO REPORT ##
				## DSP-45/DSP-77 + TREATMENT QUESTIONNAIRE ##
				if ($this->data['Service']['name'] == "evmedmx-a1-TREAT.QUEST.Initial / DSP-45" || $this->data['Service']['name'] == "evmedmx-a1-TREAT.QUEST.Follow up / DSP-45" || $this->data['Service']['name'] == "WPS-TRQ/DSP45-Initial" || $this->data['Service']['name'] == "WPS-TRQ/DSP45-Follow-up" || $this->data['Service']['name'] == "DRM-TRQ/DSP-45-Initial" || $this->data['Service']['name'] == "DRM-TRQ/DSP-45-Follow-up" || $this->data['Service']['name'] == "DRM-TRQ/DSP-77-Initial" || $this->data['Service']['name'] == "DRM-TRQ/DSP-77-Follow-up") {
					$this->data['QuestionnaireService']['questionnaire_id'] = '1';
					Controller::loadModel('QuestionnaireTreatment');
					$countTreatQ = $this->QuestionnaireTreatment->countTreatQ($this->data['QuestionnaireService']['evaluation_id']);

					Controller::loadModel('DspScore');
					$countDsps = $this->DspScore->countDsp($this->data['QuestionnaireService']['evaluation_id']);

					if ($countTreatQ == 0 && $countDsps == 0) {
						$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));
					} else {

						$this->redirect(array(
							'controller' => 'dsp_scores', 'action' => 'view_combo_dsp_trq_score', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue'],
							'ord' => $this->data['Order']['id'], 'quest' => $this->data['QuestionnaireService']['questionnaire_id'], 'test_serie' => $this->data['Evaluation']['test_serie']
						));
					}
				}
			}
		} else {
			$this->data['QuestionnaireService']['evaluation_id'] = $eval_id;
			$this->data['Service']['id'] = $serv_id;
			$this->data['QuestionnaireService']['formname'] = 1;  //to control the jquery submit

			$infoEvalorder = $this->QuestionnairesService->Service->Evaluation->infoEvalorder($eval_id);
			$this->data['Service']['name'] = $infoEvalorder['Service']['name'];
			$this->data['Employee']['name'] = $infoEvalorder['Employee']['name'];
			$this->data['Employee']['id'] = $infoEvalorder['Employee']['id'];
			$this->data['Employee']['langue'] = $emp_language;
			$this->data['Order']['order_code'] = $infoEvalorder['Order']['order_code'];
			$this->data['Order']['id'] = $infoEvalorder['Order']['id'];
			$this->data['Evaluation']['test_serie'] = $infoEvalorder['Evaluation']['test_serie'];
		}
		# Get all the questionnaires associated to a specific Service
		$questionnaires = $this->QuestionnairesService->Questionnaire->infoquestservice($this->data['Service']['id']);


		$this->set(compact('questionnaires', 'infoEvalorder'));
	}
	

	function view_answers() {
	$serv_id = 0;
	$eval_id = 0;
		# First time the page is loaded - right after an Employee has been selected
		if (isset($this->params['named']['serv'])) {
			$serv_id = $this->params['named']['serv'];
			$eval_id = $this->params['named']['eval'];
		}	
		//echo '$serv_id '.$serv_id;
		//echo '$eval_id '.$eval_id;
		
		if (!empty($this->data)) {
			if(( $this->data['QuestionnaireService']['questionnaire_id'] == 1 ) || ( $this->data['QuestionnaireService']['questionnaire_id'] == 2 )) {
			## DSP-45 OR DSP-77 ##
				Controller::loadModel('DspScore');
				$countDsps = $this->DspScore->countDsp($this->data['QuestionnaireService']['evaluation_id']);
				if( $countDsps == 0 ) {
					$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));					
				}else{
					$this->redirect(array('controller' => 'dsp_scores', 'action' => 'view', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue']));
				}
			}elseif( $this->data['QuestionnaireService']['questionnaire_id'] == 3 ){
			## HSQ ##
				Controller::loadModel('HsqScore');
				$countHsqs = $this->HsqScore->countHsq($this->data['QuestionnaireService']['evaluation_id']);
				if( $countHsqs == 0 ) {
					$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));						
				}else{
					$this->redirect(array('controller' => 'hsq_scores', 'action' => 'view', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue']));
				}										
			}else{
			## TR.Quest Initial / TR.Quest Follow Up ##
				if(( $this->data['QuestionnaireService']['questionnaire_id'] == 4 ) || ( $this->data['QuestionnaireService']['questionnaire_id'] == 5 ) ){
					Controller::loadModel('QuestionnaireTreatment');
					$countTreatQ = $this->QuestionnaireTreatment->countTreatQ($this->data['QuestionnaireService']['evaluation_id']);
					if( $countTreatQ == 0 ) 
					{
						$this->flashWarning(__('El cuestionario no pudo ser procesado. No ha sido completado aún.', true));							
					}else{
						$this->redirect(array('controller' => 'questionnaire_treatments', 'action' => 'view', 'eval' => $this->data['QuestionnaireService']['evaluation_id'], 'elang' => $this->data['QuestionnairesServices']['langue'],
						'quest' => $this->data['QuestionnaireService']['questionnaire_id']));
					}	
				}
			}						
		}else{
			$this->data['QuestionnaireService']['evaluation_id'] = $eval_id;
			$this->data['Service']['id'] = $serv_id;
			$this->data['QuestionnaireService']['formname'] = 2;  //to control the jquery submit
					
			$infoEvalorder = $this->QuestionnairesService->Service->Evaluation->infoEvalorder($eval_id);
			$this->data['Service']['name'] = $infoEvalorder['Service']['name'];
			$this->data['Employee']['name'] = $infoEvalorder['Employee']['name'];
			$this->data['Employee']['id'] = $infoEvalorder['Employee']['id'];
			$this->data['Order']['order_code'] = $infoEvalorder['Order']['order_code'];			
			$this->data['Order']['id'] = $infoEvalorder['Order']['id'];
			$this->data['Evaluation']['test_serie'] = $infoEvalorder['Evaluation']['test_serie'];			
		}
			$questionnaires = $this->QuestionnairesService->Questionnaire->infoquestservice($this->data['Service']['id']);			
		
			$this->set(compact('questionnaires'));
	}		
}
?>