<?php
class QuestionsController extends AppController {

	var $name = 'Questions';
	var $helpers = array('Html', 'Form', 'Time');

		
	function beforeFilter(){
	  parent::beforeFilter();
	}		
	
	
	function index() {
		$this->Question->recursive = 0;
		$this->set('questions', $this->paginate());
	}
	

	function view($id = null) {
		# Get all the questions from a specific Questionnaire
		$questions = $this->Question->Questionnaire->infoquestion($id);
		
		$this->set(compact('questions'));
	}
	

	function add() {
		if (!empty($this->data)) {
			$this->Question->create();
			if ($this->Question->save($this->data)) {
				$this->flashSuccess(__('The Question has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Question could not be created. Please correct the error(s) and try again', true));
			}
		}
	}		

	
	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Question->save($this->data)) {
				$this->flashSuccess(__('The Question has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Question could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$this->data = $this->Question->read(null, $id);
		}
	}	
		
}
?>