<?php
class RequestersController extends AppController {

	var $name = 'Requesters';
	var $helpers = array('Html', 'Form', 'Time', 'Text', 'FormatMask.Format', 'Js' => array('Jquery'));
	var $components = array('RequestHandler', 'FormatMask.Format');

	
	function beforeFilter(){
		$this->group_id = $this->Auth->user('group_id');
		$this->requester_id = $this->Auth->user('requester_id');
		$this->team_id = $this->Auth->user('team_id');
		parent::beforeFilter();
	}		
	
	function index() {
		$this->layout = 'main_index';
		$this->Requester->recursive = 0;		

		$activeLetter = isset($this->params['named']['letter']) ? $this->params['named']['letter'] : '';
		$letters = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 
			            'h', 'i', 'j', 'k', 'l', 'm', 'n', 
						'o', 'p', 'q', 'r', 's', 't', 'u', 
						'v', 'w', 'x', 'y', 'z');
		
		$urlArgs = array('url' => $this->params['named']);

		# Admin
		if ($this->group_id == 1) {		
			$condita = array('Requester.last_name LIKE' => $activeLetter.'%', 'Requester.hide' => 0);
		}				
		# Superv
		if ($this->group_id == 2) {		
			$condita = array(
							"Requester.last_name LIKE" => $activeLetter.'%',
							'Requester.hide' => 0,
							"OR" => array (
								"Requester.id_supervisor" => $this->requester_id,
								"Requester.id" => $this->requester_id
										)						
							);
		}
		$requesters = isset($activeLetter) ? $this->paginate('Requester', $condita) : $this->paginate();
		
		$this->set(compact('letters', 'requesters', 'activeLetter', 'urlArgs'));			
	}


	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('requester', $this->Requester->read(null, $id));
	}		

	
	function cancel() {
		$this->redirect('/requesters'); 
	}

	
	function add() {
		if (!empty($this->data)) {
			$this->Requester->create();
			if ($this->Requester->save($this->data)) {
				$this->flashSuccess(__('El solicitante ha sido creado.', true), 'index');
			} else {
				$this->flashWarning(__('El solicitante no ha sido creado. Corrija el error.', true));
			}
		}else{
			$this->data['Requester']['createdby'] = $this->Session->read('Auth.User.username');
		}
		$ctrlform = 1;
		# Admin
		if ($this->group_id == 1) {	
			$teams = $this->Requester->Team->find('list');
			$supervisors = array();			
		}				
		# Superv
		if ($this->group_id == 2) {	
			$teams = $this->Requester->Team->find('list', array('conditions' =>  array('Team.id' => $this->team_id)));
			$this->data['Requester']['team_id'] = $this->team_id;
			$supervisors = $this->Requester->infoSuperv($this->requester_id);					
			$this->data['Requester']['id_supervisor'] = $this->requester_id;
		}		
		$this->set(compact('supervisors', 'teams', 'ctrlform'));
	}		


	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Requester->save($this->data)) {
				$this->flashSuccess(__('El solicitante ha sido actualizado.', true), 'index');
			}else {
				$this->flashWarning(__('El solicitante no ha sido actualizado. Corrija el error.', true));
			}
		}else{			
			$this->data = $this->Requester->read(null, $id);
			$this->data['Requester']['modifiedby'] = $this->Session->read('Auth.User.username');
		}

		$ctrlform = 0;
		# Admin
		if ($this->group_id == 1) {
			$teams = $this->Requester->Team->find('list');
			$supervisors = $this->Requester->listSupervTeam($this->data['Team']['id']);
		}
		# Superv
		if ($this->group_id == 2) {	
			$teams = $this->Requester->Team->find('list', array('conditions' =>  array('Team.id' => $this->team_id)));
			$this->data['Requester']['team_id'] = $this->team_id;
			$supervisors = $this->Requester->infoSuperv($this->requester_id);					
			$this->data['Requester']['id_supervisor'] = $this->requester_id;
		}			
		$this->set(compact('supervisors','teams','ctrlform'));
	}
	

	function delete($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if ($this->Requester->del($id)) {
			$this->flashSuccess('Requester deleted', 'index');
		}
	}		
	
	#private methods
	public function get_requesters_ajax() {
		Configure::write('debug', 0);
		if($this->RequestHandler->isAjax()) {
			$this->set('requesters', $this->Requester->find('list',
							   array('conditions' =>
										   array('Requester.team_id' => $this->params['url']['idteam'],
										   'Requester.id_supervisor IS NULL', 'Requester.hide' => 0),
									'fields' => array('id', 'name'),
									'group' => array('Requester.name')
									 )));
	  }
	}
}
?>