<?php
class ServicesController extends AppController {

	var $name = 'Services';
	var $helpers = array('Html', 'Form', 'Time');

	
	function beforeFilter(){
	  if ($this->only(array('add', 'edit'))) { $this->__lists(); }
	  parent::beforeFilter();
	}	
	

	function index() {
		$this->Service->recursive = 0;
		$this->set('services', $this->paginate());
	}


	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('service', $this->Service->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/services'); 
	}	
	

	function add() {
		if (!empty($this->data)) {
			$this->Service->create();
			if ($this->Service->save($this->data)) {
				$this->flashSuccess(__('The Service has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Service could not be created. Please correct the error(s) and try again', true));
			}
		}
	}

	function form($id = null) {
		if (!empty($this->data)) {
			$this->Service->create();
			if ($this->Service->save($this->data)) {
				$this->flashSuccess(__('The Service has been saved', true), 'index');
			}else {
				$this->flashWarning(__('The Service could not be saved. Please correct the error(s) and try again', true));
			}
		}else {
			$this->data = $this->Service->read(null, $id);
		}
		$questionnaires = $this->Service->Questionnaire->find('list',array('fields'=>array('id','name')));
		$customers = $this->Service->Customer->find('list',array('fields'=>array('id','name')));
		$this->set(compact('questionnaires', 'customers'));
	}
	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		if (!empty($this->data)) {
			if ($this->Service->save($this->data)) {
				$this->flashSuccess(__('The Service has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Service could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$this->data = $this->Service->read(null, $id);
		}
		$questionnaires = $this->Service->Questionnaire->find('list',array('fields'=>array('id','name')));
		$this->set(compact('questionnaires'));		
	}	


	function delete($id = null) {
		$this->idEmptyRedirect($id, 'index');
		if ($this->Service->delete($id)) {
			$this->flashSuccess('Service deleted', 'index');
		}
	}	
		

	# Private methods
	function __lists(){
		$customers = $this->Service->Customer->find('list');
		$this->set(compact('customers'));
	}		
}
?>