<?php
class StatusesController extends AppController {

	var $name = 'Statuses';	
	var $helpers = array('Html', 'Form', 'Time');

		
	function beforeFilter(){
		parent::beforeFilter();
	}
		
	
	function index() {
		$this->Status->recursive = 0;
		$this->paginate = array(
			  'order' => array('type_s' => 'ASC', 'name_eng' => 'ASC'));
		$this->set('statuses', $this->paginate());
	}


	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('status', $this->Status->read(null, $id));
	}	

	function cancel() {
		$this->redirect('/statuses'); 
	}	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Status->save($this->data)) {
				$this->flashSuccess(__('The Status has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Status could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$this->data = $this->Status->read(null, $id);
		}
	}		


	function delete($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if ($this->Status->delete($id)) 
		{
       $this->flashSuccess(__('Status deleted', true), 'index');
		}
	}	
	
}
?>