<?php
class TeamsController extends AppController {

	var $name = 'Teams';
	var $helpers = array('Html', 'Form', 'Time');
	
	function beforeFilter(){
	  if ($this->only(array('add', 'edit'))) { $this->__lists(); }
	  parent::beforeFilter();
	}
	
	
	function index() {
		$this->Team->recursive = 0;
		$this->set('teams', $this->paginate());
	}

	
	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');
		$this->set('team', $this->Team->read(null, $id));
	}	
	
	
	function cancel() {
		$this->redirect('/teams'); 
	}
	
	
	function add() {
		if (!empty($this->data)) {
			$this->Team->create();
			if ($this->Team->save($this->data)) {
				$this->flashSuccess(__('The Team has been created', true), 'index');
			} else {
				$this->flashWarning(__('The Team could not be created. Please correct the error(s) and try again', true));
			}
		}
	}	
	

	function edit($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->Team->save($this->data)) {
				$this->flashSuccess(__('The Team has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The Team could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$this->data = $this->Team->read(null, $id);
		}
	}	


	function delete($id = null) {
		$this->idEmptyRedirect($id, 'index');
		
		if ($this->Team->delete($id)) {
			$this->flashSuccess(__('Team deleted', true), 'index');
		}
	}	
	
	# Private methods
	function __lists() {
		$customers = $this->Team->Customer->find('list');
		$this->set(compact('customers'));
	}		
}
?>