<?php
class UsersController extends AppController {

	var $name = 'Users';	
	var $helpers = array('Html', 'Form', 'Time', 'Js' => array('Jquery'));		
    var $components = array('RequestHandler');

	
	public function beforeFilter() {
		$this->customer_id = $this->Auth->user('customer_id');
		$this->group_id = $this->Auth->user('group_id');
		$this->team_id = $this->Auth->user('team_id');
		$this->requester_id = $this->Auth->user('requester_id');
		parent::beforeFilter();
		if($this->action == 'add') {
			$this->Auth->authenticate = $this->User;
		}
	}

	
	function login() {
        if ($user = $this->Auth->user()) {
            $this->User->Group->id = $this->Auth->user('group_id');			
		
            $this->Session->write('Auth.User.group_nameeng', $this->User->Group->field('name_eng'));
			$this->Session->write('Auth.User.group_namefre', $this->User->Group->field('name_fre'));
			
			$this->User->Requester->id = $this->Auth->user('requester_id');
			$reqList = $this->User->Requester->findById($this->Auth->user('requester_id')); 
			
			$this->Session->write('Auth.User.team_id', $this->User->Requester->field('team_id'));
			
			$this->User->Requester->Team->id = $this->Auth->user('team_id');
			$this->Session->write('Auth.User.customer_id', $this->User->Requester->Team->field('customer_id'));
			
            $this->redirect($this->Auth->redirect());
        } 	
	}

	function logout() {
		$this->redirect($this->Auth->logout());
	}

	
	function index() {
		$this->layout = 'main_index';
		$activeLetter = isset($this->params['named']['letter']) ? $this->params['named']['letter'] : '';
		$letters = array('a', 'b', 'c', 'd', 'e', 'f', 'g', 
			            'h', 'i', 'j', 'k', 'l', 'm', 'n', 
						'o', 'p', 'q', 'r', 's', 't', 'u', 
						'v', 'w', 'x', 'y', 'z');
		
		$urlArgs = array('url' => $this->params['named']);		

		$conditions['Requester.last_name LIKE'] = $activeLetter.'%';
		$condwww = $activeLetter.'%';

		# Admin
		if ($this->group_id == 1) {		
			$condita = array(
							"Requester.last_name LIKE" => $condwww,
							"Group.hide" => 0,
							"User.hide" => 0
							);

		}				
		# Superv
		if ($this->group_id == 2) {		
			$condita = array(
							"Requester.last_name LIKE" => $condwww,
							"Group.hide" => 0,
							"User.hide" => 0,							
							"OR" => array (
								"Requester.id_supervisor" => $this->requester_id,
								"Requester.id" => $this->requester_id
										)						
							);

		}
		$this->paginate = array('fields' => array('id','username','group_id','requester_id'),	
						'conditions' => $condita,						
						'link' => array(
							'Requester' => array(
											'Team' => array(
													'Customer' => array('fields' => array('Customer.id', 'Customer.name')),
													'fields' => array('Team.id', 'Team.name'))),
							'Group'	=> array('fields' => array('Group.id', 'Group.name_eng', 'Group.name_fre'))
									),
							'order' => 'User.id DESC'
						);
						
		$users = $this->paginate('User');		
		$this->set(compact('letters', 'users', 'activeLetter', 'urlArgs'));	
		
	}
	

	function view($id = null) {
		$this->idEmptyRedirect($id, 'index');

		# Get the Employee-Customer information
		$infoUser = $this->User->infoUser($id);

        $nameSuperv = !$this->User->Requester->nameSuperv($infoUser[0]['Requester']['id_supervisor']) ?
            null :
            $this->User->Requester->nameSuperv($infoUser[0]['Requester']['id_supervisor']);

		$this->set(compact('infoUser', 'nameSuperv'));	
		
	}
	
	
	function cancel() {
		$this->redirect('/users'); 
	}	

	
	function add() {
		if (!empty($this->data)) {
			$this->User->create();
			if ($this->User->save($this->data)) {
				$this->flashSuccess(__('The User has been created', true), 'index');
			} else {	
				# Admin
				if ($this->group_id == 1) {		
					$teams = $this->User->Requester->Team->find('list', array('conditions' => array('Team.id' => $this->data['User']['team_id'])));

					if ($this->data['User']['team_id'] == 7)  {
						$this->set('groups', $this->User->Group->find('list', array(
																			'conditions' => array('Group.hide' => 0),
																			'fields' => array('id', 'name_'.Configure::read('Config.language')))
									));
					} else {
						$this->set('groups', $this->User->Group->find('list', array(
																			'conditions' => 'Group.id IN (2,3)',
																			'fields' => array('id', 'name_'.Configure::read('Config.language')))
									));
					}
					
					if ($this->data['User']['group_id'] == 1 || $this->data['User']['group_id'] == 2){
						$this->set('requesters', $this->User->Requester->listSupervTeam($this->data['User']['team_id']));
					} elseif ($this->data['User']['group_id'] == 3) {
						$this->set('requesters', $this->User->Requester->listCaseMngSupervTeam($this->data['User']['team_id']));
					}			
				}
				
				# Superv
				if ($this->group_id == 2) {	
					$teams = $this->User->Requester->Team->find('list', array('conditions' => array('Team.id' => $this->data['User']['team_id'])));
					$this->data['User']['team_id'] = $this->team_id;
					$groups = $this->User->Group->find('list', array('conditions' =>  'Group.id = 3',
																	'fields' => array('id', 'name_'.Configure::read('Config.language'))
																	));	

					if ($this->data['User']['group_id'] == 3) {
						$this->set('requesters', $this->User->Requester->listRequestSuperv($this->requester_id));
					}					
				}
				$this->flashWarning(__('The User could not be created. Please correct the error(s) and try again', true));				
			}
		}else{
			$this->data['User']['createdby'] = $this->Session->read('Auth.User.username');
			# Admin
			if ($this->group_id == 1) {		
				$teams = $this->User->Requester->Team->find('list');			
				$groups = array();
			}
			# Superv
			if ($this->group_id == 2) {	
				$teams = $this->User->Requester->Team->find('list', array('conditions' => array('Team.id' => $this->team_id)));
				$this->data['User']['team_id'] = $this->team_id;
				$groups = $this->User->Group->find('list', array('conditions' =>  'Group.id = 3',
																'fields' => array('id', 'name_'.Configure::read('Config.language')))
													);			
			}
			$requesters = array();			
		}
		
		$this->set(compact('teams','requesters','groups'));		
	}		

	function edit($id = null) {
	
		$this->idEmptyRedirect($id, 'index');
		
		if (!empty($this->data)) {
			if ($this->User->save($this->data)) {
				$this->flashSuccess(__('The User has been updated', true), 'index');
			} else {
				$this->flashWarning(__('The User could not be updated. Please correct the error(s) and try again', true));
			}
		} else {
			$users = $this->User->read(null, $id);
			$this->data['User']['id'] = $users['User']['id'];
			$this->data['User']['requester_id'] = $users['User']['requester_id'];
			$this->data['User']['username'] = $users['User']['username'];
			$this->data['User']['active'] = $users['User']['active'];
			$this->data['User']['group_id'] = $users['User']['group_id'];
			$this->data['User']['modifiedby'] = $this->Session->read('Auth.User.username');
		}
		# Admin
		if ($this->group_id == 1) {
			if ($users['Requester']['team_id'] == 7) {
				$groups = $this->User->Group->find('list', array('conditions' => array('Group.hide' => 0),
																'fields' => array('id', 'name_'.Configure::read('Config.language')))
												);
			} else {
				$groups = $this->User->Group->find('list', array('conditions' => array('Group.id' => array(2,3)),
																'fields' => array('id', 'name_'.Configure::read('Config.language')))
												);
			}
			
			$requesters = $this->User->Requester->find('list', array('fields' => array('id', 'name'),'order' => 'name ASC'));				
		} elseif ($this->group_id == 2) {
		# Superv
			//Modifying the Req. Superv logged in
			if ($this->requester_id == $this->data['User']['requester_id']) {
				$groups = $this->User->Group->find('list', array('conditions' => array('Group.id' => array(2,3)),
																'fields' => array('id', 'name_'.Configure::read('Config.language')))
													);
			} else {
				$groups = $this->User->Group->find('list', array('conditions' =>  'Group.id = 3',
																'fields' => array('id', 'name_'.Configure::read('Config.language')))
												);
			}
			$requesters = $this->User->Requester->listRequestSuperv($this->requester_id);			
		}
		$this->set(compact('requesters','groups','users'));			
	}	
	
	function export_usersxls() {	
		$data = $this->User->listUsers();
		$this->set('rows', $data);
		$this->render('export_usersxls', 'export_usersxls');

	}	
	
	
	#private methods
											
	public function get_groups_ajax() {
	Configure::write('debug', 0);
	if($this->RequestHandler->isAjax()) {
		if ($this->params['url']['idteam'] == 7)  {
			$this->set('groups', $this->User->Group->find('list', array('conditions' => array('Group.hide' => 0),
																	'fields' => array('id', 'name_'.Configure::read('Config.language')))
													));
		} else {
			$this->set('groups', $this->User->Group->find('list', array('conditions' =>  'Group.id IN (2,3)',
																	'fields' => array('id', 'name_'.Configure::read('Config.language')))
													));
		}		
	  }
	}
	
	public function get_requesters_ajax() {
	Configure::write('debug', 0);	  
	if($this->RequestHandler->isAjax()) {
		if ($this->group_id == 1) {
			if ($this->params['url']['idgroup'] == 1 || $this->params['url']['idgroup'] == 2){
				$this->set('requesters', $this->User->Requester->listSupervTeam($this->params['url']['idteam']));
			} elseif ($this->params['url']['idgroup'] == 3) {
				$this->set('requesters', $this->User->Requester->listCaseMngSupervTeam($this->params['url']['idteam']));
			}		
		}
		elseif ($this->group_id == 2) {
			if ($this->params['url']['idgroup'] == 3) {
				$this->set('requesters', $this->User->Requester->listRequestSuperv($this->requester_id));
			}		
		}

	  }
	}	
}
?>