<?php
class Choice extends AppModel {
	var $name = 'Choice';
	

	var $belongsTo = array(
		'Question' => array(
			'className' => 'Question',
			'foreignKey' => 'question_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	var $hasMany = array(
		'ChoiceSecondary' => array(
			'className' => 'ChoiceSecondary',
			'foreignKey' => 'choice_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);	
	
	### Returns the Questions-Choices information - in an specific Language
	# 	$question_id = The question_id for an specific Questionnaire
	# 	$language = 1(English) or 0 (French)
	function questionchoices($question_id, $language)	
	{
		if ($language == 1){
		# Ingles
			$field_language = 'name_eng';
		}else{
		# French
			$field_language = 'name_fre';
		}
		
		return $this->find('list', array('fields' => array('nochoice',$field_language,'id'),
				'conditions' =>  array('question_id' => $question_id),
				'order' => array('nochoice ASC')
			));						
			
	}	

}
?>