<?php
class City extends AppModel {
	var $name = 'City';
	var $displayField = 'name';
	
	var $validate = array(
		'province_id' => array(
			'required' => 'notEmpty'	            
			),
		'name' => array(
			'required' => 'notEmpty'	            
			)
		);	
		
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	var $belongsTo = array(
		'Province' => array(
			'className' => 'Province',
			'foreignKey' => 'province_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	var $hasMany = array(
		'Customer' => array(
			'className' => 'Customer',
			'foreignKey' => 'city_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Employee' => array(
			'className' => 'Employee',
			'foreignKey' => 'city_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

    function searchListCityName($name, $province) 
	{
//		return $this->find('all', array('conditions'=>array('City.name LIKE'=>'%'.$name.'%'), 
//				'fields' => array('id', 'name'),'order' => 'name ASC'));
		return $this->find('all', array('conditions'=>array('City.name LIKE'=>'%'.$name.'%', 'City.province_id LIKE' => $province),
				'fields' => array('id', 'name'),'order' => 'name ASC'));				
	}	
	
}
?>