<?php
class Doctor extends AppModel {
	var $name = 'Doctor';
	
  var $validate = array(
	       'full_name' => array(
				'required' => 'notEmpty'
	       ),
//	       'email' => array(
//				'required' => 'email'
//	       ),		   
			'gender' => array(
				'required' => 'notEmpty'
			),
			'langue' => array(
				'required' => 'notEmpty'					
			),
	       'address' => array(
				'existingAddressEmail' => array(
					'rule' => array('existingAddressEmail', 'email', 'fax'),
					'last' => true
	            )
		   ),
	       'province_id' => array(
				'validateAddressFields' => array(
					'rule' => array('validateAddressFields', 'city_id', 'code_postal', 'address')
	            )
	       ),		   		   
	       'city_id' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => true,
	             'message' => 'must have City'
	            )
	       ),		   
	       'code_postal' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => true,
	             'message' => 'must have zip / postal code'
	            )
	       )								

	);	
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	var $belongsTo = array(
		'City' => array(
			'className' => 'City',
			'foreignKey' => 'city_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Province' => array(
			'className' => 'Province',
			'foreignKey' => 'province_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	
    function existingAddressEmail( $field=array(), $compare_field0=null, $compare_field1=null) 
    {
        foreach( $field as $key => $value ){
            $v1 = $value;
            //$v2 = $this->data[$this->name][$compare_field0]; 

            if(empty($v1) && empty($this->data[$this->name][$compare_field0]) && empty($this->data[$this->name][$compare_field1])) {
                return FALSE;
            } else {
             continue;
            }
        }
        return TRUE;
    } 


    function validateAddressFields( $field=array(), $compare_field1=null, $compare_field2=null, $compare_field3=null ) 
    {
        foreach( $field as $key => $value )
		{
            $v1 = $value;
            $v2 = $this->data[$this->name][ $compare_field1 ]; 
			$v3 = $this->data[$this->name][ $compare_field2 ];
			$v4 = $this->data[$this->name][ $compare_field3 ];

			if (!empty($v4))
			{
				if(empty($v1) && empty($v2) && empty($v3)) 
				{
					return FALSE;
				} 
				else 
				{
					continue;
				}
			}
        }
        return TRUE;
    } 		
	
    function searchListDoctorName($name) 
	{
		return $this->find('all', array('conditions'=>array('CONCAT(Doctor.last_name, " ,", Doctor.first_name) 
				LIKE'=>'%'.$name.'%'),
				'fields' => array('id', 'name'),'order' => 'name ASC'));
	}	

	# Doctor info list by Doctor_id +++++ a reviser
    function listdocInfo($doc_id) 
	{
		return $this->find('list', 
							array('conditions' => array('Doctor.id' => $doc_id),
									'fields' => array('address','email')								   
									));
									
	}
	
	###################################################################################
	# Returns the Doctor-Evaluation-one information by eval_id provided        #
	# Called from View Claim Letter - from Evaluation controller                      #
	###################################################################################
	function infoDoctorEval($doctor_id, $eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Evaluation' => array(
						'Order' => array(
							'Customer'															
							),
						'conditions' =>  array('Evaluation.id' => $eval_id)
					),
					'City'  => array(
							'conditions' => 'Doctor.city_id  = City.id'),
					'Province' => array(
							'conditions' => 'Doctor.province_id  = Province.id')
				),
				'fields' => array('Evaluation.id',
							'Customer.id','Customer.abbrv','Customer.name',
							'Province.name','City.name', 
							'Doctor.id','Doctor.full_name','Doctor.address','Doctor.code_postal',
							'Doctor.langue', 'Doctor.gender'
							),			
				'conditions' =>  array('Doctor.id' => $doctor_id)
			));						
			
	}
	
}
?>