<?php
class DspScore extends AppModel {

	var $name = 'DspScore';
//	var $displayField = 'name';

	var $belongsTo = array(
		'Evaluation' => array(
			'className' => 'Evaluation',
			'foreignKey' => 'evaluation_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Questionnaire' => array(
			'className' => 'Questionnaire',
			'foreignKey' => 'questionnaire_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)	
	);

	###########################################################################
	# Validate if there is already a DSP Score
	###########################################################################
	function countDsp($eval_id)
	{
		return $this->find('count', array('conditions' => array('DspScore.evaluation_id' => $eval_id)));
	}	
	
	###################################################################################
	# Get a complete information about a DSP Score: Customer/Employee/Evaluation/DSP
	###################################################################################
	function infoDsp($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Evaluation' => array(
						'Order' => array(
							'Customer',
							'Employee'
							),
						'Requester' => array(
											'Team'  => array('conditions' => 'Requester.team_id  = Team.id'),
											'conditions' => 'Evaluation.requester_id  = Requester.id'
											),
						'Status' => array('conditions' => 'Evaluation.status_id  = Status.id'),
						'Service' => array('conditions' => 'Evaluation.service_id  = Service.id')
							)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie', 'Evaluation.created', 'Evaluation.order_id',
							'Evaluation.service_id', 'Evaluation.requester_id', 'Evaluation.status_id', 'Evaluation.communication_id', 							
							'Requester.first_name', 'Requester.last_name',
							'Order.id','Order.order_code',
							'Customer.id','Customer.name',
							'Team.id','Team.name',
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email',
							'Service.id','Service.name',
							'Status.id','Status.name_eng','Status.name_fre',
							'DspScore.GRD','DspScore.type_q','DspScore.created'),
				'conditions' =>  array('DspScore.evaluation_id' => $eval_id)				
			));	
	}	

	###################################################################################
	# Get the DSP values scales from an specific Current Evaluation-Test
	###################################################################################
	function infoCurrentDsp($eval_id)
	{
		return $this->find('first', array('conditions' => array('DspScore.evaluation_id' => $eval_id),
										'fields' => array('DspScore.id', 'DspScore.type_q', 'DspScore.SOM', 'DspScore.DEP', 'DspScore.ALC', 
														'DspScore.ANX', 'DspScore.OBS', 'DspScore.PAN', 'DspScore.AGO', 'DspScore.TRA', 
														'DspScore.MIN', 'DspScore.RB', 'DspScore.GRD', 'DspScore.Q44', 'DspScore.answers', 'DspScore.questionnaire_id'
														//'DspScore.created'
														)
										)
							);
	}
	
	###################################################################################
	# Get the DSP values scales history from an specific Order and Evaluation id
	###################################################################################
	function infoHistoryDsp($eval_id, $order_id, $test_serie)
	{
		return $this->find('all', array(		
								'link' => array(
									'Evaluation'
								),
								'conditions' => array('Evaluation.order_id' => $order_id, 'Evaluation.test_serie BETWEEN ? AND ?' => array(1,$test_serie)),
								'fields' => array('DspScore.id', 'DspScore.type_q', 'DspScore.SOM', 'DspScore.DEP', 'DspScore.ALC', 
														'DspScore.ANX', 'DspScore.OBS', 'DspScore.PAN', 'DspScore.AGO', 'DspScore.TRA', 
														'DspScore.MIN', 'DspScore.RB', 'DspScore.GRD', 'DspScore.Q44', 'DspScore.answers', 'DspScore.questionnaire_id'
														//'DspScore.created'
														)
								)
							);
							
    //array('Post.id BETWEEN ? AND ?' => array(1,10))
							
	}	
	
	###################################################################################
	# Get the DSP values GI scale from an specific last Evaluation-Test (Previous)
	###################################################################################
	function infoLastDsp($eval_id, $test_serial)
	{
		$last_eval = $this->Evaluation->getLastEvalOrd($eval_id, $test_serial);
		return $this->find('first', array('conditions' => array('DspScore.evaluation_id' => $last_eval['Evaluation']['id']),
										'fields' => array('DspScore.id', 'DspScore.type_q', 'DspScore.SOM', 'DspScore.DEP', 'DspScore.ALC', 
														'DspScore.ANX', 'DspScore.OBS', 'DspScore.PAN', 'DspScore.AGO', 'DspScore.TRA', 
														'DspScore.MIN', 'DspScore.RB', 'DspScore.GRD', 'DspScore.Q44', 'DspScore.answers', 
														'DspScore.questionnaire_id', 'DspScore.created')
										)
							);
							
	}		
	
	###################################################################################
	# Get the DSP values GI scale from an specific last Evaluation-Test (BEFORE Previous)
	###################################################################################
	function infoBeforeLastDsp($eval_id, $test_serial) {
		$last_eval = $this->Evaluation->getBeforeLastEvalOrd($eval_id, $test_serial);
		return $this->find('first', array('conditions' => array('DspScore.evaluation_id' => $last_eval['Evaluation']['id']),
										'fields' => array('DspScore.id', 'DspScore.type_q', 'DspScore.SOM', 'DspScore.DEP', 'DspScore.ALC', 
														'DspScore.ANX', 'DspScore.OBS', 'DspScore.PAN', 'DspScore.AGO', 'DspScore.TRA', 
														'DspScore.MIN', 'DspScore.RB', 'DspScore.GRD', 'DspScore.Q44', 'DspScore.answers', 
														'DspScore.questionnaire_id', 'DspScore.created')
										)
							);
							
	}		

	###################################################################################
	# Get the DSP Critical Items specific Evaluation-Test
	###################################################################################
	function criticalDspList($eval_id, $questionnaire_id, $language) {	
		$listDspCriticalQ = $this->Questionnaire->Question->infoCriticalquestion($questionnaire_id);		
		$infoListScaleDsp = $this->infoCurrentDsp($eval_id);		
		$questionsCount = count($listDspCriticalQ);
		
		$array_criticals = array();

		if ($language == 1) {
		# Ingles
			$field_language = 'desc_eng';
			$field_language_abbrv = 'abbrv_eng';
		} else {
		# French
			$field_language = 'desc_fre';
			$field_language_abbrv = 'abbrv_fre';
		}		
	
		for ($i=0; $i < $questionsCount; $i++) {
			$rest = substr($infoListScaleDsp['DspScore']['answers'], $i, 1);
			if ($rest >= $listDspCriticalQ[$i]['Question']['critical'] && $rest != 9) {
				if($listDspCriticalQ[$i]['Question']['noquestion'] < 10){
					$array_criticals = array_merge($array_criticals, array('Q.'.$listDspCriticalQ[$i]['Question']['noquestion'].' .- '.$listDspCriticalQ[$i]['Question'][$field_language].' '.$listDspCriticalQ[$i]['Question'][$field_language_abbrv]));
				} else {
					$array_criticals = array_merge($array_criticals, array('Q.'.$listDspCriticalQ[$i]['Question']['noquestion'].'.-'.$listDspCriticalQ[$i]['Question'][$field_language].' '.$listDspCriticalQ[$i]['Question'][$field_language_abbrv]));
				}
			}		
		}		
		return $array_criticals;
	}
	
	function infodataset($hystDsp) {
		$dataSet_new = array();
		
		$itemsCount = count($hystDsp[0]['Evaluation']);		
		for ($i=0; $i < $itemsCount; $i++) {
			if ($hystDsp[0]['Evaluation'][$i]['DspScore'][0]['type_q'] == 'DSP - 45') {
				$nbre_scales = 5;
				$dataSet_new = array_merge($dataSet_new, array($hystDsp[0]['Evaluation'][$i]['DspScore'][0]['SOM'],
										$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['DEP'],$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['ALC'],
										$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['ANX'],$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['RB']));
								
			} elseif ($hystDsp[0]['Evaluation'][$i]['DspScore'][0]['type_q'] == 'DSP - 77') {
				$nbre_scales = 10;
				$dataSet_new = array_merge($dataSet_new, array($hystDsp[0]['Evaluation'][$i]['DspScore'][0]['SOM'],
									$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['DEP'],$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['ALC'],
									$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['ANX'],$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['OBS'],
									$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['PAN'],$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['AGO'],
									$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['TRA'], $hystDsp[0]['Evaluation'][$i]['DspScore'][0]['MIN'],
									$hystDsp[0]['Evaluation'][$i]['DspScore'][0]['RB']));
			}		
		}
			$dataSet_new = array_chunk($dataSet_new, $nbre_scales);			
		return $dataSet_new;		
	}	

	
	###################################################################################	
	# Get an array Interpretation of the DSP Score
	###################################################################################
	function interpDspScore ($eval_id, $language) {
		$texteDspInterp = array();
		$texteDspInterpSOM = array();
		$texteDspInterpDEP = array();
		$texteDspInterpALC = array();
		$texteDspInterpANX = array();
		$texteDspInterpOBS = array();  
		$texteDspInterpPAN = array();
		$texteDspInterpAGO = array();		// one range to cover [0 - 60]
		$texteDspInterpTRA = array();
		$texteDspInterpMINRB = array();
		$texteDspInterpMIN = array();
		$texteDspInterpRB = array();		// one range to cover [0 - 70]
		$texteDspInterpGRD1 = array();
		$texteDspInterpGRDRB = array();
		$texteDspInterpQ44 = array();
		
		$countMIN = 0;
		$depval = 0;
		$anxval = 0;
		$alcval = 0;
		$somval = 0;
		$OBSval = 0;
		$panval = 0;
		$agoval = 0;
		$traval = 0;
		$minrbval = 0;

		if ($language == 1){
		# Ingles
			$field_language = 'int_eng';
		}else{
		# French
			$field_language = 'int_fre';
		}		
		
		App::import('Model','DspInterp');
		$this->DspInterp = new DspInterp(); 
		$listDspInterp = $this->DspInterp->find('all', 
								array(
									'fields' => array('id', 'scale', 'low', 'high', 'high2', 'low2', $field_language),
									'order' => 'id ASC'
								)
							);
		
		$infoListScaleDsp = $this->infoCurrentDsp($eval_id);
		
		//BEGIN Loop each 
		foreach ($listDspInterp as $interpDsp): 

			if ($interpDsp['DspInterp']['scale'] == 'SOM'){
				if ($infoListScaleDsp['DspScore']['SOM'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['SOM'] < $interpDsp['DspInterp']['high'])
				{				
					$texteDspInterpSOM = array('id' => 1, 'scalex' => 'SOM', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$somval = 1;
				}else{
					if ($somval == 0) { $texteDspInterpSOM = array('id' => 1, 'scalex' => 'SOM', 'texte' => ''); }
				}				
			}
			if ($interpDsp['DspInterp']['scale'] == 'DEP'){
			##  /94 0 60 next /94 59 65 next /94 64 70 next /94 69 85 next /94 84 105 next /94 104 301 next
				if ($infoListScaleDsp['DspScore']['DEP'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['DEP'] < $interpDsp['DspInterp']['high'])
				{	
					//echo $interpDsp['DspInterp'][$field_language];
					$texteDspInterpDEP = array('id' => 2, 'scalex' => 'DEP', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$depval = 1;
				}else{
					if ($depval == 0) { $texteDspInterpDEP = array('id' => 2, 'scalex' => 'DEP', 'texte' => ''); }
				}				
			}		
			if ($interpDsp['DspInterp']['scale'] == 'ALC'){
				if ($infoListScaleDsp['DspScore']['ALC'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['ALC'] < $interpDsp['DspInterp']['high'])
				{				
					$texteDspInterpALC = array('id' => 3, 'scalex' => 'ALC', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$alcval = 1;
				}else{
					if ($alcval == 0) { $texteDspInterpALC = array('id' => 3, 'scalex' => 'ALC', 'texte' => ''); }
				}				
			}
			if ($interpDsp['DspInterp']['scale'] == 'ANX')
			{
				if ($infoListScaleDsp['DspScore']['ANX'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['ANX'] < $interpDsp['DspInterp']['high'])
				{				
					$texteDspInterpANX = array('id' => 4, 'scalex' => 'ANX', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$anxval = 1;
				}
				else
				{
					if ($anxval == 0) { $texteDspInterpANX = array('id' => 4, 'scalex' => 'ANX', 'texte' => ''); }
				}				
			}
			if ($interpDsp['DspInterp']['scale'] == 'OBS')
			{
				if ($infoListScaleDsp['DspScore']['OBS'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['OBS'] < $interpDsp['DspInterp']['high'])
				{				
					$texteDspInterpOBS = array('id' => 5, 'scalex' => 'OBS', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$OBSval = 1;
				}else{
					if ($OBSval == 0) { $texteDspInterpOBS = array('id' => 5, 'scalex' => 'OBS', 'texte' => ''); }
				}				
			}
			if ($interpDsp['DspInterp']['scale'] == 'PAN')
			{
				if ($infoListScaleDsp['DspScore']['PAN'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['PAN'] < $interpDsp['DspInterp']['high'])
				{				
					$texteDspInterpPAN = array('id' => 6, 'scalex' => 'PAN', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$panval = 1;
				}else{
					if ($panval == 0) { $texteDspInterpPAN = array('id' => 6, 'scalex' => 'PAN', 'texte' => ''); }
				}				
			}		
			if ($interpDsp['DspInterp']['scale'] == 'AGO'){
				if ($infoListScaleDsp['DspScore']['AGO'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['AGO'] < $interpDsp['DspInterp']['high']){				
					$texteDspInterpAGO = array('id' => 7, 'scalex' => 'AGO', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$agoval = 1;
				}else{
					if ($agoval == 0) { $texteDspInterpAGO = array('id' => 7, 'scalex' => 'AGO', 'texte' => ''); }
				}
			}
			if ($interpDsp['DspInterp']['scale'] == 'TRA'){
				if ($infoListScaleDsp['DspScore']['TRA'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['TRA'] < $interpDsp['DspInterp']['high'])
				{				
					$texteDspInterpTRA = array('id' => 8, 'scalex' => 'TRA', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$traval = 1;
				}else{
					if ($traval == 0) { $texteDspInterpTRA = array('id' => 8, 'scalex' => 'TRA', 'texte' => ''); }
				}				
			}	
			if ($interpDsp['DspInterp']['scale'] == 'MINRB' && $infoListScaleDsp['DspScore']['type_q'] == 'DSP - 77'){
				if (($infoListScaleDsp['DspScore']['MIN'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['MIN'] < $interpDsp['DspInterp']['high']) && 
					($infoListScaleDsp['DspScore']['RB'] > $interpDsp['DspInterp']['low2'] && $infoListScaleDsp['DspScore']['RB'] < $interpDsp['DspInterp']['high2']))
				{				
					$texteDspInterpMINRB = array('id' => 9, 'scalex' => 'MINRB', 'texte' => $interpDsp['DspInterp'][$field_language]);
					$minrbval = 1;
				}else{
					if ($minrbval == 0) { $texteDspInterpMINRB = array('id' => 9, 'scalex' => 'MINRB', 'texte' => ''); }
				}				
			}
			if ($interpDsp['DspInterp']['scale'] == 'MIN')
			{
				if ($infoListScaleDsp['DspScore']['MIN'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['MIN'] < $interpDsp['DspInterp']['high'])
				{									
					$texteDspInterpMIN = array('id' => 10, 'scalex' => 'MIN', 'texte' => $interpDsp['DspInterp'][$field_language]);
				}
				else
				{
					$texteDspInterpMIN = array('id' => 10, 'scalex' => 'MIN', 'texte' => '');
				}				
			}			
			if ($interpDsp['DspInterp']['scale'] == 'RB'){
				if ($infoListScaleDsp['DspScore']['RB'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['RB'] < $interpDsp['DspInterp']['high']){									
					$texteDspInterpRB = array('id' => 11, 'scalex' => 'RB', 'texte' => $interpDsp['DspInterp'][$field_language]);
				}else{
					$texteDspInterpRB = array('id' => 11, 'scalex' => 'RB', 'texte' => '');
				}				
			}		
			if ($interpDsp['DspInterp']['scale'] == 'Q44') {
				if ($infoListScaleDsp['DspScore']['Q44'] > $interpDsp['DspInterp']['low'] && $infoListScaleDsp['DspScore']['Q44'] < $interpDsp['DspInterp']['high']){				
					$texteDspInterpQ44 = array('id' => 13, 'scalex' => 'Q44', 'texte' => $interpDsp['DspInterp'][$field_language]);
				}else{
					$texteDspInterpQ44 = array('id' => 13, 'scalex' => 'Q44', 'texte' => '');
				}				
			}		
			//END Loop each 
		endforeach;	
		
		//Evaluate multiple GRD	
		if ($infoListScaleDsp['DspScore']['GRD'] == 0) {					
			$texteDspInterpGRD1 = array('id' =>$listDspInterp[30]['DspInterp']['id'], 'scalex' => 'GRD', 'texte' => $listDspInterp[30]['DspInterp'][$field_language]);
			if ($infoListScaleDsp['DspScore']['RB'] > $listDspInterp[34]['DspInterp']['low2'] )
			{
				$texteDspInterpGRDRB = array('id' =>$listDspInterp[34]['DspInterp']['id'], 'scalex' => 'GRDRB', 'texte' => $listDspInterp[34]['DspInterp'][$field_language]);
			}else{
				$texteDspInterpGRDRB = array('id' => 0, 'scalex' => 'GRDRB', 'texte' => '');
			}
		} elseif ($infoListScaleDsp['DspScore']['GRD'] == 1) {					
			$texteDspInterpGRD1 = array('id' =>$listDspInterp[31]['DspInterp']['id'], 'scalex' => 'GRD', 'texte' => $listDspInterp[31]['DspInterp'][$field_language]);
			if ($infoListScaleDsp['DspScore']['RB'] > $listDspInterp[34]['DspInterp']['low2'] )
			{
				$texteDspInterpGRDRB = array('id' =>$listDspInterp[34]['DspInterp']['id'], 'scalex' => 'GRDRB', 'texte' => $listDspInterp[34]['DspInterp'][$field_language]);
			}
			else
			{
				$texteDspInterpGRDRB = array('id' => 0, 'scalex' => 'GRDRB', 'texte' => '');
			}			
		} elseif($infoListScaleDsp['DspScore']['GRD'] == 2) {					
			$texteDspInterpGRD1 = array('id' =>$listDspInterp[32]['DspInterp']['id'], 'scalex' => 'GRD', 'texte' => $listDspInterp[32]['DspInterp'][$field_language]);			
			if ($infoListScaleDsp['DspScore']['RB'] > $listDspInterp[34]['DspInterp']['low2'] )
			{
				$texteDspInterpGRDRB = array('id' =>$listDspInterp[34]['DspInterp']['id'], 'scalex' => 'GRDRB', 'texte' => $listDspInterp[34]['DspInterp'][$field_language]);
			}
			else
			{
				$texteDspInterpGRDRB = array('id' => 0, 'scalex' => 'GRDRB', 'texte' => '');
			}			
		} elseif($infoListScaleDsp['DspScore']['GRD'] > 2) {					
			$texteDspInterpGRD1 = array('id' =>$listDspInterp[33]['DspInterp']['id'], 'scalex' => 'GRD', 'texte' => $listDspInterp[33]['DspInterp'][$field_language]);
			$texteDspInterpGRDRB = array('id' => 0, 'scalex' => 'GRDRB', 'texte' => '');
		}
			
		if ($infoListScaleDsp['DspScore']['type_q'] == 'DSP - 77')
		{
			$result = array($texteDspInterpGRD1, $texteDspInterpGRDRB, $texteDspInterpSOM, $texteDspInterpALC, $texteDspInterpANX, $texteDspInterpOBS,
							$texteDspInterpPAN, $texteDspInterpAGO, $texteDspInterpTRA, $texteDspInterpMINRB, $texteDspInterpMIN, 
							$texteDspInterpRB, $texteDspInterpDEP, $texteDspInterpQ44);
		}
		
		if ($infoListScaleDsp['DspScore']['type_q'] == 'DSP - 45')
		{
			$result = array($texteDspInterpGRD1, $texteDspInterpGRDRB, $texteDspInterpSOM, $texteDspInterpALC, $texteDspInterpANX, $texteDspInterpRB,
							$texteDspInterpDEP, $texteDspInterpQ44);
			
		}
		
		return $result;
	}
	
	function beforeSave($opt=[]) {	
//		if(empty($this->id)) {
		### When an Insert Table is made
			$choicesarray = array(); 
			$choicesstring = '';
			$questionsCount = 0;
			 
			$calculsom = 0;
			$calculdep = 0;
			$calculalc = 0;	 
			$calculanx = 0;
			$calculOBS = 0;	 
			$calculpan = 0;
			$calculago = 0;	 
			$calcultra = 0;
			$calculmin = 0;
			$calculrb = 0;
			$calculgi = 0;
		 

	
			if ($this->data['DspScore']['type_q'] == 'DSP - 45') { 
				$questionsCount = 45;
			} else { 
				$questionsCount = 77;
			}
				
			for ($i=0; $i < $questionsCount; $i++){			
				if ($this->data['DspScore'][$i]['reponse'] == '') {
					$this->data['DspScore'][$i]['reponse'] = 9;
				}

				$choicesstring = $choicesstring.$this->data['DspScore'][$i]['reponse'];
			
				if ($this->data['DspScore'][$i]['reponse'] != 9) {
					###### DSP Calcul #####			
					if ($questionsCount == 45) {	 
						###Somatic
						# 45 DSP
						if ($i == 0 || $i == 1 || $i == 2 || $i == 9 || $i == 13 || $i == 25 || $i == 33 || $i == 40) {
							$calculsom = $calculsom + $this->data['DspScore'][$i]['reponse'];
						}
						
						###Depression
						# 45 DSP
						if ($i == 6 || $i == 16 || $i == 19 || $i == 23 || $i == 24 || $i == 26 || $i == 31 || $i == 32 || $i == 36 || $i == 38) {
							$calculdep = $calculdep + $this->data['DspScore'][$i]['reponse'];
						}

						###Alcohol and Drugs
						# 45 DSP
						if ($i == 8 || $i == 11 || $i == 14 || $i == 22 || $i == 29 || $i == 34 || $i == 41 || $i == 42) {
							$calculalc = $calculalc + $this->data['DspScore'][$i]['reponse'];
						}
						
						###Anxiety
						# 45 DSP
						if ($i == 4 || $i == 5 || $i == 7 || $i == 10 || $i == 21 || $i == 30 || $i == 35 || $i == 38 || $i == 39 || $i == 44) {
							$calculanx = $calculanx + $this->data['DspScore'][$i]['reponse'];
						}	
						
						###Mag - Rb
						# 45 DSP
						if ($i == 3 || $i == 12 || $i == 15 || $i == 17 || $i == 20 || $i == 27 || $i == 37 || $i == 43) {
							$calculrb = $calculrb + $this->data['DspScore'][$i]['reponse'];
						}	

						###GI
						# 45 DSP
						if ($i == 18 || $i == 28) {
							$calculgi = $calculgi + $this->data['DspScore'][$i]['reponse'];
						}

						###Q27
						# 45 DSP
						if ($i == 26) {
							$this->data['DspScore']['Q44'] = $this->data['DspScore'][$i]['reponse'];
						}					
						
					} elseif ($questionsCount == 77) { 
						###Somatic
						# 77 DSP
						if ($i == 0 || $i == 1 || $i == 2 || $i == 12 || $i == 17 || $i == 41 || $i == 58 || $i == 67) {
							$calculsom = $calculsom + $this->data['DspScore'][$i]['reponse'];				
						}

						###Depression
						# 77 DSP
						if ($i == 8 || $i == 22 || $i == 29 || $i == 36 || $i == 40 || $i == 43 || $i == 54 || $i == 57 || $i == 63 || $i == 65) {
							$calculdep = $calculdep + $this->data['DspScore'][$i]['reponse'];
						}
						
						###Alcohol and Drugs
						# 77 DSP
						if ($i == 10 || $i == 14 || $i == 20 || $i == 34 || $i == 51 || $i == 61 || $i == 68 || $i == 70) {
							$calculalc = $calculalc + $this->data['DspScore'][$i]['reponse'];
						}

						###Anxiety
						# 77 DSP
						if ($i == 6 || $i == 7 || $i == 9 || $i == 13 || $i == 32 || $i == 52 || $i == 62 || $i == 65 || $i == 66 || $i == 73) {
							$calculanx = $calculanx + $this->data['DspScore'][$i]['reponse'];
						}				

						###Obsessive
						# 77 DSP
						if ($i == 4 || $i == 11 || $i == 18 || $i == 27 || $i == 45 || $i == 49 || $i == 59 || $i == 72 || $i == 75) {
							$calculOBS = $calculOBS + $this->data['DspScore'][$i]['reponse'];
						}				

						###Panic
						# 77 DSP
						if ($i == 5 || $i == 19 || $i == 26 || $i == 31 || $i == 37 || $i == 38 || $i == 42 || $i == 48 || $i == 55) {
							$calculpan = $calculpan + $this->data['DspScore'][$i]['reponse'];
						}

						###Agor
						# 77 DSP
						if ($i == 25 || $i == 56) {
							$calculago = $calculago + $this->data['DspScore'][$i]['reponse'];
						}

						###Traumatic
						# 77 DSP
						if ($i == 23 || $i == 33 || $i == 39 || $i == 44 || $i == 47 || $i == 48 || $i == 65 || $i == 73 || $i == 74 ) {
							$calcultra = $calcultra + $this->data['DspScore'][$i]['reponse'];
						}
						
						###Min
						# 77 DSP
						if ($i == 16 || $i == 35 || $i == 53 || $i == 60 || $i == 69 || $i == 76 ) {
							$calculmin = $calculmin + $this->data['DspScore'][$i]['reponse'];
						}
						
						###Mag - Rb
						# 77 DSP
						if ($i == 3 || $i == 15 || $i == 21 || $i == 24 || $i == 30 || $i == 46 || $i == 64 || $i == 71) {
							$calculrb = $calculrb + $this->data['DspScore'][$i]['reponse'];
						}

						###GI
						# 77 DSP
						if ($i == 28 || $i == 50) {
							$calculgi = $calculgi + $this->data['DspScore'][$i]['reponse'];
						}
						
						###Q44
						# 77 DSP
						if ($i == 43) {
							$this->data['DspScore']['Q44'] = $this->data['DspScore'][$i]['reponse'];
						}					
					}				
				
				}
			}
			
			# Call the Table of DspDeterminant DSP
			App::import('Model','DspDeterminant');
			$this->DspDeterminant = new DspDeterminant(); 			
			$listDspDeterminants = $this->DspDeterminant->listDspDeterminants();
			foreach($listDspDeterminants as $listDspDeterminant):
				if ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'SOM'){
					$calculsom = ((($calculsom - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'DEP'){
					$calculdep = ((($calculdep - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'ALC'){
					$calculalc = ((($calculalc - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'ANX'){
					$calculanx = ((($calculanx - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'OBS'){
					$calculOBS = ((($calculOBS - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'PAN'){
					$calculpan = ((($calculpan - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'AGO'){
					$calculago = ((($calculago - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'TRA'){
					$calcultra = ((($calcultra - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'MIN'){
					$calculmin = ((($calculmin - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}elseif ($listDspDeterminant['DspDeterminant']['abr_eng'] == 'RB'){
					$calculrb = ((($calculrb - $listDspDeterminant['DspDeterminant']['det1']) / $listDspDeterminant['DspDeterminant']['det2']) * 10) + 50;
				}				
			endforeach;			
		
			$this->data['DspScore']['SOM'] = round($calculsom);
			$this->data['DspScore']['DEP'] = round($calculdep);
			$this->data['DspScore']['ALC'] = round($calculalc);
			$this->data['DspScore']['ANX'] = round($calculanx);
			$this->data['DspScore']['OBS'] = round($calculOBS);
			$this->data['DspScore']['PAN'] = round($calculpan);
			$this->data['DspScore']['AGO'] = round($calculago);
			$this->data['DspScore']['TRA'] = round($calcultra);
			$this->data['DspScore']['MIN'] = round($calculmin);
			$this->data['DspScore']['RB'] = round($calculrb);
			$this->data['DspScore']['GRD'] = round($calculgi);
			
			$this->data['DspScore']['created'] = date('Y-m-d h:i:s a');
			
			$this->data['DspScore']['answers'] = $choicesstring;			 
		 
			return true;
//		}
	}
	
	function afterSave($created) {
		### When an Insert is made
		if($created){
			$today = date('Y-m-d', time());	
			$serviceid = $this->data['Service']['id'];
			$evaluationid = $this->data['DspScore']['evaluation_id'];
			$orderid = $this->data['Evaluation']['order_id'];

			$questionnairesLists = $this->Evaluation->Service->QuestionnairesService->find('all', 
									array('conditions' => array('QuestionnairesService.service_id' => $serviceid),
										'fields' => array('QuestionnairesService.id', 'QuestionnairesService.questionnaire_id', 'QuestionnairesService.service_id'
														)
										)
							);		
			$nbQuest = 0;
			foreach($questionnairesLists as $questionnairesList):			
				//if ($serviceid == 1 || $serviceid == 2 || $serviceid == 3 || $serviceid == 5 || $serviceid == 6 || $serviceid == 7 || $serviceid == 8)
				if($questionnairesList['QuestionnairesService']['questionnaire_id'] == 4 || 
					$questionnairesList['QuestionnairesService']['questionnaire_id'] == 5) {
				### TR. QUEST - Initial / TR. QUEST - Follow Up
					# Call the QuestionnaireTreatment table
					App::import('Model','QuestionnaireTreatment');
					$this->QuestionnaireTreatment = new QuestionnaireTreatment(); 			
					$countTreatQ = $this->QuestionnaireTreatment->countTreatQ($evaluationid);
					if($countTreatQ == 1) { $nbQuest++; } 					
				}elseif($questionnairesList['QuestionnairesService']['questionnaire_id'] == 3) {
				### HSQ
					# Call the HSQ table
					App::import('Model','HsqScore');
					$this->HsqScore = new HsqScore(); 			
					$countHsq = $this->HsqScore->countHsq($evaluationid);
					if($countHsq == 1) { $nbQuest++; }
				}
			endforeach;
			
			if ($nbQuest == (count($questionnairesLists) - 1)){				
				$this->Evaluation->id = $evaluationid;
				$this->Evaluation->set(array(
							'status_id' => 94,
							'status_date' => $today
							));				
				if ($this->Evaluation->save($this->data['Evaluation'])) {	
					# Validate the max number of tests by order - then close the Order
					if ($this->data['DspScore']['test_serie'] == 6) {
						$this->Evaluation->Order->id = $orderid;
						if (!$this->Evaluation->Order->saveField('status_id', 6)) {
							return false;
						}
					}						
				} else {
					return false;
				}					
			}				
		}
		return true;
	}		
}
?>