<?php
class Employee extends AppModel 
{
	var $name = 'Employee';

	var $pat = 'c';
	
	public $virtualFields = array(
		'name' => 'CONCAT(Employee.first_name, " ", Employee.last_name)'
								); 		
		
	var $validate = array(
			'customer_id' => array(
				'required' => 'notEmpty'
			),  
			'first_name' => array(
				'required' => 'notEmpty'	            
			),
			'last_name' => array(
				'required' => 'notEmpty'
			),
			'date_birth' => array(
				'employenameRule-1' => array(
					'rule' => 'date',
					'allowEmpty' => false,
					'last' => true
				),
				'employenameRule-2' => array(
					'rule' => array('validateEmployeeFields', 'first_name', 'last_name', 'customer_id'),
					'on' => 'create',
					'last' => true
				)				
			),		   
			'gender' => array(
				'required' => 'notEmpty'
			),
			'langue' => array(
				'required' => 'notEmpty'
			),			
/*	       'email' => array(
	            'email' => array(
					'rule' => 'email',
					'allowEmpty' => true,
					'message' => 'Enter a valid email address'
					)
			),	 			 */
	       'province_id' => array(
				'validateAddressFields' => array(
					'rule' => array('validateAddressFields', 'city_id', 'code_postal', 'address')
	            )
	       ),
/*	       'city_id' => array(
				'required' => 'notEmpty'
	       ),	*/	   
	    //    'code_postal' => array(
		// 		'postalcoderule' => array(
		// 			'rule' => array('postal', null, 'ca'),
		// 			'allowEmpty' => true					
		// 		)
	    //    )		   
	);
	
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	public $belongsTo = array('City', 'Province', 'Customer');

	public $hasMany = array('Order');	

	

    function searchListEmployeeName($name) 
	{
		return $this->find('all', array('conditions'=>array('CONCAT(Employee.last_name, " ,", Employee.first_name) 
				LIKE'=>'%'.$name.'%'),
				'fields' => array('id', 'name'),'order' => 'name ASC'));
	}
 	
	
    function existingAddressEmail( $field=array(), $compare_field=null ) 
    {
        foreach( $field as $key => $value ){
            $v1 = $value;
            $v2 = $this->data[$this->name][ $compare_field ]; 

            if(empty($v1) && empty($v2)) 
			{
				$pat = "a";
                return FALSE;
            } 
			else 
			{
			# Address 
			 if (!empty($v1))
			   {
				$pat = "b";
			   }
             continue;
            }
        }
        return TRUE;
    } 	

    function validateAddressFields( $field=array(), $compare_field1=null, $compare_field2=null, $compare_fieldmain=null ) 
    {
		if (!empty($this->data[$this->name][ $compare_fieldmain ]))
		{
			foreach( $field as $key => $value )
			{
				$v1 = $value;
				$v2 = $this->data[$this->name][ $compare_field1 ]; 
				$v3 = $this->data[$this->name][ $compare_field2 ]; 
				
				$v22 = $this->data['City']['name'];

				if(empty($v1) && empty($v2) && empty($v3)) 
				{
					return FALSE;
				} 
				else 
				{
					if(!empty($v1) && !empty($v2) && (!empty($v3) || !empty($v22))) 
					{
						continue;
					}
					else
					{
						return FALSE;
					}						
				}
			}
		}	
		return TRUE; 
    }

    function validateEmployeeFields( $field=array(), $compare_field1=null, $compare_field2=null, $compare_field3=null) 
    {
	if (!empty($this->data[$this->name][$compare_field1]) && !empty($this->data[$this->name][$compare_field2]))
	 {
        foreach( $field as $key => $value )
		{
			$emp_firstname = '';
			$emp_lastname = '';
			$emp_existants = 0;
			
            $emp_dob = $value;
            $emp_firstname = $this->data[$this->name][ $compare_field1 ]; 
            $emp_lastname = $this->data[$this->name][ $compare_field2 ];
			$cust_id = $this->data[$this->name][ $compare_field3 ]; 
			
			//$id_requester = $this->data[$this->name][ $requester_field ];

			$emp_existants = $this->find('count', array(
				'fields' => 'Employee.id',
				'conditions' => array('Employee.date_birth' => $emp_dob,
									'Employee.last_name' => $emp_lastname,
									'Employee.first_name' => $emp_firstname,
									'Employee.customer_id' => $cust_id)
			));			
			
			if ($emp_existants > 0) {
				return FALSE; 		
			}
        }
	 }	
	 return TRUE; 
    }	
	
	# xxx returns the Employee information by Employee_id provided
	function infoEmp($emp_id) {
		return $this->find('first', array(
				'link' => array(
					'Customer',
					'City' => array(
								'conditions' => 'Employee.city_id  = City.id'),
					'Province' => array(
								'conditions' => 'Employee.province_id  = Province.id'),
				),
				'fields' => array('Employee.id','Employee.first_name','Employee.last_name','Employee.email',
							'Employee.date_birth', 'Employee.gender', 'Employee.address', 'Employee.code_postal',
							'Employee.langue',
							'City.name', 'Province.name',
							'Customer.id','Customer.name'),			
				'conditions' =>  array('Employee.id' => $emp_id)				
			));						
			
	}

	function beforeSave($opt=[]) {
		# The city doesn't not exist in the table - it's a new one
		if (empty($this->data['Employee']['city_id']) || $this->data['Employee']['city_id'] == 999);{
			# insert a new City			
			if (isset($this->data['Employee']['province_id']) && empty($this->data['City']['id'])){
				$this->data['City']['province_id'] = $this->data['Employee']['province_id'];
				$this->City->save($this->data['City']);
				$this->data['Employee']['city_id'] = $this->City->id;
			} 
		}
		return true;	
	} 
}	
?>