<?php
class Fee extends AppModel {
	var $name = 'Fee';
	var $displayField = 'id';
	
  var $validate = array(
			'communication_id' => array(		   
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Service'			   		   
			),
			'service_id' => array(
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Service'				 
			),
			'status_id' => array(				 
				'Please select a Type of Communication'=>array(
					'rule'=> array('notEmpty')
				),
				'The Fee Service/Communication/Status combination already exists' => array(
					'rule'=> array('validateDuplicateEntry', 'communication_id', 'service_id', 'status_id'),
					'on' => 'create'
				)				 
			),			
			'type_test' => array(
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Type of Test'				 
			),
			'fee_value' => array(
	             'decimal' => array(
	             'rule' => array('decimal', 2),
	             'allowEmpty' => false,
	             'message' => 'The Fee value must be in this format e.g 10.00'
	            )
	       )			
	);
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed	

	public $belongsTo = array(
		'Communication' => array(
			'className' => 'Communication',
			'foreignKey' => 'communication_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Service' => array(
			'className' => 'Service',
			'foreignKey' => 'service_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Status' => array(
			'className' => 'Status',
			'foreignKey' => 'status_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)				
	);

    function validateDuplicateEntry( $field=array(), $communication_field=null, $service_field=null, $status_field=null ) 
    {
		//$communication_field = $this->data[$this->name][$communication_field]; 
		$existing_entry = $this->find('count', array(
							'conditions' => array($communication_field => $this->data[$this->name][$communication_field],
										$service_field => $this->data[$this->name][$service_field],
										$status_field => $this->data[$this->name][$status_field]
										), 
							'recursive' => -1) 
						);
		if ($existing_entry !== 0) {
			return FALSE; 		
		}
		return TRUE;
    } 
	
	
	function getFeeValue($type_test, $communic_id, $service_id, $status_id) 
	{
		return $this->find('first', array(
				'fields' => array('Fee.id','Fee.fee_value'),			
				'conditions' =>  array('Fee.type_test' => $type_test,'Fee.communication_id' => $communic_id,'Fee.service_id' => $service_id, 
										'Fee.status_id' => $status_id,'Fee.active' => 1)
//				'group' => 'Order.id'				
			));			
	}	
		
}
?>