<?php
class HsqScore extends AppModel {

	var $name = 'HsqScore';
//	var $displayField = 'name';

	var $belongsTo = array(
		'Evaluation' => array(
			'className' => 'Evaluation',
			'foreignKey' => 'evaluation_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Questionnaire' => array(
			'className' => 'Questionnaire',
			'foreignKey' => 'questionnaire_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)	
	);
		

	###########################################################################
	# Validate if there is already a HSQ Score
	###########################################################################	
	function countHsq($eval_id)
	{
		return $this->find('count', array('conditions' => array('HsqScore.evaluation_id' => $eval_id)));
	}
	
	###################################################################################
	# Get the HSQ values scales from an specific Evaluation-Test
	###################################################################################
	function infoScaleHsq($eval_id)
	{
		return $this->find('all', array('conditions' => array('HsqScore.evaluation_id' => $eval_id),
										'fields' => array('HsqScore.id', 'HsqScore.questionnaire_id', 'HsqScore.HP', 'HsqScore.PF', 'HsqScore.RP', 
														'HsqScore.RE', 'HsqScore.SF', 'HsqScore.MH', 'HsqScore.BP', 'HsqScore.EF', 'HsqScore.answers', 'HsqScore.createdby')
										)
							);
	}	
	
	###################################################################################
	# Get a complete information about a HSQ Score: Customer/Employee/Evaluation/HSQ
	###################################################################################
	function infoHsq($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Evaluation' => array(
						'Order' => array(
							'Customer',
							'Employee'
							),
						'Requester' => array(
											'Team'  => array('conditions' => 'Requester.team_id  = Team.id'),
											'conditions' => 'Evaluation.requester_id  = Requester.id'
											),
						'Status' => array('conditions' => 'Evaluation.status_id  = Status.id'),
						'Service' => array('conditions' => 'Evaluation.service_id  = Service.id')
							)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie', 'Evaluation.created', 'Evaluation.order_id',
							'Evaluation.service_id', 'Evaluation.requester_id', 'Evaluation.status_id', 'Evaluation.communication_id', 					
							'Requester.first_name', 'Requester.last_name',
							'Order.id','Order.order_code',
							'Customer.id','Customer.name',
							'Team.id','Team.name',
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email',
							'Service.id','Service.name',
							'Status.id','Status.name_eng','Status.name_fre',
							'HsqScore.Q37','HsqScore.Q38','HsqScore.Q39','HsqScore.created'),
				'conditions' =>  array('HsqScore.evaluation_id' => $eval_id)				
			));	
	}
	
	###################################################################################
	# Get the HSQ values Depression Screener from an specific Evaluation-Test
	###################################################################################
	function infoDeprScreenerScoreHsq($eval_id)
	{
		return $this->find('all', array('conditions' => array('HsqScore.evaluation_id' => $eval_id),
										'fields' => array('HsqScore.id','HsqScore.answers', 'HsqScore.Q37','HsqScore.Q38','HsqScore.Q39')
										)
							);
	}	

	###################################################################################
	# Get the HSQ Depression Screener specific Evaluation-Test
	###################################################################################
	function depressionHsqScreener($eval_id, $questionnaire_id, $language)
	{	
		// 0,1,2 [question]
		$listHsqDepressionQ = $this->Questionnaire->Question->infoHsqDepressionquestion($questionnaire_id);
		// 0 [hsqScore]
		$infoListScreenerScoreHsq = $this->infoDeprScreenerScoreHsq($eval_id);	
		
		$texteQ37 = array();
		$texteQ38 = array();
		$texteQ39 = array();
		$str_Q = array();
		$str_yesno = array();
		
		$titleQ37 = '';
		$titleQ38 = '';
		$titleQ39 = '';
		
		if ($language == 1)   # English
		{
			$field_language = 'desc_eng';
			$str_Q = array('Major Depression', 'Dysthymia', 'Dysthymia');			
			$str_yesno = array('YES', 'NO');
		}
		else   # French
		{
			$field_language = 'desc_fre';
			$str_Q = array(0 => 'Dpression majeure', 1 => 'Dysthimie', 2 => 'Dysthimie');
			$str_yesno = array(0 => 'OUI', 1 => 'NON');
		}

		# Q37
		$rest37 = substr($infoListScreenerScoreHsq[0]['HsqScore']['answers'], 36, 1);		
		if ($rest37 == 0)  //Yes - to the answer
		{
			$titleQ37 = $listHsqDepressionQ[0]['Question']['noquestion'].'. '.$str_Q[0].' - '.$str_yesno[0];
		}
		if ($rest37 == 1)  //No - to the answer
		{
			$titleQ37 = $listHsqDepressionQ[0]['Question']['noquestion'].'. '.$str_Q[0].' - '.$str_yesno[1];		
		}
		
		# Q38			
		$rest38 = substr($infoListScreenerScoreHsq[0]['HsqScore']['answers'], 37, 1);		
		if ($rest38 == 0)  //Yes - to the answer
		{
//			$titleQ38 = '';
			$titleQ38 .= $listHsqDepressionQ[1]['Question']['noquestion'].'. '.$str_Q[1].' - '.$str_yesno[0];
		}
		if ($rest38 == 1)  //No - to the answer
		{
//			$titleQ38 = '';
			$titleQ38 .= $listHsqDepressionQ[1]['Question']['noquestion'].'. '.$str_Q[1].' - '.$str_yesno[1];
		}
		
		# Q39
		$rest39 = substr($infoListScreenerScoreHsq[0]['HsqScore']['answers'], 38, 1);
		if ($rest39 == 0)  //Yes - to the answer
		{
//			$titleQ39 = '';
			$titleQ39 .= $listHsqDepressionQ[2]['Question']['noquestion'].'. '.$str_Q[2].' - '.$str_yesno[0];
		}
		if ($rest39 == 1)  //No - to the answer
		{
//			$titleQ39 = '';
			$titleQ39 .= $listHsqDepressionQ[2]['Question']['noquestion'].'. '.$str_Q[2].' - '.$str_yesno[1];
		}
		
		$texteQ37 = array('id' => 0, 'title' => $titleQ37, 'texte' => $listHsqDepressionQ[0]['Question'][$field_language]);
		$texteQ38 = array('id' => 1, 'title' => $titleQ38, 'texte' => $listHsqDepressionQ[1]['Question'][$field_language]);
		$texteQ39 = array('id' => 2, 'title' => $titleQ39, 'texte' => $listHsqDepressionQ[2]['Question'][$field_language]);
		
		$array_HsqScreener = array($texteQ37, $texteQ38, $texteQ39);
		
		return $array_HsqScreener;
	}	
	
	function infodataset($hystHsq)
	{
		$dataSet_new = array();
		
		$itemsCount = count($hystHsq[0]['Evaluation']);		
		for ($i=0; $i < $itemsCount; $i++)
		{					
			$nbre_scales = 8;
			$dataSet_new = array_merge($dataSet_new, array($hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['HP'],
								$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['PF'],$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['RP'],
								$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['RE'],$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['SF'],
								$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['MH'],$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['BP'],
								$hystHsq[0]['Evaluation'][$i]['HsqScore'][0]['EF']));		
		}
			$dataSet_new = array_chunk($dataSet_new, $nbre_scales);			
		return $dataSet_new;		
	}		
	
	###################################################################################	
	# Get an array Interpretation of the HSQ Score
	###################################################################################
	function interpHsqScore ($eval_id, $language)
	{
		$texteHsqInterp = array();
		$texteHsqInterpHP = array();
		$texteHsqInterpPF = array();
		$texteHsqInterpRP = array();
		$texteHsqInterpRE = array();
		$texteHsqInterpSF = array();  
		$texteHsqInterpMH = array();
		$texteHsqInterpBP = array();
		$texteHsqInterpEF = array();
		$texteHsqInterpPFRPBPHP = array();
		$texteHsqInterpMHRESFEF = array();
		
		$checkPFRPBPHP = 0;
		$checkMHRESFEF = 0;
		
		$avgMHRESFEF = 0;
		$avgMHRESFEF = 0;
		
		$countMIN = 0;

		if ($language == 1)   # Ingles
		{
			$field_language = 'int_eng';
			$field_header_language = 'header_eng';

		}
		else   # French
		{
			$field_language = 'int_fre';
			$field_header_language = 'header_fre';
		}		
		
		App::import('Model','HsqInterp');
		$this->HsqInterp = new HsqInterp(); 
		$listHsqInterp = $this->HsqInterp->find('all', 
								array(
									'fields' => array('id', $field_header_language, 'scale', 'low', 'high', $field_language),
									'order' => 'id ASC'
								)
							);
		
		$infoListScaleHsq = $this->infoScaleHsq($eval_id);
		
		//BEGIN Loop each 
		foreach ($listHsqInterp as $interpHsq): 
		
			if ($interpHsq['HsqInterp']['scale'] == 'HP')
			{
				if ($infoListScaleHsq[0]['HsqScore']['HP'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['HP'] <= $interpHsq['HsqInterp']['high'])
				{
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['HP'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpHP = array('id' => 1, 'scalex' => 'HP', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}
			if ($interpHsq['HsqInterp']['scale'] == 'PF')
			{
				if ($infoListScaleHsq[0]['HsqScore']['PF'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['PF'] <= $interpHsq['HsqInterp']['high'])
				{	
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['PF'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpPF = array('id' => 2, 'scalex' => 'PF', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}		
			if ($interpHsq['HsqInterp']['scale'] == 'RP')
			{
				if ($infoListScaleHsq[0]['HsqScore']['RP'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['RP'] <= $interpHsq['HsqInterp']['high'])
				{	
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['RP'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpRP = array('id' => 3, 'scalex' => 'RP', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}
			if ($interpHsq['HsqInterp']['scale'] == 'RE')
			{
				if ($infoListScaleHsq[0]['HsqScore']['RE'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['RE'] <= $interpHsq['HsqInterp']['high'])
				{				
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['RE'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpRE = array('id' => 4, 'scalex' => 'RE', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}
			if ($interpHsq['HsqInterp']['scale'] == 'SF')
			{
				if ($infoListScaleHsq[0]['HsqScore']['SF'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['SF'] <= $interpHsq['HsqInterp']['high'])
				{				
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['SF'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpSF = array('id' => 5, 'scalex' => 'SF', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}
			if ($interpHsq['HsqInterp']['scale'] == 'MH')
			{
				if ($infoListScaleHsq[0]['HsqScore']['MH'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['MH'] <= $interpHsq['HsqInterp']['high'])
				{				
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['MH'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpMH = array('id' => 6, 'scalex' => 'MH', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}		
			if ($interpHsq['HsqInterp']['scale'] == 'BP')
			{
				if ($infoListScaleHsq[0]['HsqScore']['BP'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['BP'] <= $interpHsq['HsqInterp']['high'])
				{				
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['BP'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpBP = array('id' => 7, 'scalex' => 'BP', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}
			if ($interpHsq['HsqInterp']['scale'] == 'EF')
			{
				if ($infoListScaleHsq[0]['HsqScore']['EF'] >= $interpHsq['HsqInterp']['low'] && $infoListScaleHsq[0]['HsqScore']['EF'] <= $interpHsq['HsqInterp']['high'])
				{				
					$textetag = str_replace('#', $infoListScaleHsq[0]['HsqScore']['EF'], $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpEF = array('id' => 8, 'scalex' => 'EF', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
				}
			}	#PFRPBPHP
			if ($interpHsq['HsqInterp']['scale'] == 'PFRPBPHP')
			{
				$averageScale = round((($infoListScaleHsq[0]['HsqScore']['PF'] + $infoListScaleHsq[0]['HsqScore']['RP'] + $infoListScaleHsq[0]['HsqScore']['BP'] + $infoListScaleHsq[0]['HsqScore']['HP']) / 4));			
				if ($averageScale >= $interpHsq['HsqInterp']['low'] && $averageScale < $interpHsq['HsqInterp']['high'])
				{	
					#$averageScale = round((($infoListScaleHsq[0]['HsqScore']['PF'] + $infoListScaleHsq[0]['HsqScore']['RP'] + $infoListScaleHsq[0]['HsqScore']['BP'] + $infoListScaleHsq[0]['HsqScore']['HP']) / 4));
					$textetag = str_replace('#', $averageScale, $interpHsq['HsqInterp'][$field_language]);
					$texteHsqInterpPFRPBPHP = array('id' => 9, 'scalex' => 'PFRPBPHP', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
					$checkPFRPBPHP = 1;
				}
				else
				{
					if ($checkPFRPBPHP == 0 ) { $texteHsqInterpPFRPBPHP = array('id' => 9, 'scalex' => 'PFRPBPHP', 'texte_header' => '', 'texte' => ''); }
				}				
			}
			if ($interpHsq['HsqInterp']['scale'] == 'MHRESFEF')
			{
				$averageScale = round((($infoListScaleHsq[0]['HsqScore']['MH'] + $infoListScaleHsq[0]['HsqScore']['RE'] + $infoListScaleHsq[0]['HsqScore']['SF'] + $infoListScaleHsq[0]['HsqScore']['EF']) / 4));			
				if ($averageScale >= $interpHsq['HsqInterp']['low'] && $averageScale < $interpHsq['HsqInterp']['high'])
				{							
					$textetag = str_replace('#', $averageScale, $interpHsq['HsqInterp'][$field_language]);				
					$texteHsqInterpMHRESFEF = array('id' => 10, 'scalex' => 'MHRESFEF', 'texte_header' => $interpHsq['HsqInterp'][$field_header_language], 'texte' => $textetag);
					$checkMHRESFEF = 1;
				}
				else
				{
					if ($checkMHRESFEF == 0 ) { $texteHsqInterpMHRESFEF = array('id' => 10, 'scalex' => 'MHRESFEF', 'texte_header' => '', 'texte' => ''); }					
				}				
			}			
			//END Loop each 
		endforeach;		

			$result = array($texteHsqInterpHP, $texteHsqInterpPF, $texteHsqInterpRP, $texteHsqInterpRE, $texteHsqInterpSF, $texteHsqInterpMH, $texteHsqInterpBP, 
						$texteHsqInterpEF, $texteHsqInterpPFRPBPHP, $texteHsqInterpMHRESFEF);
		
		return $result;
	}
	
	
	function beforeSave($opt=[]) 
	{
	### When an Insert Table is made		
//		if(empty($this->id))		 
//		{
		$questionsCount = 39;
		$choicesstring = '';		

		$calculhp = 0;
		$calculpf = 0;
		$calculrp = 0;	 
		$calculre = 0;
		$calculsf = 0;	 
		$calculmh = 0;
		$calculbp = 0;
		$calculef = 0;
		
		$nbnonrsp_hp = 0;
		$nbnonrsp_pf = 0;
		$nbnonrsp_rp = 0;
		$nbnonrsp_re = 0;
		$nbnonrsp_sf = 0;
		$nbnonrsp_mh = 0;
		$nbnonrsp_bp = 0;
		$nbnonrsp_ef = 0;		
		 	
			// For - begin
			for ($i=0; $i < $questionsCount; $i++)
			{
			
				if ($this->data['HsqScore'][$i]['reponse'] == '') 
				{
					$this->data['HsqScore'][$i]['reponse'] = 9;
				}

			// To save the answers
			$choicesstring = $choicesstring.$this->data['HsqScore'][$i]['reponse'];
			
				###### HSQ Calcul #####			
				### HP								
				# HP Question 1 ( i = 0 )
				if ($i == 0) 
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 85;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 60;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 25;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} 
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_hp =  1 + $nbnonrsp_hp;
					}
					else
					{
						$calculhp = $calculhp + $this->data['HsqScore'][$i]['reponse'];
					}					
				}
				
				# HP Question 34 ( i = 33 ) / Question 36 ( i = 35 )
				if (($i == 33) || ($i == 35))
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 75;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 50;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 25;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} 
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_hp =  1 + $nbnonrsp_hp;
					}
					else
					{
						$calculhp = $calculhp + $this->data['HsqScore'][$i]['reponse'];
					}					
				}

				# HP Question 33 ( i = 32 ) PH / Question 35 ( i = 34 ) 
				if ($i == 32 || $i == 34)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 25;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 50;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 75;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					}

					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_hp =  1 + $nbnonrsp_hp;
					}
					else
					{
						$calculhp = $calculhp + $this->data['HsqScore'][$i]['reponse'];
					}
				}								
				//////////////////////////////////////////////////////////////////////////////////

				### PF
				# PF Question 3 to Question 12 ( i = 2 to i = 11)
				if ($i == 2 || $i == 3 || $i == 4 || $i == 5 || $i == 6 || $i == 7 || $i == 8 || $i == 9 || $i == 10 || $i == 11) 
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 50;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} 
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_pf =  1 + $nbnonrsp_pf;
					}
					else
					{
						$calculpf = $calculpf + $this->data['HsqScore'][$i]['reponse'];
					}
				}
				//////////////////////////////////////////////////////////////////////////////////
				
				### RP
				# RP Question 13 to Question 16 ( i = 12 to i = 15)
				if ($i == 12 || $i == 13 || $i == 14 || $i == 15) 
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} 
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_rp =  1 + $nbnonrsp_rp;
					}
					else
					{
						$calculrp = $calculrp + $this->data['HsqScore'][$i]['reponse'];
					}	
				}					
				//////////////////////////////////////////////////////////////////////////////////
				
				### RE
				# RE Question 17 to Question 19 ( i = 16 to i = 18)
				if ($i == 16 || $i == 17 || $i == 18) 
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} 
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_re =  1 + $nbnonrsp_re;
					}
					else
					{
						$calculre = $calculre + $this->data['HsqScore'][$i]['reponse'];
					}
				}				
				//////////////////////////////////////////////////////////////////////////////////
				
				### SF
				# SF Question 20 ( i = 19 )
				if ($i == 19)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 75;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 50;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 25;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} 
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_sf =  1 + $nbnonrsp_sf;
					}
					else
					{
						$calculsf = $calculsf + $this->data['HsqScore'][$i]['reponse'];
					}
				}

				# SF Question 32 ( i = 31 )
				if ($i == 31)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 25;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 50;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 75;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					}
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_sf =  1 + $nbnonrsp_sf;
					}
					else
					{
						$calculsf = $calculsf + $this->data['HsqScore'][$i]['reponse'];
					}					
				}								
				//////////////////////////////////////////////////////////////////////////////////	
				
				### MH
				# MH Question 24 ( i = 23 ) / Question 25 ( i = 24 ) / Question 28 ( i = 27 )
				if ($i == 23 || $i == 24 || $i == 27)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 20;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 40;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 60;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 80;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 5) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					}

					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_mh =  1 + $nbnonrsp_mh;
					}
					else
					{
						$calculmh = $calculmh + $this->data['HsqScore'][$i]['reponse'];
					}
				}
//MH = 87(error)  74  => 0,0,5,5,0 = 0+0+0+100+100 /  2+2+3+2+3 = 40+40+40+40+40
				# MH Question 26 ( i = 25 ) / Question 30 ( i = 29 )
				if ($i == 25 || $i == 29)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 80;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 60;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 40;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 20;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 5) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					}

					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_mh =  1 + $nbnonrsp_mh;
					}
					else
					{
						$calculmh = $calculmh + $this->data['HsqScore'][$i]['reponse'];
					}
				}				
				//////////////////////////////////////////////////////////////////////////////////

				### BP
				# BP Question 21 ( i = 20 )
				if ($i == 20)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 80;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 60;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 40;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 20;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 5) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					}

					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_bp =  1 + $nbnonrsp_bp;
					}
					else
					{
						$calculbp = $calculbp + $this->data['HsqScore'][$i]['reponse'];
					}				
				}
				
				# BP Question 22 ( i = 21 )
				if ($i == 21)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 75;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 50;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 25;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					}
					
					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_bp =  1 + $nbnonrsp_bp;
					}
					else
					{
						$calculbp = $calculbp + $this->data['HsqScore'][$i]['reponse'];
					}					
				}				
				//////////////////////////////////////////////////////////////////////////////////
					
				### EF
				# EF Question 23 ( i = 22 ) / Question 27 ( i = 26 )
				if ($i == 22 || $i == 26)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 80;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 60;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 40;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 20;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 5) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					}

					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_ef =  1 + $nbnonrsp_ef;
					}
					else
					{
						$calculef = $calculef + $this->data['HsqScore'][$i]['reponse'];
					}			
				}
//EF = 59  57  => 5, 0, 5, 0 = 0+100+100+0
				# EF Question 29 ( i = 28 ) / Question 31 ( i = 30 )
				if ($i == 28 || $i == 30)
				{
					if ($this->data['HsqScore'][$i]['reponse'] == 0) {
						$this->data['HsqScore'][$i]['reponse'] = 0;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 1) {
						$this->data['HsqScore'][$i]['reponse'] = 20;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 2) {
						$this->data['HsqScore'][$i]['reponse'] = 40;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 3) {
						$this->data['HsqScore'][$i]['reponse'] = 60;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 4) {
						$this->data['HsqScore'][$i]['reponse'] = 80;
					} elseif ($this->data['HsqScore'][$i]['reponse'] == 5) {
						$this->data['HsqScore'][$i]['reponse'] = 100;
					}

					if ($this->data['HsqScore'][$i]['reponse'] == 9)
					{
						$nbnonrsp_ef =  1 + $nbnonrsp_ef;
					}
					else
					{
						$calculef = $calculef + $this->data['HsqScore'][$i]['reponse'];
					}
				}
				
				# Question 2 ( i = 1 ) / Question 37 ( i = 36 ) / Question 38 ( i = 37 ) / Question 39 ( i = 38 )
					if ($i == 1) {
						$this->data['HsqScore']['Q2'] = $this->data['HsqScore'][$i]['reponse'];
					} elseif ($i == 36) {
						$this->data['HsqScore']['Q37'] = $this->data['HsqScore'][$i]['reponse'];
					} elseif ($i == 37) {
						$this->data['HsqScore']['Q38'] = $this->data['HsqScore'][$i]['reponse'];
					} elseif ($i == 38) {
						$this->data['HsqScore']['Q39'] = $this->data['HsqScore'][$i]['reponse'];
					}
			}
			// For - end
			
			### Scales calculator
			# HP
			if ($nbnonrsp_hp == 0) {
				$calculhp = $calculhp / 5;
			} elseif ($nbnonrsp_hp == 1 || $nbnonrsp_hp == 2) {
				$calculhp = $calculhp / (5 - $nbnonrsp_hp);
			}

			# PF
			if ($nbnonrsp_pf == 0) {
				$calculpf = $calculpf / 10;
			} elseif ($nbnonrsp_pf == 1 || $nbnonrsp_pf == 2) {
				$calculpf = $calculpf / (10 - $nbnonrsp_pf);
			}			
			
			# RP
			if ($nbnonrsp_rp == 0) {
				$calculrp = $calculrp / 4;
			} elseif ($nbnonrsp_rp == 1 || $nbnonrsp_rp == 2) {
				$calculrp = $calculrp / (4 - $nbnonrsp_rp);
			}				

			# RE
			if ($nbnonrsp_re == 0) {
				$calculre = $calculre / 3;
			} elseif ($nbnonrsp_re == 1) {
				$calculre = $calculre / (3 - $nbnonrsp_re);
			}

			# SF
			if ($nbnonrsp_sf == 0) {
				$calculsf = $calculsf / 2;
			} elseif ($nbnonrsp_sf == 1) {
				$calculsf = $calculsf / (2 - $nbnonrsp_sf);
			}

			# MH
			if ($nbnonrsp_mh == 0) {
				$calculmh = $calculmh / 5;
			} elseif ($nbnonrsp_mh == 1 || $nbnonrsp_mh == 2) {
				$calculmh = $calculmh / (5 - $nbnonrsp_mh);
			}			

			# BP
			if ($nbnonrsp_bp == 0) {
				$calculbp = $calculbp / 2;
			} elseif ($nbnonrsp_bp == 1) {
				$calculbp = $calculbp / (2 - $nbnonrsp_bp);
			}

			# EF
			if ($nbnonrsp_ef == 0) {
				$calculef = $calculef / 4;
			} elseif ($nbnonrsp_ef == 1 || $nbnonrsp_ef == 2) {
				$calculef = $calculef / (4 - $nbnonrsp_ef);
			}

			## Get - Gender / Age  - Set fields name
			if ($this->data['Employee']['gender'] == 'M')  //Homme
			{
				# Avant retraite
				if ($this->data['Employee']['age'] > 0 && $this->data['Employee']['age'] < 65)
				{
					$namefield = 'h64';
					$namefielddet = 'deth64';
				}
				# Retrait
				if ($this->data['Employee']['age'] > 64)
				{
					$namefield = 'h65';
					$namefielddet = 'deth65';
				}				
			} elseif ($this->data['Employee']['gender'] == 'F') {  //Femme
				# Avant retraite
				if ($this->data['Employee']['age'] > 0 && $this->data['Employee']['age'] < 65)
				{
					$namefield = 'm64';
					$namefielddet = 'detm64';					
				}
				# Retrait
				if ($this->data['Employee']['age'] > 64)
				{
					$namefield = 'm65';
					$namefielddet = 'detm65';						
				}	
			}
				
			## Call the Table of HsqDeterminant HSQ
			App::import('Model','HsqDeterminant');
			$this->HsqDeterminant = new HsqDeterminant(); 			
			$listHsqDeterminants = $this->HsqDeterminant->listHsqDeterminants();
//			echo pr($listHsqDeterminants);
			foreach($listHsqDeterminants as $listHsqDeterminant):
				if ($listHsqDeterminant['HsqDeterminant']['id'] == 1)  {    //HP
					$calculhp = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculhp)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 2) {   //PF
					$calculpf = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculpf)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 3) {   //RP
					$calculrp = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculrp)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 4) {   //RE
					$calculre = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculre)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 5) {   //SF
					$calculsf = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculsf)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 6) {   //MH
					$calculmh = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculmh)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 7) {   //BP
					$calculbp = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculbp)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				} elseif ($listHsqDeterminant['HsqDeterminant']['id'] == 8) {   //EF
					$calculef = ((($listHsqDeterminant['HsqDeterminant'][$namefield] - round($calculef)) / $listHsqDeterminant['HsqDeterminant'][$namefielddet]) * 10 ) + 50;
				}
			endforeach;			
			
			$this->data['HsqScore']['HP'] = round($calculhp);
			$this->data['HsqScore']['PF'] = round($calculpf);
			$this->data['HsqScore']['RP'] = round($calculrp);
			$this->data['HsqScore']['RE'] = round($calculre);
			$this->data['HsqScore']['SF'] = round($calculsf);
			$this->data['HsqScore']['MH'] = round($calculmh);
			$this->data['HsqScore']['BP'] = round($calculbp);
			$this->data['HsqScore']['EF'] = round($calculef);
			
//			$this->data['HsqScore']['created'] = date('Y-m-d', time());
			if(empty($this->id)){
				$this->data['HsqScore']['created'] = date('Y-m-d H:i:s');
			}
			else{
				$this->data['HsqScore']['modified'] = date('Y-m-d H:i:s');			
			}
			
			
			$this->data['HsqScore']['answers'] = $choicesstring;			 
		 
			return true;
//		}					
	 
	}	

	function afterSave($created) 
	{
		### When an Insert is made
		if($created)		 
		{
			$today = date('Y-m-d', time());	
			$serviceid = $this->data['Service']['id'];
			$evaluationid = $this->data['HsqScore']['evaluation_id'];			
			$orderid = $this->data['Evaluation']['order_id'];
			
			$questionnairesLists = $this->Evaluation->Service->QuestionnairesService->find('all', 
									array('conditions' => array('QuestionnairesService.service_id' => $serviceid),
										'fields' => array('QuestionnairesService.id', 'QuestionnairesService.questionnaire_id', 'QuestionnairesService.service_id'
														)
										)
							);		
			
			/*			
			1	DSP-45
			2	DSP-77
			3	HSQ
			4	TR. QUEST - Initial
			5	TR. QUEST - Follow Up	
			*/	
			
			$nbQuest = 0;
			foreach($questionnairesLists as $questionnairesList):			
				//if ($serviceid == 1 || $serviceid == 2 || $serviceid == 3 || $serviceid == 5 || $serviceid == 6 || $serviceid == 7 || $serviceid == 8)
				if($questionnairesList['QuestionnairesService']['questionnaire_id'] == 4 || $questionnairesList['QuestionnairesService']['questionnaire_id'] == 5)
				{
				### TR. QUEST - Initial / TR. QUEST - Follow Up
					# Call the QuestionnaireTreatment table
					App::import('Model','QuestionnaireTreatment');
					$this->QuestionnaireTreatment = new QuestionnaireTreatment(); 			
					$countTreatQ = $this->QuestionnaireTreatment->countTreatQ($evaluationid);
					if($countTreatQ == 1) { $nbQuest++; } 					
					
				}elseif($questionnairesList['QuestionnairesService']['questionnaire_id'] == 1 || $questionnairesList['QuestionnairesService']['questionnaire_id'] == 2) {
				### DSP
					# Call the DSP table
					App::import('Model','DspScore');
					$this->DspScore = new DspScore(); 			
					$countDsp = $this->DspScore->countDsp($evaluationid);
					if($countDsp == 1) { $nbQuest++; }
		
				}
			endforeach;
			
			if ($nbQuest == (count($questionnairesLists) - 1))
			{				
				$this->Evaluation->id = $evaluationid;
				$this->Evaluation->set(array(
							'status_id' => 13,
							'status_date' => $today
							));				
				if ($this->Evaluation->save($this->data['Evaluation']))
				{	
					# Validate the max number of tests by order - then close the Order
					if ($this->data['HsqScore']['test_serie'] == 6){
						$this->Evaluation->Order->id = $orderid;
						if (!$this->Evaluation->Order->saveField('status_id', 6)) {
							return false;
						}
					}						
				} else {
					return false;
				}					
			}			
		}
		return true;
	}		

}
?>