<?php
class InvoiceItem extends AppModel {
	var $name = 'InvoiceItem';
	var $displayField = 'id';
	
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed	
	
	public $belongsTo = array(
		'Invoice' => array(
			'className' => 'Invoice',
			'foreignKey' => 'invoice_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Status' => array(
			'className' => 'Status',
			'foreignKey' => 'status_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)		
	);
	
	################################################################################
	# Returns the Invoice information with all the test-evaluations - Test list    #
	# Used in view-order                                                           #
	################################################################################
	function infoInvoiceItems($invoice_id)
	{
		return $this->find('all', array(
				'link' => array(
					'Evaluation' => array(
							'Order'  => array(
										'Employee' => array(
													'conditions' => 'Order.employee_id  = Employee.id'),
										'conditions' => 'Evaluation.order_id  = Order.id'),
							'Requester' => array(
										'Team' => array('conditions' => 'Requester.team_id  = Team.id'),
										'conditions' => 'Evaluation.requester_id  = Requester.id'),
							'Status'  => array(
										'conditions' => 'Evaluation.status_id  = Status.id'),
							'Communication',
							'Service',
							'conditions' => 'InvoiceItem.evaluation_id  = Evaluation.id'
							)
				),
				'fields' => array('Order.id','Order.order_code','Evaluation.id','Evaluation.order_id','Evaluation.communication_id',
							'Evaluation.status_id','Evaluation.test_serie','Evaluation.status_date','InvoiceItem.amount','InvoiceItem.evaluation_id',
							'Requester.first_name', 'Requester.last_name',
							'Service.id','Service.name','Employee.first_name','Employee.last_name','Employee.customer_internalcode'),
				'conditions' =>  array('InvoiceItem.invoice_id = '.$invoice_id, 'Evaluation.status_id' => [7,13,14,15]), //Removed all statuses except for cases completed April 2019
				'order' => array('Requester.team_id','Requester.id')
//				'group' => array('Requester.team_id', 'Order.id')
			));		
	}
	
	################################################################################
	# Returns the Invoice information with all the test-evaluations - Test list    #
	# Used in Invoice - XLS FILE                                                   #
	################################################################################
	function infoInvoiceItemsXls($invoice_id)
	{
		return $this->find('all', array(
				'link' => array(
					'Evaluation' => array(
							'Order'  => array(
										'Employee' => array(
													'conditions' => 'Order.employee_id  = Employee.id'),
										'conditions' => 'Evaluation.order_id  = Order.id'),
							'Requester' => array(
										'Team' => array('conditions' => 'Requester.team_id  = Team.id'),
										'conditions' => 'Evaluation.requester_id  = Requester.id'),
							'Status'  => array(
										'conditions' => 'Evaluation.status_id  = Status.id'),
							'Communication',
							'Service',
							'conditions' => 'InvoiceItem.evaluation_id  = Evaluation.id'
							)
				),
				'fields' => array('Order.id','Order.order_code','Evaluation.id','Evaluation.order_id','Evaluation.communication_id',
							'Evaluation.status_id','Evaluation.test_serie','Evaluation.status_date','InvoiceItem.amount','InvoiceItem.evaluation_id',
							'Requester.first_name', 'Requester.last_name',
							'Service.id','Service.name','Employee.first_name','Employee.last_name','Employee.customer_internalcode'),
				'conditions' =>  array('InvoiceItem.invoice_id = '.$invoice_id),
				'order' => array('Requester.team_id')
			));		
	}
	
	################################################################################
	#                                  After Save                                  #
	################################################################################		
	function afterSave($created) 
	{
	//$today = date('Y-m-d');	
	### When an Insert is made
		if($created)
		{

			
		}
		else
		{
	
			
		}
		return true;		
	}	
}
?>