<?php
class Evaluation extends AppModel {
	var $name = 'Evaluation';
	var $displayField = 'id';
	
	var $validate = array(
	       'requester_id' => array(
				'required' => 'notEmpty'		 
			),
	       'service_id' => array(
				'required' => 'notEmpty'
			),			
	       'communication_id' => array(
				'required' => 'notEmpty'		 
			),
	       'status_id' => array(
				'required' => 'notEmpty'		 
			)			
	);
	
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed		
	public $belongsTo = array(
		'Order' => array(
			'className' => 'Order',
			'foreignKey' => 'order_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Invoice' => array(
			'className' => 'Invoice',
			'foreignKey' => 'invoice_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),		
		'Requester' => array(
			'className' => 'Requester',
			'foreignKey' => 'requester_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Status' => array(
			'className' => 'Status',
			'foreignKey' => 'status_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Communication' => array(
			'className' => 'Communication',
			'foreignKey' => 'communication_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Service' => array(
			'className' => 'Service',
			'foreignKey' => 'service_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)		
	);
	
	public $hasMany = array(
		'DspScore' => array(
			'className' => 'DspScore',
			'foreignKey' => 'evaluation_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'HsqScore' => array(
			'className' => 'HsqScore',
			'foreignKey' => 'evaluation_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),		
		'QuestionnaireTreatment' => array(
			'className' => 'QuestionnaireTreatment',
			'foreignKey' => 'evaluation_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),		
		'InvoiceItem' => array(
			'className' => 'InvoiceItem',
			'foreignKey' => 'evaluation_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)		
		
	);	
	
	# returns the last Evaluation information by order
	function lastEvalinfo($ord_id)
	{
//		return $this->find('first', array('fields' => array('Evaluation.id','Evaluation.communication_id'),'conditions' => array('Evaluation.order_id' => $ord_id), 'order' => 'Evaluation.test_serie DESC'));
		return $this->find('first', array('fields' => array('Evaluation.id','Evaluation.status_id','Evaluation.communication_id'),'conditions' => array('Evaluation.order_id' => $ord_id, 'Evaluation.last_test' => 1)));
	}		

	### Returns the number of evaluation by order - Not cancelations included
	# 	Validate if the last Evaluation-Test was canceled in order to update the REAL test_serie 
	function countEval($ord_id)
	{
		return $this->find('count', array('conditions' => array('Evaluation.order_id' => $ord_id, 
																'NOT' => array('Evaluation.status_id' => array(7,14,15,16,18)
																				)
																)
										)
							);
	}		

	#############################################################################################
	# Returns the number of Questionnaires that have already been completed by eval_id provided #
	# But the Evaluation still opened - validation executed when an Update action is called     #
	#############################################################################################
	function validNbrQuestCompl($eval_id){
/*		$exitsDSP = $this->DspScore->countDsp($eval_id);
		$exitsHSQ = $this->HsqScore->countHsq($eval_id);
		$exitsQT = $this->QuestionnaireTreatment->countTreatQ($eval_id);
		if ($exitsDSP = )
*/	
	}
	
	###################################################################################
	# Returns the Order-Evaluation-one information by eval_id provided                #
	# Used in 'questionnaires_services_controller' to add/view questionnaire          #
	###################################################################################
	function infoEvalorder($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Order' => array(
						'Customer',
						'Employee'						
					),
					'Service',
					'Requester'  => array('Team'),
					'Doctor' => array(
								'City'  => array(
										'conditions' => 'Doctor.city_id  = City.id'),
								'Province' => array(
										'conditions' => 'Doctor.province_id  = Province.id'),
								'conditions' => 'Evaluation.doctor_id  = Doctor.id'),
					'Status',
					'Invoice'
				),
				'fields' => array('Evaluation.id','Evaluation.order_id','Evaluation.communication_id',
							'Evaluation.requester_id','Evaluation.status_id','Evaluation.test_serie','Evaluation.createdby',
							'Evaluation.modifiedby','Evaluation.created', 'Evaluation.modified','Evaluation.status_date','Evaluation.invoice_id',
							'Evaluation.tokenhash', 'Evaluation.service_id',
							'Invoice.invoice_code',
							'Order.id','Order.order_code',
							'Customer.id','Customer.name',
							'Employee.id','Employee.first_name','Employee.last_name',
							'Requester.id', 'Requester.first_name', 'Requester.last_name',
							'Doctor.id',
							'Team.name',
							'Status.name_eng', 
							'Service.id','Service.name'),			
				'conditions' =>  array('Evaluation.id' => $eval_id)
			));						
			
	}
	
	###################################################################################
	# Returns the Order-Evaluation-one information by eval_id provided                #
	# Called from View Treatment Questionnaire Report - Doctor letter                 #
	###################################################################################
	function infoCustomerEvalOrder($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Order' => array(
						'Customer' => array(
										'City'  => array(
												'conditions' => 'Customer.city_id  = City.id'),
										'Province' => array(
												'conditions' => 'Customer.province_id  = Province.id')
											),
						'Employee'						
					),
					'Requester' => array('conditions' => 'Evaluation.requester_id  = Requester.id')
				),
				'fields' => array('Evaluation.id','Evaluation.order_id','Evaluation.requester_id','Evaluation.test_serie','Evaluation.status_date',
							'Order.id','Order.order_code',
							'Customer.id','Customer.abbrv','Customer.name','Customer.address','Customer.code_postal',
							'Province.name','City.name', 
							'Requester.first_name','Requester.last_name',
							'Employee.id','Employee.first_name','Employee.last_name','Employee.customer_internalcode'
							),			
				'conditions' =>  array('Evaluation.id' => $eval_id)
			));						
			
	}
	
	###################################################################################
	# Returns the EmployeeOrder-Evaluation-one information by eval_id provided        #
	# Called from View Claim Letter - from Evaluation controller                      #
	###################################################################################
	function infoEmployeeEvalOrder($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Order' => array(
						'Customer',
						'Employee' => array(
										'City'  => array(
												'conditions' => 'Employee.city_id  = City.id'),
										'Province' => array(
												'conditions' => 'Employee.province_id  = Province.id')
											)																
					),
					'Requester',
					'Service'
				),
				'fields' => array('Evaluation.id','Evaluation.order_id','Evaluation.requester_id','Evaluation.test_serie',
							'Order.id','Order.order_code',
							'Customer.id','Customer.abbrv','Customer.name',
							'Province.name','City.name', 
							'Requester.first_name', 'Requester.last_name',
							'Employee.id','Employee.first_name','Employee.last_name','Employee.customer_internalcode','Employee.address','Employee.code_postal'
							),			
				'conditions' =>  array('Evaluation.id' => $eval_id)
			));						
			
	}
	
	####################################################################################
	# Returns the CustomerEmployeeOrder-Evaluation-one information by eval_id provided #
	# Called from View Complete Letter SLF - from Evaluation controller                #
	####################################################################################
	function infoCustomerEmpEvalOrder($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Order' => array(
						'Customer' => array(
										'City'  => array(
												'conditions' => 'Customer.city_id  = City.id'),
										'Province' => array(
												'conditions' => 'Customer.province_id  = Province.id')
											),
						'Employee'												
					),
					'Requester',
					'Service'
				),
				'fields' => array('Evaluation.id','Evaluation.order_id','Evaluation.requester_id','Evaluation.test_serie',
							'Order.id','Order.order_code',
							'Customer.id','Customer.abbrv','Customer.name','Customer.code_postal','Customer.address',
							'Province.name','City.name', 
							'Requester.first_name', 'Requester.last_name',
							'Employee.id','Employee.first_name','Employee.last_name','Employee.customer_internalcode'
							),			
				'conditions' =>  array('Evaluation.id' => $eval_id)
			));						
			
	}
	
	################################################################################
	# Returns the Order information with all the test-evaluations - Test list      #
	# Used in view-order                                                           #
	################################################################################
	function infoOrdereval($ord_id)
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Customer' => array(
											'City'  => array(
													'conditions' => 'Customer.city_id  = City.id'),
											'Province' => array(
													'conditions' => 'Customer.province_id  = Province.id')
											),
						'Employee',
						'StatusOrder' => array(
								'conditions' => 'Order.status_id  = StatusOrder.id')
					),
					'Requester' => array(
								'conditions' => 'Evaluation.requester_id  = Requester.id'),								
					'Status'  => array(
								'conditions' => 'Evaluation.status_id  = Status.id'),
					'Communication',
					'Service'
				),
				'fields' => array('Evaluation.id','Evaluation.order_id','Evaluation.communication_id','Evaluation.status_id','Evaluation.test_serie',
							'Evaluation.status_date', 'Order.id','Order.order_code','Order.status_id','Customer.id','Customer.name','Employee.id',
							'Employee.first_name','Employee.last_name','Employee.email','Service.id','Service.name'),			
				'conditions' =>  array('Evaluation.order_id' => $ord_id)
//				'group' => 'Order.id'				
			));			
	}
	
	
	# returns the Order-Evaluation information by Evaluation_id provided
	function infoEval($eval_id)
	{
		return $this->find('first', array(
				'link' => array(
					'Order' => array(
						'Employee',
						'Customer'
						
					),
					'Requester' => array(
										'Team'  => array('conditions' => 'Requester.team_id  = Team.id'),
										'conditions' => 'Evaluation.requester_id  = Requester.id'
										),
					'Status' => array('conditions' => 'Evaluation.status_id  = Status.id'),
					'Service' => array('conditions' => 'Evaluation.service_id  = Service.id'),
					'Doctor' => array('conditions' => 'Evaluation.doctor_id  = Doctor.id')
				),
				'fields' => array('Evaluation.id', 'Evaluation.test_serie', 'Evaluation.last_test', 'Evaluation.created', 'Evaluation.tokenhash', 'Evaluation.order_id',
							'Evaluation.service_id', 'Evaluation.requester_id', 'Evaluation.status_id', 'Evaluation.communication_id', 						
							'Requester.first_name', 'Requester.last_name',
							'Order.id','Order.order_code',
							'Customer.id','Customer.name',
							'Team.id','Team.name',
							'Employee.id', 'Employee.first_name', 'Employee.last_name', 'Employee.langue', 'Employee.email', 'Employee.gender', 'Employee.date_birth',
							'Service.id','Service.name',
							'Doctor.id', 'Doctor.full_name', 'Doctor.gender', 'Doctor.langue', 'Doctor.fax', 'Doctor.email', 'Doctor.address',
							'Doctor.code_postal', 'Doctor.city_id', 'Doctor.province_id',
							'Status.id','Status.name_eng','Status.name_fre'),
				'conditions' =>  array('Evaluation.id' => $eval_id)				
			));						
			
	}
	#################################################original code#############################################################################
	// Correction made by Aaron - old reads as :returns the list of evaluations-tests that will be send by email - when their status_id = 9
	/*function listTestsToSendEmail()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee'
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie', 'Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue'),
				'conditions' =>  array('Evaluation.status_id' => 9, 'Evaluation.sent' => 0)
				));			
	}*/
	#################################################################################################################################################
	#################################################Starts statuses change for email reminder shells#############################################################################
	// For status = 9 to status = 10 change, it returns the list of evaluations-tests that will change status 
	// before sending the first reminder be send by email - when their status_id = 9
	function listTestsStatus9To10()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee'
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie','Evaluation.status_date', 'Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id'),
				'conditions' =>  array('Evaluation.status_id' => 9, 'Evaluation.sent' => 0)
				));			
	}
	############################################################################################################################################
	################################################# Statuses change 10 to 11 #############################################################################
	// For status = 10 to status = 11 change, it returns the list of evaluations-tests that will change status 
	// before sending the second reminder be send by email - when their status_id = 10
	function listTestsStatus10To11()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee'
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie','Evaluation.status_date','Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id'),
				'conditions' =>  array('Evaluation.status_id' => 10, 'Evaluation.sent' => 1)
				));			
	}
	############################################################################################################################################
	############################################################################################################################################
	################################################# Statuses change 11 to 12 #############################################################################
	// For status = 11 to status = 12 change, it returns the list of evaluations-tests that will change status 
	// before sending the third reminder be send by email - when their status_id = 10
	function listTestsStatus11To12()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee'
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie','Evaluation.status_date','Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id'),
				'conditions' =>  array('Evaluation.status_id' => 11, 'Evaluation.sent' => 1)
				));			
	}
	############################################################################################################################################
	############################################################################################################################################
	//new reads as : returns the list of evaluations-tests that will be send by email - when their status_id = 10 (1st reminder) or 11 (2nd reminder).
	//see conditions line 388. This function will be called by the email shell on the main() execution.
	#####################FIRST REMINDER##########################
	function listTestsToSendEmailFirstRem()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee',
						'Customer'//here
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie', 'Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id','Customer.name'),//fields added here
				//old line for 2 reminders
				//'conditions' =>  array('Evaluation.status_id' => array (10,11), 'Evaluation.sent' => array (0,1)) 
				'conditions' =>  array('Evaluation.status_id' => 10, 'Evaluation.sent' => 0)
				));			
	}
	#####################SECOND REMINDER##########################
	function listTestsToSendEmailSecRem()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee',
						'Customer'//here
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie', 'Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id','Customer.name'),//fields added here
				//old line for 2 reminders			
				//'conditions' =>  array('Evaluation.status_id' => array (10,11), 'Evaluation.sent' => array (0,1)) 
				'conditions' =>  array('Evaluation.status_id' => 11, 'Evaluation.sent' => 1)
				));			
	}
		#####################THIRD REMINDER##########################
	function listTestsToSendEmailThirdRem()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee',
						'Customer'//here
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie', 'Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id','Customer.name'),//fields added here
				//old line for 2 reminders			
				//'conditions' =>  array('Evaluation.status_id' => array (10,11), 'Evaluation.sent' => array (0,1)) 
				'conditions' =>  array('Evaluation.status_id' => 12, 'Evaluation.sent' => 1)
				));			
	}
	#####################CANCELLATION AFTER THE SECOND REMINDER-GATHERS ALL EVALUATIONS TO BE CANCELLED-CALLED BY CANCELLATION SHELL##########################
	function listTestsToCancel()
	{
		return $this->find('all', array(
				'link' => array(
					'Order' => array(
						'Employee',
						'Customer'//here
						)
				),
				'fields' => array('Evaluation.id','Evaluation.test_serie','Evaluation.status_date', 'Evaluation.last_test', 'Evaluation.status_id', 'Evaluation.tokenhash', 
							'Employee.id', 'Employee.first_name','Employee.last_name','Employee.email','Employee.gender','Employee.date_birth',
							'Employee.langue','Employee.customer_id','Customer.name'),//fields added here
				//old line for 2 reminders			
				//'conditions' =>  array('Evaluation.status_id' => array (10,11), 'Evaluation.sent' => array (0,1)) 
				'conditions' =>  array('Evaluation.status_id' => 12, 'Evaluation.sent' => 0)
				));			
	}

	# returns the Service-Order information
	function infoServorderDSP($evaluation_id)
	{
		return $this->find('all', array(
				'link' => array(
					'Service' => array(
						'QuestionnairesService' => array(
													'Questionnaire' => array('conditions' => 'QuestionnairesService.questionnaire_id  = Questionnaire.id'),
													'conditions' => 'Service.id  = QuestionnairesService.service_id'
													),
						'conditions' => 'Service.id  = Evaluation.service_id'
							)
						),
				'fields' => array('Evaluation.order_id','Service.id','Service.name'),			
				'conditions' =>  array('Evaluation.id' => $evaluation_id, 'Questionnaire.type_q' => 'DSP'),
				'order' => array('Questionnaire.id ASC')
			));						
			
	}			
	
	################################################################################
	#   Get the 	 Last DSP information										   #
	#   Used in the Dr. Letter - Follow up  = 1	                        		   #
	################################################################################
	function getLastEvalOrd($eval_id, $test_serial)
	{
		$test_serial = $test_serial - 1;
		$Orderid = $this->find('first', array('contain' => array('Order'),
											'fields' => array('Order.id','Order.order_code'),					
											'conditions' =>  array('Evaluation.id' => $eval_id))
								);	
		return $this->find('first', array('contain' => array('Order'),
										'fields' => array('Evaluation.id', 'Evaluation.status_id'),
										'conditions' =>  array('Evaluation.order_id' => $Orderid['Order']['id'], 'Evaluation.status_id' => 13, 'Evaluation.test_serie' => $test_serial))
								);					
	}
	
	################################################################################
	#   Get the Before Last DSP information										   #
	#   Used in the Dr. Letter - Follow up > = 2                        		   #
	################################################################################
	function getBeforeLastEvalOrd($eval_id, $test_serial)
	{
		$test_serial = $test_serial - 2;
		$Orderid = $this->find('first', array('contain' => array('Order'),
											'fields' => array('Order.id','Order.order_code'),					
											'conditions' =>  array('Evaluation.id' => $eval_id))
								);	
		return $this->find('first', array('contain' => array('Order'),
										'fields' => array('Evaluation.id', 'Evaluation.status_id'),
										'conditions' =>  array('Evaluation.order_id' => $Orderid['Order']['id'], 'Evaluation.status_id' => 13, 'Evaluation.test_serie' => $test_serial))
								);					
	}
	
	# returns last 10 open Orders
	function userTestByStatus($week, $month_test, $year_test, $type)
	{			
		if ($type == 1) {

			$date_week = '';
			$date_week0 = '';

			$date_week = $year_test.'-'.$month_test.'-'.$week;
						
			$dateReq = strtotime('-1 week', strtotime($date_week));
			
			$date_week0 = date('Y-m-d', $dateReq);
			
			return $this->find('all', array(
					'link' => array(
								'Status',
								'Order' => array('Customer')
					),
					'fields' => array(
								'Customer.id','Customer.name',
								'COUNT(Evaluation.id) AS nbrTest', 'if(Evaluation.test_serie > 1, 9, 1)  as test_serie'),
					'conditions' => array(
									'Evaluation.status_id' => array(7, 10, 11, 13, 14, 15, 16, 18),  					
									'Evaluation.status_date BETWEEN ? AND ?' => array($date_week0,$date_week)
							),
					'group'=>array('Customer.id', 'Evaluation.test_serie'),
					'order' => 'Customer.id DESC'
				));	
		} elseif ($type == 2) {
		
			return $this->find('all', array(
					'link' => array(
								'Status' => array('fields' => array('Status.id','Status.name_eng')),
								'Order' => array('Customer' => array('fields' => array('Customer.id','Customer.name'))											
									)),
					'fields' => array('COUNT(Evaluation.id) AS nbrTest', 'if(Evaluation.test_serie > 1, 9, 1)  as test_serie'),
					'conditions' => array(
								'Evaluation.status_id' => array(7, 10, 11, 13, 14, 15, 16, 18),  
								'YEAR(Evaluation.status_date)' => $year_test,
								'MONTH(Evaluation.status_date)' => $month_test
							),
					'group'=> array('Evaluation.status_id', 'Evaluation.test_serie', 'Customer.id'),
					'order' => 'Customer.id ASC'
				));			
		
		} elseif ($type == 3) {
		
			return $this->find('all', array(
					'link' => array(
								'Status' => array('fields' => array('Status.id','Status.name_eng')),
								'Order' => array('Customer' => array('fields' => array('Customer.id','Customer.name'))											
								)),
					'fields' => array('COUNT(Evaluation.id) AS nbrTest', 'if(Evaluation.test_serie > 1, 9, 1)  as test_serie'),
					'conditions' => array(
								'Evaluation.status_id' => array(7, 10, 11, 13, 14, 15, 16, 18),  	
								'YEAR(Evaluation.status_date)' => $year_test
							),
					'group'=> array('Evaluation.status_id', 'Evaluation.test_serie', 'Customer.id'),
					'order' => 'Customer.id ASC'
				));				
		//array(7, 13, 14, 15),  
		}		

	}	
	
	function beforeSave($opt=[]) {
		if(empty($this->id)){
		#### INSERT ####
		##### email validation	 
			# if the type of communication is Email 
			# Controlled by jquery in the EDIT Form			
			if ($this->data['Evaluation']['communication_id'] == 1) {
				$this->data['Evaluation']['status_id'] = 9;
			}
			if ($this->data['Evaluation']['communication_id'] == 2){			
			  #  The Quest will be send by Mail - status test = Pend. to send out Quest.		
				$this->data['Evaluation']['status_id'] = 8;
			}	 
			
			##### Check if an Order Code is alreadey assigned
			if (isset($this->data['Evaluation']['order_id'])) {
				# Followup - it exists an Order Code
			}else{
				# First Order - Evaluation Not previous Order Code
				$this->data['Evaluation']['order_id'] = $this->Order->id;
			}				
			 
			##### set todays date to 'status_date' 
			$today = date('Y-m-d', time());	
			$this->data['Evaluation']['status_date'] = $today;
			 
			##### set the order_serie on Evaluation table
			$ordevInfo = $this->countEval($this->data['Evaluation']['order_id']);
			
			if($ordevInfo == 0){ 
				# 1st Evaluation
				$this->data['Evaluation']['test_serie'] = 1;		
			}else{			
				# Follow up	 
				$this->data['Evaluation']['test_serie'] = $this->data['Evaluation']['new_test_serie'];
			}
		}else{
			//echo 'beforeSave';
			#### UPDATE ####
			##### set todays date to 'status_date' 
			$today = date('Y-m-d', time());	
			$this->data['Evaluation']['status_date'] = $today;
		}
		return true;
	}
	
	function afterSave($created) {	
		if($created) {
		### When an Insert is made
			# New Order and New-First Evaluation-Test
			if (($this->data['Evaluation']['last_id'] == 0)){			


			}else{
				# Follow-up - There already exists an Order - just creating a New-Evaluation and Updating the Last One, field Last_test
				$this->id = $this->data['Evaluation']['last_id'];
				$this->saveField('last_test', 0);
			}
			
		}else{
		### When an Update is made	
			
			
		}
		return true;
	}	
		
}
?>