<?php
class Question extends AppModel {
	var $name = 'Question';
	

	var $belongsTo = array(
		'Questionnaire' => array(
			'className' => 'Questionnaire',
			'foreignKey' => 'questionnaire_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);
	
	var $hasMany = array(
		'Choice' => array(
			'className' => 'Choice',
			'foreignKey' => 'question_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);
	
	function infoquestionallchoices($questionnaire_id)
	{
		return $this->find('all', 
								array(
									'contain' => array(
											'Choice' => array(
												'ChoiceSecondary' => array(
															'FrequencyList',
															'order' => 'ChoiceSecondary.id ASC'))
														),
									'conditions' => array('Question.questionnaire_id' => $questionnaire_id)					
									)
							);									
	}
	
	
	function infoCriticalquestion($questionnaire_id) {
		return $this->find('all', 
								array(
									'conditions' => array('Question.questionnaire_id' => $questionnaire_id),
									'contain' => false,
									'fields' => array('id','critical', 'noquestion', 'abbrv_eng', 'abbrv_fre', 'desc_eng', 'desc_fre', 'active'
												)
									)
							);				
	}	
	
	function infoHsqDepressionquestion($questionnaire_id) {
		return $this->find('all', 
								array(
									'conditions' => array('Question.questionnaire_id' => $questionnaire_id, 
														'Question.noquestion' => array(37,38,39)
														),
									'contain' => false,
									'fields' => array('id','noquestion', 'desc_eng', 'desc_fre', 'active'
												)
									)
							);				
	}	
}
?>