<?php
class Questionnaire extends AppModel {
	var $name = 'Questionnaire';
	var $displayField = 'name';
	//The Associations below have been created with all possible keys, those that are not needed can be removed
/*
	public $hasAndBelongsToMany = array(
		'Service' => array(
			'className' => 'Service',
			'joinTable' => 'questionnaires_services',
			'foreignKey' => 'questionnaire_id',
			'associationForeignKey' => 'service_id',
			'unique' => true,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		)
	); */
	
	public $hasMany = array(
		'Question' => array(
			'className' => 'Question',
			'foreignKey' => 'questionnaire_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'DspScore' => array(
			'className' => 'DspScore',
			'foreignKey' => 'questionnaire_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'QuestionnaireTreatment' => array(
			'className' => 'QuestionnaireTreatment',
			'foreignKey' => 'questionnaire_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'HsqScore' => array(
			'className' => 'HsqScore',
			'foreignKey' => 'questionnaire_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)		
		);
		
		
	### Get all the questions from a specific Questionnaire for a specific language
	function infoquestion($questionnaire_id)
	{			
		return $this->find('all', array(
				'link' => array(
					'Question'
					),
				'fields' => array('Question.noquestion'),
				'conditions' =>  array('Questionnaire.id' => $questionnaire_id),
				'order' => array('Question.noquestion ASC')
			));	
							
	}


	### Get all the questions/ choices / secondary choices from a specific Questionnaire
	#	
	function infoquestionchoices($questionnaire_id)
	{
		return $this->find('all', array(
				'link' => array(
							'Question' => array(
										'Choice' => array(
													'conditions' => 'Question.id  = Choice.question_id')
										)
								),
				'fields' => array('Question.noquestion'),
				'conditions' =>  array('Questionnaire.id' => $questionnaire_id),
				'order' => array('Question.noquestion, Choice.nochoice  ASC')
			));								
	}

	
	
	### Get all the questionnaires associated to a specific Service
	#	
	function infoquestservice($service_id)
	{	
		return $this->find('list', 
			array(
				'link' => array(
					'QuestionnairesService' => array(
						'conditions' => 'QuestionnairesService.questionnaire_id = Questionnaire.id'
//						'fields' => array('QuestionnairesService.questionnaire_id')
						)
					),
				'fields' => array('QuestionnairesService.questionnaire_id', 'Questionnaire.name'),
				'conditions' =>  array('QuestionnairesService.service_id' => $service_id)
//				'order' => array('Questionnaire.id ASC')
				)
			);								
	}	
	
}
?>