<?php
class QuestionnaireTreatment extends AppModel {

	var $name = 'QuestionnaireTreatment';
//	var $displayField = 'name';

	public $hasMany = array(
		'TherapyTreatment' => array(
			'className' => 'TherapyTreatment',
			'foreignKey' => 'questionnaire_treatment_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'MedicationTreatment' => array(
			'className' => 'MedicationTreatment',
			'foreignKey' => 'questionnaire_treatment_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)	
	);	
	
	var $belongsTo = array(
		'Evaluation' => array(
			'className' => 'Evaluation',
			'foreignKey' => 'evaluation_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Questionnaire' => array(
			'className' => 'Questionnaire',
			'foreignKey' => 'questionnaire_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)		
	);
	
	# Validate if there is already a QuestionnaireTreatment Score
	function countTreatQ($eval_id) {
		return $this->find('count', array('conditions' => array('QuestionnaireTreatment.evaluation_id' => $eval_id)));
	}	
	
	###################################################################################
	# Get the Treatment Quest values scales from an specific Evaluation-Test
	###################################################################################
	function infoTreatQuest($eval_id) {
	
		return $this->find('all', array(
				'contain' => array(
					'TherapyTreatment',
					'MedicationTreatment' => array(
						'Drug' => array(
							'conditions' => 'MedicationTreatment.drug_id  = Drug.id')
						)
				),
				'fields' => array('QuestionnaireTreatment.id', 'QuestionnaireTreatment.type_q', 'QuestionnaireTreatment.treatment',
							'QuestionnaireTreatment.nonprescrip_compounds', 'QuestionnaireTreatment.nonprescrip_compounds_name', 
							'QuestionnaireTreatment.side_effects', 'QuestionnaireTreatment.side_effects_list', 'QuestionnaireTreatment.custome_side_effect',
							'QuestionnaireTreatment.taking_meds_list', 'QuestionnaireTreatment.stoping_drugs', 'QuestionnaireTreatment.psychotherapy', 
							'QuestionnaireTreatment.choice_secondary_id', 'QuestionnaireTreatment.questionnaire_id', 'QuestionnaireTreatment.created'),			
				'conditions' =>  array('QuestionnaireTreatment.evaluation_id' => $eval_id)
			));	
	}

	function infoTreatQuest0($eval_id) {
	
		return $this->find('first', array('conditions' => array('QuestionnaireTreatment.evaluation_id' => $eval_id),
									'fields' => array('QuestionnaireTreatment.id', 'QuestionnaireTreatment.type_q', 'QuestionnaireTreatment.treatment',
									'QuestionnaireTreatment.nonprescrip_compounds', 'QuestionnaireTreatment.nonprescrip_compounds_name', 
									'QuestionnaireTreatment.side_effects', 'QuestionnaireTreatment.side_effects_list', 'QuestionnaireTreatment.custome_side_effect',
									'QuestionnaireTreatment.taking_meds_list', 'QuestionnaireTreatment.stoping_drugs', 'QuestionnaireTreatment.psychotherapy', 
									'QuestionnaireTreatment.choice_secondary_id', 'QuestionnaireTreatment.questionnaire_id', 'QuestionnaireTreatment.created')
								)
							);						
	}

	
	#############################################################################################
	# Get an Interpretation Array of the Treatment Questionnaire Score							#
	# Doctor's Letter																			#
	#############################################################################################	
	function interpDoctorLetter($eval_id, $test_serie,$language) 	
	{
		# Initializing values
		$HighScalesN = array();
		$DrInterpsCodeN = array();
		$DrInterpsCodeP = array();
		$DrInterpsCodePnew = array();
		$DrInterpsMeds = array();
		$DrInterpsStoppedMeds= array();
		$texteDocGsection = array();
		$texteDocPsection = array();
		
		$texteRefsSection = array();
		
		$DspVal = 0;	
		$countAntidep = 0;
		$ref138 = 0;
		$ref153 = 0;
		$refCita = 0;
		$check26 = false;
		//$refQueti = 0;
		$strcode23 = '';
		$strcode30 = '';
		
		$infoLastDsp = array();
		$DrInterpsCode = array();
		$DrPharmCodeAll = array();
		$DrPharmCode = array();	
		$stoppedmedsname = array();	
		$infoBeforeLastDsp = array();
		
		$ImprovPercent = 0;		
		
		if ($language == 1) {
		# Ingles
			$field_language = 'int_eng';
			$field_temp = 'name_eng';
			$ms_temp = 'The usual dose range for #Mx is #dx.';
			$ad_temp = 'The usual antidepressant dose range for #Mx is #dx.';
			$sc_temp = 'The respondant reports being on #SC. The total dose for this medication is #s1 mg/day.';
		} else {
		# Spanish
			$field_language = 'int_fre';
			$field_temp = 'name_fre';
			$ms_temp = 'La dosis habitual de #Mx es de #dx.';
			$ad_temp = 'La dosis habitual del antidepresivo #Mx es de #dx.';			
			$sc_temp = 'El encuestado reporta tomar #SC. La dosis total de este medicamento es de #s1 mg/dia.';
		}			
		
		#=========================================================================
		# Get the DSP values scales from an specific Evaluation-Test
		$infoEvalScaleDsp = $this->Evaluation->DspScore->infoCurrentDsp($eval_id);			
		
		#===============================================================
		# Get the Treatment Quest values scales from an specific Evaluation-Test
		$infoTreatQuest = $this->infoTreatQuest($eval_id);
		//echo pr($infoTreatQuest);
		$R5R6Current = 0;
		$R5R6Last = 0;
		#====== INITIAL TEST =======
		if ($test_serie == 1) {
		
			## Check IF RULE 5 / RULE 6  APPLIED FOR THE CURRENT TEST ##	
			$R5R6Current = $this->checkRule5Rule6($infoEvalScaleDsp);			
				
			#=====  GENERAL LETTER SECTION  =====
			$DrInterpsCodeAll  = $this->generalLetterSection($infoEvalScaleDsp, $infoLastDsp, $test_serie, 0, $infoTreatQuest, $field_temp, array($R5R6Current, $R5R6Last));

			# Main Codes - Geneal section
			$DrInterpsCodeN  = $DrInterpsCodeAll[0];
			sort($DrInterpsCodeN);
			
			# High scales - with elevations
			$HighScalesN = $DrInterpsCodeAll[1];			
			
			# Therapy - Section
			$generalChaine  = $DrInterpsCodeAll[2];		
			
			#=====  PHARMAÉLITE LETTER SECTION  =====
			$DrPharmCodeAll  = $this->pharmLetterSection($infoTreatQuest, $infoEvalScaleDsp, $infoLastDsp, $ImprovPercent, $field_temp, $test_serie, 0, array($R5R6Current, $R5R6Last));		
			
			//echo pr($DrPharmCodeAll);
			
			# Main Codes - Pharm section 
			$DrInterpsCodeP = $DrPharmCodeAll[0];
			$refCita = $DrPharmCodeAll[2];
			//$refQueti = $DrPharmCodeAll[3];
			
			# DSP value for the CURRENT test
			$DspVal = $infoEvalScaleDsp['DspScore']['DEP'];
			
			# StoppedMeds 
			$DrInterpsStoppedMeds = $DrPharmCodeAll[1];
			
			# Reformatting the array for the search of the text letters code
			for ($j=0; $j < count($DrInterpsCodeP); $j++) {
				$DrInterpsCodePnew = array_merge($DrInterpsCodePnew, array($DrInterpsCodeP[$j]['id']));
			}
			
			# HighScales
			if (!empty($HighScalesN)) {
				$highScaleNameTexte = '';
				$jointexte = '';
				$nbrHighScales = count($HighScalesN);
				for ($i=0; $i < $nbrHighScales; $i++) {					
					//avant dernier scale
					if ($i == ($nbrHighScales - 2)) {						
						if ($language == 1) { $jointexte = ' and '; }
						if ($language == 0) { $jointexte = ' et '; }
					} elseif ($i != ($nbrHighScales - 1)) {
						$jointexte = ', ';
					}	
					$highScaleNameTexte .= $HighScalesN[$i]['scale'].$jointexte;
					if ($nbrHighScales == 1 && $DspVal < 60) { 
						//change the assigned value to DSP if it is < 60
						$DspVal = $HighScalesN[$i]['value'];
					}
					$jointexte = '';
				}
			}
		} elseif ($test_serie > 1) {
		###### FOLLOW UP ######				
			
			##########################################################
			# Get the DSP values GI scale from an specific last Evaluation-Test (Previous)
			$infoLastDsp = $this->Evaluation->DspScore->infoLastDsp($eval_id, $test_serie);

			if ($test_serie >= 3) {
				##########################################################
				# Get the DSP values GI scale from an specific last Evaluation-Test (BEFORE Previous)
				$infoBeforeLastDsp = $this->Evaluation->DspScore->infoBeforeLastDsp($eval_id, $test_serie);			
			}
			## Check IF RULE 5 / RULE 6  APPLIED FOR THE CURRENT TEST ##	
			$R5R6Current = $this->checkRule5Rule6($infoEvalScaleDsp);
			
			## Check IF RULE 5 / RULE 6  APPLIED FOR THE LAST TEST ##		
			$R5R6Last = $this->checkRule5Rule6($infoLastDsp);			
			
			####  GENERAL LETTER SECTION  ####				
			$DrInterpsCodeAll  = $this->generalLetterSection($infoEvalScaleDsp, $infoLastDsp, $test_serie, 1, $infoTreatQuest, $field_temp, array($R5R6Current, $R5R6Last));

			# Improvement
			$Improvement = $this->improvCalcul($infoEvalScaleDsp['DspScore']['DEP'], $infoLastDsp['DspScore']['DEP']);
			# General section
			
			$DrInterpsCodeN  = $DrInterpsCodeAll[0];
			sort($DrInterpsCodeN);
			
			# General section - GRDVal
			//$GRDVal  = $DrInterpsCodeAll[1];
			# General section - Therapy
			$generalChaine  = $DrInterpsCodeAll[2];		
			
			####  PharmÃ‰lite LETTER SECTION  ####					
			$DrPharmCodeAll  = $this->pharmLetterSection($infoTreatQuest, $infoEvalScaleDsp, $infoLastDsp, $Improvement, $field_temp, $test_serie, 1, array($R5R6Current, $R5R6Last));
			
			# Pharm section 
			$DrInterpsCodeP = $DrPharmCodeAll[0];				
			$refCita = $DrPharmCodeAll[1];	
			//$refQueti = $DrPharmCodeAll[2];
			
			# DSP value
			$DspVal = $infoEvalScaleDsp['DspScore']['DEP'];
			# DSP last value 
			$DspValLast = $infoLastDsp['DspScore']['DEP'];	
			 
			# Reformatting the array for the search of the text letters code
			for ($j=0; $j < count($DrInterpsCodeP); $j++) {
				$DrInterpsCodePnew = array_merge($DrInterpsCodePnew, array($DrInterpsCodeP[$j]['id']));
			}		
		}			

		##==========================================================	
		## Getting the text letter  ##
		App::import('Model','DoctorInterp');
		$this->DoctorInterp = new DoctorInterp(); 
		$listDoctorInterp = $this->DoctorInterp->find('all', array(
										'conditions' => array('DoctorInterp.id' => array_merge($DrInterpsCodeN,$DrInterpsCodePnew, array(23, 180,181,182))),
										'fields' => array('id',$field_language,'section'),
										'order' => 'id ASC'));
		
			$DSPdescrip = $this->DoctorInterp->find('list', array(
										'conditions' => array('DoctorInterp.id' => array(170,171,172,173,174,175,176,177,178,179)),
										'fields' => array('id',$field_language),
										'order' => 'id ASC'));
										
		# Getting the text values for the DEP level
		if ($DspVal > 59 && $DspVal < 65) {
			$texteDsp = $DSPdescrip[170];
			$texteScale = $DSPdescrip[175];
		} elseif ($DspVal > 64 && $DspVal < 70) {
			$texteDsp = $DSPdescrip[171];
			$texteScale = $DSPdescrip[176];
		} elseif ($DspVal > 69 && $DspVal < 85) {
			$texteDsp = $DSPdescrip[172];
			$texteScale = $DSPdescrip[177];
		} elseif ($DspVal > 84 && $DspVal < 105) {
			$texteDsp = $DSPdescrip[173];
			$texteScale = $DSPdescrip[178];
		} elseif ($DspVal > 104) {
			$texteDsp = $DSPdescrip[174];
			$texteScale = $DSPdescrip[179];
		}		
		
		# Creating the "TEXT" array for the letter
		foreach ($listDoctorInterp as $doctorInterp):
			### General Section
			if ($doctorInterp['DoctorInterp']['section'] == 'G') {				
				if ($doctorInterp['DoctorInterp']['id'] == 1 || $doctorInterp['DoctorInterp']['id'] == 2 || $doctorInterp['DoctorInterp']['id'] == 3 || 
					$doctorInterp['DoctorInterp']['id'] == 4 || $doctorInterp['DoctorInterp']['id'] == 5 || $doctorInterp['DoctorInterp']['id'] == 6 ||
					$doctorInterp['DoctorInterp']['id'] == 7 || $doctorInterp['DoctorInterp']['id'] == 8) {
					$texteDocGsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $doctorInterp['DoctorInterp'][$field_language]));
				} elseif ($doctorInterp['DoctorInterp']['id'] == 9)   {
					$texte = str_replace('#1', $highScaleNameTexte, $doctorInterp['DoctorInterp'][$field_language]);
					$texte = str_replace('#2', $texteScale, $texte);
					if (empty($texteDocGsection)) {
						$texteDocGsection = array_merge(array($texteDocGsection), array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));
					} elseif (!empty($texteDocGsection)) {
						$texteDocGsection = array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));
					}
				} elseif ($doctorInterp['DoctorInterp']['id'] == 10)   {
					$texte = str_replace('#', $highScaleNameTexte, $doctorInterp['DoctorInterp'][$field_language]);
					if (empty($texteDocGsection)) {
						$texteDocGsection = array_merge(array($texteDocGsection), array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));						
					} elseif (!empty($texteDocGsection)) {
						$texteDocGsection = array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));						
					}
				} elseif ($doctorInterp['DoctorInterp']['id'] == 11)   {
					$texte = str_replace('#', $texteDsp, $doctorInterp['DoctorInterp'][$field_language]);
					$texteDocGsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte));
				} elseif ($doctorInterp['DoctorInterp']['id'] == 12)   {
					$texte1 = str_replace('#1', $texteDsp, $doctorInterp['DoctorInterp'][$field_language]);
					$texte = str_replace('#2', $highScaleNameTexte, $texte1);
					$texteDocGsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte));
				}  elseif($doctorInterp['DoctorInterp']['id'] == 13) {
					$texte = str_replace('#', $DrInterpsCodeAll[1], $doctorInterp['DoctorInterp'][$field_language]);
					$texteDocGsection =  array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));
				} elseif ($doctorInterp['DoctorInterp']['id'] == 15 || $doctorInterp['DoctorInterp']['id'] == 17 || $doctorInterp['DoctorInterp']['id'] == 18 || 
					$doctorInterp['DoctorInterp']['id'] == 19 || $doctorInterp['DoctorInterp']['id'] == 20 || $doctorInterp['DoctorInterp']['id'] == 21) {
					$texteDocGsection = array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $doctorInterp['DoctorInterp'][$field_language])));
				} elseif ($doctorInterp['DoctorInterp']['id'] == 14)   {
					$texte = str_replace('#', $DrInterpsCodeAll[3], $doctorInterp['DoctorInterp'][$field_language]);
					$texteDocGsection =  array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));
				} elseif ($doctorInterp['DoctorInterp']['id'] == 16)   {
					$texte1 = str_replace('#DEP', $DspVal, $doctorInterp['DoctorInterp'][$field_language]);
					$texte = str_replace('#', $texteDsp, $texte1);
					if (empty($texteDocGsection)) {
						$texteDocGsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte));
					} elseif (!empty($texteDocGsection)) {
						$texteDocGsection = array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));
					}					
				} elseif ($doctorInterp['DoctorInterp']['id'] == 22)   {
					$texte = str_replace('#', $generalChaine, $doctorInterp['DoctorInterp'][$field_language]);
					$texteDocGsection =  array_merge($texteDocGsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'G', 'texte' => $texte)));
				}
			} elseif ($doctorInterp['DoctorInterp']['section'] == 'P') {
				if ($doctorInterp['DoctorInterp']['id'] == 23) {
					if ($refCita == 1) { $strcode23 = $doctorInterp['DoctorInterp'][$field_language].'*'; }							
				} 				
				### PharmÉlite Section	
				for ($j=0; $j < count($DrInterpsCodeP); $j++) {
					if ($DrInterpsCodeP[$j]['id'] == $doctorInterp['DoctorInterp']['id'])  {
					//echo 'BEFORE $texteDocPsection : ';
					//echo pr($texteDocPsection);
						if ($doctorInterp['DoctorInterp']['id'] == 26) {
							$SCranges = array();
							$SCnames = array();							
							$SCnames = explode("/", $DrInterpsCodeP[$j]['text0']);							
							$SCranges = explode("/", $DrInterpsCodeP[$j]['text1']);							
							$texte = str_replace('#SC', $SCnames[0], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#s1', $SCranges[0], $texte);							
							
							$sc_temp0 = '';
							$sc_tempn = '';							
							for ($m=1; $m < count($SCranges); $m++)  {
								$sc_temp0 = str_replace('#s1', $SCranges[$m], $sc_temp);
								$sc_tempn .= str_replace('#SC', $SCnames[$m], $sc_temp0);
							}
							$texte = str_replace('#h', $sc_tempn, $texte);
							$check26 = true;
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 27 || $doctorInterp['DoctorInterp']['id'] == 28 || $doctorInterp['DoctorInterp']['id'] == 29) {
						
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							if ($check26) {
								$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
							} else {
								$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
							}							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 30) {	
/*
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 30, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose))));
*/						
//echo $DrInterpsCodeP[$j]['text0'];
							$ADdosenames = array();
							$ADranges = array();
							$ADnames = array();							
							$ADdosenames = explode(",", $DrInterpsCodeP[$j]['text0']);
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							$texte = str_replace('#AA', $ADdosenames[0], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);							
							$texte = str_replace('#AB', $ADdosenames[1], $texte);
							$texte = str_replace('#A2', $ADnames[1], $texte);
							$texte = str_replace('#d2', $ADranges[1], $texte);																				
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));												
						// } elseif ($doctorInterp['DoctorInterp']['id'] == 31 || $doctorInterp['DoctorInterp']['id'] == 33) {	aaron											
						} elseif ($doctorInterp['DoctorInterp']['id'] == 33 ) {
							// var_dump($DrInterpsCodeP);
							// exit;
							$texte = str_replace('#AA', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);							
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text5'], $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));												
						} elseif ($doctorInterp['DoctorInterp']['id'] == 32 || $doctorInterp['DoctorInterp']['id'] == 34 ||
								$doctorInterp['DoctorInterp']['id'] == 121 || $doctorInterp['DoctorInterp']['id'] == 122 || 
								$doctorInterp['DoctorInterp']['id'] == 125 || $doctorInterp['DoctorInterp']['id'] == 126 || 
								$doctorInterp['DoctorInterp']['id'] == 128 || $doctorInterp['DoctorInterp']['id'] == 129 || 
								$doctorInterp['DoctorInterp']['id'] == 131 || $doctorInterp['DoctorInterp']['id'] == 132 ||
								$doctorInterp['DoctorInterp']['id'] == 136 || $doctorInterp['DoctorInterp']['id'] == 140 || 
								$doctorInterp['DoctorInterp']['id'] == 143 || $doctorInterp['DoctorInterp']['id'] == 144) {
							$texte = str_replace('#', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 35) {
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text1'], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 36 || $doctorInterp['DoctorInterp']['id'] == 38) {
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 37) {
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text1'], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 39) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 40 || $doctorInterp['DoctorInterp']['id'] == 41) {											
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							if($doctorInterp['DoctorInterp']['id'] == 40) { $texte = str_replace('#A1', $DrInterpsCodeP[$j]['text1'], $texte); }
							if($doctorInterp['DoctorInterp']['id'] == 41) { $texte = str_replace('#T1', $DrInterpsCodeP[$j]['text1'], $texte); }
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text2'], $texte);	
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text3']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text4']);
							$texte = str_replace('#d2', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 42 || $doctorInterp['DoctorInterp']['id'] == 43) {						
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							if($doctorInterp['DoctorInterp']['id'] == 42) {
								$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text1'], $texte);		
							} elseif($doctorInterp['DoctorInterp']['id'] == 43) {
								$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text1'], $texte);		
							}
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text2']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text3']);
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 44 || $doctorInterp['DoctorInterp']['id'] == 114 || 
								$doctorInterp['DoctorInterp']['id'] == 123 || $doctorInterp['DoctorInterp']['id'] == 124 || $doctorInterp['DoctorInterp']['id'] == 138) {
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 45 || $doctorInterp['DoctorInterp']['id'] == 46) {								
							$texte0 = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte0);
							$texte0 = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);							
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte0);
							$texte0 = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text5'], $texte0);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));								
						} elseif ($doctorInterp['DoctorInterp']['id'] == 47) {											
							$texte0 = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte0);
							$texte0 = str_replace('#T1', $DrInterpsCodeP[$j]['text2'], $texte);							
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte0);
							$texte0 = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text5'], $texte0);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 48 || $doctorInterp['DoctorInterp']['id'] == 49) {													
							if($doctorInterp['DoctorInterp']['id'] == 48){
								$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
								$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);	
							} elseif($doctorInterp['DoctorInterp']['id'] == 49){
								$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
								$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text2'], $texte);
							}							
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte0);
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte0);													
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							$texte0 = str_replace('#d2', $MSranges[0], $texte);
							$texte = str_replace('#M1', $Msnames[0], $texte0);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte0 = str_replace('#z', $ms_tempn, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte0)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 50 || $doctorInterp['DoctorInterp']['id'] == 52) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d3', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text5'], $texte);							
							$ADdosenames = array();
							$ADranges = array();
							$ADnames = array();							
							$ADdosenames = explode(",", $DrInterpsCodeP[$j]['text0']);
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#AA', $ADdosenames[0], $texte);
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$texte = str_replace('#AB', $ADdosenames[1], $texte);
							$texte = str_replace('#d2', $ADranges[1], $texte);
							$texte = str_replace('#A2', $ADnames[1], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 51 || $doctorInterp['DoctorInterp']['id'] == 53) {
							// var_dump( $DrInterpsCodeP);
							// exit();
							$texte = str_replace('#AA', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#TR', $DrInterpsCodeP[2]['text0'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text5'], $texte);
							$texte = str_replace('#d3', $DrInterpsCodeP[$j]['text6'], $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text7'], $texte);							
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 54) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#MM', $DrInterpsCodeP[$j]['text6'], $texte);
							$ADdosenames = array();
							$ADranges = array();
							$ADnames = array();							
							$ADdosenames = explode(",", $DrInterpsCodeP[$j]['text0']);
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#AA', $ADdosenames[0], $texte);
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$texte = str_replace('#AB', $ADdosenames[1], $texte);
							$texte = str_replace('#d2', $ADranges[1], $texte);
							$texte = str_replace('#A2', $ADnames[1], $texte);
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text5']);							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d3', $MSranges[0], $texte);
							$texte = str_replace('#M1', $Msnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);														
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 55) {
							$texte0 = str_replace('#MS', $DrInterpsCodeP[$j]['text6'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#MM', $DrInterpsCodeP[$j]['text9'], $texte0);					
							$texte = str_replace('#AA', $DrInterpsCodeP[$j]['text0'], $texte);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);							
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text5'], $texte);
							
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text7']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text8']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d3', $MSranges[0], $texte);
							$texte = str_replace('#M1', $Msnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);							
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 56) {
							$texte = str_replace('#MM', $DrInterpsCodeP[$j]['text6'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#DD', $DrInterpsCodeP[$j]['text7'], $texte);					
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $texte);	
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte);	
							
							$ADranges = array();
							$ADnames = array();		
							$MSranges = array();					
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ad_temp = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ad_temp);
								$texte = str_replace('#d2', $MSranges[0], $texte);
							}
							$texte = str_replace('#v', $ms_tempn, $texte);	
							
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d3', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 57) {						
							$texte = str_replace('#MM', $DrInterpsCodeP[$j]['text6'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#DD', $DrInterpsCodeP[$j]['text7'], $texte);					
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $texte);	
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte);	
							
							$ADranges = array();
							$ADnames = array();							
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ad_temp = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ad_temp);
							}
							$texte = str_replace('#v', $ms_tempn, $texte);	
							
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d3', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte0);		
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text8'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text9'], $texte);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text10'], $texte);						
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 58 || $doctorInterp['DoctorInterp']['id'] == 59) {						
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#N1', $DrInterpsCodeP[$j]['text5'], $texte);	
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 60) {
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#N1', $DrInterpsCodeP[$j]['text5'], $texte);							
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 61 || $doctorInterp['DoctorInterp']['id'] == 62) {						
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#NA', $DrInterpsCodeP[$j]['text6'], $texte);
							$texte = str_replace('#NN', ucfirst($DrInterpsCodeP[$j]['text6']), $texte);							
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);														
						
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte);							
							$ms_temp0 = '';
							$ms_tempn = '';
							for ($m=1; $m < count($ANranges); $m++) {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}								
							$texte = str_replace('#y', $ms_tempn, $texte);							
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 63) {
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#NA', $DrInterpsCodeP[$j]['text6'], $texte);
							$texte = str_replace('#NN', ucfirst($DrInterpsCodeP[$j]['text6']), $texte);							
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);														
						
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte);							
							$ms_temp0 = '';
							$ms_tempn = '';
							for ($m=1; $m < count($ANranges); $m++) {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}								
							$texte = str_replace('#y', $ms_tempn, $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 64 || $doctorInterp['DoctorInterp']['id'] == 66) {					
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $doctorInterp['DoctorInterp'][$field_language]);
							if($doctorInterp['DoctorInterp']['id'] == 64) {							
								$texte = str_replace('#d3', $DrInterpsCodeP[$j]['text4'], $texte);					
								$texte = str_replace('#N1', $DrInterpsCodeP[$j]['text5'], $texte);					
							}
							$ADdosenames = array();
							$ADranges = array();
							$ADnames = array();							
							$ADdosenames = explode(",", $DrInterpsCodeP[$j]['text0']);
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#AA', $ADdosenames[0], $texte);
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							
							$texte = str_replace('#AB', $ADdosenames[1], $texte);
							$texte = str_replace('#d2', $ADranges[1], $texte);
							$texte = str_replace('#A2', $ADnames[1], $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							if($doctorInterp['DoctorInterp']['id'] == 66) {							
								$ANranges = array();
								$ANnames = array();
								$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
								$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);														
							
								//The usual dose range for #Mx is #dx.
								$texte = str_replace('#d3', $ANranges[0], $texte);
								$texte = str_replace('#N1', $ANnames[0], $texte);							
								$ms_temp0 = '';
								$ms_tempn = '';
								for ($m=1; $m < count($ANranges); $m++) {
									$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
									$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
								}								
								$texte = str_replace('#y', $ms_tempn, $texte);					
							}							
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 65 || $doctorInterp['DoctorInterp']['id'] == 67) {
/*
Array
(
    [id] => 65
    [text0] => Cipralex 20 mg
    [text1] => 10-20 mg
    [text2] => Cipralex
    [text3] => CO Risperidone
    [text4] => 0.50-6 mg
    [text5] => CO Risperidone
    [text6] => Teva-Trazodone 50 mg
    [text7] => Teva-Trazodone
    [text8] => 150-300 mg
)
*/
						
						//echo 'yehhhhhh';
						//echo pr($DrInterpsCodeP[$j]);
						//echo '<br/>';							
						
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $doctorInterp['DoctorInterp'][$field_language]);
							if($doctorInterp['DoctorInterp']['id'] == 65) {							
								$texte = str_replace('#d3', $DrInterpsCodeP[$j]['text4'], $texte);					
								$texte = str_replace('#N1', $DrInterpsCodeP[$j]['text5'], $texte);					
							}	
//echo '$texte '.$texte;							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#AA', $DrInterpsCodeP[$j]['text0'], $texte);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);
							
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text6'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text8'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text7'], $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							
							if($doctorInterp['DoctorInterp']['id'] == 67) {
						
								$ANranges = array();
								$ANnames = array();
								$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
								$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);														
							
								//The usual dose range for #Mx is #dx.
								$texte = str_replace('#d3', $ANranges[0], $texte);
								$texte = str_replace('#N1', $ANnames[0], $texte);							
								$ms_temp0 = '';
								$ms_tempn = '';
								for ($m=1; $m < count($ANranges); $m++) {
									$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
									$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
								}								
								$texte = str_replace('#y', $ms_tempn, $texte);					
							}												
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 68 || $doctorInterp['DoctorInterp']['id'] == 69) {		
/*
Array
(
    [id] => 68
    [text0] => Teva-Trazodone 150 mgWellbutrin 300 mg, Cipralex 10 mg
    [text1] => 150-300 mg100-300 mg, 10-20 mg
    [text2] => Teva-TrazodoneWellbutrin, Cipralex
    [text3] => Pms-Risperidone 1 mg
    [text4] => 0.50-6 mg
    [text5] => Pms-Risperidone
    [text6] => 
    [text7] => three
)
*/						
						//echo 'yehhhhhh';
						//echo pr($DrInterpsCodeP[$j]);
						//echo '<br/>';
							$texte = str_replace('#NA', $DrInterpsCodeP[$j]['text6'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#DD', $DrInterpsCodeP[$j]['text7'], $texte);					
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $texte);	
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);	
							
							$ADranges = array();
							$ADnames = array();							
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ms_temp0);
							}
							$texte = str_replace('#v', $ms_tempn, $texte);	
							
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ANranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}
							$texte = str_replace('#y', $ms_tempn, $texte);	
							if($doctorInterp['DoctorInterp']['id'] == 69){
								$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text8'], $texte);
								$texte = str_replace('#d3', $DrInterpsCodeP[$j]['text10'], $texte);
								$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text9'], $texte);
							}	
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 70 || $doctorInterp['DoctorInterp']['id'] == 71) {
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#P1', $DrInterpsCodeP[$j]['text5'], $texte);
							$texte = str_replace('#C', $strcode23, $texte);			
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 72) {
							$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#P1', $DrInterpsCodeP[$j]['text5'], $texte);						
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 73 || $doctorInterp['DoctorInterp']['id'] == 75 ||
								$doctorInterp['DoctorInterp']['id'] == 74 || $doctorInterp['DoctorInterp']['id'] == 76) {
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text3'], $texte);
							
							$ADranges = array();
							$ADnames = array();							
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ms_temp0);
							}
							$texte = str_replace('#v', $ms_tempn, $texte);	
							
							$PAranges = array();
							$PAnames = array();
							$PAranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$PAnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $PAranges[0], $texte);
							$texte = str_replace('#P1', $PAnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($PAranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $PAranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $PAnames[$m], $ms_temp0);
							}
							$texte = str_replace('#x', $ms_tempn, $texte);		
							if($doctorInterp['DoctorInterp']['id'] == 74 || $doctorInterp['DoctorInterp']['id'] == 76) {
								$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text6'], $texte);
								$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text7'], $texte);
								$texte = str_replace('#d3', $DrInterpsCodeP[$j]['text8'], $texte);							
							}														
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 77 || $doctorInterp['DoctorInterp']['id'] == 78) {
							$texte = str_replace('#DD', $DrInterpsCodeP[$j]['text9'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $texte);
							$texte = str_replace('#NA', $DrInterpsCodeP[$j]['text11'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text6'], $texte);
							$texte = str_replace('#MM', $DrInterpsCodeP[$j]['text10'], $texte);
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte);
							
							$ADranges = array();
							$ADnames = array();							
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ms_temp0);
							}
							$texte = str_replace('#v', $ms_tempn, $texte);	

							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text5']);							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d3', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);								
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text7']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text8']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ANranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}
							$texte = str_replace('#y', $ms_tempn, $texte);		
							if($doctorInterp['DoctorInterp']['id'] == 78) {
								$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text12'], $texte);
								$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text13'], $texte);
								$texte = str_replace('#d4', $DrInterpsCodeP[$j]['text14'], $texte);							
							}
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 79 || $doctorInterp['DoctorInterp']['id'] == 80) {
							$texte = str_replace('#DD', $DrInterpsCodeP[$j]['text12'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $texte);
							$texte = str_replace('#NA', $DrInterpsCodeP[$j]['text14'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text6'], $texte);
							$texte = str_replace('#MM', $DrInterpsCodeP[$j]['text13'], $texte);
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#PP', $DrInterpsCodeP[$j]['text15'], $texte);
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text9'], $texte);
							$ADranges = array();
							$ADnames = array();							
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ms_temp0);
							}
							$texte = str_replace('#v', $ms_tempn, $texte);	
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d3', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);								
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text7']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text8']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ANranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}
							$texte = str_replace('#y', $ms_tempn, $texte);														
							$PAranges = array();
							$PAnames = array();
							$PAranges = explode(",", $DrInterpsCodeP[$j]['text10']);
							$PAnames = explode(",", $DrInterpsCodeP[$j]['text11']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d4', $PAranges[0], $texte);
							$texte = str_replace('#P1', $PAnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($PAranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $PAranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $PAnames[$m], $ms_temp0);
							}
							$texte = str_replace('#x', $ms_tempn, $texte);	
							if($doctorInterp['DoctorInterp']['id'] == 80) {
								$texte = str_replace('#TR', $DrInterpsCodeP[$j]['text16'], $texte);
								$texte = str_replace('#T1', $DrInterpsCodeP[$j]['text17'], $texte);
								$texte = str_replace('#d5', $DrInterpsCodeP[$j]['text18'], $texte);
							}
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 81 || $doctorInterp['DoctorInterp']['id'] == 82) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 83 || $doctorInterp['DoctorInterp']['id'] == 84) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);							
							$MSranges = array();
							$MSnames = array();
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text2']);							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);	
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 85) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#d2', $DrInterpsCodeP[$j]['text4'], $texte);
							$texte = str_replace('#N1', $DrInterpsCodeP[$j]['text5'], $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 86 || $doctorInterp['DoctorInterp']['id'] == 87) {
							$texte = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte);
							
							$MSranges = array();
							$MSnames = array();							
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte = str_replace('#z', $ms_tempn, $texte);	
							
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ANranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}
							$texte = str_replace('#y', $ms_tempn, $texte);														
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 88) {
							$texte0 = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text3'], $texte0);
							
							$MSranges = array();
							$MSnames = array();							
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte0 = str_replace('#d1', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte0);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte0 = str_replace('#z', $ms_tempn, $texte);	
							
							$PAranges = array();
							$PAnames = array();
							$PAranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$PAnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $PAranges[0], $texte0);
							$texte0 = str_replace('#P1', $PAnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($PAranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $PAranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $PAnames[$m], $ms_temp0);
							}
							$texte = str_replace('#x', $ms_tempn, $texte0);														
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 89) {
							$texte0 = str_replace('#MS', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text3'], $texte0);
							$texte0 = str_replace('#PA', $DrInterpsCodeP[$j]['text6'], $texte);
							
							$MSranges = array();
							$MSnames = array();							
							$MSranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$MSnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte0 = str_replace('#d1', $MSranges[0], $texte);
							$texte = str_replace('#M1', $MSnames[0], $texte0);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($MSranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $MSranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $MSnames[$m], $ms_temp0);
							}
							$texte0 = str_replace('#z', $ms_tempn, $texte);	
							
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $ANranges[0], $texte0);
							$texte0 = str_replace('#N1', $ANnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ANranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}
							$texte = str_replace('#y', $ms_tempn, $texte0);	
							
							$PAranges = array();
							$PAnames = array();
							$PAranges = explode(",", $DrInterpsCodeP[$j]['text7']);
							$PAnames = explode(",", $DrInterpsCodeP[$j]['text8']);
							
							//The usual dose range for #Mx is #dx.
							$texte0 = str_replace('#d2', $PAranges[0], $texte);
							$texte = str_replace('#P1', $PAnames[0], $texte0);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($PAranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $PAranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $PAnames[$m], $ms_temp0);
							}
							$texte0 = str_replace('#x', $ms_tempn, $texte);														
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte0)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 90 || $doctorInterp['DoctorInterp']['id'] == 91) {
						
/*
Array
(
    [id] => 90
    [text0] => Abilify 2 mg
)
*/						
						
						//echo 'yehhh';
						//echo pr($DrInterpsCodeP[$j]);
						//echo '<br/>';
						
							$texte = str_replace('#AN', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							if($doctorInterp['DoctorInterp']['id'] == 90) {
								$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
								$texte = str_replace('#N1', $DrInterpsCodeP[$j]['text2'], $texte);
							}
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 92) {
							$texte0 = str_replace('#AN', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text3'], $texte0);						
							
							$ANranges = array();
							$ANnames = array();
							$ANranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$ANnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte0 = str_replace('#d1', $ANranges[0], $texte);
							$texte = str_replace('#N1', $ANnames[0], $texte0);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ANranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ANranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $ANnames[$m], $ms_temp0);
							}
							$texte0 = str_replace('#y', $ms_tempn, $texte);	
							
							$PAranges = array();
							$PAnames = array();
							$PAranges = explode(",", $DrInterpsCodeP[$j]['text4']);
							$PAnames = explode(",", $DrInterpsCodeP[$j]['text5']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d2', $PAranges[0], $texte0);
							$texte0 = str_replace('#P1', $PAnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($PAranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $PAranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $PAnames[$m], $ms_temp0);
							}
							$texte = str_replace('#x', $ms_tempn, $texte0);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));

						} elseif ($doctorInterp['DoctorInterp']['id'] == 115 || $doctorInterp['DoctorInterp']['id'] == 116) {
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 130) {
							$texte = str_replace('#BZ', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 93) {
							$texte = str_replace('#PA', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$PAranges = array();
							$PAnames = array();
							$PAranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$PAnames = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte0 = str_replace('#d1', $PAranges[0], $texte);
							$texte = str_replace('#P1', $PAnames[0], $texte0);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($PAranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $PAranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $PAnames[$m], $ms_temp0);
							}
							$texte0 = str_replace('#x', $ms_tempn, $texte);
							$texteDocPsection = array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte0));												
						} elseif ($doctorInterp['DoctorInterp']['id'] == 97 || $doctorInterp['DoctorInterp']['id'] == 99) {
							$texte = str_replace('#Q1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texte = str_replace('#A1', $DrInterpsCodeP[$j]['text2'], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 96 || $doctorInterp['DoctorInterp']['id'] == 98 ) {	
							$texte = str_replace('#Q1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text1'], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 94 || $doctorInterp['DoctorInterp']['id'] == 100) {							
							$texte = str_replace('#ALL', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#QE', $DrInterpsCodeP[$j]['text3'], $texte);
							
							$ranges = array();
							$names = array();
							$ranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$names = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#l1', $ranges[0], $texte);
							$texte = str_replace('#L1', $names[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $names[$m], $ms_temp0);
							}
							$texte = str_replace('#q', $ms_tempn, $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						}  elseif ($doctorInterp['DoctorInterp']['id'] == 95) {
							$texte = str_replace('#ALL', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#QE', $DrInterpsCodeP[$j]['text3'], $texte);
							$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text5'], $texte);
							
							$ADranges = array();
							$ADnames = array();							
							$ADranges = explode(",", $DrInterpsCodeP[$j]['text6']);
							$ADnames = explode(",", $DrInterpsCodeP[$j]['text7']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#d1', $ADranges[0], $texte);
							$texte = str_replace('#A1', $ADnames[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ADranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ADranges[$m], $ad_temp);
								$ms_tempn .= str_replace('#Mx', $ADnames[$m], $ms_temp0);
							}
							//echo '$ms_tempn '.$ms_tempn;
							$texte = str_replace('#v', $ms_tempn, $texte);	
							
							$ranges = array();
							$names = array();
							$ranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$names = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#l1', $ranges[0], $texte);
							$texte = str_replace('#L1', $names[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $names[$m], $ms_temp0);
							}
							$texte = str_replace('#q', $ms_tempn, $texte);
							$texte = str_replace('#M1', $DrInterpsCodeP[$j]['text4'], $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 101 || $doctorInterp['DoctorInterp']['id'] == 105 || $doctorInterp['DoctorInterp']['id'] == 107) {							
							$texte = str_replace('#Q1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 109) {							
							$texte = str_replace('#ALL', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#QE', $DrInterpsCodeP[$j]['text3'], $texte);
							
							$ranges = array();
							$names = array();
							$ranges = explode(",", $DrInterpsCodeP[$j]['text1']);
							$names = explode(",", $DrInterpsCodeP[$j]['text2']);
							
							//The usual dose range for #Mx is #dx.
							$texte = str_replace('#l1', $ranges[0], $texte);
							$texte = str_replace('#L1', $names[0], $texte);
							$ms_temp0 = '';
							$ms_tempn = '';							
							for ($m=1; $m < count($ranges); $m++)  {
								$ms_temp0 = str_replace('#dx', $ranges[$m], $ms_temp);
								$ms_tempn .= str_replace('#Mx', $names[$m], $ms_temp0);
							}
							$texte = str_replace('#q', $ms_tempn, $texte);
							$texte = str_replace('#C', $strcode23, $texte);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 103) {
							$texte = str_replace('#QE', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);						
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));	
						} elseif ($doctorInterp['DoctorInterp']['id'] == 104 || $doctorInterp['DoctorInterp']['id'] == 106 ||
								$doctorInterp['DoctorInterp']['id'] == 108) {
							$texte = str_replace('#Q1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);						
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));	
						} elseif ($doctorInterp['DoctorInterp']['id'] == 110) {
							$texte = str_replace('#Q1', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texte = str_replace('#d1', $DrInterpsCodeP[$j]['text1'], $texte);								
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));								
						} elseif ($doctorInterp['DoctorInterp']['id'] == 111 || $doctorInterp['DoctorInterp']['id'] == 112) {
							$texte = str_replace('#DO', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));				
						} elseif ($doctorInterp['DoctorInterp']['id'] == 113) {
							$texte = str_replace('#QE', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));
						} elseif ($doctorInterp['DoctorInterp']['id'] == 149 || $doctorInterp['DoctorInterp']['id'] == 150 || $doctorInterp['DoctorInterp']['id'] == 151)   {
							$texte0 = str_replace('#1', $DspValLast, $doctorInterp['DoctorInterp'][$field_language]);
							$texte1 = str_replace('#2', $DspVal, $texte0);
							$texte = str_replace('#3', $Improvement.'%', $texte1);
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));														
						} elseif ($doctorInterp['DoctorInterp']['id'] == 152  || $doctorInterp['DoctorInterp']['id'] == 159 || 
								$doctorInterp['DoctorInterp']['id'] == 160)   {							
							if($doctorInterp['DoctorInterp']['id'] == 159 || $doctorInterp['DoctorInterp']['id'] == 160) {
								$texte = str_replace('#AD', $DrInterpsCodeP[$j]['text0'], $doctorInterp['DoctorInterp'][$field_language]);	
							} else {
								$texte = $doctorInterp['DoctorInterp'][$field_language];
							}
							$texte = str_replace('#', $Improvement.'%', $texte);
							$texteDocPsection =  array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $texte)));							
						} elseif ($doctorInterp['DoctorInterp']['id'] == 24 || $doctorInterp['DoctorInterp']['id'] == 25 || 						
								$doctorInterp['DoctorInterp']['id'] == 117 || $doctorInterp['DoctorInterp']['id'] == 118 || 
								$doctorInterp['DoctorInterp']['id'] == 119 || 					  																
								$doctorInterp['DoctorInterp']['id'] == 133 || $doctorInterp['DoctorInterp']['id'] == 134 || 
								$doctorInterp['DoctorInterp']['id'] == 135 || $doctorInterp['DoctorInterp']['id'] == 127 ||
								$doctorInterp['DoctorInterp']['id'] == 137 || $doctorInterp['DoctorInterp']['id'] == 139 ||
								$doctorInterp['DoctorInterp']['id'] == 141 || $doctorInterp['DoctorInterp']['id'] == 142 ||
								$doctorInterp['DoctorInterp']['id'] == 145 || $doctorInterp['DoctorInterp']['id'] == 146 ||
								$doctorInterp['DoctorInterp']['id'] == 147 || $doctorInterp['DoctorInterp']['id'] == 148 || 
								$doctorInterp['DoctorInterp']['id'] == 153 || $doctorInterp['DoctorInterp']['id'] == 154 || 
								$doctorInterp['DoctorInterp']['id'] == 155 || $doctorInterp['DoctorInterp']['id'] == 156 || 
								$doctorInterp['DoctorInterp']['id'] == 157 || $doctorInterp['DoctorInterp']['id'] == 158 ||
								$doctorInterp['DoctorInterp']['id'] == 161 || $doctorInterp['DoctorInterp']['id'] == 162 || 
								$doctorInterp['DoctorInterp']['id'] == 163 || $doctorInterp['DoctorInterp']['id'] == 164 ||
								$doctorInterp['DoctorInterp']['id'] == 165 || $doctorInterp['DoctorInterp']['id'] == 166 || 
								$doctorInterp['DoctorInterp']['id'] == 167								
								) {
							$texteDocPsection = array_merge($texteDocPsection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'section' => 'P', 'texte' => $doctorInterp['DoctorInterp'][$field_language])));
							if($doctorInterp['DoctorInterp']['id'] == 153) { $ref153 = 1; }							
						}
					}
				}	
			} else {
				if($doctorInterp['DoctorInterp']['id'] == 180 && $refCita == 1) { $texteRefsSection = array_merge($texteRefsSection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'texte' => $doctorInterp['DoctorInterp'][$field_language]))); }
				if($doctorInterp['DoctorInterp']['id'] == 181 && $ref138 == 1) { $texteRefsSection = array_merge($texteRefsSection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'texte' => $doctorInterp['DoctorInterp'][$field_language]))); }
				if($doctorInterp['DoctorInterp']['id'] == 182 && $ref153 == 1) { $texteRefsSection = array_merge($texteRefsSection, array(array('id' => $doctorInterp['DoctorInterp']['id'], 'texte' => $doctorInterp['DoctorInterp'][$field_language]))); }
			}
		endforeach;	
		$result = array($texteDocGsection, $texteDocPsection, $DrInterpsStoppedMeds, $texteRefsSection);		
		return $result;
	}

	
	############################################################################
	# Get the General Letter Section.
	############################################################################
	function generalLetterSection($Dspvalues, $DspOldvalues, $testserie, $typeTest, $TreatQuestVals, $field_temp, $arrayR5R6) {	
		$DrInterpsCodeTemp = array();	
		$HighScalesTemp = array();
		
		$ctrlRule4 = 0;		
		$code18 = 0;
		$diffGI = 0;
		$diffDEP = 0;
		
		$sumALCCritical = 0;
		$sumALC  = 0;
		
		$generalChaine = ''; $scalesnames = '';		
		
		#===================================== $typeTest 0,1 COMMON RULES ==========================#
		#### ['GRD'] < 3
		if ($Dspvalues['DspScore']['GRD'] < 3) {			
			switch((int) $Dspvalues['DspScore']['GRD']) {
				case(0):
					$DrInterpsCodeTemp = array(1);
					break;
				case(1):
					$DrInterpsCodeTemp = array(2);
					break;
				case(2):
					$DrInterpsCodeTemp = array(3); 
					break;
			}			
		}
		
		# BEGIN - Check IF the DSP (exception: DEP) has Elevations = 1(>60) OR No Elevations = 0(<60) #
		$StrCheckElevations = $this->checkElevations($Dspvalues);

		if($StrCheckElevations[0] == 1) {
			$HighScalesTemp = $StrCheckElevations[1];
			sort($HighScalesTemp);									
		}		
		# END - Check IF the DSP (exception: DEP) has Elevations = 1(>60) OR No Elevations = 0(<60) #			

		# Searching if some scale is higher than 64 - RB not included
		if ($Dspvalues['DspScore']['RB'] > 79) {
			# DSP - 45
			if ($Dspvalues['DspScore']['questionnaire_id'] == 1){					
				if ($Dspvalues['DspScore']['SOM'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['ALC'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['ANX'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['DEP'] > 64) { $code18 = 1; }
			}
			# DSP - 77		
			elseif ($Dspvalues['DspScore']['questionnaire_id'] == 2){
				if ($Dspvalues['DspScore']['SOM'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['ALC'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['ANX'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['OBS'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['PAN'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['AGO'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['TRA'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['MIN'] > 64) { $code18 = 1; }
				if ($Dspvalues['DspScore']['DEP'] > 64) { $code18 = 1; }
			}			
		}
		
		$checkRule19Rule20 = $this->checkRule19Rule20($Dspvalues);
		
		#================================== END = $typeTest 0,1 COMMON RULES ==================================#		
		if($typeTest == 1) {
		#---- FOLLOW UP			
			### RULES FOR FOLLOW UP 1 - IMPORTANT RULE!!!!			
			if ($DspOldvalues['DspScore']['GRD'] < 3 && $Dspvalues['DspScore']['GRD'] > 2) {
			## Old['GRD'] < 3
				if ($arrayR5R6[1] == 5 || $arrayR5R6[1] == 6) {					
					//(x) TREAT THE CURRENT TEST as INITIAL TEST(for the rules)					
					$DrInterpsCodeTemp = array(4);
					if ($testserie == 2) { $typeTest = 0;}
				}
			}
		}
		
		#---- BEGIN ['GRD'] > 2
		if ($Dspvalues['DspScore']['GRD'] > 2) {		
			#---- Validate FOR THE CURRENT TEST - ['GRD'] == 3 (RULES 5 T0 6) - Check IF RULE 5 / RULE 6 ----#
			if ($Dspvalues['DspScore']['GRD'] == 3) {	
				if ($arrayR5R6[0] == 5) {
					if(empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array(5); }
					if(!empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(5));  } 
				} elseif($arrayR5R6[0] == 6) {
					if(empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array(6); }
					if(!empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(6));  } 
				}
			}
			#---- INITIAL
			if ($typeTest == 0) {	
				$nbrHighScales = count($HighScalesTemp);
				if ($Dspvalues['DspScore']['DEP'] < 60) {
					if ($arrayR5R6[0] == 0) {
						if($StrCheckElevations[0] == 1) {
							# RULE 07
							if(empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array(7); }
							if(!empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(7));  } 						
						} elseif($StrCheckElevations[0] == 0) {
							# RULE 08
							if(empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array(8); }
							if(!empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(8));  } 
						}
					}
					#----YES Elevations
					if ($StrCheckElevations[0] == 1) {
						if($nbrHighScales == 1) { 
						# RULE 09
							$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(9)); 
						} elseif($nbrHighScales > 1) {
						# RULE 10
							$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(10));
						}
					}				
				} elseif ($Dspvalues['DspScore']['DEP'] > 59) {
					#----NO Elevations
					if ($StrCheckElevations[0] == 0) {
						# RULE 11
						$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(11));
					} elseif ($StrCheckElevations[0] == 1) {
						# RULE 12
						$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(12));
					}
				}
				# RULE 17
				if ($Dspvalues['DspScore']['Q44'] > 0) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(17));}				
				# RULE 18
				if ($code18 == 1) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(18));}
			} elseif ($typeTest == 1) {			
			#---- FOLLOW UP
				if ($Dspvalues['DspScore']['DEP'] < 60) {
					if ($arrayR5R6[0] == 0) {					
						if($StrCheckElevations[0] == 1) {
							# RULE 07
							if(empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array(7); }
							if(!empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(7));  } 						
						} elseif($StrCheckElevations[0] == 0) {
							# RULE 08
							if(empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array(8); }
							if(!empty($DrInterpsCodeTemp))  { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(8));  } 
						}
					}
					if ($Dspvalues['DspScore']['ANX'] > 59 || $Dspvalues['DspScore']['SOM'] > 59) {							
						if ($Dspvalues['DspScore']['ANX'] > 59) { $scalesnames .= 'ANX '; }
						if ($Dspvalues['DspScore']['SOM'] > 59) { $scalesnames .= 'SOM'; }
						$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(14)); 
					}					
				} elseif ($Dspvalues['DspScore']['DEP'] > 59) {
					if ($arrayR5R6[0] == 0) {					
						$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(16)); 	
					}				
				}

				$diffGI = $DspOldvalues['DspScore']['GRD'] - $Dspvalues['DspScore']['GRD'];
				$diffDEP = $DspOldvalues['DspScore']['DEP'] - $Dspvalues['DspScore']['DEP'];
				if ($diffGI >= 4 && $diffDEP > 30 && $arrayR5R6[0] == 0) {  $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(15)); }					

				# RULE 17
				if ($Dspvalues['DspScore']['Q44'] > 0) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(17)); }	
				# RULE 18				
				if ($code18 == 1) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp ,array(18));}				
			}
		### END ['GRD'] > 2	
		} elseif ($Dspvalues['DspScore']['GRD'] < 3) {
			if($typeTest == 1) {
				if ($DspOldvalues['DspScore']['GRD'] > 2 && $arrayR5R6[1] == 0) {
					$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(13));
				} 					
			}
		}
		if ($typeTest == 0) {
			# RULE 19
			if($checkRule19Rule20[0] == 1) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(19));}					
			# RULE 21  //sumALCCritical
			if ($checkRule19Rule20[1] == 1) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(21));}	
		} elseif ($typeTest == 1) {
			# RULE 20
			if($checkRule19Rule20[0] == 1){ $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(20));}		
			# RULE 21 //sumALCCritical				
			if ($checkRule19Rule20[1] == 1) { $DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(21));}			
		}
		#### Check for the List of TREAT. With Therapy
		## Yes With Therapy
		if ($TreatQuestVals[0]['QuestionnaireTreatment']['psychotherapy'] == 1) {			
			$endTexte = '';
			$nbr = count($TreatQuestVals[0]['TherapyTreatment']);
			for ($i=0; $i < $nbr; $i++) {
				if($TreatQuestVals[0]['TherapyTreatment'][$i]['frequency_list_id'] != 6 && $TreatQuestVals[0]['TherapyTreatment'][$i]['frequency_list_id'] != 42) {
					$frecType = $this->TherapyTreatment->FrequencyList->find('list', 
										array('conditions' => array('FrequencyList.id' => $TreatQuestVals[0]['TherapyTreatment'][$i]['frequency_list_id']),
											'fields' => array('FrequencyList.id',$field_temp),
											'order' => 'id ASC')); 	
					$d = implode("", $frecType);
					$frecTexte = substr($d, 4);
				} else {
					$frecTexte = '"'.$TreatQuestVals[0]['TherapyTreatment'][$i]['customeFtherapy'].'"';
				}
					
				if ($i == ($nbr - 1)) { 
					$endTexte = '';
				} else { 
					$endTexte = '; '; 				
				}
				$therapname = '';
				
				$unites = ' minutes ';
				if ($field_temp == 'name_eng') {
					$article1 = 'a';
					$article2 = 'for';
				#Spanish
				} else {
					$article1 = 'un';
					$article2 = 'con sesiones de';				
				}
				//echo pr($TreatQuestVals);
				# The Therapy comes from the Therapy list
				if ($TreatQuestVals[0]['TherapyTreatment'][$i]['choice_secondary_id'] != 7 && $TreatQuestVals[0]['TherapyTreatment'][$i]['choice_secondary_id'] != 14) {
					$therapyType = $this->TherapyTreatment->ChoiceSecondary->find('list', 
									array('conditions' => array('ChoiceSecondary.id' => $TreatQuestVals[0]['TherapyTreatment'][$i]['choice_secondary_id']),
										'fields' => array('ChoiceSecondary.id',$field_temp),
										'order' => 'id ASC'));
															
					$t = implode("", $therapyType);
					//echo $t;
					if ($TreatQuestVals[0]['TherapyTreatment'][$i]['choice_secondary_id'] != 4 && $TreatQuestVals[0]['TherapyTreatment'][$i]['choice_secondary_id'] != 11) { 
						$therapname = strtolower($t); 
						//$therapname = $t; 
					} else { 
						$therapname = $t; 
						if ($field_temp == 'name_eng') {
							$article1 = 'an';
						} else {
							#Spanish
							$article1 = 'el';
						}
					}
					
					if (!empty($TreatQuestVals[0]['TherapyTreatment'][$i]['duration_of_session'])) {
						$generalChaine .= $article1.' '.$therapname.' '.$article2.' '.$TreatQuestVals[0]['TherapyTreatment'][$i]['duration_of_session'].$unites.$frecTexte.$endTexte;
					} else	{
						$generalChaine .= $article1.' '.$therapname.' '.$frecTexte.$endTexte;
					}					
					//echo $generalChaine;
				} else {
					if (!empty($TreatQuestVals[0]['TherapyTreatment'][$i]['duration_of_session'])) {
						//$generalChaine .= $article1.' "'.strtolower($TreatQuestVals[0]['TherapyTreatment'][$i]['custometherapy']).'" '.$article2.' '.$TreatQuestVals[0]['TherapyTreatment'][$i]['duration_of_session'].$unites.$frecTexte.$endTexte;
						$generalChaine .= $article1.' "'.$TreatQuestVals[0]['TherapyTreatment'][$i]['custometherapy'].'" '.$article2.' '.$TreatQuestVals[0]['TherapyTreatment'][$i]['duration_of_session'].$unites.$frecTexte.$endTexte;
					} else	{
						//$generalChaine .= $article1.' "'.strtolower($TreatQuestVals[0]['TherapyTreatment'][$i]['custometherapy']).'" '.$frecTexte.$endTexte;
						$generalChaine .= $article1.' "'.$TreatQuestVals[0]['TherapyTreatment'][$i]['custometherapy'].'" '.$frecTexte.$endTexte;
					}									
				}
			}
			# end for therapy
			$DrInterpsCodeTemp = array_merge($DrInterpsCodeTemp, array(22));
		} else {
		## No With Therapy
		}		
		//echo pr($DrInterpsCodeTemp);
		if ($typeTest == 0) { return array($DrInterpsCodeTemp, $HighScalesTemp, $generalChaine); } 
		if ($typeTest == 1) { return array($DrInterpsCodeTemp, $Dspvalues['DspScore']['GRD'], $generalChaine, trim($scalesnames)); }
	}	
	
	
	############################################################################################################
	# Get the Pharma Letter Section.
	############################################################################################################
	function pharmLetterSection($TreatQuestvalues, $Dspvalues2, $Dspvalues0, $improvVal, $field_temp, $testserie, $typeTest, $arrayR5R6) {	
		$stoppedmedsnameTemp = array();
		$DrPharmCodeTemp = array();
		
		### Medication array
		$nbAntiDep = 0;
		$nbAntiDepLine1 = 0;
		$nbPotent = 0;
		$nbMoodS = 0;
		$nbAtipNeuro = 0;
		$nbsDose  = 0;
		$nbQE = 0;

		$stoppedMeds = 0;
		$nbAntiDepStop = 0;
		$nbAntiDepLine1Stop = 0;
		
		$nbBenzo = 0;		
		$checkdoseCita = 0;
		$bipolarRule = 0;

		#####--------------START------------ COMMON RULES for Initial and Follow Up --------------------#
		
		#----------------- START Q.1 = 1 Yes, receiving some treatment  ----------------#
		if ($TreatQuestvalues[0]['QuestionnaireTreatment']['treatment'] == 1) {
			### Medication array
			$nameADDose = '';  $nameADrange = '';  $nameADsDose = '';			
			$nameMSDose = '';  $nameMSrange = '';  $nameMSsDose = '';			
			$nameANDose = ''; $nameANrange = ''; $nameANsDose = '';			
			$namePADose = ''; $namePArange = ''; $namePAsDose = '';						
			$chainesDose = '';
			$strMedsDose = ''; $strMedsName = ''; $strMedsRange = ''; 			
			$nameBenzo = ''; $nameCustomeDrug = '';
			$nameQEDose = ''; $nameQErange = ''; $nameQEsDose = '';
			$nameTRDose = ''; $nameTRrange = ''; $nameTRsDose = '';
			$doseQE = 0; $checkQE = 0;			
			$countCustomeDrug = 0;
			$doseCitalopram = 0; $nameCitalopram = '';			
			$doseVenlafaxine = 0; $nameVenlafaxine = '';						
			$doseAmitriptyline = 0;	$nameAmitriptyline = '';			
			$doseEscitalopram = 0; 	$doseADAnyLine = '';			
			$checkDuloxetine = 0;  $nameDuloxetine = '';			
			$checkSertraline = 0; $nameSertraline = '';			
			$checkEscitalopram = 0; $checkLithium = 0;
			$countNODate = 0;  $nameNODateAD = '';
			$checkTrazodone = 0; $doseTrazodone = 0;	
			$isTrazoAD = false;
			$checkLamotrigine = 0; $checkCarDivalValOx = 0; $checkLamoTopi = 0;
			$check44 = 0; $checkBuspiCyto = 0;			
			$diffdaysAD = 0;		
			$drugTable = 0; $higherDose = 9;			
			$supramaximal = 0;  $checkImprov = 9;			
			$customeDose = 0; 
			
			$listSameCateg = array();  $listToutSameCateg = array();			
			###### START ---- Looping the Medication list
			for ($i=0; $i < count($TreatQuestvalues[0]['MedicationTreatment']); $i++) {
			
				#--------  The Med-Drug comes from the drug list
				if (!empty($TreatQuestvalues[0]['MedicationTreatment'][$i]['drug_id'])) {
				$drugTable = 1;
				$drugInfo = $TreatQuestvalues[0]['MedicationTreatment'][$i]['Drug'];
					# ['type_temps'] == 1: Current medications
					if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['type_temps'] == 1) {
						#-------- YES same category ----------						
						$listSameCateg = $this->isDrugSameCategory($TreatQuestvalues[0]['MedicationTreatment'], $drugInfo['category'], 1);					
						if(!empty($listSameCateg) ) {
							$notFound = false;
							if(!empty($listToutSameCateg)) {
								//Look up if the same caegory already exists in the array
								foreach ($listToutSameCateg as $list):
									if($list['categ'] == $drugInfo['category']) {
										$notFound = false;
										break; 
									} else {
										$notFound = true;
									}								
								endforeach;								
								if ($notFound) { $listToutSameCateg = array_merge($listToutSameCateg, array($listSameCateg)); }							
							} else {
								$listToutSameCateg = array($listSameCateg); 
							}						
						} else {
						#--START------ NO same category ----------
						$nL = $drugInfo['range_left'];
						$nR = $drugInfo['range_right'];
						if (($nL - floor($nL)) == 0) { $nL = floor($nL); }
						if (($nR - floor($nR)) == 0) { $nR = floor($nR); }
							
						$customeDose = $TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'];
						$whole = floor($customeDose);      // 100
						$fraction = $customeDose - $whole; // .00
						
						if ($fraction == 0 || $fraction == 0.00) { $customeDose = $whole;}
						if($customeDose == 0 && $drugInfo['type_d1'] != 5) {
							$nbsDose++;
							if($nbsDose == 1) { $chainesDose .= ' '.$drugInfo['name']; }
							if($nbsDose > 1) { $chainesDose .= ', '.$drugInfo['name']; }
						}		
						//echo $drugInfo['type_d1'];
						if ($drugInfo['type_d1'] == 1) {
						#--- Antidepression
						$nbAntiDep++;
							#--- The date_of_start of AD IS provided ---#
							if (!empty($TreatQuestvalues[0]['MedicationTreatment'][$i]['date_of_start'])) {
								$datetime1 = $TreatQuestvalues[0]['QuestionnaireTreatment']['created'];
								$datetime2 = $TreatQuestvalues[0]['MedicationTreatment'][$i]['date_of_start']; 
								$diffdaysAD = floor(abs(strtotime($datetime1) - strtotime($datetime2)) / 86400);
								if($TreatQuestvalues[0]['MedicationTreatment'][$i]['higherdose'] != NULL) {
									$higherDose = $TreatQuestvalues[0]['MedicationTreatment'][$i]['higherdose'];
								}
							} else {
								if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['more_5years'] == 1) {
									$diffdaysAD = 1781;
								} else {
									$diffdaysAD = 9999;
									$countNODate++;
								}									
							}							
							if ($drugInfo['line'] == 1) { 
								$nbAntiDepLine1++; 								
								if ($customeDose > $nR) { $supramaximal = 1;}
							}
							if ($drugInfo['category'] == 2) { 
								#---Citalopram: Celexa / Apo-Citalopram
								$doseCitalopram = $customeDose; 
								$nameCitalopram = $drugInfo['name'];
							} elseif ($drugInfo['category'] == 4) {
								#---Duloxetine
								$checkDuloxetine = 1; 
								$nameDuloxetine = $drugInfo['name']; 
							} elseif ($drugInfo['category'] == 5) {
								#---Escitalopram
								$doseEscitalopram = $customeDose; 
								$checkEscitalopram = 1;
							} elseif ($drugInfo['category'] == 11) {
								#---Sertraline: Zoloft/Apo- Sertraline
								$checkSertraline = 1;
								$nameSertraline = $drugInfo['name']; 	
							} elseif ($drugInfo['category'] == 12) {
								#---Venlafaxine: Effexor / Co Venlafaxine XR
								$doseVenlafaxine = $customeDose; 
								$nameVenlafaxine = $drugInfo['name'];
							} elseif ($drugInfo['category'] == 13) {
								#---Amitriptyline: Elavil
								$doseAmitriptyline = $customeDose; 
								$nameAmitriptyline = $drugInfo['name']; 
							}elseif ($drugInfo['category'] == 19) {
								#---Trazodone: Desyrel / Apo-Trazodone D
								$doseTrazodone = $customeDose; 
								$checkTrazodone = 1;
								if ($doseTrazodone >= 150) $isTrazoAD = true;
								$nameTRsDose = $drugInfo['name'];								
								$nameTRrange = $nL.'-'.$nR.' '.$drugInfo['unit'];
								if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'] != 0) {
									$nameTRDose = $drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];		
									if ($countNODate == 1) { $nameNODateAD .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];}
									if ($countNODate > 1) { $nameNODateAD .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];}									
								} else {
									$nameTRDose = $nameTRsDose;
									if ($countNODate == 1) { $nameNODateAD .= ' '.$drugInfo['name'];}
									if ($countNODate > 1) { $nameNODateAD .= ', '.$drugInfo['name'];}									
								}									
							}
							//echo 'nameADDose...1 :'.$nameADDose;
							# The dose is provided by the patient
							if($drugInfo['category'] != 19 || ($drugInfo['category'] == 19 && $isTrazoAD)){
								if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'] != 0) {
									if($nbAntiDep == 1) {
										$nameADDose .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
										$nameADsDose .= ' '.$drugInfo['name'];
										$nameADrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
										$doseADAnyLine = $customeDose.' '.$drugInfo['unit'];
									} else {
									//$isTrazoAD
										//if($nbAntiDep == 2 && $checkTrazodone == 1){
										if($nbAntiDep == 2 && ($checkTrazodone == 1 && $isTrazoAD == false)){
											$nameADDose .= $drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
											$nameADsDose .= $drugInfo['name'];
											$nameADrange .= $nL.'-'.$nR.' '.$drugInfo['unit'];
											$doseADAnyLine = $customeDose.' '.$drugInfo['unit'];										
										} else {
											$nameADDose .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
											$nameADsDose .= ', '.$drugInfo['name'];
											$nameADrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];										
										}	
									}	
									if ($countNODate == 1) { $nameNODateAD .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];}
									if ($countNODate > 1) { $nameNODateAD .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];}
								} else {
								
									if($nbAntiDep == 1) {
										$nameADDose .= ' '.$drugInfo['name'];
										$nameADsDose .= ' '.$drugInfo['name'];
										$nameADrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];										
									} else {
										if($nbAntiDep == 2 && $checkTrazodone == 1){
											$nameADDose .= ' '.$drugInfo['name'];
											$nameADsDose .= ' '.$drugInfo['name'];
											$nameADrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];																				
										} else {
											$nameADDose .= ', '.$drugInfo['name'];
											$nameADsDose .= ', '.$drugInfo['name'];
											$nameADrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];																				
										}
									}
									if ($countNODate == 1) { $nameNODateAD .= ' '.$drugInfo['name'];}
									if ($countNODate > 1) { $nameNODateAD .= ', '.$drugInfo['name'];}
								}
							} 	
							//echo 'nameADDose2 :'.$nameADDose;
						} elseif ($drugInfo['type_d1'] == 2) {
						#--- Potentializing agent = 2
						$nbPotent++;
							if ($drugInfo['type_d2'] == 4) { 
								# Lithium: Apo-lithium carbonate / Carbolith / Euro lithium
								$checkLithium  = 1; 
								$nbMoodS++;
								if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'] != 0 ) {
									if($nbMoodS == 1) {
										$nameMSDose .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
										$nameMSsDose .= ' '.$drugInfo['name'];
										$nameMSrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
									} else {
										$nameMSDose .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
										$nameMSsDose .= ', '.$drugInfo['name'];
										$nameMSrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
									}								
								} else {
									if($nbMoodS == 1) {
										$nameMSDose .= ' '.$drugInfo['name'];
										$nameMSsDose .= ' '.$drugInfo['name'];
										$nameMSrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
									} else {
										$nameMSDose .= ', '.$drugInfo['name'];
										$nameMSsDose .= ', '.$drugInfo['name'];
										$nameMSrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
									}
								}								
							}								
							if ($drugInfo['category'] == 23  || $drugInfo['category'] == 24) { 
								# Buspirone / Cytomel
								$checkBuspiCyto = 1; 
							}

							# The dose is provided by the patient
							if($checkLithium  == 0){
							if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'] != 0) {
								if($nbPotent == 1) {
									$namePADose .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
									$namePAsDose .= ' '.$drugInfo['name'];
									$namePArange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								} else {
									$namePADose .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
									$namePAsDose .= ', '.$drugInfo['name'];
									$namePArange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								}								
							} else {
								if($nbPotent == 1) {
									$namePADose .= ' '.$drugInfo['name'];
									$namePAsDose .= ' '.$drugInfo['name'];
									$namePArange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								} else {
									$namePADose .= ', '.$drugInfo['name'];
									$namePAsDose .= ', '.$drugInfo['name'];
									$namePArange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								}
							}
							}							
						} elseif ($drugInfo['type_d1'] == 3) {
						# Atypical neuroleptic = 3
							$nbAtipNeuro++;	
							# The dose is provided by the patient
							if ($customeDose != 0) {
								if($nbAtipNeuro == 1) {
									$nameANDose .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
									$nameANsDose .= ' '.$drugInfo['name'];	
									$nameANrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								} else {
									$nameANDose .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
									$nameANsDose .= ', '.$drugInfo['name'];	
									$nameANrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								}								
							} else {
								if($nbAtipNeuro == 1) {							
									$nameANDose .= ' '.$drugInfo['name'];										
									$nameANsDose .= ' '.$drugInfo['name'];	
									$nameANrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								} else {
									$nameANDose .= ', '.$drugInfo['name'];
									$nameANsDose .= ', '.$drugInfo['name'];	
									$nameANrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								}						
							}							
						} elseif ($drugInfo['type_d1'] == 4) {
						# Mood stabilizer = 4
							$nbMoodS++;
							if ($drugInfo['category'] == 32 || $drugInfo['category'] == 33 || $drugInfo['category'] == 34 || $drugInfo['category'] == 35) { 
								# Carbamazepine / Divalproex / Valproic acid / Oxcarbazepine
								$checkCarDivalValOx = 1; 
							}
							if ($drugInfo['category'] == 36  || $drugInfo['category'] == 37) { 
								# Lamotrigine / Topiramate
								$checkLamoTopi = 1; //LamoTopi
								if ($drugInfo['category'] == 36) { $checkLamotrigine = 1; }								
							}							
							# The dose is provided by the patient
							if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'] != 0) {
								if($nbMoodS == 1) {
									$nameMSDose .= ' '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
									$nameMSsDose .= ' '.$drugInfo['name'];
									$nameMSrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								} else {
									$nameMSDose .= ', '.$drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];
									$nameMSsDose .= ', '.$drugInfo['name'];
									$nameMSrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								}								
							} else {
								if($nbMoodS == 1) {
									$nameMSDose .= ' '.$drugInfo['name'];
									$nameMSsDose .= ' '.$drugInfo['name'];
									$nameMSrange .= ' '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								} else {
									$nameMSDose .= ', '.$drugInfo['name'];
									$nameMSsDose .= ', '.$drugInfo['name'];
									$nameMSrange .= ', '.$nL.'-'.$nR.' '.$drugInfo['unit'];
								}
							}														
						} elseif ($drugInfo['type_d1'] == 5) {
						# Benzodiazepines = 5
							$nbBenzo++;
							if ($nbBenzo == 1) { $nameBenzo .= ''.$drugInfo['name']; }
							if ($nbBenzo > 1) { $nameBenzo .= ', '.$drugInfo['name']; }
						} elseif ($drugInfo['type_d1'] == 6) {
						# Quetiapine
						//echo 'Quetiapine ';
							$nbQE++;
							$checkQE = 1; 
							$doseQE = $customeDose;
							$nameQEsDose = $drugInfo['name'];
							$nameQErange = $nL.'-'.$nR.' '.$drugInfo['unit'];
							//if (!empty($TreatQuestvalues['MedicationTreatment'][$i]['custome_dose'])) {
							if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_dose'] != 0) {
								$nameQEDose = $drugInfo['name'].' '.$customeDose.' '.$drugInfo['unit'];							
							} else	{
								$nameQEDose = $drugInfo['name'];
							}
						}	
						$drugInfo = array();
						#--END------ NO same category ----------
						}						
					} elseif ($TreatQuestvalues[0]['MedicationTreatment'][$i]['type_temps'] == 0) {
					# Call to Stopped Medications
						$getStoppedMeds = $this->getStoppedMeds($drugInfo, $TreatQuestvalues[0]['MedicationTreatment'][$i], $stoppedmedsnameTemp, $stoppedMeds, $nbAntiDepStop, $nbAntiDepLine1Stop, $field_temp);
						$stoppedmedsnameTemp = $getStoppedMeds[0];
						$stoppedMeds = $getStoppedMeds[1];
						$nbAntiDepStop = $getStoppedMeds[2];
						$nbAntiDepLine1Stop = $getStoppedMeds[3];
					}	
				#--- END -----  The Med-Drug comes from the drug list
				} else {
				#--------  Custome Med-Drug /dose
					$drugInfo = array();
					if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['type_temps'] == 1) {
						# Current Drugs
						$countCustomeDrug++;
						if($countCustomeDrug == 1) {
							$nameCustomeDrug .= ''.$TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_drug'];
						} else {
							$nameCustomeDrug .= ', '.$TreatQuestvalues[0]['MedicationTreatment'][$i]['custome_drug'];
						}					
					} elseif ($TreatQuestvalues[0]['MedicationTreatment'][$i]['type_temps'] == 0) {				
					# Call to Stopped Medications					
						$getStoppedMeds = $this->getStoppedMeds($drugInfo, $TreatQuestvalues[0]['MedicationTreatment'][$i], $stoppedmedsnameTemp, $stoppedMeds, $nbAntiDepStop, $nbAntiDepLine1Stop, $field_temp);
						$stoppedmedsnameTemp = $getStoppedMeds[0];
						$stoppedMeds = $getStoppedMeds[1];
						$nbAntiDepStop = $getStoppedMeds[2];
						$nbAntiDepLine1Stop = $getStoppedMeds[3];											
					}
				#--- END -----  Custome Med-Drug /dose
				}			
			}
			###### END ---- Looping the Medication list
			
			$nameSCtotaldose = ''; $nameSCsDose = '';
			$ADwithSC = false; $MSwithSC = false; $ANwithSC = false;
			$PAwithSC = false; $QEwithSC = false;
			for ($k=0; $k < count($listToutSameCateg); $k++) {
				if($k == 0) {
				$nameSCsDose .= $listToutSameCateg[$k]['strname'];
				$nameSCtotaldose .= $listToutSameCateg[$k]['custome_dose'];
				} else {
				$nameSCsDose .= '/'.$listToutSameCateg[$k]['strname'];
				$nameSCtotaldose .= '/'.$listToutSameCateg[$k]['custome_dose'];				
				}
				if ($listToutSameCateg[$k]['id'] == 1) {
				#--- Antidepression
				$nbAntiDep++;
				$ADwithSC = true;
					if ($listToutSameCateg[$k]['id'] == 1 && $listToutSameCateg[$k]['line'] == 1) { $nbAntiDepLine1++; }
					#--- The date_of_start of AD IS provided ---#
					if (!empty($listToutSameCateg[$k]['date_of_start'])) {
						$datetime1 = $TreatQuestvalues[0]['QuestionnaireTreatment']['created'];
						$datetime2 = $listToutSameCateg[$k]['date_of_start']; 
						$diffdaysAD = floor(abs(strtotime($datetime1) - strtotime($datetime2)) / 86400);
						$higherDose = $listToutSameCateg[$k]['higherDose'];
					} else {
						if ($listToutSameCateg[$k]['more_5years'] == 1) {
							$diffdaysAD = 1781;
						} else {
							$diffdaysAD = 9999;
							if ($listToutSameCateg[$k]['countNODate'] > 0) { $countNODate = $countNODate + $listToutSameCateg[$k]['countNODate']; }
						}
					}							
					if ($listToutSameCateg[$k]['categ'] == 2) { 
						#---Citalopram: Celexa / Apo-Citalopram
						$doseCitalopram = $listToutSameCateg[$k]['custome_dose']; 
						$nameCitalopram = $listToutSameCateg[$k]['strname'];
					} elseif ($listToutSameCateg[$k]['categ'] == 4) {
						#---Duloxetine
						$checkDuloxetine = 1; 
						$nameDuloxetine = $listToutSameCateg[$k]['strname'];
					} elseif ($listToutSameCateg[$k]['categ'] == 5) {
						#---Escitalopram
						$doseEscitalopram = $listToutSameCateg[$k]['custome_dose'];
						$checkEscitalopram = 1;
					} elseif ($listToutSameCateg[$k]['categ'] == 11) {
						#---Sertraline: Zoloft/Apo- Sertraline
						$checkSertraline = 1;
						$nameSertraline = $listToutSameCateg[$k]['mainDrug'];
					} elseif ($listToutSameCateg[$k]['categ'] == 12) {
						#---Venlafaxine: Effexor / Co Venlafaxine XR
						$doseVenlafaxine = $listToutSameCateg[$k]['custome_dose']; 
						$nameVenlafaxine = $listToutSameCateg[$k]['mainDrug'];
					} elseif ($listToutSameCateg[$k]['categ'] == 13) {
						#---Amitriptyline: Elavil
						$doseAmitriptyline = $listToutSameCateg[$k]['custome_dose']; 
						$nameAmitriptyline = $listToutSameCateg[$k]['mainDrug'];
					}elseif ($listToutSameCateg[$k]['categ'] == 19) {
						#---Trazodone: Desyrel / Apo-Trazodone D
						$doseTrazodone = $listToutSameCateg[$k]['custome_dose']; 
						$checkTrazodone = 1;
						if ($doseTrazodone >= 150) $isTrazoAD = true;
						$nameTRsDose = $listToutSameCateg[$k]['strname'];									
						$nameTRrange = $listToutSameCateg[$k]['range'];
						if ($listToutSameCateg[$k]['custome_dose'] > 0) {
							$nameTRDose = $listToutSameCateg[$k]['strname'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';
							// if ($countNODate == $nbCateg) { $nameNODateAD .= ' '.$listToutSameCateg[$k]['strname'].' mg';} aaron
							if ($countNODate == $listToutSameCateg[$k]['nbCateg']) { $nameNODateAD .= ' '.$listToutSameCateg[$k]['strname'].' mg';}
						} else {
							$nameTRDose = $nameTRsDose;
							// if ($countNODate == $nbCateg) { $nameNODateAD .= ' '.$listToutSameCateg[$k]['strname'];} aaron
							if ($countNODate == $listToutSameCateg[$k]['nbCateg']) { $nameNODateAD .= ' '.$listToutSameCateg[$k]['strname'];}					
						}									
					}
					if($nbAntiDep == 1) {
						$nameADsDose .= ' '.$listToutSameCateg[$k]['mainDrug'];
						$nameADDose .= ' '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
						$nameADrange .= ' '.$listToutSameCateg[$k]['range'];
					} else {
						if($nbAntiDep == 2 && $checkTrazodone == 1) {
							$nameADsDose .= $listToutSameCateg[$k]['mainDrug'];
							$nameADDose .= $listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$nameADrange .= $listToutSameCateg[$k]['range'];						
						} else {
							$nameADsDose .= ', '.$listToutSameCateg[$k]['mainDrug'];
							$nameADDose .= ', '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$nameADrange .= ', '.$listToutSameCateg[$k]['range'];						
						}
					}					
				} elseif ($listToutSameCateg[$k]['id'] == 2) {
				#--- Potentializing agent = 2
				$nbPotent++;
				$PAwithSC = true;
					if ($listToutSameCateg[$k]['type_d2'] == 4) { 
						# Lithium: Apo-lithium carbonate / Carbolith / Euro lithium
						$checkLithium  = 1; 
						$nbMoodS++;
						$MSwithSC = true;
						if($nbMoodS == 1) {
							$nameMSsDose .= ' '.$listToutSameCateg[$k]['mainDrug'];
							$nameMSDose .= ' '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$nameMSrange .= ' '.$listToutSameCateg[$k]['range'];
						} else {
							$nameMSsDose .= ', '.$listToutSameCateg[$k]['mainDrug'];
							$nameMSDose .= ', '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$nameMSrange .= ', '.$listToutSameCateg[$k]['range'];
						}						
					}								
					if ($listToutSameCateg[$k]['categ'] == 23  || $listToutSameCateg[$k]['categ'] == 24) { 
						# Buspirone / Cytomel
						$checkBuspiCyto = 1; 
					}
					# The dose is provided by the patient
					if($checkLithium  == 0){
						if($nbPotent == 1) {
							$namePAsDose .= ' '.$listToutSameCateg[$k]['mainDrug'];
							$namePADose .= ' '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$namePArange .= ' '.$listToutSameCateg[$k]['range'];
						} else {
							$namePAsDose .= ', '.$listToutSameCateg[$k]['mainDrug'];
							$namePADose .= ', '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$namePArange .= ', '.$listToutSameCateg[$k]['range'];
						}
					}							
				} elseif ($listToutSameCateg[$k]['id'] == 3) {
				# Atypical neuroleptic = 3
					$nbAtipNeuro++;	
					$ANwithSC = true;
					# The dose is provided by the patient						
						if($nbAtipNeuro == 1) {
							$nameANsDose .= ' '.$listToutSameCateg[$k]['mainDrug'];
							$nameANDose .= ' '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$nameANrange .= ' '.$listToutSameCateg[$k]['range'];
						} else {
							$nameANsDose .= ', '.$listToutSameCateg[$k]['mainDrug'];
							$nameANDose .= ', '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
							$nameANrange .= ', '.$listToutSameCateg[$k]['range'];
						}						
				} elseif ($listToutSameCateg[$k]['id'] == 4) {
				# Mood stabilizer = 4
					$nbMoodS++;
					if ($listToutSameCateg[$k]['categ'] == 32 || $listToutSameCateg[$k]['categ'] == 33 || $listToutSameCateg[$k]['categ'] == 34 || 
						$listToutSameCateg[$k]['categ'] == 35) { 
						# Carbamazepine / Divalproex / Valproic acid / Oxcarbazepine
						$checkCarDivalValOx = 1; 
					}
					if ($listToutSameCateg[$k]['categ'] == 36  || $listToutSameCateg[$k]['categ'] == 37) { 
						# Lamotrigine / Topiramate
						$checkLamoTopi = 1; //LamoTopi
						if ($listToutSameCateg[$k]['categ'] == 36) { $checkLamotrigine = 1; }								
					}							
					# The dose is provided by the patient
					if($nbMoodS == 1) {
						$nameMSsDose .= ' '.$listToutSameCateg[$k]['mainDrug'];
						$nameMSDose .= ' '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
						$nameMSrange .= ' '.$listToutSameCateg[$k]['range'];
					} else {
						$nameMSsDose .= ', '.$listToutSameCateg[$k]['mainDrug'];
						$nameMSDose .= ', '.$listToutSameCateg[$k]['mainDrug'].' '.$listToutSameCateg[$k]['custome_dose'].' mg';							
						$nameMSrange .= ', '.$listToutSameCateg[$k]['range'];
					}
				} elseif ($listToutSameCateg[$k]['id'] == 6) {
				# Quetiapine
				//echo 'Quetiapine ';
					$nbQE++;
					$QEwithSC = true;
					$checkQE = 1; 
					$doseQE = $listToutSameCateg[$k]['custome_dose'];
					$nameQEsDose = $listToutSameCateg[$k]['mainDrug'];
					$nameQErange = $listToutSameCateg[$k]['range'];
					if($doseQE == 0){ $nameQEDose = $nameQEsDose; }
					if($doseQE > 0){ $nameQEDose = $nameQEsDose.' '.$doseQE.' mg'; }					
				}				
			}
		
			$strNoLetters = '';


			/****************************************************************/
			//if ($doseTrazodone > 0 && $doseTrazodone < 150) $nbAntiDep--;
			/****************************************************************/
			
			#--------------------  Check the Inserted text  -------------------#
			if ($doseCitalopram > 0 && $doseCitalopram < 21 && $Dspvalues2['DspScore']['DEP'] > 70) { $checkdoseCita = 1;} 
			//echo '$typeTest '.$typeTest;		
			//echo '$TreatQuestvalues[0][QuestionnaireTreatment][choice_secondary_id] '.$TreatQuestvalues[0]['QuestionnaireTreatment']['choice_secondary_id'];
			if ($typeTest == 0) {
			#--------------  Check for the improvement rate - INITIAL  --------------#
				if (!empty($TreatQuestvalues[0]['QuestionnaireTreatment']['choice_secondary_id'])) {
					$improv = $this->TherapyTreatment->ChoiceSecondary->find('list', 
											array('conditions' => array('ChoiceSecondary.id' => $TreatQuestvalues[0]['QuestionnaireTreatment']['choice_secondary_id']),
												'fields' => array('id',$field_temp),
												'order' => 'id ASC'));
					//d'amioration
					//echo pr($improv);
					foreach ($improv as $imp):
						$chaineImprov = str_replace("d'amioration", '', $imp);
						$chaineImprov = str_replace("d'amélioration", '', $imp);
						$chaineImprov = str_replace("d’amélioration", '', $imp);
						$chaineImprov = strtolower($chaineImprov);
					endforeach;				
//echo 'ANTES $chaineImprov '.$chaineImprov;
					$chaineImprov = str_replace('improved', '', $chaineImprov);
//echo 'DESPUES $chaineImprov '.$chaineImprov;					
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 143, 'text0' => trim($chaineImprov))));	
					if($TreatQuestvalues[0]['QuestionnaireTreatment']['choice_secondary_id'] != 15) {
						$checkImprov = 1;
					} else {
						$checkImprov = 0;
					}
				}
			} elseif ($typeTest == 1) {
			#--------------  Check for the improvement rate - FOLLOW UP  --------------#
				if($improvVal > 19 && $improvVal != 999) { 
					$checkImprov = 1;
				} elseif($improvVal < 20 && $improvVal != 999) {
					$checkImprov = 0;					
				}
			}
			/********************************//********************************//********************************/
			/********************************//********************************//********************************/
			//$sameCategory = false;  $nameSCtotaldose = ''; $nameSCsDose = '';
			if (count($listToutSameCateg) > 0) {  
				//echo 'ooooo';
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 26, 'text0' => trim($nameSCsDose), 
																				'text1' => trim($nameSCtotaldose))));			
			}
			#--------------  There is no QUETIAPINE  --------------#
			if($checkQE == 0){			
				### -------------- Some AD is Trazodone or not, if it is Trazodone, its dose has to be >= 150 mg)
				if (($checkTrazodone == 1 && $doseTrazodone >= 150) || $checkTrazodone == 0) {
					if ($nbAtipNeuro == 0 && $nbPotent  == 0) {
						if ($nbAntiDep == 1 && $nbMoodS == 0) {
							if($nbAntiDepLine1 == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 27, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange))));
							} elseif($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 28, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange))));
							}													
						} elseif ($nbAntiDep == 1 && $nbMoodS > 0) {
							if ($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 36, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameMSDose))));		
								if ($doseAmitriptyline > 0 && $doseAmitriptyline < 51) {
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 44, 'text0' => trim($nameADDose))));
									$check44 = 1;
								} 																				
							} elseif ($nbAntiDepLine1 == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 38, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameMSDose))));
							}
							# Carbamazepine / Divalproex / Valproic acid / Oxcarbazepine
							if ($checkCarDivalValOx == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 40, 'text0' => trim($nameADrange), 
																				'text1' => trim($nameADsDose), 'text2' => trim($nameMSDose),
																				'text3' => trim($nameMSrange), 'text4' => trim($nameMSsDose))));
							}
							# Lamotrigine / Topiramate
							if ($checkLamoTopi == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 42, 'text0' => trim($nameADrange), 
																				'text1' => trim($nameADsDose), 'text2' => trim($nameMSrange), 
																				'text3' => trim($nameMSsDose))));
							}							
						} elseif ($nbAntiDep == 2 && $nbMoodS == 0){
							if ($nbAntiDepLine1 == 1 || $nbAntiDepLine1 == 2) {
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 30, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose))));
							} elseif ($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 32, 'text0' => trim($nameADDose))));
							}

						} elseif ($nbAntiDep == 2 && $nbMoodS == 1) {
							if($checkLamoTopi == 1) {
								$bipolarRule = 1;
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 50, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																				'text5' => trim($nameMSsDose))));
							}
							if($checkLamoTopi == 0) {
								$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 52, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																				'text5' => trim($nameMSsDose))));				
							}							
						} elseif ($nbAntiDep == 2 && $nbMoodS > 1) {
								$bipolarRule = 1;
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 54, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																				'text5' => trim($nameMSsDose), 'text6' => trim($strNoLetters))));						
						} elseif ($nbAntiDep > 2 && $nbMoodS == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 34, 'text0' => trim($nameADDose))));
						} elseif ($nbAntiDep > 2 && $nbMoodS > 0) {
								$bipolarRule = 1;
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 56, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose), 'text6' => trim($strNoLetters),
																					'text7' => trim($strADLetters))));
						}						
						if ($nbAntiDep > 0 && $nbMoodS > 0) {
							$bipolarRule = 1;
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 39, 'text0' => trim($nameMSDose))));
						}		
					} elseif ($nbAtipNeuro == 0 && $nbPotent  == 1) {
						if($checkLithium == 1){
							if ($nbAntiDep == 1 && $nbMoodS == 1) {
								if ($nbAntiDepLine1 == 1){
									$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 45, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose))));
								} elseif ($nbAntiDepLine1 == 0){
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 46, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose))));
								}
							} elseif ($nbAntiDep == 1 && $nbMoodS > 1) {
									$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 48, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose))));						
							} elseif($nbAntiDep == 2 && $nbMoodS == 1){
								# Lithium or (Lamotrigine or Topiramate)
									$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 50, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose))));
							} elseif($nbAntiDep == 2 && $nbMoodS > 1){
								$bipolarRule = 1;
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 54, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose), 'text6' => trim($strNoLetters))));										
							
							} elseif($nbAntiDep > 2 && $nbMoodS > 0){
								$bipolarRule = 1;
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 56, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose), 'text6' => trim($strNoLetters),
																					'text7' => trim($strADLetters))));							
							}
						}
						if ($nbAntiDep == 1 && $nbMoodS == 0) {
							if($nbAntiDepLine1 == 1 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 70, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose))));					
							} elseif($nbAntiDepLine1 == 0 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 71, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose))));					
							}
						}
					} elseif ($nbAtipNeuro == 1 && $nbPotent  == 0) {
						if ($nbAntiDep == 1 && $nbMoodS == 0) {
							if($nbAntiDepLine1 == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 58, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																			'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																			'text5' => trim($nameANsDose))));
							} elseif($nbAntiDepLine1 == 0){
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 59, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																			'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																			'text5' => trim($nameANsDose))));
							}
						} elseif ($nbAntiDep == 2 && $nbMoodS == 0) {
							if ($nbAntiDepLine1 == 2 || $nbAntiDepLine1 == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 64, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose))));					
							}						
						}					
 					} elseif ($nbAtipNeuro > 1 && $nbPotent  == 0) {
						if ($nbAntiDep == 1 && $nbMoodS == 0) {
							if($nbAntiDepLine1 == 1) {
								$strNoLetters = $this->numberLetters($field_temp, $nbAtipNeuro);
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 61, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																			'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																			'text5' => trim($nameANsDose), 'text6' => trim($strNoLetters))));								
							} elseif($nbAntiDepLine1 == 0) {
								$strNoLetters = $this->numberLetters($field_temp, $nbAtipNeuro);
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 62, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																			'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																			'text5' => trim($nameANsDose), 'text6' => trim($strNoLetters))));							
							}
						} elseif ($nbAntiDep == 2 && $nbMoodS == 0) {
							if ($nbAntiDepLine1 == 2 || $nbAntiDepLine1 == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 66, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose))));					
							}												
						}
					}
					if($nbAtipNeuro > 0 && $nbPotent  == 0) {				
						if($nbAntiDep > 2 && $nbMoodS == 0){
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep);
								$strNoLetters = $this->numberLetters($field_temp, $nbAtipNeuro);				
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 68, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																					'text5' => trim($nameANsDose), 'text6' => trim($strNoLetters),
																					'text7' => trim($strADLetters))));	
						}			
					}
					if ($nbAtipNeuro  == 0 && $nbPotent >= 1) {
						if ($nbAntiDep > 1 && $nbMoodS == 0) {
							if($nbAntiDepLine1 == 0 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 75, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose))));					
							} elseif($nbAntiDepLine1 > 1 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 73, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose))));					
							}
						}
					}									
					if ($nbAntiDep > 0 && $nbMoodS > 0 && $nbAtipNeuro > 0 && (($checkLithium == 1 && $nbPotent  == 1) || ($checkLithium == 0 && $nbPotent  == 0))) {
							$bipolarRule = 1;
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);			
								$strANLetters = $this->numberLetters($field_temp, $nbAtipNeuro);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 77, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose), 'text6' => trim($nameANDose), 
																					'text7' => trim($nameANrange), 'text8' => trim($nameANsDose),
																					'text9' => trim($strADLetters), 'text10' => trim($strNoLetters),
																					'text11' => trim($strANLetters))));
					}
					if ($nbAntiDep > 0 && $nbMoodS > 0 && $nbAtipNeuro > 0 && $nbPotent > 0 && $checkLithium == 0) {
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);			
								$strANLetters = $this->numberLetters($field_temp, $nbAtipNeuro);			
								$strPALetters = $this->numberLetters($field_temp, $nbPotent);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 79, 'text0' => trim($nameADDose), 
																					'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																					'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																					'text5' => trim($nameMSsDose), 'text6' => trim($nameANDose), 
																					'text7' => trim($nameANrange), 'text8' => trim($nameANsDose),
																					'text9' => trim($namePADose), 'text10' => trim($namePArange), 
																					'text11' => trim($namePAsDose), 'text12' => trim($strADLetters), 
																					'text13' => trim($strNoLetters), 'text14' => trim($strANLetters),
																					'text15' => trim($strPALetters))));		
					}
				### END -------------- Some AD is Trazodone or not, if it is Trazodone, its dose has to be >= 150 mg)	
				}
				
				### -------------- Some AD is Trazodone if it is Trazodone, its dose has to be < 150 mg)
				if ($checkTrazodone == 1 && $doseTrazodone < 150) {
					if ($nbAtipNeuro == 0 && $nbPotent  == 0) {
						if ($nbAntiDep == 1 && $nbMoodS == 0){
							if($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 29, 'text0' => trim($nameTRDose), 
																			'text1' => trim($nameTRrange))));
							}														
						} elseif ($nbAntiDep == 1 && $nbMoodS > 0) {
							if ($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 37, 'text0' => trim($nameTRDose), 
																			'text1' => trim($nameMSDose))));						
							}
							# Carbamazepine / Divalproex / Valproic acid / Oxcarbazepine
							if ($checkCarDivalValOx == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 41, 'text0' => trim($nameTRrange), 
																			'text1' => trim($nameTRsDose), 'text2' => trim($nameMSDose),
																			'text3' => trim($nameMSrange), 'text4' => trim($nameMSsDose))));
							}
							# Lamotrigine / Topiramate
							if ($checkLamoTopi == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 43, 'text0' => trim($nameTRrange), 
																			'text1' => trim($nameTRsDose), 'text2' => trim($nameMSrange), 
																			'text3' => trim($nameMSsDose))));
							}					
								
						} elseif ($nbAntiDep == 2 && $nbMoodS == 0){				
							if ($nbAntiDepLine1 == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 31, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),
																			'text3' => trim($nameTRDose), 'text4' => trim($nameTRrange), 
																			'text5' => trim($nameTRsDose))));
							} elseif ($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 33, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																			'text3' => trim($nameTRDose), 'text4' => trim($nameTRrange), 
																			'text5' => trim($nameTRsDose))));
							}				
						} elseif ($nbAntiDep == 2 && $nbMoodS == 1) {
							# Lithium or (Lamotrigine or Topiramate)
							if($checkLamoTopi == 1) {
								$bipolarRule = 1;
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 51, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),
																			'text3' => trim($nameTRDose),  'text4' => trim($nameTRrange), 
																			'text5' => trim($nameTRsDose), 'text6' => trim($nameMSDose),  
																			'text7' => trim($nameMSrange), 'text8' => trim($nameMSsDose))));
							}
							if($checkLamoTopi == 0) {
								$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 53, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),
																			'text3' => trim($nameTRDose),  'text4' => trim($nameTRrange), 
																			'text5' => trim($nameTRsDose), 'text6' => trim($nameMSDose),  
																			'text7' => trim($nameMSrange), 'text8' => trim($nameMSsDose))));				
							}							
						} elseif ($nbAntiDep == 2 && $nbMoodS > 1) {
								$bipolarRule = 1;
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 55, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),
																			'text3' => trim($nameTRDose),  'text4' => trim($nameTRrange), 
																			'text5' => trim($nameTRsDose), 'text6' => trim($nameMSDose), 
																			'text7' => trim($nameMSrange), 'text8' => trim($nameMSsDose), 
																			'text9' => trim($strNoLetters))));
						} elseif ($nbAntiDep > 2 && $nbMoodS == 0){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 35, 'text0' => trim($nameTRDose), 
																			'text1' => trim($nameADDose))));
						} elseif ($nbAntiDep > 2 && $nbMoodS > 0) {
								$bipolarRule = 1;
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep - 1);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 57, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																			'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																			'text5' => trim($nameMSsDose), 'text6' => trim($strNoLetters),
																			'text7' => trim($strADLetters), 'text8' => trim($nameTRDose),
																			'text9' => trim($nameTRsDose), 'text10' => trim($nameTRrange))));
						}		
					} elseif ($nbAtipNeuro == 0 && $nbPotent  == 1) {
						if($checkLithium == 1){
							if ($nbAntiDep == 1 && $nbMoodS == 1) {
								if ($nbAntiDepLine1 == 1){

								} elseif ($nbAntiDepLine1 == 0){
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 47, 'text0' => trim($nameTRDose), 
																			'text1' => trim($nameTRrange), 'text2' => trim($nameTRsDose), 
																			'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																			'text5' => trim($nameMSsDose))));
								}
							} elseif ($nbAntiDep == 1 && $nbMoodS > 1) {
								$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 49, 'text0' => trim($nameTRDose), 
																			'text1' => trim($nameTRrange), 'text2' => trim($nameTRsDose), 
																			'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																			'text5' => trim($nameMSsDose))));	
							} elseif ($nbAntiDep == 2 && $nbMoodS == 1) {
								$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 51, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),
																			'text3' => trim($nameTRrange), 'text4' => trim($nameTRsDose),
																			'text5' => trim($nameMSDose), 'text6' => trim($nameMSrange), 
																			'text7' => trim($nameMSsDose))));
							} elseif ($nbAntiDep == 2 && $nbMoodS > 1) {
								$bipolarRule = 1;
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 55, 'text0' => trim($nameADDose), 
																			'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),
																			'text3' => trim($nameTRDose),  'text4' => trim($nameTRrange), 
																			'text5' => trim($nameTRsDose), 'text6' => trim($nameMSDose), 
																			'text7' => trim($nameMSrange), 'text8' => trim($nameMSsDose), 
																			'text9' => trim($strNoLetters))));
							} elseif ($nbAntiDep > 2 && $nbMoodS > 0) {
								$bipolarRule = 1;							
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep - 1);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 57, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																				'text5' => trim($nameMSsDose), 'text6' => trim($strNoLetters),
																				'text7' => trim($strADLetters), 'text8' => trim($nameTRDose),
																				'text9' => trim($nameTRsDose), 'text10' => trim($nameTRrange))));							
							}							
						} //end checklithium
						if ($nbAntiDep == 1 && $nbMoodS == 0 ) {
							if($nbAntiDepLine1 == 0 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 72, 'text0' => trim($nameTRDose), 
																				'text1' => trim($nameTRrange), 'text2' => trim($nameTRsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose))));					
							}
						}						
					} elseif ($nbAtipNeuro == 1 && $nbPotent  == 0) {
						if ($nbAntiDep == 1 && $nbMoodS == 0){
							if($nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 60, 'text0' => trim($nameTRDose), 
																				'text1' => trim($nameTRrange), 'text2' => trim($nameTRsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose))));								
							}
						} elseif ($nbAntiDep == 2 && $nbMoodS == 0){
						//ECHO '$nbAntiDep '.$nbAntiDep.'<br/>';
						//ECHO '$nbAntiDepLine1 '.$nbAntiDepLine1;
							if ($nbAntiDepLine1 == 1 || $nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 65, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose), 'text6' => trim($nameTRDose),
																				'text7' => trim($nameTRsDose), 'text8' => trim($nameTRrange))));					
							}
						}
					} elseif ($nbAtipNeuro > 1 && $nbPotent  == 0) {
						if ($nbAntiDep == 1 && $nbMoodS == 0){
							if($nbAntiDepLine1 == 0) {
								$strNoLetters = $this->numberLetters($field_temp, $nbAtipNeuro);
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 63, 'text0' => trim($nameTRDose), 
																				'text1' => trim($nameTRrange), 'text2' => trim($nameTRsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose), 'text6' => trim($strNoLetters))));							
							}						
						} elseif ($nbAntiDep == 2 && $nbMoodS == 0){
							if ($nbAntiDepLine1 == 1 || $nbAntiDepLine1 == 0) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 67, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose), 'text6' => trim($nameTRDose),
																				'text7' => trim($nameTRsDose), 'text8' => trim($nameTRrange))));					
							}						
						}
					}
					//echo '$nbAntiDep '.$nbAntiDep;
					if($nbAtipNeuro > 0 && $nbPotent  == 0) {																
						if($nbAntiDep > 2 && $nbMoodS == 0){						
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep - 1);
								$strNoLetters = $this->numberLetters($field_temp, $nbAtipNeuro);				
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 69, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameANDose), 'text4' => trim($nameANrange), 
																				'text5' => trim($nameANsDose), 'text6' => trim($strNoLetters),
																				'text7' => trim($strADLetters), 'text8' => trim($nameTRDose),
																				'text9' => trim($nameTRsDose), 'text10' => trim($nameTRrange))));	
						}			
					}							
					if ($nbAtipNeuro  == 0 && $nbPotent >= 1) {				
						if ($nbAntiDep > 1 && $nbMoodS == 0) {
							if($nbAntiDepLine1 == 0 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 76, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose), 'text6' => trim($nameTRDose),
																				'text7' => trim($nameTRsDose), 'text8' => trim($nameTRrange))));					
							} elseif($nbAntiDepLine1 > 1 && $checkBuspiCyto == 1) {
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 74, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($namePADose), 'text4' => trim($namePArange), 
																				'text5' => trim($namePAsDose), 'text6' => trim($nameTRDose),
																				'text7' => trim($nameTRsDose), 'text8' => trim($nameTRrange))));					
							}
						}				
					}
					if ($nbAntiDep > 0 && $nbMoodS > 0 && $nbAtipNeuro > 0 && (($checkLithium == 1 && $nbPotent  == 1) || ($checkLithium == 0 && $nbPotent  == 0))) {
							$bipolarRule = 1;
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep - 1);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);			
								$strANLetters = $this->numberLetters($field_temp, $nbAtipNeuro);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 78, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																				'text5' => trim($nameMSsDose), 'text6' => trim($nameANDose), 
																				'text7' => trim($nameANrange), 'text8' => trim($nameANsDose),
																				'text9' => trim($strADLetters), 'text10' => trim($strNoLetters),
																				'text11' => trim($strANLetters), 'text12' => trim($nameTRDose),
																				'text13' => trim($nameTRsDose), 'text14' => trim($nameTRrange))));
					}			
					if ($nbAntiDep > 0 && $nbMoodS > 0 && $nbAtipNeuro > 0 && $nbPotent > 0 && $checkLithium == 0) {
								$strADLetters = $this->numberLetters($field_temp, $nbAntiDep - 1);
								$strNoLetters = $this->numberLetters($field_temp, $nbMoodS);			
								$strANLetters = $this->numberLetters($field_temp, $nbAtipNeuro);			
								$strPALetters = $this->numberLetters($field_temp, $nbPotent);
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 80, 'text0' => trim($nameADDose), 
																				'text1' => trim($nameADrange), 'text2' => trim($nameADsDose), 
																				'text3' => trim($nameMSDose), 'text4' => trim($nameMSrange), 
																				'text5' => trim($nameMSsDose), 'text6' => trim($nameANDose), 
																				'text7' => trim($nameANrange), 'text8' => trim($nameANsDose),
																				'text9' => trim($namePADose), 'text10' => trim($namePArange), 
																				'text11' => trim($namePAsDose), 'text12' => trim($strADLetters), 
																				'text13' => trim($strNoLetters), 'text14' => trim($strANLetters),
																				'text15' => trim($strPALetters), 'text16' => trim($nameTRDose),
																				'text17' => trim($nameTRsDose), 'text18' => trim($nameTRrange))));		
					}
				### END -------------- Some AD is Trazodone if it is Trazodone, its dose has to be < 150 mg)	
				}
				
				#----------------------- START Codes for MS alone - from 81 to 84 --------------------------#
				if ($nbAntiDep == 0 && $nbMoodS == 1 && $nbAtipNeuro == 0) {
					if($nbPotent == 0 && $checkLamotrigine == 1){
						$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 81, 'text0' => trim($nameMSDose), 
																				'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose))));
					}
					if ($checkLithium == 1 && $nbPotent  == 1) {
						$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 82, 'text0' => trim($nameMSDose), 
																				'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose))));				
					}				
				} 
				if ($nbAntiDep == 0 && $nbMoodS > 1 && $nbAtipNeuro == 0) {
					if($nbPotent == 0 && $checkLamotrigine == 1) {
						$bipolarRule = 1;
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 83, 'text0' => trim($nameMSDose), 
																				'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose))));				
					}
				}
				if ($nbAntiDep == 0 && $nbMoodS >= 1 && $nbAtipNeuro == 0) {
//					if($nbPotent == 0 && $checkLamotrigine == 0) {
					if(($nbPotent == 0 && $checkLamotrigine == 0) || ($checkLithium == 1 && $nbPotent == 1 && $checkLamotrigine == 0)) {
							$bipolarRule = 1;
								$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 84, 'text0' => trim($nameMSDose), 
																				'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose))));				
					}
				}			
				#----------------------- END Codes for MS alone - from 81 to 84 --------------------------#
				
				#----------------------- START Codes for MS and AN - from 85 to 87 ------------------------#
				if ($nbAntiDep == 0 && ($nbPotent == 0 || ($checkLithium == 1 && $nbPotent  == 1))) {
					if ($nbMoodS == 1 && $nbAtipNeuro == 1){
						if($checkLamotrigine == 1) {
								$bipolarRule = 1;
										$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 85, 'text0' => trim($nameMSDose), 
																					'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose),
																					'text3' => trim($nameANDose), 'text4' => trim($nameANrange),
																					'text5' => trim($nameANsDose))));				
						}				
					}
					if ($nbMoodS > 1 && $nbAtipNeuro >= 1){
						if($checkLamotrigine == 1) {
								$bipolarRule = 1;
										$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 86, 'text0' => trim($nameMSDose), 
																					'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose),
																					'text3' => trim($nameANDose), 'text4' => trim($nameANrange),
																					'text5' => trim($nameANsDose))));				
						}				
					}				
					if ($nbMoodS >= 1 && $nbAtipNeuro >= 1){
						if($checkLamotrigine == 0) {
								$bipolarRule = 1;
										$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 87, 'text0' => trim($nameMSDose), 
																					'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose),
																					'text3' => trim($nameANDose), 'text4' => trim($nameANrange),
																					'text5' => trim($nameANsDose))));				
						}				
					}				
				}			
				#----------------------- END Codes for MS and AN - from 85 to 87 --------------------------#
				
				#----------------------- START Codes for MS and PA - from 88 ------------------------#
				if ($nbAntiDep == 0 && $nbAtipNeuro == 0) {
					if ($nbMoodS > 0 && $nbPotent > 0 && $checkLithium == 0){
										$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 88, 'text0' => trim($nameMSDose), 
																					'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose),
																					'text3' => trim($namePADose), 'text4' => trim($namePArange),
																					'text5' => trim($namePAsDose))));				
					}
				}
				#-----------------------  END  Codes for MS and PA - from 88 ------------------------#

				#----------------------- START Codes for MS, AN and PA - from 89 ------------------------#
				if ($nbAntiDep == 0) {
					if ($nbMoodS > 0 && $nbAtipNeuro > 0 && $nbPotent > 0){
										$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 89, 'text0' => trim($nameMSDose), 
																					'text1' => trim($nameMSrange), 'text2' => trim($nameMSsDose),
																					'text3' => trim($nameANDose), 'text4' => trim($nameANrange),
																					'text5' => trim($nameANsDose), 'text6' => trim($namePADose),																				
																					'text7' => trim($namePArange), 'text8' => trim($namePAsDose))));
					}
				}			
				#-----------------------  END  Codes for MS, AN and PA - from 89 ------------------------#			
				
				#----------------------- START Codes for AN alone - from 90 to 91 --------------------------#
				if ($nbAntiDep == 0 && $nbMoodS == 0 && $nbPotent == 0) {
					if ($nbAtipNeuro == 1){
						$bipolarRule = 1;
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 90, 'text0' => trim($nameANDose), 'text1' => trim($nameANrange),
																										'text2' => trim($nameANsDose))));
					} elseif ($nbAtipNeuro > 1){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 91, 'text0' => trim($nameANDose))));
					}
				}
				#-----------------------  END  Codes for AN alone - from 90 to 91 --------------------------#
				
				#----------------------- START Codes for AN and PA - 92 ------------------------#
				if ($nbAntiDep == 0 && $nbMoodS == 0) {
					if ($nbAtipNeuro > 0 && $nbPotent > 0 && $checkLithium == 0){
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 92, 'text0' => trim($nameANDose),
																					'text1' => trim($nameANrange), 'text2' => trim($nameANsDose),
																					'text3' => trim($namePADose), 'text4' => trim($namePArange),
																					'text5' => trim($namePAsDose))));
					}
				}
				#-----------------------  END  Codes for AN and PA - 92 ------------------------#			
				
				#------------------------------- START Codes for PA alone - 93 ----------------------------------#
				if ($nbAntiDep == 0 && $nbMoodS == 0 && $nbAtipNeuro == 0 && $nbPotent > 0 && $checkQE == 0) {
									$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 93, 'text0' => trim($namePADose), 
																					'text1' => trim($namePArange), 'text2' => trim($namePAsDose))));
				}			
				#----------------------------------  END  Codes for PA alone - 93 --------------------------------#
				

			} elseif ($checkQE == 1) {
			#--------------  YES There is QUETIAPINE  --------------#
			
				if(!empty($nameADDose)) { 
				if ($nbAntiDep > 0 && $nbMoodS > 0 && $nbAtipNeuro >= 0 && $nbPotent >= 0) { 
					//$strMedsDose .= $nameADDose; 
				} else {
					$strMedsDose .= $nameADDose; 
					$strMedsName .= $nameADsDose;
					$strMedsRange .= $nameADrange;				
				}
				}
				//echo '$nameMSDose '.$nameMSDose;
				//echo 'namePADose '.$namePADose;
				//'text2' => trim($strMedsName)
				if(!empty($nameMSDose) && !empty($strMedsDose)) { 
					$strMedsDose .= ', '.$nameMSDose;
					$strMedsName .= ', '.$nameMSsDose;
					$strMedsRange .= ', '.$nameMSrange;
				}
				if(!empty($nameMSDose) && empty($strMedsDose)) { 
					$strMedsDose .= $nameMSDose;
					$strMedsName .= $nameMSsDose;
					$strMedsRange .= $nameMSrange;					
				}
				if(!empty($nameANDose) && !empty($strMedsDose)) { 
					$strMedsDose .= ', '.$nameANDose;
					$strMedsName .= ', '.$nameANsDose;
					$strMedsRange .= ', '.$nameANrange;					
				} 
				if(!empty($nameANDose) && empty($strMedsDose)) { 
					$strMedsDose .= $nameANDose;
					$strMedsName .= $nameANsDose;
					$strMedsRange .= $nameANrange;
				} 
				if(!empty($namePADose) && !empty($strMedsDose)) { 
					$strMedsDose .= ', '.$namePADose;
					$strMedsName .= ', '.$namePAsDose;
					$strMedsRange .= ', '.$namePArange;										
				} 
				if(!empty($namePADose) && empty($strMedsDose)) { 
					$strMedsDose .= $namePADose;
					$strMedsName .= $namePAsDose;
					$strMedsRange .= $namePArange;					
				} 		
				if(!empty($nameTRDose) && !empty($strMedsDose)) { 
					$strMedsDose .= ', '.$nameTRDose;
					$strMedsName .= ', '.$nameTRsDose;
					$strMedsRange .= ', '.$nameTRrange;										
				} 				
				if(!empty($nameTRDose) && empty($strMedsDose)) { 
					$strMedsDose .= $nameTRDose;
					$strMedsName .= $nameTRsDose;
					$strMedsRange .= $nameTRrange;					
				} 
				##############
				if ($nbAntiDep == 0 && $nbMoodS > 0 && $nbAtipNeuro >= 0 && $nbPotent >= 0 && $nbQE == 1) {
					if ($checkLithium == 0 && $nbAtipNeuro == 0) {
						$bipolarRule = 1;
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 96, 'text0' => trim($nameQEsDose),
																			'text1' => trim($nameMSsDose))));
					} 
					if ($nbAtipNeuro >= 0) {						
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 94, 'text0' => trim($strMedsDose), 
																			'text1' => trim($strMedsRange), 'text2' => trim($strMedsName),
																			'text3' => trim($nameQEDose))));
					}					
					if ($checkLithium == 1 && $nbAtipNeuro >= 0) {
						
/*						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 98, 'text0' => trim($strMedsDose), 
																			'text1' => trim($strMedsRange), 'text2' => trim($strMedsName),
																			'text3' => trim($nameQEDose), 'text4' => trim($nameQEsDose),
																			'text5' => trim($nameMSsDose))));	*/
						$bipolarRule = 1;
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 98, 'text0' => trim($nameQEsDose),
																			'text1' => trim($nameMSsDose))));																			
					}
				}
				if ($nbAntiDep > 0 && $nbMoodS > 0 && $nbAtipNeuro >= 0 && $nbPotent >= 0 && $nbQE == 1) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 95, 'text0' => trim($strMedsDose), 
																		'text1' => trim($strMedsRange), 'text2' => trim($strMedsName),
																		'text3' => trim($nameQEDose), 'text4' => trim($nameMSsDose), 
																		'text5' => trim($nameADDose), 'text6' => trim($nameADrange), 
																		'text7' => trim($nameADsDose))));	
																		
/*																		
echo 'text0 :'.$strMedsDose;	//Wellbutrin 300 mg, Mylan-Lamotrigine 150 mg
echo 'text1 :'.$strMedsRange;	//, 75-400 mg
echo 'text2 :'.$strMedsName;	//, Mylan-Lamotrigine
echo 'text3 :'.$nameQEDose;		//Seroquel 25 mg
echo 'text4 :'.$nameMSsDose;	//Mylan-Lamotrigine
echo 'text5 :'.$nameADrange;	//100-300 mg
echo 'text6 :'.$nameADsDose;	//Wellbutrin */
/*
					$strMedsDose .= $nameADDose; 
					$strMedsName .= $nameADsDose;
					$strMedsRange .= $nameADrange;				
'text0' => trim($nameADDose), 
'text1' => trim($nameADrange), 'text2' => trim($nameADsDose),					
*/																			
					if ($checkLithium == 0 ) {
						$bipolarRule = 1;
/*						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 97, 'text0' => trim($strMedsDose), 
																			'text1' => trim($strMedsRange), 'text2' => trim($strMedsName),
																			'text3' => trim($nameQEDose), 'text4' => trim($nameQEsDose),
																			'text5' => trim($nameMSsDose), 'text6' => trim($nameADrange), 
																			'text7' => trim($nameADsDose))));*/
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 97, 'text0' => trim($nameQEsDose),
																			'text1' => trim($nameMSsDose), 'text2' => trim($nameADsDose))));																			
					} elseif ($checkLithium == 1 ) {
						$bipolarRule = 1;
/*						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 99, 'text0' => trim($strMedsDose), 
																			'text1' => trim($strMedsRange), 'text2' => trim($strMedsName),
																			'text3' => trim($nameQEDose), 'text4' => trim($nameQEsDose),
																			'text5' => trim($nameMSsDose), 'text6' => trim($nameADrange), 
																			'text7' => trim($nameADsDose))));	*/	
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 99, 'text0' => trim($nameQEsDose),
																			'text1' => trim($nameMSsDose), 'text2' => trim($nameADsDose))));																			
					}
				}				
				##############	
//echo 'text3 :'.$nameQEDose;				
				if ($nbAntiDep > 0 || $nbMoodS > 0 || $nbAtipNeuro > 0 || $nbPotent > 0) {
					if($doseQE == 0) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 109, 'text0' => trim($strMedsDose), 
																			'text1' => trim($strMedsRange), 
																			'text2' => trim($strMedsName),
																			'text3' => trim($nameQEDose))));						
					} 
				}
				//echo '$doseQE '.$doseQE;
				if ($nbMoodS == 0 && ($nbAntiDep > 0 || $nbAtipNeuro > 0 || $nbPotent > 0)) {
					if ($checkLithium == 0 ) {
						if($doseQE > 0) {
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 100, 'text0' => trim($strMedsDose), 
																				'text1' => trim($strMedsRange), 
																				'text2' => trim($strMedsName),
																				'text3' => trim($nameQEDose))));						
						}
						if($doseQE > 0 && $doseQE < 50) {
/*							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 100, 'text0' => trim($strMedsDose), 
																				'text1' => trim($strMedsRange), 
																				'text2' => trim($strMedsName),
																				'text3' => trim($nameQEDose), 'text4' => trim($nameQEsDose))));  */ 	
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 101, 'text0' => trim($nameQEsDose))));																				
						} elseif($doseQE >= 50 && $doseQE <= 150) {
/*							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 105, 'text0' => trim($strMedsDose), 
																				'text1' => trim($strMedsRange), 
																				'text2' => trim($strMedsName),
																				'text3' => trim($nameQEDose), 'text4' => trim($nameQEsDose))));*/
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 105, 'text0' => trim($nameQEsDose))));																				
						} elseif($doseQE > 150) {
/*							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 107, 'text0' => trim($strMedsDose), 
																				'text1' => trim($strMedsRange), 
																				'text2' => trim($strMedsName),
																				'text3' => trim($nameQEDose), 'text4' => trim($nameQEsDose))));*/
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 107, 'text0' => trim($nameQEsDose))));																					
						}
					}	
				}				
				/*
				echo '$strMedsDose '.$strMedsDose;  //$strMedsDose Mirtazapine 45 mg
				echo '$strMedsRange '.$strMedsRange; //$strMedsRange 
				echo '$strMedsName '.$strMedsName; //$strMedsName 
				echo '$nameQEDose '.$nameQEDose;  //$nameQEDose Seroquel XR 200 mg
				echo '$nameQEsDose '.$nameQEsDose;  //$nameQEsDose Seroquel XR  */
				if ($nbAntiDep == 0 && $nbMoodS == 0 && $nbAtipNeuro == 0 && $nbPotent == 0) {
					if($doseQE == 0) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 110, 
																			'text0' => trim($nameQEsDose), 'text1' => trim($nameQErange))));
					} elseif($doseQE > 0) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 103, 'text0' => trim($nameQEDose))));						
						if($doseQE > 0 && $doseQE < 50) {
	/*						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 104, 
																				'text0' => trim($nameQEDose), 'text1' => trim($nameQEsDose))));	 */																								
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 104, 'text0' => trim($nameQEsDose))));																				
						} elseif($doseQE >= 50 && $doseQE <= 150) {
/*							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 106, 
																				'text0' => trim($nameQEDose), 'text1' => trim($nameQEsDose))));	*/
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 106, 'text0' => trim($nameQEsDose))));
						} elseif($doseQE > 150) {
/*							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 108, 
																				'text0' => trim($nameQEDose), 'text1' => trim($nameQEsDose))));	*/
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 108, 'text0' => trim($nameQEsDose))));																				
						}					
					}
				}
				if($doseQE == 0) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 113, 'text0' => trim($nameQEsDose))));
				}
			}
			if($nbsDose == 1) {
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 111, 'text0' => trim($chainesDose))));
			} elseif($nbsDose > 1) {
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 112, 'text0' => trim($chainesDose))));
			}
			#-----------------------  START  Codes for Higher / Lower dose [AD] - from 114 to 119 --------------------------#
			//echo '$nbAntiDep '.$nbAntiDep;
			/****************************************************************/
			if ($doseTrazodone > 0 && $doseTrazodone < 150) $nbAntiDep--;
			/****************************************************************/
			if ($nbAntiDep == 1 && $Dspvalues2['DspScore']['GRD'] > 2) {
				if ($checkTrazodone == 0 || ($checkTrazodone == 1 && $isTrazoAD)){
				if ($diffdaysAD > 0 && $diffdaysAD <= 14) {
					if ($higherDose == 9) {	
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 114, 'text0' => trim($nameADDose))));
					} 
					if ($higherDose == 1 && !empty($doseADAnyLine)) {	
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 115, 'text0' => trim($nameADsDose),
																					'text1' => trim($doseADAnyLine))));
					} 
					if ($higherDose == 0 && !empty($doseADAnyLine)) {	
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 116, 'text0' => trim($nameADsDose),
																					'text1' => trim($doseADAnyLine))));
					} 
				}
				if($typeTest == 0){
					if ($diffdaysAD > 84 && $diffdaysAD != 9999 && $checkImprov == 0 && $Dspvalues2['DspScore']['DEP'] > 59) {
						if($supramaximal == 0){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 117)));
						}elseif($supramaximal == 1){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 118)));
						}
					}								
					//if ($diffdaysAD > 0 && $diffdaysAD <= 84 && $supramaximal == 1 && $checkImprov == 0) {
					if ($diffdaysAD > 0 && $diffdaysAD <= 84 && $supramaximal == 1) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 119)));
					}
				}				
				}
			} 
			#-----------------------  END  Codes for Higher / Lower dose [AD] - from 114 to 119 --------------------------#
			
			#-------- START for BOTH - if $nbAntiDepLine1 == 0 and not enought therapy - Codes from 133 to 135 --------#
			if($nbAntiDepLine1 == 0  && $Dspvalues2['DspScore']['GRD'] > 2) {
			//echo '$nbAntiDepLine1Stop '.$nbAntiDepLine1Stop;
				if($nbAntiDepLine1Stop == 0) {
					if ($Dspvalues2['DspScore']['DEP'] > 69 && $TreatQuestvalues[0]['QuestionnaireTreatment']['psychotherapy'] == 0) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 133)));
					} elseif ($Dspvalues2['DspScore']['DEP'] > 69 && $TreatQuestvalues[0]['QuestionnaireTreatment']['psychotherapy'] == 1) {
						if ($typeTest == 0 && $bipolarRule == 0) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 134))); }
						if ($typeTest == 1 && $bipolarRule == 0 && ($improvVal == 999 || ($improvVal > 0 && $improvVal < 20))) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 134))); }
					}					
				}elseif($nbAntiDepLine1Stop > 0){
					if ($Dspvalues2['DspScore']['DEP'] > 79) {				
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 135)));
					}					
				}
			}						
			#-------- END ONLY for INITIAL - if $nbAntiDepLine1 == 0 and not enought therapy - Codes from 133 to 135 --------#

			#-----------------  START  Codes doses drugs from 121 to 132 --------------------------#
			if($doseTrazodone > 0 && $doseTrazodone < 150){
				// var_dump($DrPharmCodeTemp);
				// echo  $nameTRDose;
				// exit; //aaron exit
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 121, 'text0' => $nameTRDose)));
			}
			if ($doseAmitriptyline > 0 && $doseAmitriptyline < 51 && $check44 == 0) {
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 122, 'text0' => $nameAmitriptyline)));
			}
			if($countNODate == 1){
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 123, 'text0' => trim($nameNODateAD))));
			}elseif($countNODate > 1){
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 124, 'text0' => trim($nameNODateAD))));
			}
			if ($doseVenlafaxine > 0 && $doseVenlafaxine < 150) { 
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 125, 'text0' => $nameVenlafaxine)));
			}
			if ($doseCitalopram > 40) { 
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 126, 'text0' => $nameCitalopram)));
			} 
			if ($doseEscitalopram > 20) {			
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 127)));
			}		

			if ($checkSertraline == 1) {
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 128, 'text0' => $nameSertraline)));
			}			
			if ($checkDuloxetine == 1) { 
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 129, 'text0' => $nameDuloxetine)));
			}
			if (!empty($nameBenzo)) {
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 130, 'text0' => trim($nameBenzo))));
			}	
			if ($countCustomeDrug > 0 && $drugTable == 1){
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 131, 'text0' => trim($nameCustomeDrug))));				
			} elseif ($countCustomeDrug > 0 && $drugTable == 0){
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 132, 'text0' => trim($nameCustomeDrug))));				
			}			
			#-----------------  END  Codes doses drugs from 121 to 132  --------------------------#
		#----------------- END Q.1 = 1 Yes, receiving any treatment  ----------------#
		} elseif ($TreatQuestvalues[0]['QuestionnaireTreatment']['treatment'] == 0) {
			#---- Initial -------- Q.1 = 0 Not, receiving any treatment with Meds -----------#
			if ($typeTest == 0) {
				#----- Looping the Stopped Medication list for an INITIAL test ------#				
				for ($i=0; $i < count($TreatQuestvalues[0]['MedicationTreatment']); $i++) {
					$drugInfo = $TreatQuestvalues[0]['MedicationTreatment'][$i]['Drug'];
					if ($TreatQuestvalues[0]['MedicationTreatment'][$i]['type_temps'] == 0) {
					/* Call to Stopped Medications */
						$getStoppedMeds = $this->getStoppedMeds($drugInfo, $TreatQuestvalues[0]['MedicationTreatment'][$i], $stoppedmedsnameTemp, $stoppedMeds, $nbAntiDepStop, $nbAntiDepLine1Stop, $field_temp);
						$stoppedmedsnameTemp = $getStoppedMeds[0];
						$stoppedMeds = $getStoppedMeds[1];
						$nbAntiDepStop = $getStoppedMeds[2];
						$nbAntiDepLine1Stop = $getStoppedMeds[3];				
					}
				}	
				if(count($TreatQuestvalues[0]['MedicationTreatment']) == 0) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 24))); }
			} elseif ($typeTest == 1) { 
			#---- Followup -------- START Q.1 = 0 Not, receiving any treatment with Meds -----------#
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 25))); 
			}
			if($Dspvalues2['DspScore']['GRD'] > 2) {
				//echo '$nbAntiDepLine1Stop 333 '.$nbAntiDepLine1Stop;
				if($nbAntiDepLine1Stop == 0) {
					if ($Dspvalues2['DspScore']['DEP'] > 69 && $TreatQuestvalues[0]['QuestionnaireTreatment']['psychotherapy'] == 0) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 133)));
					} elseif ($Dspvalues2['DspScore']['DEP'] > 69 && $TreatQuestvalues[0]['QuestionnaireTreatment']['psychotherapy'] == 1) {						
						if ($typeTest == 0 && $bipolarRule == 0) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 134))); }
						if ($typeTest == 1 && $bipolarRule == 0 && ($improvVal == 999 || ($improvVal > 0 && $improvVal < 20))) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 134))); }						
					}					
				}elseif($nbAntiDepLine1Stop > 0){
					if ($Dspvalues2['DspScore']['DEP'] > 79) {				
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 135)));
					}					
				}
			}			
		#------------ END Q.1 = 0 Not, receiving any treatment with Meds -----------#	
		}		
		#----------- END ------------ COMMON RULES for Initial and Follow Up ------------------------#

		
		#----------- START COMMON RULES - Yes There are nonprescrip_compounds (out of 'If cond. meds')-----------#
		if ($TreatQuestvalues[0]['QuestionnaireTreatment']['nonprescrip_compounds'] == 1 && !empty($TreatQuestvalues[0]['QuestionnaireTreatment']['nonprescrip_compounds_name']))  {
			$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 136, 'text0' => $TreatQuestvalues[0]['QuestionnaireTreatment']['nonprescrip_compounds_name'])));			
			if(stristr($TreatQuestvalues[0]['QuestionnaireTreatment']['nonprescrip_compounds_name'], 'wort') === true) {
				if ($nbAntiDep > 0) {
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 138, 'text0' => $nameADsDose)));
				}
			}
		} elseif ($TreatQuestvalues[0]['QuestionnaireTreatment']['nonprescrip_compounds'] == 1 && empty($TreatQuestvalues[0]['QuestionnaireTreatment']['nonprescrip_compounds_name']))  {
			$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 137)));
		}
		if ($stoppedMeds > 0) {
			$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 139)));
		}
		#------ Yes There are some Side Effects
		if ($TreatQuestvalues[0]['QuestionnaireTreatment']['side_effects'] == 1) {
			//if(!empty($TreatQuestvalues['QuestionnaireTreatment']['side_effects_list'])) {
				$sideEffectChaine = substr($TreatQuestvalues[0]['QuestionnaireTreatment']['side_effects_list'], 1);				
				$sideEffectArray = explode(":", $sideEffectChaine);
					
				$listSideEffect = $this->TherapyTreatment->ChoiceSecondary->find('list', 
										array('conditions' => array('ChoiceSecondary.id' => $sideEffectArray),
											'fields' => array('id',$field_temp),
											'order' => 'id ASC'));
				$chaineSideEffect = '';					
				$newarray = array();
				$array_keys = array_keys($listSideEffect);
				$se=0;
				$totalse = count($array_keys);
				foreach($array_keys as $key){
					$newarray[$se] = $listSideEffect[$key];
					if ($key == 32 || $key == 46) {
						$chaineSideEffect .= '"'.$TreatQuestvalues[0]['QuestionnaireTreatment']['custome_side_effect'].'"';
					} else {
						$chaineSideEffect .= strtolower($newarray[$se]);
					}
					if ($se == ($totalse - 1)) {
						$chaineSideEffect .= '';
					} elseif ($se == ($totalse - 2)) {
						# avant dernier scale
						if ($field_temp == 'name_eng') { $chaineSideEffect .= ' and '; }
						#spanish
						if ($field_temp == 'name_fre') { $chaineSideEffect .= ' y '; }						
					} else {
							$chaineSideEffect .= ', ';
					}											
					$se++;
				}
			//}
			#### Yes considering stopping Meds
			if ($TreatQuestvalues[0]['QuestionnaireTreatment']['stoping_drugs'] == 1) {	
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 140, 'text0' => $chaineSideEffect)));
			} else {
			#### Not considering stopping Meds
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 141)));				
			}		
		} else {
		#----------- No, There are NO Side Effects
			if ($TreatQuestvalues[0]['QuestionnaireTreatment']['treatment'] == 1) {
				$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 142)));
			}			
		}	
		#---------START ---- Check for the List of additional medications
		if (!empty($TreatQuestvalues[0]['QuestionnaireTreatment']['taking_meds_list'])) {
			$generalChaine = substr($TreatQuestvalues[0]['QuestionnaireTreatment']['taking_meds_list'], 1);				
			$generalArray = explode(":", $generalChaine);
				
			$listGeneral = $this->TherapyTreatment->ChoiceSecondary->Choice->find('list', 
									array('conditions' => array('Choice.id' => $generalArray),
										'fields' => array('id',$field_temp),
										'order' => 'id ASC'));
			$chaineGeneral = '';					
			$newarray = array();
			$array_keys = array_keys($listGeneral);
			$se=0;
			$totalse = count($array_keys);
			//echo pr($array_keys);
/*
Array
(
    [0] => 1068
)
1038
1068
*/			
			foreach($array_keys as $key){
				if ($key == 1038 || $key == 1068) {
					//echo mb_substr($str, $s, $l) ."\n"; // Bü
					$pos = strpos($listGeneral[$key], '(');
					//echo $pos;
					//echo mb_substr($listGeneral[$key], 0, $pos);
					$newarray[$se] = mb_substr($listGeneral[$key], 0, $pos);				
				} else {
					$newarray[$se] = $listGeneral[$key];
				}
				//echo $newarray[$se];
				if ($se == ($totalse - 1)){
					$chaineGeneral .= $newarray[$se];
				} else {
					//avant dernier scale
					if ($se == ($totalse - 2)) {
						if ($field_temp == 'name_eng') { $chaineGeneral .= $newarray[$se].' and '; }
						#spanish
						if ($field_temp == 'name_fre') { $chaineGeneral .= $newarray[$se].' y '; }						
					} else {
						$chaineGeneral .= $newarray[$se].', ';
					}
				}				
				$se++;
			}
			$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 144, 'text0' => trim($chaineGeneral))));
			if ($totalse == 1) {$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 145)));	}
			if ($totalse > 1) {$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 146)));	}						
		}
		#---------END ---- Check for the List of additional medications		
		#----------- END COMMON RULES - Yes There are nonprescrip_compounds (out of 'If cond. meds')-----------#
		
		#-------------------------------- START RULES for FOLLOW UPs ----------------------------------#
		if ($typeTest == 1){
		//echo '$diffdaysAD '.$diffdaysAD;
		//echo '$nbAntiDep 3'.$nbAntiDep;
			#  GI of [Current Test] > 2   AND  ID 5 OR ID 6 does NOT apply on [Current Test]
			if($Dspvalues2['DspScore']['GRD'] > 2 && $arrayR5R6[0] == 0) {	
				if($Dspvalues0['DspScore']['DEP'] > 64 && $Dspvalues2['DspScore']['DEP'] > 64 && $Dspvalues2['DspScore']['DEP'] > $Dspvalues0['DspScore']['DEP']) {
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 147))); 
					if($diffdaysAD > 13 && $diffdaysAD != 9999 && $nbAntiDep == 1){ $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 153))); }
				}	
				//echo '$improvVal '.$improvVal;
				if ($improvVal == 0) { 
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 148))); 
					if($diffdaysAD > 13 && $diffdaysAD != 9999 && $nbAntiDep == 1){ $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 153))); }
				}
				if ($improvVal >= 1 && $improvVal <= 5) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 149))); }
				if ($improvVal >= 6 && $improvVal <= 14) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 150))); }
				if ($improvVal >= 15 && $improvVal <= 19) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 151))); }
				if ($improvVal > 19 && $improvVal != 999 && $Dspvalues2['DspScore']['DEP'] >= 60) { 
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 152))); 
				}					
				//echo pr($DrPharmCodeTemp);
				if($nbAntiDep == 1 && $Dspvalues2['DspScore']['DEP'] > 59 && $Dspvalues2['DspScore']['DEP'] < 65) {
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 154)));
					if($Dspvalues0['DspScore']['DEP'] > 64 && $improvVal >= 6 && $improvVal <= 14) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 155)));}
					//if($Dspvalues0['DspScore']['DEP'] > 64) { $DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 155)));}
				}elseif($nbAntiDep == 1 && $Dspvalues2['DspScore']['DEP'] > 64) {
					if ($diffdaysAD > 0 && $diffdaysAD < 14) {
						$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 156))); 
					}elseif ($diffdaysAD > 13 && $diffdaysAD < 28) {
						if ($improvVal >= 0 && $improvVal <= 7){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 157))); 
						}elseif ($improvVal > 7 && $improvVal <= 19){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 158))); 
						} elseif ($improvVal >= 20 && $improvVal <= 49){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 159, 'text0' => $nameADsDose))); 
							//echo pr($DrPharmCodeTemp);							
						} elseif ($improvVal > 49 && $improvVal != 999){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 160, 'text0' => $nameADsDose))); 
						}										
					}elseif ($diffdaysAD > 27 && $diffdaysAD < 85) {
						if ($improvVal >= 0 && $improvVal <= 19){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 161))); 
						} elseif ($improvVal >= 20 && $improvVal <= 49){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 162))); 
						} elseif ($improvVal > 49 && $improvVal != 999){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 163))); 
						}								
					}elseif ($diffdaysAD > 84 && $diffdaysAD != 9999) {
						if ($improvVal >= 0 && $improvVal <= 19){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 164))); 
						} elseif ($improvVal >= 20 && $improvVal <= 49){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 165))); 
						} elseif ($improvVal > 49 && $improvVal != 999){
							$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 166))); 
						}				
					}
				}
				if ($Dspvalues0['DspScore']['DEP'] > 64 && $Dspvalues2['DspScore']['DEP'] < 60 &&
					$Dspvalues2['DspScore']['ANX'] < 60 && $Dspvalues2['DspScore']['SOM'] < 60 && $nbAntiDep > 0) {
					$DrPharmCodeTemp = array_merge($DrPharmCodeTemp, array(array('id' => 167))); 
				}
			}			
		}
		//echo pr($DrPharmCodeTemp);
		if ($typeTest == 0) { return array($DrPharmCodeTemp, $stoppedmedsnameTemp, $checkdoseCita); } 
		if ($typeTest == 1) { return array($DrPharmCodeTemp, $checkdoseCita); }	
	}
	
	############################################################################
	#### 						getStoppedMeds								 ###
	############################################################################	
	function getStoppedMeds ($drugInfoTmp, $TreatQuestvaluesTmp, $stoppedmedsTemp, $stoppedMeds, $nbAntiDepStop, $nbAntiDepLine1Stop, $field_temp) 
	{
	//echo pr($TreatQuestvaluesTmp);
		//$strUnit = 'mg';
		$strNameMed = '';
	//echo pr($drugInfoTmp);	
		$stoppedMeds++;
		/***AAA***/
		if (!empty($drugInfoTmp['id'])) {
			# Antidepression = 1
			if ($drugInfoTmp['type_d1'] == 1) {
				$nbAntiDepStop++;
				if ($drugInfoTmp['line'] == 1) { $nbAntiDepLine1Stop++; } 
			}		
			//$strUnit = $drugInfoTmp['unit'];
			$strNameMed = $drugInfoTmp['name'];
		} else {
			$strNameMed = $TreatQuestvaluesTmp['custome_drug'];
		}				
		/***AAA***/
		
		if (!empty($TreatQuestvaluesTmp['reason_stopped_list'])) {
			$listestop = substr($TreatQuestvaluesTmp['reason_stopped_list'], 1);
		} else {
			$listestop = '';
		}	
	
		$selectedstop1 = explode(":", $listestop);	
		$selectedstop = $this->TherapyTreatment->ChoiceSecondary->find('list', 
						array(
							'conditions' => array('ChoiceSecondary.id' => $selectedstop1),
							'fields' => array('id',$field_temp),
							'order' => 'id ASC'));
		//echo pr($selectedstop);
		$chaineselectedstop = '';
		foreach ($selectedstop as $reasonstopped):
			$chaineselectedstop .= $reasonstopped.' ';
			#echo pr($reasonstopped);
		endforeach;	

		if (!empty($TreatQuestvaluesTmp['custome_dose']) && $TreatQuestvaluesTmp['custome_dose'] != 0) {
				$whole = floor($TreatQuestvaluesTmp['custome_dose']);      // 100
				$fraction = $TreatQuestvaluesTmp['custome_dose'] - $whole; // .00
				
				if ($fraction == 0 || $fraction == 0.00) {
					$customeStopDose = $whole.' mg';
				} else {
					$customeStopDose = $TreatQuestvaluesTmp['custome_dose'].' mg';
				}								
		} else {
			$customeStopDose = '';
		}					
		$stoppedmedsTemp = array_merge($stoppedmedsTemp, array(array('name' => $strNameMed, 
												'customedose' => $customeStopDose,
												'reasons' => $chaineselectedstop)));

		return array($stoppedmedsTemp, $stoppedMeds, $nbAntiDepStop, $nbAntiDepLine1Stop);
	}
	
	############################################################################
	#### BEGIN - ['GRD'] == 3 (RULES 4 T0 5) - Check IF RULE 4 / RULE 5  ###
	############################################################################	
	function checkRule5Rule6 ($infoValDspScored) {
		if ($infoValDspScored['DspScore']['GRD'] == 3) {
			# DSP - 45 - SOM DEP ALC ANX RB (GRD-Q44)
			if ($infoValDspScored['DspScore']['questionnaire_id'] == 1){			
				## RULE 5 - EACH scale of the  DSP is < 50
				if ($infoValDspScored['DspScore']['DEP'] < 50 && $infoValDspScored['DspScore']['ANX'] < 50) { 					
					return 5;
				}
				## RULE 6 - ONLY the DEP is < 50
				if ($infoValDspScored['DspScore']['DEP'] < 50 && $infoValDspScored['DspScore']['SOM'] >= 50 && $infoValDspScored['DspScore']['ALC'] >= 50 &&
					$infoValDspScored['DspScore']['ANX'] >= 50 && $infoValDspScored['DspScore']['RB'] >= 50) { 
					return 6;
					}
			} elseif ($infoValDspScored['DspScore']['questionnaire_id'] == 2){
			# DSP - 77  SOM DEP ALC ANX OBS PAN AGO TRA MIN RB (GRD-Q44)
				## RULE 5 - EACH scale of the  DSP is < 50		
				if ($infoValDspScored['DspScore']['DEP'] < 50 && $infoValDspScored['DspScore']['ANX'] < 50) { 	
					return 5;
				} 
				## RULE 6 - ONLY the DEP is < 50
				if ($infoValDspScored['DspScore']['DEP'] < 50 && $infoValDspScored['DspScore']['SOM'] >= 50 && $infoValDspScored['DspScore']['ALC'] >= 50 &&
					$infoValDspScored['DspScore']['ANX'] >= 50 && $infoValDspScored['DspScore']['OBS'] >= 50 && $infoValDspScored['DspScore']['PAN'] >= 50 &&
					$infoValDspScored['DspScore']['AGO'] >= 50 && $infoValDspScored['DspScore']['TRA'] >= 50 && $infoValDspScored['DspScore']['MIN'] >= 50 &&
					$infoValDspScored['DspScore']['RB'] >= 50) {
					return 6;
					}
			}
		}
		return 0;	
	}
	
	############################################################################
	#### BEGIN - Checks RULES 19 and 20
	############################################################################	
	function checkRule19Rule20 ($infoValDspScored) {
		if ($infoValDspScored['DspScore']['ALC'] > 64) {
			# DSP 45
			if ($infoValDspScored['DspScore']['questionnaire_id'] == 1) {
				#Answers Info
				$sumALC = 0;
				$sumALCCritical = 0;
				for ($h=0; $h < 45; $h++){										
					$rest = substr($infoValDspScored['DspScore']['answers'], $h, 1);
					# Check Q.9/Q.12/Q.15/Q.23/Q.30/Q.35/Q.42/Q.43/
					if ( $h == 8 || $h == 11 || $h == 14 || $h == 22 || $h == 29 || $h == 34 || $h == 41 || $h == 42) {
						if ($rest >= 3) { $sumALCCritical = 1; }
					}
				}
			} elseif ($infoValDspScored['DspScore']['questionnaire_id'] == 2) {
			# DSP 77
				#Answers Info
				$sumALC = 0;
				$sumALCCritical = 0;
				for ($h=0; $h < 77; $h++){										
					$rest = substr($infoValDspScored['DspScore']['answers'], $h, 1);
					# Check Q.11/Q.15/Q.21/Q.35/Q.52/Q.62/Q.69/Q.73/
					if ( $h == 10 || $h == 14 || $h == 20 || $h == 34 || $h == 51 || $h == 61 || $h == 68 || $h == 70) {
						if ($rest >= 3) { $sumALCCritical = 1; }
					}
				}					
			}
			return array(1, $sumALCCritical);
		} else {
			return array(0, 0);
		}
	}	
	
	#########################################################################
	#### CHECK IF THERE ARE ELEVATIONS IN THE SCALES					  ###
	#########################################################################	
	function checkElevations ($strValDspScored) {
		$HighScalesTemp0 = array();
		$HighScaleSOM = array();
		$HighScaleALC = array();
		$HighScaleANX = array();
		$HighScaleRB = array();
		$HighScaleOBS = array();
		$HighScalePAN = array();
		$HighScaleAGO = array();
		$HighScaleTRA = array();
		$HighScaleMIN = array();
		
		$elevations = 0;
		
		### BEGIN - Check IF the DSP (exception: DEP) has Elevations = 1(>60) OR No Elevations = 0(<60) ###
		# DSP - 45 - SOM DEP ALC ANX RB (GRD-Q44)
		if ($strValDspScored['DspScore']['questionnaire_id'] == 1){	
			# The DSP has No Elevations = 0(<60) - DEP not included
			if ($strValDspScored['DspScore']['SOM'] < 60 && $strValDspScored['DspScore']['ALC'] < 60 && 
				$strValDspScored['DspScore']['ANX'] < 60 && $strValDspScored['DspScore']['RB'] < 80) { 
				$elevations = 0; 
			} else {
			# The DSP has Elevations = 1 at least one(>59) - DEP not included
				if ($strValDspScored['DspScore']['SOM'] > 59) { $HighScaleSOM = array('scale' => 'SOM', 'value' => $strValDspScored['DspScore']['SOM']); }
				if ($strValDspScored['DspScore']['ALC'] > 59) { $HighScaleALC = array('scale' => 'ALC', 'value' => $strValDspScored['DspScore']['ALC']); }
				if ($strValDspScored['DspScore']['ANX'] > 59) { $HighScaleANX = array('scale' => 'ANX', 'value' => $strValDspScored['DspScore']['ANX']); }
				if ($strValDspScored['DspScore']['RB'] > 79) { $HighScaleRB = array('scale' => 'RB', 'value' => $strValDspScored['DspScore']['RB']); }
				$elevations = 1;
				$HighScalesTemp0 = array_filter(array($HighScaleSOM,$HighScaleALC,$HighScaleANX,$HighScaleRB));
				sort($HighScalesTemp0);
			}				
		}
		# DSP - 77  SOM DEP ALC ANX OBS PAN AGO TRA MIN RB (GRD-Q44)			
		elseif ($strValDspScored['DspScore']['questionnaire_id'] == 2){
			# The DSP has No Elevations = 0(<60) - DEP not included
			if ($strValDspScored['DspScore']['SOM'] < 60 && $strValDspScored['DspScore']['ALC'] < 60 && 
				$strValDspScored['DspScore']['ANX'] < 60 && $strValDspScored['DspScore']['OBS'] < 60 && $strValDspScored['DspScore']['PAN'] < 60 &&
				$strValDspScored['DspScore']['AGO'] < 60 && $strValDspScored['DspScore']['TRA'] < 60 && $strValDspScored['DspScore']['MIN'] < 60 &&
				$strValDspScored['DspScore']['RB'] < 80) { 
				$elevations = 0; 
			} else { 
			# The DSP has Elevations = 1 at least one(>59) - DEP not included
				if ($strValDspScored['DspScore']['SOM'] > 59) { $HighScaleSOM = array('scale' => 'SOM', 'value' => $strValDspScored['DspScore']['SOM']); }
				if ($strValDspScored['DspScore']['ALC'] > 59) { $HighScaleALC = array('scale' => 'ALC', 'value' => $strValDspScored['DspScore']['ALC']); }						
				if ($strValDspScored['DspScore']['ANX'] > 59) { $HighScaleANX = array('scale' => 'ANX', 'value' => $strValDspScored['DspScore']['ANX']); }
				if ($strValDspScored['DspScore']['OBS'] > 59) { $HighScaleOBS = array('scale' => 'OBS', 'value' => $strValDspScored['DspScore']['OBS']); }
				if ($strValDspScored['DspScore']['PAN'] > 59) { $HighScalePAN = array('scale' => 'PAN', 'value' => $strValDspScored['DspScore']['PAN']); }
				if ($strValDspScored['DspScore']['AGO'] > 59) { $HighScaleAGO = array('scale' => 'AGO', 'value' => $strValDspScored['DspScore']['AGO']); }
				if ($strValDspScored['DspScore']['TRA'] > 59) { $HighScaleTRA = array('scale' => 'TRA', 'value' => $strValDspScored['DspScore']['TRA']); }
				if ($strValDspScored['DspScore']['MIN'] > 69) { $HighScaleMIN = array('scale' => 'MIN', 'value' => $strValDspScored['DspScore']['MIN']); }
				if ($strValDspScored['DspScore']['RB'] > 79) { $HighScaleRB = array('scale' => 'RB', 'value' => $strValDspScored['DspScore']['RB']); }	
				$elevations = 1; 
				$HighScalesTemp0 = array_filter(array($HighScaleSOM,$HighScaleALC,$HighScaleANX,$HighScaleOBS,$HighScalePAN,$HighScaleAGO,$HighScaleTRA,$HighScaleMIN,$HighScaleRB));
				sort($HighScalesTemp0);
			}				
		}
		#### END - Check IF the DSP (exception: DEP) has Elevations = 1(>60) OR No Elevations = 0(<60) ####		
		return array($elevations, $HighScalesTemp0);
	}	

	#########################################################################
	#### Compute the Improvement % for follow ups   					  ###
	#########################################################################		
	function improvCalcul ($DepCurrent, $DepLast) {
		$improv = 0;
		$diffVal = 0;
		$calcLast = ($DepLast - 50) / 10; 
		$calcCurrent = ($DepCurrent - 50) / 10; 
		$diffVal = $calcLast - $calcCurrent;
		
		if ($calcLast == 0 || $diffVal < 0) {
			$improv = 999; 
		} elseif ($diffVal >= 0 && $calcLast > 0) {
			$improv = round(($diffVal / $calcLast) * 100);
		}				
		return $improv;
	}

	#################################################################################
	#### Return TRUE if the same category drug has been mentionned by the patient ###
	#################################################################################		
	function isDrugSameCategory ($medsArray, $categ, $typetemps) {
		$nbCateg = 0; $type_d1 = 0; $type_d2 = 0; $line = 0;
		$sumCateg = 0; $strname = '';
		$countNODate = 0;  $higherDose = ''; $range = '';  $mainDrug = '';
		$listCateg = array();
		$recentDate= '0000-00-00';  $more_5years = 0;
		//echo pr($medsArray);  
		foreach($medsArray as $item) {
			if (!empty($item['Drug']) && $item['Drug']['category'] == $categ && $item['type_temps'] == $typetemps) {
				$nbCateg++;
				$sumCateg = $sumCateg + $item['custome_dose'];
				//if (($item['Drug']['range_left'] - floor($item['Drug']['range_left'])) == 0) { $nL = floor($nL); }
				//if (($nR - floor($nR)) == 0) { $nR = floor($nR); }				
				$range = ' '.floor($item['Drug']['range_left']).'-'.floor($item['Drug']['range_right']).' '.$item['Drug']['unit'];
				if($nbCateg == 1){
					$strname .= $item['Drug']['name'];
					$mainDrug = $item['Drug']['name'];					
				}else{
					$strname .= ' + '.$item['Drug']['name'];
				}	
				if(!empty($item['date_of_start'])){
					if ($item['date_of_start'] >= $recentDate) { 
						$recentDate = $item['date_of_start'];
						$mainDrug = $item['Drug']['name'];
						if($item['higherdose'] != NULL) {
							$higherDose = $item['higherdose'];
						}												
					}
				} else {
					if ($item['more_5years'] == 1) {
						$more_5years = 1;
					} else {
						$countNODate++;
					}									
				}				
				$type_d1 = $item['Drug']['type_d1'];
				$type_d2 = $item['Drug']['type_d2'];
				$line = $item['Drug']['line'];
			}				
		}
		if ($nbCateg > 1 ) { 
			$listCateg = array('id' => $type_d1, 'type_d2' => $type_d2, 'categ' => $categ, 'line' => $line, 'custome_dose' => $sumCateg, 
							'strname' => $strname, 'mainDrug' => $mainDrug, 'range' => $range, 'date_of_start' => $recentDate, 
							'higherDose' => $higherDose, 'more_5years' => $more_5years, 'nbCateg' => $nbCateg, 
							'countNODate' => $countNODate); 
		}
		return $listCateg;
	}	
	
	#########################################################################
	#### Return the text letter of the number of meds  					  ###
	#########################################################################		
	function numberLetters ($field_temp, $nb) {
		$strNoLetter ='';
		switch((int) $nb) {
			# Spanish translation
			case(2):
				if ($field_temp == 'name_eng') { $strNoLetter = 'two'; }
				if ($field_temp == 'name_fre') { $strNoLetter = 'dos'; }
				break;
			case(3):
				if ($field_temp == 'name_eng') { $strNoLetter = 'three'; }
				if ($field_temp == 'name_fre') { $strNoLetter = 'tres'; }
				break;
			case(4):
				if ($field_temp == 'name_eng') { $strNoLetter = 'four'; }
				if ($field_temp == 'name_fre') { $strNoLetter = 'cuatro'; }
				break;	
			case(5):
				if ($field_temp == 'name_eng') { $strNoLetter = 'five'; }
				if ($field_temp == 'name_fre') { $strNoLetter = 'cinco'; }
				break;
			case(6):
				$strNoLetter = 'six'; 
				break;				
		}
		return $strNoLetter;
	}							
	

	
	#########################################################################
	#### beforeSave									 					  ###
	#########################################################################	
	function beforeSave($opt=[]) {
	### When an Insert Table is made
//		if(empty($this->id))	{
		# Inital
			if ($this->data['QuestionnaireTreatment']['type_q'] == 0){			
				# Q.1 NO there is not a Current Treatment
				if ($this->data['QuestionnaireTreatment']['treatment'] == '1011'){
					$this->data['QuestionnaireTreatment']['treatment'] = 0;
					$this->data['QuestionnaireTreatment']['side_effects'] = NULL;
					$this->data['QuestionnaireTreatment']['stoping_drugs'] = NULL;
					$this->data['QuestionnaireTreatment']['side_effects_list'] = NULL;
				}
				
				# Q.1 YES there is a Current Treatment
				if ($this->data['QuestionnaireTreatment']['treatment'] == '1010'){
					$this->data['QuestionnaireTreatment']['treatment'] = 1;

					# Q.4 NO there are not side effects
					if ($this->data['QuestionnaireTreatment']['side_effects'] == '1017'){
						$this->data['QuestionnaireTreatment']['side_effects'] = 0;
					}
					# Q.4 YES there are side effects
					if ($this->data['QuestionnaireTreatment']['side_effects'] == '1016'){
						$this->data['QuestionnaireTreatment']['side_effects'] = 1;
						# Q.5 NO stopping meds
						if ($this->data['QuestionnaireTreatment']['stoping_drugs'] == '1019'){
							$this->data['QuestionnaireTreatment']['stoping_drugs'] = 0;
						}
						# Q.5 YES stopping meds
						if ($this->data['QuestionnaireTreatment']['stoping_drugs'] == '1018'){
							$this->data['QuestionnaireTreatment']['stoping_drugs'] = 1;
							# If yes Q 5 = then check side effects
							if ($this->data['QuestionnaireTreatment']['side_effects_chaine'] !== ''){			
								$sideffectschaine = '';				
								$sideffects = $this->data['QuestionnaireTreatment']['side_effects_chaine'];
								foreach($sideffects as $sideffect){
									$sideffectschaine = $sideffectschaine.':'.$sideffect;			
								}
								$this->data['QuestionnaireTreatment']['side_effects_list'] = $sideffectschaine;
							}						
						}						
					}					
				}
				
				# Q.8 NO there is non-prescription compounds
				if ($this->data['QuestionnaireTreatment']['nonprescrip_compounds'] == '1025'){
					$this->data['QuestionnaireTreatment']['nonprescrip_compounds'] = 0;
				}
				# Q.8 YES there is non-prescription compounds
				if ($this->data['QuestionnaireTreatment']['nonprescrip_compounds'] == '1024'){
					$this->data['QuestionnaireTreatment']['nonprescrip_compounds'] = 1;
				}		
					
				# Q.9 Taking other meds
				if ($this->data['QuestionnaireTreatment']['taking_meds_chaine'] !== ''){
					$takingmedschaine = '';
					$takingmeds = $this->data['QuestionnaireTreatment']['taking_meds_chaine'];
					foreach($takingmeds as $takingmed)
					{
						$takingmedschaine = $takingmedschaine.':'.$takingmed;			
					}
					$this->data['QuestionnaireTreatment']['taking_meds_list'] = $takingmedschaine;
				}
				
				# Q.10 NO Psychotherapy
				if ($this->data['QuestionnaireTreatment']['psychotherapy'] == '1040'){
					$this->data['QuestionnaireTreatment']['psychotherapy'] = 0;
				}
				# Q.10 YES Psychotherapy
				if ($this->data['QuestionnaireTreatment']['psychotherapy'] == '1039'){
					$this->data['QuestionnaireTreatment']['psychotherapy'] = 1;
				}			
			}elseif ($this->data['QuestionnaireTreatment']['type_q'] == 1){
			# Follow Up			
				# Q.1 NO there is not a Current Treatment
				if ($this->data['QuestionnaireTreatment']['treatment'] == '1045'){
					$this->data['QuestionnaireTreatment']['treatment'] = 0;
					$this->data['QuestionnaireTreatment']['side_effects'] = NULL;
					$this->data['QuestionnaireTreatment']['stoping_drugs'] = NULL;
					$this->data['QuestionnaireTreatment']['side_effects_list'] = NULL;					
				}
				
				# Q.1 YES there is a Current Treatment
				if ($this->data['QuestionnaireTreatment']['treatment'] == '1044'){
					$this->data['QuestionnaireTreatment']['treatment'] = 1;
					
					# Q.3 NO there are not side effects
					if ($this->data['QuestionnaireTreatment']['side_effects'] == '1050'){
						$this->data['QuestionnaireTreatment']['side_effects'] = 0;
					}
					# Q.3 YES there are side effects
					if ($this->data['QuestionnaireTreatment']['side_effects'] == '1049'){
						$this->data['QuestionnaireTreatment']['side_effects'] = 1;
						# Q.4 NO stopping meds
						if ($this->data['QuestionnaireTreatment']['stoping_drugs'] == '1052'){
							$this->data['QuestionnaireTreatment']['stoping_drugs'] = 0;
						}
						# Q.4 YES stopping meds
						if ($this->data['QuestionnaireTreatment']['stoping_drugs'] == '1051'){
							$this->data['QuestionnaireTreatment']['stoping_drugs'] = 1;
							# If yes Q.5 = then check side effects
							if ($this->data['QuestionnaireTreatment']['side_effects_chaine'] !== '')
							{			
								$sideffectschaine = '';				
								$sideffects = $this->data['QuestionnaireTreatment']['side_effects_chaine'];
								foreach($sideffects as $sideffect)
								{
									$sideffectschaine = $sideffectschaine.':'.$sideffect;			
								}
								$this->data['QuestionnaireTreatment']['side_effects_list'] = $sideffectschaine;
							}						
						}
					}				
				}
			
				### Taking other meds ###
				# Q.6 NO there is non-prescription compounds
				if ($this->data['QuestionnaireTreatment']['nonprescrip_compounds'] == '1055'){
					$this->data['QuestionnaireTreatment']['nonprescrip_compounds'] = 0;
				}
				# Q.6 YES there is non-prescription compounds
				if ($this->data['QuestionnaireTreatment']['nonprescrip_compounds'] == '1054'){
					$this->data['QuestionnaireTreatment']['nonprescrip_compounds'] = 1;
				}						
								
				# Q.7 Taking other meds
				if ($this->data['QuestionnaireTreatment']['taking_meds_chaine'] !== ''){
					$takingmedschaine = '';
					$takingmeds = $this->data['QuestionnaireTreatment']['taking_meds_chaine'];
					foreach($takingmeds as $takingmed)
					{
						$takingmedschaine = $takingmedschaine.':'.$takingmed;			
					}
					$this->data['QuestionnaireTreatment']['taking_meds_list'] = $takingmedschaine;
				}	

				# Q.8 NO Psychotherapy
				if ($this->data['QuestionnaireTreatment']['psychotherapy'] == '1070'){
					$this->data['QuestionnaireTreatment']['psychotherapy'] = 0;
				}
				# Q.8 YES Psychotherapy
				if ($this->data['QuestionnaireTreatment']['psychotherapy'] == '1069'){
					$this->data['QuestionnaireTreatment']['psychotherapy'] = 1;
				}					
			}
//		}	
		return true;
	}
	
	#########################################################################
	#### afterSave									 					  ###
	#########################################################################		
	function afterSave($created) {
		### When an Insert is made
		if($created){
			$today = date('Y-m-d', time());	
			$serviceid = $this->data['Service']['id'];
			$evaluationid = $this->data['QuestionnaireTreatment']['evaluation_id'];
			$orderid = $this->data['Evaluation']['order_id'];
			
			$questionnairesLists = $this->Evaluation->Service->QuestionnairesService->find('all', 
									array('conditions' => array('QuestionnairesService.service_id' => $serviceid),
										'fields' => array('QuestionnairesService.id', 'QuestionnairesService.questionnaire_id', 'QuestionnairesService.service_id'
														)
										)
							);
			
			$nbQuest = 0;
			foreach($questionnairesLists as $questionnairesList):
				if($questionnairesList['QuestionnairesService']['questionnaire_id'] == 3){
				### HSQ
					# Call the HSQ table
					App::import('Model','HsqScore');
					$this->HsqScore = new HsqScore(); 			
					$countHsq = $this->HsqScore->countHsq($evaluationid);
					if($countHsq == 1) { $nbQuest++; }					
				} elseif($questionnairesList['QuestionnairesService']['questionnaire_id'] == 1 || $questionnairesList['QuestionnairesService']['questionnaire_id'] == 2) {
				### DSP
					# Call the DSP table
					App::import('Model','DspScore');
					$this->DspScore = new DspScore(); 			
					$countDsp = $this->DspScore->countDsp($evaluationid);
					if($countDsp == 1) { $nbQuest++; }
		
				}
			endforeach;
			
			if ($nbQuest == (count($questionnairesLists) - 1)){				
				$this->Evaluation->id = $evaluationid;
				$this->Evaluation->set(array(
							'status_id' => 13,
							'status_date' => $today
							));				
				if ($this->Evaluation->save($this->data['Evaluation'])){
					//$this->data['Evaluation']['status_id'] = 13; 
					# Validate the max number of tests by order - then close the Order
					if ($this->data['QuestionnaireTreatment']['test_serie'] == 6){
						$this->Evaluation->Order->id = $orderid;
						if (!$this->Evaluation->Order->saveField('status_id', 6)) {
							return false;
						}
					}						
				} else {
					return false;
				}					
			}
		}
		return true;
	}
}
?>