<?php
class Requester extends AppModel {
	var $name = 'Requester';
	
	var $virtualFields = array(
		'name' => 'CONCAT(Requester.first_name, " ", Requester.last_name)'
//		'name2' => 'CONCAT(Supervisor.last_name, ", ", Supervisor.first_name)'
		); 	
	
  var $validate = array(				 				 
	       'first_name' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'must have First name'
	            )
	       ),

	       'last_name' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'must have Last name'
	            )
	       ),					 
/*				
	       'phone' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'must have phone'
	            )
	       )	,
*/
	       'fax' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 3),
	             'allowEmpty' => true,
	             'message' => 'fax must have more 3 numbers'
	            )
	       )	,

	       'email' => array(
	             'email' => array(
	             'rule' => 'email',
	             'allowEmpty' => false,
	             'message' => 'must have valid email address'
	            )
	       ),
	       'gender' => array(
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Gender'
				),
	       'team_id' => array(
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Team'
				),
	       'langue' => array(
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Language'
				)				
	);	

	
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	var $belongsTo = array(
		'Team' => array(
			'className' => 'Team',
			'foreignKey' => 'team_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Supervisor' => array(
			'className' => 'Requester',
            'foreignKey' => 'id_supervisor',
            'conditions' => '',
            'fields' => '',
            'order' => ''
        )		
	);
	

/*	
	var $hasOne = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'requester_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);
*/	
	
	var $hasMany = array(
		'Evaluation' => array(
			'className' => 'Evaluation',
			'foreignKey' => 'requester_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)
	);

	# returns the List of Requesters by Customer_id provided
	function listRequestCust($custom_id)
	{
		return $this->find('list', array(
				'link' => array(
					'Team' => array(
						'Customer' => array(
								'conditions' => array('Team.customer_id' => 'Customer.id', 'Customer.id' => $custom_id))
					)
				),
				'fields' => array('Requester.id','Requester.name'),
				'conditions' =>  array('Requester.hide' => 0)
			));									
	}	
	
	# returns the List of Requesters by Team_id provided
	function listRequestTeam($team_id)
	{
		return $this->find('list', array(
				'link' => array(
					'Team' => array(
						'conditions' => array('Requester.team_id' => 'Team.id', 'Requester.team_id' => $team_id,
									'Requester.hide' => 0
									)
							)
					),
				'fields' => array('Requester.id','Requester.name'),
				'order' => array('Requester.name')
//				'conditions' =>  array('Requester.id' => $eval_id)				
			));									
	}
	
	###################################################################################
	# Returns the List of "Supervisors" by team_id provided
	###################################################################################
	function listSupervTeam($team_id)
	{	
		return $this->find('list', array(
						'conditions' =>  array('Requester.team_id' => $team_id, 'Requester.id_supervisor IS NULL',
												'Requester.hide' => 0),
						'fields' => array('Requester.id', 'Requester.name'),
						'order' => 'name ASC'
			));
	}
	
	###################################################################################
	# Returns the List of Requesters - Case Managers by team_id provided
	###################################################################################
	function listCaseMngTeam($team_id)
	{	
		return $this->find('list', array(
						'conditions' =>  array('Requester.team_id' => $team_id, 'Requester.id_supervisor IS NOT NULL',
												'Requester.hide' => 0),
						'fields' => array('Requester.id', 'Requester.name'),
						'order' => 'first_name ASC'
			));
	}	
		
	###################################################################################
	# Returns the List of Requesters with a Supervisors assigned by team_id provided
	###################################################################################
	function listCaseMngSupervTeam($team_id)
	{	
		return $this->find('list', array(
						'conditions' =>  array('Requester.team_id' => $team_id, 'Requester.hide' => 0),
						'fields' => array('Requester.id', 'Requester.name'),
						'order' => 'first_name ASC'
			));
	}		
	
	###################################################################################
	# Returns the List of Requesters by id_supervisor provided
	###################################################################################
	function listRequestSuperv($id_supervisor)
	{	
		return $this->find('list', array(
//						'conditions' =>  array('Requester.id_supervisor' => $id_supervisor, 'Requester.id' => $id_supervisor),
						'conditions' =>  array('Requester.id_supervisor' => $id_supervisor, 'Requester.hide' => 0),
						'fields' => array('Requester.id', 'Requester.name'),
						'order' => 'first_name ASC'
			));
	}
	
	############################################################################################
	# Returns the List of Requesters by id_supervisor provided. It will include also the Superv
	############################################################################################
	function listRequestSupervPlus($id_supervisor)
	{	
		return $this->find('list', array(
//						'conditions' =>  array('Requester.id_supervisor' => $id_supervisor, 'Requester.id' => $id_supervisor),
						'conditions' =>  'Requester.id_supervisor = '.$id_supervisor.' AND Requester.hide = 0 OR Requester.id = '.$id_supervisor,
						'fields' => array('Requester.id', 'Requester.name'),
						'order' => 'first_name ASC'
			));
	}	

	###################################################################################
	# Returns the Supervisor information (Requester - Supervisor) by req_id
	###################################################################################
	function nameSuperv($req_id)
	{
		return $this->find('first', array(
						'conditions' =>  array('Requester.id' => $req_id),
						'fields' => array('Requester.id', 'Requester.first_name','Requester.last_name')
			));
	}
	
	###################################################################################
	# Returns the Supervisor information (Requester - Supervisor) by superv_id
	###################################################################################
	function infoSuperv($superv_id)
	{
		return $this->find('list', array(
						'conditions' =>  array('Requester.id' => $superv_id),
						'fields' => array('Requester.id', 'Requester.name')
			));		
	}	
}
?>