<?php
class Service extends AppModel {
	var $name = 'Service';
	var $displayField = 'name';
	
  var $validate = array(
	       'customer_id' => array(
				 'rule' => 'notEmpty',
				 'message' => 'Please select a Customer' 
	       ),
	       'name' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'Please enter a Service name'
	            )
	       )			
	);	
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	var $belongsTo = array(
		'Customer' => array(
			'className' => 'Customer',
			'foreignKey' => 'customer_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)	
	);
	
	var $hasMany = array(
		'Evaluation' => array(
			'className' => 'Evaluation',
			'foreignKey' => 'service_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Fee' => array(
			'className' => 'Fee',
			'foreignKey' => 'service_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)		
	);


	var $hasAndBelongsToMany = array(
		'Questionnaire' => array(
			'className' => 'Questionnaire',
			'joinTable' => 'questionnaires_services',
			'foreignKey' => 'service_id',
			'associationForeignKey' => 'questionnaire_id',
			'unique' => true,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		)
	);

	### List of Services by Customer id, called from a specific action
	##  $cust_id => Customer code
	##  $action = 0 => Order
	##  $action = 1 => Evaluation
	function servicesCustomer($cust_id, $action)
	{										
		return $this->find('list', array(
										'fields' => array('id', 'name'),
										'conditions' => array('Service.active' => 1, 'Service.customer_id' => $cust_id, 'Service.type_s' => $action),
										'order' => 'name ASC'));																
	}
	
	function servicesInfo($serv_id)
	{										
		return $this->find('first', array(
										'fields' => array('id', 'name'),
										'conditions' => array('Service.id' => $serv_id),
										'order' => 'name ASC'));																
	}

	
}
?>