<?php
class Status extends AppModel {

	var $name = 'Status';

	  var $validate = array(				 				 		   
		   
	       'name_eng' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'Please enter a English name'
	            )
	       ),
	       'name_fre' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'Please enter a French name'
	            )
	       )		   		   
		);

	#################################################################################################################
	### The Associations below have been created with all possible keys, those that are not needed can be removed ###
	#################################################################################################################
	var $hasMany = array(
		'Evaluation' => array(
			'className' => 'Evaluation',
			'foreignKey' => 'status_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Order' => array(
			'className' => 'Order',
			'foreignKey' => 'status_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Invoice' => array(
			'className' => 'Invoice',
			'foreignKey' => 'status_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Fee' => array(
			'className' => 'Fee',
			'foreignKey' => 'status_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'InvoiceItem' => array(
			'className' => 'InvoiceItem',
			'foreignKey' => 'status_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)		
	);
	
	####################################################################
	#	Returns the status description by profile-action and language
	#   $type_s = 1(Order), 2(Eval),3(Invoice)
	#   $ctrl = 0 (App), 1 (Admin), 2 (Req)
	# 	$field_language = 'name_eng' or 'name_fre'
	#	$tablename = 'Status' / 'StatusOrder'
	####################################################################
	function listStatusName($type_s, $ctrl, $field_language, $tablename) {
		return $this->find('list', array('fields' => array('id', $field_language),
										'conditions' => array($tablename.'.type_s' => $type_s, $tablename.'.ctrl' => array($ctrl,9))
										)
							);
	}
	
	####################################################################
	#	Returns the status description by profile-action and language
	#   $type_s = 1(Order), 2(Eval),3(Invoice)
	# 	$field_language = 'name_eng' or 'name_fre'
	####################################################################
	function forsearchListStatus($type_s, $field_language, $nametable) {
		return $this->find('list', array('fields' => array('id', $field_language),
										'conditions' => array($nametable.'.type_s' => $type_s),
										'order' => $nametable.'.'.$field_language.' ASC'
										)
							);
	}
}
?>