<?php
class Team extends AppModel {
	var $name = 'Team';
	var $displayField = 'name';
	
	  var $validate = array(				 				 		   
		   
	       'customer_id' => array(
	             'numeric' => array(
	             'rule' => 'numeric',
	             'allowEmpty' => false,
	             'message' => 'Please enter a Customer'
	            )
	       ),
	       'name' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'Please enter a Team name'
	            )
	       ),
	       'abbrv' => array(
	             'minLength' => array(
	             'rule' => array('minLength', 1),
	             'allowEmpty' => false,
	             'message' => 'Please enter an abbrv name'
	            )
	       )		   		   
		);		
	
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	public $belongsTo = array(
		'Customer' => array(
			'className' => 'Customer',
			'foreignKey' => 'customer_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	public $hasMany = array(
		'Requester' => array(
			'className' => 'Requester',
			'foreignKey' => 'team_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		),
		'Invoice' => array(
			'className' => 'Invoice',
			'foreignKey' => 'team_id',
			'dependent' => false,
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'exclusive' => '',
			'finderQuery' => '',
			'counterQuery' => ''
		)		
	);
	
	# List of Teams by Customer id
	function teamsCustomer($cust_id)
	{		
		return $this->find('list', array(
										'fields' => array('id', 'name'),		
										'conditions' => array('Team.active' => 1, 'Team.customer_id' => $cust_id),
										'order' => 'name ASC'));
	}

}
?>