<?php
class User extends AppModel {
	var $name = 'User';
	
	### ACL Component
	var $actsAs = array('Acl' => array('type' => 'requester'));
	
	var $validate = array(
			'username' => array(
				'usernameRule-1' => array(
					'rule' => 'alphaNumeric', 
					'required' => true,
					'allowEmpty' => false,
//					'message' => 'Only alphabets and numbers allowed',
					'last' => true
				 ),
				'usernameRule-2' => array(
					'rule' => array('minLength', 5),  
//					'message' => 'Minimum length of 5 characters',
					'last' => true
				),
				'usernameRule-3' => array(
					'rule' => 'isUnique',  
//					'message' => 'This username has already been taken',
					'last' => true
				)		
			),
			'password'=>array(
				'Password cannot be empty.'=>array(
					'rule'=>array('notEmpty')
				),
				'Password must be at least four characters.'=>array(
					'rule'=>array('minLength',4)
				)
			),
/*			'password' => array(
				'rule' => array('between', 5, 15),
				'message' => 'Passwords must be between 5 and 15 characters long.'
			),			*/			
			'active' => array(
					'rule' => 'notEmpty',
					'message' => 'Please select a Status'
			),
			'requester_id' => array(
				'Please select a Requester.'=>array(
					'rule'=>array('notEmpty')
				),
				'The Requester already has a User account.'=>array(
					'rule'=>array('validateCurrentAccount', 'requester_id'),
					'on' => 'create'
				)
			),
			'group_id' => array(
					'rule' => 'notEmpty',
					'message' => 'Please select a User Group'
			)			
	);	
	

	
	//The Associations below have been created with all possible keys, those that are not needed can be removed

	var $belongsTo = array(
		'Requester' => array(
			'className' => 'Requester',
			'foreignKey' => 'requester_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		),
		'Group' => array(
			'className' => 'Group',
			'foreignKey' => 'group_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)	
	);
   
    function validateCurrentAccount( $field=array(), $requester_field=null ) 
    {
//	$actionVal == $this->params['action'];
//		if ($actionVal == 'add') {
			$id_requester = $this->data[$this->name][ $requester_field ]; 
			if ($this->countUser($id_requester) !== 0) {
				return FALSE;
//			} 		
		}
		return TRUE;
    }   

    function hashPasswords($data,$enforce=false) {
	$countU = 0;
	if (isset($this->data[$this->alias]['requester_id'])) { $countU = $this->countUser($this->data[$this->alias]['requester_id']); }
	
		if ($countU > 0) {
		//Update 
		$userA = $this->find('first', array('conditions' => array('User.id' => $this->data[$this->alias]['id'])));			
			if (!empty($this->data[$this->alias]['newpassword'])) {
                $this->data[$this->alias]['password'] = Security::hash($this->data[$this->alias]['newpassword'], null, true);
           }		
		} elseif ($countU == 0) {
		//Create
			if ($enforce && isset($this->data[$this->alias]['password'])) {
				if (!empty($this->data[$this->alias]['password'])) {
					$this->data[$this->alias]['password'] = Security::hash($this->data[$this->alias]['password'], null, true);
				}
			}
		}	
        return $data;
    }
 
    function beforeSave($opt=[]) {
        $this->hashPasswords(null,true);
        return true;
    }		
	
	### ACL Component
	function parentNode() {
	    if (!$this->id && empty($this->data)) {
		return null;
	    }
	    if (isset($this->data['User']['group_id'])) {
		$groupId = $this->data['User']['group_id'];
	    } else {
		$groupId = $this->field('group_id');
	    }
	    if (!$groupId) {
		return null;
	    } else {
		return array('Group' => array('id' => $groupId));
	    }
	}
	
	
	# returns all Users
	function listUsers()
	{
		return $this->find('all', array(
				'link' => array(
					'Requester' => array(
						'Team' => array(
									'Customer'  => array(
												'conditions' => 'Team.customer_id  = Customer.id')
											),
						'Supervisor' => array(
									'conditions' => 'Requester.id_supervisor = Supervisor.id',
									'fields' => array('id', 'first_name', 'last_name')
						),
						'conditions' => array('User.requester_id  = Requester.id')
									),
					'Group' => array('conditions' => array('User.group_id = Group.id', 'Group.hide = 0'))
				),
				'fields' => array('User.id','User.username','User.active', 'User.created', 
							'Customer.name', 'Group.name_eng', 'Group.name_fre', 'Team.name'),
				'conditions' => array('User.id <> 3')
				//'group'	=> array('id' => $groupId);		
			));			
	}
	
	###########################################################################
	# Validate if there is already a User Code by an specific Requester_id
	###########################################################################
	function countUser($requester_id)
	{
		return $this->find('count', array('conditions' => array('User.requester_id' => $requester_id)));
	}	
	
	###################################################################################
	# Returns the User information (Requester - Supervisor) by user_id
	###################################################################################
	function infoUser($user_id)
	{
		return $this->find('all', array(
				'link' => array(
					'Requester' => array(
						'Team'
					),
					'Group'
				),
				'fields' => array('User.id','User.username','User.created','User.createdby','User.modified','User.modifiedby',
							'User.requester_id','User.group_id','User.active',
							'Requester.id','Requester.first_name','Requester.last_name','Requester.id_supervisor', 'Requester.langue',
							'Group.id', 'Group.name_eng', 'Group.name_fre'),	//Aaron, May 19, 2015 added "_eng" to Group.name to avoid SQL failure warning
				'conditions' =>  array('User.id' => $user_id)
			));						
			
	}
	
}
?>