<?php

App::import('Vendor','tcpdf/config/lang/eng');
App::import('Vendor','tcpdf/tcpdf');
 

class ClaimletterPDF  extends TCPDF {

	var $xEmployee = '';
	var $xheadertext  = 'PDF created using CakePHP and TCPDF'; 
	var $xClient = '';

	var $xDate = '';

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'logo.png';
//		$this->Cell(0, 0, $image_file, 1, 1, 'C', 0, '', 1);
        $this->Image($image_file, 15, 10, 95, 23, 'PNG', '', 'M', 2, 300, 'C', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-7);
        // Set font
        $this->SetFont('helvetica', 'I', 7.5);
        // Page number
        $this->Cell(0, 7, $this->xAddressTestmetrix, 'T', false, 'C', 0, '', 0, false, 'T', 'M');
    }

    function HeadingLetter()
    {		 
		$this->SetFontSize(11);		
		$this->Ln(13);
		//Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=0, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M')
		$this->Cell(0, 0, $this->xDateLetter, 0, false, 'L', 0, '', 0);		
		// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
		$this->writeHTMLCell(0, '', '', 60, $this->xAddressLetter, 0, 0, 0,true, 'L');		
    }		
	
	
	function SubjectLetter()
	{	
		// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)	
		$this->writeHTMLCell(50, '', '', 90, $this->xSubjectTitle, 'B', 0, 0, true, 'L', true);
		// write the second column
		$this->writeHTMLCell(130, '', '', '', $this->xCustomerSubject, 'B', 1, 0, true, 'L', true);	
		$this->Ln(2);	
	}	
	
	function ClaimLetterContent($rowss, $field, $customer, $testserie)
	{	
		$this->Ln(3);
		$this->writeHTMLCell(0, '', '', '', $this->xGenderTitle, 0, 0, 0,true, 'L');
		$this->Ln(7);	
		$texte = '';
		//echo pr($rowss);
        foreach($rowss as $row) 
		{
			if ($testserie == 1) {
				if ($row['DocLabel']['serie'] == 2 || $row['DocLabel']['serie'] == 5) {
					$texte = str_replace('#', $customer, $row['DocLabel'][$field]);			
					$this->MultiCell (0, 0, $texte, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );					
				} elseif ($row['DocLabel']['serie'] == 6) {
					$texte = str_replace('#', $customer, $row['DocLabel'][$field]);	
					$this->writeHTMLCell(0, '', '', '', '<b>'.$texte.'</b>', 0, 0, 0,true, 'L');
					$this->Ln(18);
				} elseif ($row['DocLabel']['serie'] == 3 || $row['DocLabel']['serie'] == 4 || 
						$row['DocLabel']['serie'] == 7 || $row['DocLabel']['serie'] == 8) {
					$this->MultiCell (0, 0, $row['DocLabel'][$field], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
					if($row['DocLabel']['serie'] == 7) {
						$this->Ln(6);
					} elseif($row['DocLabel']['serie'] == 8) {
						$this->Ln(7);
					}
				}		
				$this->Ln(3);			
			} elseif ($testserie > 1) {
				if ($row['DocLabel']['serie'] == 2 || $row['DocLabel']['serie'] == 4)
				{
					$texte = str_replace('#', $customer, $row['DocLabel'][$field]);								
					if ($row['DocLabel']['serie'] == 4) {
						$this->writeHTMLCell(0, '', '', '', '<b>'.$texte.'</b>', 0, 0, 0,true, 'L');
						$this->Ln(19);
					}else {
						$this->MultiCell (0, 0, $texte, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
					}
				} elseif ($row['DocLabel']['serie'] == 3 || $row['DocLabel']['serie'] == 5 || $row['DocLabel']['serie'] == 6)
				{
					$this->MultiCell (0, 0, $row['DocLabel'][$field], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
					if ($row['DocLabel']['serie'] == 5) {
						$this->Ln(7);
					} elseif($row['DocLabel']['serie'] == 6) {
						$this->Ln(4);
					}					
				}		
				$this->Ln(2);			
			}
        }
	}	
	
	function EndLetter($tserie, $endsal, $drTitle, $serv)
	{	
		$this->Ln(11);
		###
        $image_file2 = K_PATH_IMAGES.'DrBrownSignature.png';
		//Image( $file,	$x = '',$y = '',$w = 0,	$h = 0,	$type = '',	$link = '',	$align = '',$resize = false,$dpi = 300,$palign = '',$ismask = false,	$imgmask = false,
		//		$border = 0,$fitbox = false,$hidden = false,$fitonpage = false,	$alt = false,$altimgs = array() ) 			
		if ($tserie == 1) {
			$this->Image($image_file2, 15, 254, 47, 10);
			$this->MultiCell (0, 0, $drTitle, 0, 'L', false, 1, '', 264, true, 0, false, true, 0, 'M', false );
			$this->SetFont("helvetica", "", 9);
			$this->MultiCell (0, 0, $endsal, 0, 'L', false, 1, '', 271, true, 0, false, true, 0, 'M', false );
			$this->MultiCell (0, 0, $serv, 0, 'L', false, 1, '', 275, true, 0, false, true, 0, 'M', false );			
		} else {
			$this->Image($image_file2, 15, 200, 47, 10);
			$this->MultiCell (0, 0, $drTitle, 0, 'L', false, 1, '', 217, true, 0, false, true, 0, 'M', false );
			$this->Ln(2);
			$this->SetFont("helvetica", "", 9);
			$this->MultiCell (0, 0, $endsal, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
			$this->MultiCell (0, 0, $serv, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );			
		}		
	}		

} 
?>