<?php

App::import('Vendor','tcpdf/config/lang/eng');
App::import('Vendor','tcpdf/tcpdf');
 

class DoctorletterPDF  extends TCPDF {

	var $xEmployee = '';
	var $xheadertext  = 'PDF created using CakePHP and TCPDF'; 
	var $xClient = '';

	var $xDate = '';

    # Page header
    public function Header() {
        //Logo
        $image_file = K_PATH_IMAGES.'logo.png';
//		$this->Cell(0, 0, $image_file, 1, 1, 'C', 0, '', 1);
        $this->Image($image_file, 15, 10, 95, 23, 'PNG', '', 'M', 2, 300, 'C', false, false, 0, false, false, false);
        //Set font
        $this->SetFont('helvetica', 'B', 20);
    }

    # Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-8);
        // Set font
        $this->SetFont('helvetica', 'I', 7.5);
        // Page number
        $this->Cell(0, 10, $this->xAddressTestmetrix, 'T', false, 'C', 0, '', 0, false, 'T', 'M');
    }

    function HeadingLetter()
    {		 
		$this->SetFontSize(11);		
		$this->Ln(7);
		//Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=0, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M')
		$this->Cell(0, 0, $this->xDateLetter, 0, false, 'L', 0, '', 0);		
		// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
		$this->writeHTMLCell(0, '', '', 57, $this->xAddressLetter, 0, 0, 0,true, 'L');	
		$this->Ln(15);		
    }			
	
	function DrLetterContent($rowss, $field, $customer, $quest)
	{	
		$this->Ln(11);
		$this->writeHTMLCell(0, '', '', '', $this->xGenderTitle, 0, 0, 0,true, 'L');
		$this->Ln(9);	
		$texte = '';
		$symbolRef = 1;
		//echo pr($rowss); 
        foreach($rowss as $row) {
			if (($row['DocLabel']['serie'] != 6 && $quest == 45) || ($row['DocLabel']['serie'] != 7 && $quest == 77)) {
				if ($row['DocLabel']['serie'] == 1) {
					$texte = str_replace('#1', '<i><b>'.$customer.'</b></i>', $row['DocLabel'][$field]);
					$this->writeHTMLCell('', '', '', '', $texte, 0, 1, 0, true, 'L', true);
				} elseif(($row['DocLabel']['serie'] == 4 && $quest == 45) || ($row['DocLabel']['serie'] == 5 && $quest == 77)) {
					$texte = str_replace('#2', '<sup>'.$symbolRef.' </sup>', $row['DocLabel'][$field]); 
					$this->writeHTMLCell('', '', '', '', $texte, 0, 1, 0, true, 'L', true);
				} else {
					$this->MultiCell (0, 0, $row['DocLabel'][$field], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
				}
			}
			$this->Ln(2);
        }
	}	
	
	function EndLetter($drTitle, $refs, $q)
	{	
		$this->Ln(12);
		###
        $image_file2 = K_PATH_IMAGES.'DrBrownSignature.png';
		/* Image( $file,	$x = '',$y = '',$w = 0,	$h = 0,	$type = '',	$link = '',	$align = '',$resize = false,$dpi = 300,$palign = '',$ismask = false,	$imgmask = false,
				$border = 0,$fitbox = false,$hidden = false,$fitonpage = false,	$alt = false,$altimgs = array() ) 	
		*/
		/* MultiCell ($w, $h, $txt, $border = 0, $align = 'J', $fill = false, $ln = 1, $x = '', $y = '', $reseth = true, $stretch = 0, $ishtml = false,
					$autopadding = true, $maxh = 0, $valign = 'T', $fitcell = false )	
		*/	
		/* writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true) */		
		if($q == 45) {
			$this->Image($image_file2, 15, 225, 47, 11);
			$this->Ln(6);
			$this->MultiCell (0, 0, $drTitle, 0, 'L', false, 1, '', 235, true, 0, false, true, 0, 'M', false );								
			if(!empty($refs)){ $this->MultiCell (50, 0, '', 'B', 'L', false, 1, '', 257, true, 0, false, true, 0, 'M', false ); }			
			$this->writeHTMLCell('', '', '', 262, $refs, 0, 1, 0, true, 'L', true);			
		} elseif($q == 77) {
			$this->Image($image_file2, 15, 247, 47, 11);
			$this->Ln(6);
			$this->MultiCell (0, 0, $drTitle, 0, 'L', false, 1, '', 257, true, 0, false, true, 0, 'M', false );			
			if(!empty($refs)){ $this->MultiCell (50, 0, '', 'B', 'L', false, 1, '', 267, true, 0, false, true, 0, 'M', false ); }			
			$this->writeHTMLCell('', '', '', 272, $refs, 0, 1, 0, true, 'L', true);					
		}		
	}		

} 
?>