<?php

App::import('Vendor','tcpdf/config/lang/eng');
App::import('Vendor','tcpdf/tcpdf');


class HsqPDF  extends TCPDF {

	var $xEmployee = '';
	var $xheadertext  = 'PDF created using CakePHP and TCPDF'; 
	//var $xfootertext  = '4333, rue Ste-Catherine o., Bureau 410, Montral (Qubec) H3Z 1P9 Tl: (514) 938-1155  1-800-930-1232  Fax: (514) 938-5268'; 
	var $xClient = '';

	var $xDate = '';

	var $xDspId = '';

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'logo.png';
//		$this->Cell(0, 0, $image_file, 1, 1, 'C', 0, '', 1);
        $this->Image($image_file, 15, 10, 95, 23, 'PNG', '', 'M', 2, 300, 'C', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('helvetica', 'B', 20);
    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }

    function EmployeeCover()
    {		 
		$this->SetFontSize(11);			                                   
			 
		$this->writeHTMLCell(0, 0, 0, 70, $this->xEmployee, 0, 0, 0,true, 'C');
		$this->Ln();
    }
	
	function HsqPageHeader()
	{	
		$this->SetFont('helvetica', '', 10);
		$this->writeHTMLCell(0, 0, 0, 35, '<font size="+2"><u><b>'.'HSQ'.'</b></u></font>', 0, 0, 0,true, 'C');
		// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)	
		$this->writeHTMLCell(100, '', '', 45, $this->xleftHsqHeader, 0, 0, 0, true, 'L', true);
		// write the second column
		$this->writeHTMLCell(90, '', '', '', $this->xrightHsqHeader, 0, 1, 0, true, 'R', true);	
	}	

	function HsqGraphSection($header,$imagepath)
	{	
		//header spacing
		$this->Ln(17);
		$this->Cell(0, 0, $header, 1, 1, 'C', 0, '', 1);
		$this->Ln();
		//Image( $file,	$x = '',$y = '',$w = 0,	$h = 0,	$type = '',	$link = '',	$align = '',$resize = false,$dpi = 300,$palign = '',$ismask = false,	$imgmask = false,
		//		$border = 0,$fitbox = false,$hidden = false,$fitonpage = false,	$alt = false,$altimgs = array() ) 			
		$this->Image($imagepath,3,90,250,125);		
		$this->SetFont('helvetica', '', 10);
		$this->writeHTMLCell('', '', '', 207, $this->xnoteHsqFooter, 0, 0, 0, true, 'L');		
	}	
	
	function ScoreInterpSection($header,$scoreinterps)
	{	
		$this->SetFont('helvetica', '', 10);
		# header spacing
		$this->Ln(2);
		$this->Cell(0, 0, $header, 1, 1, 'C', 0, '', 1);
		$this->Ln();		
        foreach($scoreinterps as $row) 
		{
			if ($row['texte'] != '')
			{
			$this->MultiCell (0, 0, $row['texte_header'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
			$this->MultiCell (0, 0, $row['texte'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
			$this->Ln(4,false);			
			}		
        }		
	}
	
	function CriticalQuestionsSection($header,$criticallists)
	{	
		$this->SetFont('helvetica', '', 10);
		//header spacing
		$this->Ln(10);
		$this->Cell(0, 0, $header, 1, 1, 'C', 0, '', 1);
		$this->Ln();
        foreach($criticallists as $row) 
		{
			$this->MultiCell (0, 0, $row['title'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
			$this->MultiCell (0, 0, $row['texte'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
			$this->Ln(5,false);
        }
	}	
} 
?>