<?php
//============================================================+
// File name   : tcpdf_config.php
// Begin       : 2004-06-11
// Last Update : 2011-04-15
//
// Description : Configuration file for TCPDF.
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com s.r.l.
//               Via Della Pace, 11
//               09044 Quartucciu (CA)
//               ITALY
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Configuration file for TCPDF.
 * @author Nicola Asuni
 * @package com.tecnick.tcpdf
 * @version 4.9.005
 * @since 2004-10-27
 */

// If you define the constant K_TCPDF_EXTERNAL_CONFIG, the following settings will be ignored.

if (!defined('K_TCPDF_EXTERNAL_CONFIG')) {

    // DOCUMENT_ROOT fix for IIS Webserver
    if ((!isset($_SERVER['DOCUMENT_ROOT'])) or (empty($_SERVER['DOCUMENT_ROOT']))) {
        if (isset($_SERVER['SCRIPT_FILENAME'])) {
            $_SERVER['DOCUMENT_ROOT'] = str_replace('\\', '/', substr($_SERVER['SCRIPT_FILENAME'], 0, 0 - strlen($_SERVER['PHP_SELF'])));
        } elseif (isset($_SERVER['PATH_TRANSLATED'])) {
            $_SERVER['DOCUMENT_ROOT'] = str_replace('\\', '/', substr(str_replace('\\\\', '\\', $_SERVER['PATH_TRANSLATED']), 0, 0 - strlen($_SERVER['PHP_SELF'])));
        } else {
            // define here your DOCUMENT_ROOT path if the previous fails (e.g. '/var/www')
            $_SERVER['DOCUMENT_ROOT'] = '/';
        }
    }

    // Automatic calculation for the following K_PATH_MAIN constant
    $k_path_main = str_replace('\\', '/', realpath(substr(dirname(__FILE__), 0, 0 - strlen('config'))));
    if (substr($k_path_main, -1) != '/') {
        $k_path_main .= '/';
    }

    /**
     * Installation path (/var/www/tcpdf/).
     * By default it is automatically calculated but you can also set it as a fixed string to improve performances.
     */
    //K_PATH_MAIN = 'C:/wamp/www/testmetrix/vendors/tcpdf/'
    define('K_PATH_MAIN', $k_path_main);

    // Automatic calculation for the following K_PATH_URL constant
    $k_path_url = $k_path_main; // default value for console mode
    if (isset($_SERVER['HTTP_HOST']) and (!empty($_SERVER['HTTP_HOST']))) {
        if (isset($_SERVER['HTTPS']) and (!empty($_SERVER['HTTPS'])) and strtolower($_SERVER['HTTPS']) != 'off') {
            $k_path_url = 'https://';
        } else {
            $k_path_url = 'http://';
        }
        $k_path_url .= $_SERVER['HTTP_HOST'];
        $k_path_url .= str_replace('\\', '/', substr(K_PATH_MAIN, (strlen($_SERVER['DOCUMENT_ROOT']) - 1)));
    }
    define ('K_PATH_URL', $k_path_url);

    /**
     * path for PDF fonts
     * use K_PATH_MAIN.'fonts/old/' for old non-UTF8 fonts
     */
    define ('K_PATH_FONTS', K_PATH_MAIN.'fonts/');

    /**
     *images directory
     */
    define ('K_PATH_IMAGES', K_PATH_MAIN.'images/');
    //*ex define ('K_PATH_IMAGES', '/images/');

    /**
     * page orientation (P=portrait, L=landscape)
     */
    define ('PDF_PAGE_ORIENTATION', 'P');

    /**
     * image logo
     */
    define ('PDF_HEADER_LOGO', 'logo.png');
    /**
     * Generic name for a blank image.
     */
    define('K_BLANK_IMAGE', '_blank.png');

    /**
     * Page format.
     */
    define('PDF_PAGE_FORMAT', 'A4');

    /**
     * Document creator.
     */
    define('PDF_CREATOR', 'TCPDF');

    /**
     * Document author.
     */
    define('PDF_AUTHOR', 'TCPDF');

    /**
     * Header title.
     */
    define('PDF_HEADER_TITLE', 'TCPDF Example');

    /**
     * Header description string.
     */
    define('PDF_HEADER_STRING', "by Nicola Asuni - Tecnick.com\nwww.tcpdf.org");

    /**
     * Document unit of measure [pt=point, mm=millimeter, cm=centimeter, in=inch].
     */
    define('PDF_UNIT', 'mm');

    /**
     * Header margin.
     */
    define('PDF_MARGIN_HEADER', 5);

    /**
     * Footer margin.
     */
    define('PDF_MARGIN_FOOTER', 10);

    /**
     * Top margin.
     */
    define('PDF_MARGIN_TOP', 27);

    /**
     * Bottom margin.
     */
    define('PDF_MARGIN_BOTTOM', 25);

    /**
     * Left margin.
     */
    define('PDF_MARGIN_LEFT', 15);

    /**
     * Right margin.
     */
    define('PDF_MARGIN_RIGHT', 15);

    /**
     * Default main font name.
     */
    define('PDF_FONT_NAME_MAIN', 'dejavusans');

    /**
     * Default main font size.
     */
    define('PDF_FONT_SIZE_MAIN', 10);

    /**
     * Default data font name.
     */
    define('PDF_FONT_NAME_DATA', 'dejavusans');

    /**
     * Default data font size.
     */
    define('PDF_FONT_SIZE_DATA', 8);

    /**
     * Default monospaced font name.
     */
    define('PDF_FONT_MONOSPACED', 'courier');

    /**
     * Ratio used to adjust the conversion of pixels to user units.
     */
    define('PDF_IMAGE_SCALE_RATIO', 1.25);

    /**
     * Magnification factor for titles.
     */
    define('HEAD_MAGNIFICATION', 1.1);

    /**
     * Height of cell respect font height.
     */
    define('K_CELL_HEIGHT_RATIO', 1.25);

    /**
     * Title magnification respect main font size.
     */
    define('K_TITLE_MAGNIFICATION', 1.3);

    /**
     * Reduction factor for small font.
     */
    define('K_SMALL_RATIO', 2 / 3);

    /**
     * Set to true to enable the special procedure used to avoid the overlappind of symbols on Thai language.
     */
    define('K_THAI_TOPCHARS', true);

    /**
     * If true allows to call TCPDF methods using HTML syntax
     * IMPORTANT: For security reason, disable this feature if you are printing user HTML content.
     */
    define('K_TCPDF_CALLS_IN_HTML', false);

    /**
     * List of TCPDF methods that are allowed to be called using HTML syntax.
     * Note: each method name must end with surrounded with | (pipe) character.
     * The constant K_TCPDF_CALLS_IN_HTML must be set to true.
     * IMPORTANT: For security reason, disable this feature if you are allowing user HTML content.
     */
    define('K_ALLOWED_TCPDF_TAGS', '');

    /**
     * If true and PHP version is greater than 5, then the Error() method throw new exception instead of terminating the execution.
     */
    define('K_TCPDF_THROW_EXCEPTION_ERROR', false);

    /**
     * Default timezone for datetime functions
     */
    define('K_TIMEZONE', 'UTC');
}
//============================================================+
// END OF FILE
//============================================================+
