<?php

App::import('Vendor','tcpdf/config/lang/eng');
App::import('Vendor','tcpdf/tcpdf');


class InvoicerepPDF  extends TCPDF {

    var $xEmployee = '';
    var $xClient = '';

    var $xDate = '';

    var $xDspId = '';

    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'logo-n.png';
//		$this->Cell(0, 0, $image_file, 1, 1, 'C', 0, '', 1);
        $this->Image($image_file, 10, 12, 83, 17, 'PNG', '', 'L', 2, 300, 'L', false, false, 0, false, false, false);
        // Set font
        $this->SetFont('dejavusans', '', 8.5);
        // light grey font color
        $this->SetTextColor(121,121,120);
        $this->writeHTMLCell(70, '', 127, 15, '<p>4950, rue de la Savane<br>Bureau 701<br>Montréal (Québec) H4P 1T7<br> Tél: (514) 938-4166</p>', 0, 0, 0, true, 'R', true);


    }

    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-20);
        // Set font
        $this->SetFont('dejavusans', 'I', 8);
        // light grey font color
        $this->SetTextColor(121,121,120);
        // Page number
        //Cell ($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M')
        $this->Cell(0, 10, '                     Page '.$this->getAliasNumPage().' of '.$this->getAliasNbPages(), 0, 1, 'C', 0, '', 0, false, 'C', 'C');
        //$this->Cell(0, 5, $this->xAddressTestmetrix, 'T', 0, 'C', 0, '', 0, false, 'T', 'M');
//        if(isset($this->xAddressTestmetrix)) {
//            $this->Cell(0, 10, $this->xAddressTestmetrix, 'T', false, 'C', 0, '', 0, false, 'T', 'C');
//        }
    }

    function HeadingLetter()
    {
        $this->SetFontSize(9);
        $this->Ln(9);
        // writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
        $this->writeHTMLCell(80, '', '', 40, '<br/>hiiii<br/>', 1, 0, 0, true, 'L', true);
        $this->writeHTMLCell(115, '', '', '', $this->xrightInvoiceTitle, 1, 1, 0, true, 'R', true);
        $this->writeHTMLCell(105, '', '', 50, '<br/><br/><br/>', 1, 0, 0, true, 'L', true);
        $this->writeHTMLCell(35, '', '', '', $this->xrightInvoiceTitle1, 1, 0, 0, true, 'L', true);
        $this->writeHTMLCell(50, '', '', '', $this->xrightInvoiceTitle2, 1, 0, 0, true, 'L', true);
    }

    function SubjectLetter()
    {
        // writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
        $this->writeHTMLCell(150, '', '', 80, $this->xSubjectTitle1, 0, 0, 0, true, 'L', true);
        // write the second column
        $this->writeHTMLCell(70, '', '', '', $this->xSubjectTitle2, 0, 1, 0, true, 'L', true);
        $this->Ln(2);
    }

    function ItemTable($header, $items, $type, $customer_id)
    {
        $this->Ln(5);
        // header spacing
        $this->Cell(0,10);
        $this->Ln();

        //Colors, line width and bold font
        $this->SetFillColor(201,255,255);
        $this->SetTextColor(0,0,0);
        $this->SetDrawColor(255,255,255);
        $this->SetLineWidth(.3);
        //$this->SetFont('','B');
        $this->SetFont('dejavusans', 'B', 9);
        //Table Header
        //array('Qty','Description','Price','Total');
        //array('#',$infoCustomerInvoice['Customer']['abbrv'].' Number','Team','Requester','Employee','Service','Sent by','Status','Price'
        //$w=array(40,85,30,35);

        //echo pr($items);
        if($customer_id == 1){
//			if($type == 2){
//				$w=array(8,13,12,27,30,23,57,13,10,15);
            $w=array(8,13,30,23,22,63,23,15);
//			}
//			elseif ($type == 1) {
//				$w=array(8,12,12,30,65,13,10,15);
//			}
        }else {
            if ($type == 3) {
                $w=array(15,25,35,55,20,20,20,25);
            } else {
                if($customer_id == 3) {
                    //$w=array(8,20,35,23,62,13,15);  (8,12,30,35,23,58,13,10,15);
                    $w=array(8,12,20,35,17,67,13,10,15);
                }else {
                    $w=array(10,15,30,30,65,17,10,15);
                }
            }
        }

        for($i=0;$i<count($header);$i++)
            //Cell ($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M')
            $this->Cell($w[$i],'',$header[$i],1,0,'C',2);
        $this->Ln();

        //Color and font restoration
        $this->SetFillColor(255,255,255);
        $this->SetTextColor(0);
        //$this->SetFont(9);
        $this->SetFont('dejavusans', '', 8);

        //$this->SetCellPadding(3);
        $lineHeights = array('');

        $fill=0;
        //echo pr($items);
        $a = 1;
        $atext = '';
        $sumAmount = 0;
        foreach($items as $row) {
            $atext = strval($a);
            $ReqInitial = substr($row['Requester']['first_name'], 0, 1);
            $EmployeeInitialFirstName = substr($row['Employee']['first_name'], 0, 1);
            $EmployeeInitialLastName = substr($row['Employee']['last_name'], 0, 1);

            // MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0)
            //echo $w[0]; [Status]
            /*
                A 13	Completed
                D 7	    Canceled by user
                E 15	Canceled by Admin
                B 10	Pend.to complete Quest.(1st reminder)
                C 11	Pend.to complete Quest.(2nd reminder)
                F 14	Auto-canceled(2nd reminder)
                G 16	Canceled by employee
                H 18	Auto-canceled(not received by mail)
            */
            if ($row['Status']['id'] == 13) {
                $statusLegend = 'Completed';
            } elseif ($row['Status']['id'] == 7) {
                $statusLegend = 'Cancelled';
            } elseif ($row['Status']['id'] == 15) {
                $statusLegend = 'Cancelled';
            } elseif ($row['Status']['id'] == 14) {
                $statusLegend = 'Cancelled';
            }


            $sumAmount = $sumAmount + $row['InvoiceItem']['amount'];
            // ITEM NUMBER
            $this->MultiCell($w[0], '',$atext, 0, 'R', $fill, 0, '' ,'', true);
            $lineHeights[] = $this->getLastH();
            // ORDER CODE
            $this->MultiCell($w[1],'', $row['Order']['order_code'], 0, 'L', $fill, 0, '' ,'', true);
            $lineHeights[] = $this->getLastH();
            if($type == 1) {
                // REQUESTER NAME
                $this->MultiCell($w[2], '', $ReqInitial.'. '.$row['Requester']['last_name'], 0, 'L', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                // EMPLOYEE NAME
                $this->MultiCell($w[3], '', $EmployeeInitialFirstName.' '.$EmployeeInitialLastName, 0, 'L', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();

                if($customer_id == 1 || $customer_id == 3){
                    // EMPLOYEE INTERNAL CODE
                    $this->MultiCell($w[4], '', $row['Employee']['customer_internalcode'], 0, 'L', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    // SERVICE NAME
                    $this->MultiCell($w[5], '', $row['Service']['name'], 0, 'L', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    // STATUS OF QUESTIONNAIRE
                    $this->MultiCell($w[6], '', $statusLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    // FEES
                    $this->MultiCell($w[7], '', '$ '.$row['InvoiceItem']['amount'], 0, 'R', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                }else{
                    $this->MultiCell($w[4], '', $row['Service']['name'], 0, 'L', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[5], '', $communcLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[6], '', $statusLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[7], '', '$ '.$row['InvoiceItem']['amount'], 0, 'R', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                }

            }
            elseif($type == 2) {
                $this->MultiCell($w[2], '', $ReqInitial.'. '.$row['Requester']['last_name'], 0, 'L', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                $this->MultiCell($w[3], '', $row['Employee']['first_name'].' '.$row['Employee']['last_name'], 0, 'L', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                if($customer_id == 1 || $customer_id == 3) {
                    $this->MultiCell($w[4], '', $row['Employee']['customer_internalcode'], 0, 'L', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[5], '', $row['Service']['name'], 0, 'L', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[6], '', $communcLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[7], '', $statusLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[8], '', '$ '.$row['InvoiceItem']['amount'], 0, 'R', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                }else {
                    $this->MultiCell($w[4], '', $row['Service']['name'], 0, 'L', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[5], '', $communcLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[6], '', $statusLegend, 0, 'C', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                    $this->MultiCell($w[7], '', '$ '.$row['InvoiceItem']['amount'], 0, 'R', $fill, 0, '' ,'', true);
                    $lineHeights[] = $this->getLastH();
                }
            }
            elseif($type == 3) {
                $this->MultiCell($w[2], '', $row['Employee']['first_name'].' '.$row['Employee']['last_name'], 0, 'L', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                $this->MultiCell($w[3], '', $row['Service']['name'], 0, 'L', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                $this->MultiCell($w[4], '', $communcLegend, 0, 'C', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                $this->MultiCell($w[5], '', $statusLegend, 0, 'C', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
                $this->MultiCell($w[6], '', '$ '.$row['InvoiceItem']['amount'], 0, 'R', $fill, 0, '' ,'', true);
                $lineHeights[] = $this->getLastH();
            }


            $this->Ln(max($lineHeights));
            $lineHeights = array('');
            $fill=!$fill;

            //Aaron May 27, 2016 - reconfigured the line breaks to show missing information on the invoice report.
            if ($a == 33 || $a == 87 || $a == 140 || $a == 175) {
                $this->AddPage();
                for($i=0;$i<count($header);$i++) {
                    $this->SetFillColor(201,255,255);
                    $this->SetTextColor(25,180,237);
                    $this->Cell($w[$i],'',$header[$i],1,0,'C',0);
                }
                $this->Ln();
                //Color and font restoration
                $this->SetFillColor(248,248,248);
                $this->SetTextColor(0);
            }
            $a++;
        }
    }

    function AmountSection()
    {
        $this->SetFontSize(9);
        $this->Ln(7);
        // writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
        $this->writeHTMLCell(113, '', '', '', '', 0, 0, 0, true, 'L', true);
        $this->writeHTMLCell(50, '', '', '', $this->xsubTotalTexte, 0, 0, 0, true, 'L', true);
        $this->writeHTMLCell(30, '', '', '', $this->xsubTotal, 0, 1, 0, true, 'R', true);
    }

//    function LegendSection()
//    {
//        $this->SetFontSize(6);
//        $this->Ln(7);
//        // writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
//        $this->writeHTMLCell(130, '', '', '', $this->xInvoiceLegend, 0, 1, 0, true, 'L', true);
//        // write the second column
//    }

    function EndInvoice()
    {
        $this->Ln(12);
        // writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
        $this->writeHTMLCell(20, '', '', '', '', 0, 0, 0, true, 'L', true);
        $this->writeHTMLCell(90, '', '', '', $this->xEndInvoiceFra, 0, 0, 0, true, 'L', true);
        // write the second column
        $this->writeHTMLCell(90, '', '', '', $this->xEndInvoiceEng, 0, 1, 0, true, 'L', true);
        $this->Ln(2);
    }

}
?>