<?php

App::import('Vendor','tcpdf/config/lang/eng');
App::import('Vendor','tcpdf/tcpdf');

   
class TreatquestPDF  extends TCPDF {

	var $xEmployee = '';
	var $xheadertext  = 'PDF created using CakePHP and TCPDF'; 
	var $xClient = '';

	var $xDate = '';
	
	var $xDspId = '';
	var $checkRef = 0;
    //Page header
    public function Header() {
        // Logo
        $image_file = K_PATH_IMAGES.'logo.png';
        $this->Image($image_file, 12, 7, 95, 20, 'PNG', '', 'M', 2, 300, 'C', false, false, 0, false, false, false);
        // Set font  
        $this->SetFont('helvetica', 'B', 20);
    }

    // Page footer
    public function Footer() {
        // Position at 12 mm from bottom
        $this->SetY(-7);
        // Set font
        $this->SetFont('helvetica', 'I', 8);
        // Page number
        $this->Cell(0, 7, $this->xAddressTestmetrix, 'T', false, 'C', 0, '', 0, false, 'T', 'M');
    }
	
    function HeadingLetter() {		 
		$this->SetFontSize(11);		
		$this->Ln(4);
		//Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=0, $link='', $stretch=0, $ignore_min_height=false, $calign='T', $valign='M')
		$this->Cell(0, 0, $this->xDateLetter, 0, false, 'L', 0, '', 0);		
		// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)
		$this->writeHTMLCell(0, '', '', 55, $this->xAddressLetter, 0, 0, 0,true, 'L');		
    }		
	
	function SubjectLetter() {	
		// writeHTMLCell($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=0, $reseth=true, $align='', $autopadding=true)	
		$this->writeHTMLCell(30, '', '', 85, $this->xSubjectTitle, 'B', 0, 0, true, 'L', true);
		// write the second column
		$this->writeHTMLCell(150, '', '', '', $this->xPatientSubject, 'B', 1, 0, true, 'L', true);	
		$this->Ln(2);	
	}	
	
	function DoctorInterpGSection($scoreGinterps) {	
		$this->Ln(2);	
        foreach($scoreGinterps as $row) {
			if ($row['texte']  != '') {			
				$this->MultiCell (0, 0, $row['texte'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
				if($row['id'] == 1 ||$row['id'] == 2 || $row['id'] == 3 || $row['id'] == 4 || $row['id'] == 5 || $row['id'] == 6) {
					$this->Ln(2);
				}				
			}
        }
	}	

	function DoctorInterpPSection($scorePinterps, $nbr, $refCita, $ref138, $ref153) {	
	//$ref102, $ref111   $ref138, $ref153
		$this->Ln(6);
		$check139 = 0;
		$check144 = 0;
		$symbolRef = 1;
		$texte = '';
		
		$this->writeHTMLCell(0, '', '', '', $this->xTitleSection, 0, 0, 0,true, 'L');	
		$this->Ln();
		if (count($scorePinterps) > 9 && $nbr > 1) { $this->SetFontSize(10); }
        foreach($scorePinterps as $row) {
			if ($row['texte']  != '') {								
				if($row['id'] == 139) {
					$this->MultiCell (0, 0, $row['texte'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
					$this->writeHTMLCell(15, '', '', '', '', 0, 0, 0, true, 'L', true);
					$this->writeHTMLCell(60, '', '', '', $this->xleftStoppedMeds, 0, 0, 0, true, 'L', true);
					# write the second column
					$this->writeHTMLCell(100, '', '', '', $this->xrightStoppedMeds, 0, 0, 0, true, 'L', true);	
					$this->writeHTMLCell(15, '', '', '', '', 0, 1, 0, true, 'L', true);	
					if ($nbr == 0) {
						$this->Ln(1);	
					} else {
						$check138 = $nbr * 3.5;
						$this->Ln($check138);	
					}					
				} else {
					if ($row['id'] == 144 && $check144 == 0) { $this->Ln(2); } 	
					if ((($row['id'] == 27 || $row['id'] == 30 || $row['id'] == 31 || $row['id'] == 38 || $row['id'] == 58 || $row['id'] == 61 || 
						$row['id'] == 64 || $row['id'] == 65 || $row['id'] == 66 || $row['id'] == 67  || $row['id'] == 70 || $row['id'] == 73  || 
						$row['id'] == 74 || $row['id'] == 100) && $refCita == 1) || ($row['id'] == 138 && $ref138 == 1) ||
						($row['id'] == 153 && $ref153 == 1)) { 
						if ($row['id'] == 138 || $row['id'] == 153) {
							$this->writeHTMLCell('', '', '', '', $row['texte'].'<sup>'.$symbolRef.'</sup>', 0, 1, 0, true, 'L', true);
						} else {
							$texte = str_replace('*', '<sup>'.$symbolRef.' </sup>', $row['texte']);
							$this->writeHTMLCell('', '', '', '', $texte, 0, 1, 0, true, 'L', true);													
						}						
						$symbolRef++;
					}else{ 
						//if ($row['id'] == 107 || $row['id'] == 81 || $row['id'] == 82 || $row['id'] == 83) { 
						if ($row['id'] == 144 || $row['id'] == 140 || $row['id'] == 141 || $row['id'] == 142) { 
							$check144 = 1; 
							$this->MultiCell (0, 0, $row['texte'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
							$this->Ln(2);
						} else {
							$this->MultiCell (0, 0, $row['texte'], 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
						}					
						
					}										
				}
			}
		$newx = '';
        }
	}

	function EndLetter($endsal, $drTitle, $refs) {	
		$this->SetFontSize(9);
		$this->Ln(50);
		$this->MultiCell (0, 0, $endsal, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
		//$this->Ln(6);
        //$image_file2 = K_PATH_IMAGES.'DrBrownSignature.png';
		//$this->Image($image_file2, '', '', 47, 11);
		
		###
		$this->Ln(11);
		$this->MultiCell (0, 0, $drTitle, 0, 'L', false, 1, '', '', true, 0, false, true, 0, 'M', false );
			
		if(!empty($refs)){ $this->MultiCell (50, 0, '', 'B', 'L', false, 1, 10, 253, true, 0, false, true, 0, 'M', false ); }
		
		$this->writeHTMLCell('', '', 10, 260, $refs, 0, 1, 0, true, 'L', true);		
	}	
} 
?>