<?php

App::import('Vendor','doctorletterpdf'); 

$pdf = new DoctorletterPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	$pdf->SetAuthor("Testmetrix at https://e-testmetrix.ca");
	$pdf->SetFont("helvetica", "", 11);
	$pdf->xheadertext = 'Testmetrix';
	$pdf->xfootertext = 'Copyright Testmetrix. All rights reserved.';

	$pdf->SetProtection($permissions=array('copy','modify','annot-forms'), $user_pass='', $owner_pass=null, $mode=0, $pubkeys=null);	
	
	//set margins
	$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);	
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);	
	
    // add a page
    $pdf->AddPage();
	// Now you position and print your page content

	$pdf->SetTextColor(0, 0, 0);
	
	$fieldname = '';
	$gendertitle = '';
	$subjectname = '';
	
	$j = 0;
	
	if ($lang_id == 0) {
		$fieldname = 'name_fre';
		//Montreal, February 19, 2012
		if (date("m") == '01'){
			$month_fra = 'janvier';
		} elseif (date("m") == '02') {
			$month_fra = 'février';
		} elseif (date("m") == '03') {
			$month_fra = 'mars';
		} elseif (date("m") == '04') {
			$month_fra = 'avril';
		} elseif (date("m") == '05') {
			$month_fra = 'mai';
		} elseif (date("m") == '06') {
			$month_fra = 'juin';
		} elseif (date("m") == '07') {
			$month_fra = 'juillet';
		} elseif (date("m") == '08') {
			$month_fra = 'août';
		} elseif (date("m") == '09') {
			$month_fra = 'septembre';
		} elseif (date("m") == '10') {
			$month_fra = 'octobre';
		} elseif (date("m") == '11') {
			$month_fra = 'novembre';
		} elseif (date("m") == '12') {
			$month_fra = 'décembre';
		}	

		if ($doctor['Doctor']['gender'] == 'F') {
			$gendertitle = 'Chère ';
		} elseif ($doctor['Doctor']['gender'] == 'M') {
			$gendertitle = 'Cher ';
		}
		
		$datelettre = 'Montréal, le '.date("d").' '.$month_fra.', '.date("Y");
	} elseif ($lang_id == 1) {
		if ($doctor['Doctor']['gender'] == 'F') {
			$gendertitle = 'Dear ';
		} elseif ($doctor['Doctor']['gender'] == 'M') {
			$gendertitle = 'Dear ';
		}
		$fieldname = 'name_eng';
		$datelettre =  'Montreal, '.date("F j, Y"); 
	}
	
	$codepostalF = substr($doctor['Doctor']['code_postal'], 0, 3).' '.substr($doctor['Doctor']['code_postal'], 3, 3);

	$addresslettre = '';
	$addresslettre .= $doctor['Doctor']['full_name'].'<br/>';
	$addresslettre .= $doctor['Doctor']['address'].'<br/>';
	$addresslettre .= $doctor['City']['name'].', '.$doctor['Province']['name'].'<br/>';
	$addresslettre .= $codepostalF.'<br/>';
	
	//$customername = strtoupper($doctor['Customer']['name']);
	$gendertitle .= $doctor['Doctor']['full_name'].',';		
	
	# First page
	$pdf->xDateLetter = $datelettre;
	$pdf->xAddressLetter = $addresslettre;
	$pdf->HeadingLetter();
	
	$pdf->xGenderTitle = $gendertitle.'<br/>';
	$pdf->DrLetterContent($labelsDoctorReport, $fieldname, $doctor['Customer']['name'], $quest);

	$addressTMX = '4333, rue Ste-Catherine o., Bureau 410, Montréal (Québec) H3Z 1P9 Tél: (514) 938-1155  1-800-930-1232  Fax: (514) 938-5268';
	$pdf->xAddressTestmetrix = $addressTMX;
	
	$drTitle = 'Ronald D. Brown, M.D.FRCPC';	
	$refsText = '';
	
	if ($quest == 45)  {
		if ($labelsDoctorReport[5]['DocLabel']['serie'] == 6)  {
			$refsText = '<font size="-4"><sup>1</sup> '.$labelsDoctorReport[5]['DocLabel'][$fieldname].'</font><br/>';	
		}
	} elseif($quest == 77) {
		if ($labelsDoctorReport[6]['DocLabel']['serie'] == 7)  {
			$refsText = '<font size="-4"><sup>1</sup> '.$labelsDoctorReport[6]['DocLabel'][$fieldname].'</font><br/>';	
		}		
	}
	
	$pdf->EndLetter($drTitle, $refsText, $quest);
	
	echo $pdf->Output('Tmx-DrLetter.pdf', 'D');
	
		//Aaron may 27-2016
	// line 77 lacks .pdf extension as in the following exemple:
	//$//this->Pdf->core->Output('example_001.pdf', 'D');
	//this causes the output file not to be recognized as pdf by the 
	//downloading computer...
	
?>