<?php

App::import('Vendor','testsreportspdf'); 

$pdf = new TestsreportsPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

	$pdf->SetAuthor("Testmetrix at https://e-testmetrix.ca");
	$pdf->SetFont("helvetica", "", 11);
	$pdf->xheadertext = 'Testmetrix';
	$pdf->xfootertext = 'Copyright Testmetrix. All rights reserved.';

	$pdf->SetProtection($permissions=array('copy','modify','annot-forms'), $user_pass='', $owner_pass=null, $mode=0, $pubkeys=null);	
	
	//set margins
	##$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
	$pdf->SetMargins(10, PDF_MARGIN_TOP, 10);
	$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
	$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);	
	
	//set auto page breaks
	$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);	
	
    // add a page
    $pdf->AddPage('L');
	// Now you position and print your page content

	$pdf->SetTextColor(0, 0, 0);
	
	//$datelettreFra = 'Montréal, le '.date("d").' '.$month_fra.', '.date("Y");
	$subjecttitle = 'Tests Frequency Report';

	
	###	$fieldname = 'name_eng';
	$dateEng =  'Montreal, '.date("F j, Y"); 
#	$invoicenameEng = 'Invoice #';		
	
	// convert month number to month name.
	$month_name = date( 'F', mktime(0, 0, 0, $month_rep) );

	// Result:
	// $month_name == "February"; 	
	
	if ($type_rep == 1) {
		$week_rep0 = $week_rep - 7;
		$reportName = 'Weekly report for '.$week_rep0.' '.$month_name.' to '.$week_rep.' '.$month_name.' of '.$year_rep;
	} elseif ($type_rep == 2) {
		$reportName = 'Monthly report for '.$month_name.' '.$year_rep;
	} elseif ($type_rep == 3) {
		$reportName = 'Annually report for '.$year_rep;
	}
	
	# Header - REPORT
	$pdf->xrightReportTitle0 = $dateEng;
	$pdf->xrightReportTitle1 = '<font size="+2"><b>'.$subjecttitle.'</b><br/></font>';
	$pdf->xrightReportTitle2 = '<i><b><br/>'.$reportName.'</b></i><br/><br/>';
	$pdf->HeadingLetter(); 	

	#Frecuency Report -Items List Section
    $columnTitles = array('Customers name<br/>', 'Completed<br/>', 'Pend.to compl.quest.(1st email reminder)', 'Pend.to compl.quest.(2nd email reminder)',
			'Auto-canceled(2nd email reminder)', 'Auto-canceled(not received by mail)', 'Canceled by user', 'Canceled by employee',
			'Canceled by Admin');
/*
					'pendComplQuest1' => $pendComplQuest1, 
					'pendComplQuest2' => $pendComplQuest2, 
					'autoCanceled1' => $autoCanceled1,
					'autoCanceled2' => $autoCanceled2, 
					'canceledUser' => $canceledUser,									
					'canceledEmp' => $canceledEmp,
					'canceledAdmin' => $canceledAdmin)));
*/			
    $pdf->ItemTable($columnTitles,$reportsData);			
	
	# Footer Section
	$addressTMX = '4333, rue Ste-Catherine O., Bureau 410, Montréal(Québec) H3Z 1P9 Tél: (514) 938-1155  Fax: (514) 938-5268';
	$pdf->xAddressTestmetrix = $addressTMX;
	
	echo $pdf->Output('TMX-Report.pdf', 'D');
	
			//Aaron may 27-2016
	// line 77 lacks .pdf extension as in the following exemple:
	//$//this->Pdf->core->Output('example_001.pdf', 'D');
	//this causes the output file not to be recognized as pdf by the 
	//downloading computer...
?>